<?php

use Dingo\Api\Routing\Router;

/** @var Router $api */
$api = app(Router::class);

$api->version('v1', function (Router $api) {
    

	// New android routes
	
	$api->group(['prefix' => 'android'], function(Router $api) {
        $api->post('login', 'App\\Api\\V1\\Controllers\\UsersController2@login');
		$api->post('forgot_password', 'App\\Api\\V1\\Controllers\\UsersController2@forgotPassword');
		$api->post('edit_profile', 'App\\Api\\V1\\Controllers\\UsersController2@editProfile');
		$api->post('update_profile', 'App\\Api\\V1\\Controllers\\UsersController2@updateProfileData');
		$api->post('logout', 'App\\Api\\V1\\Controllers\\UsersController2@logout');
		$api->post('change_password', 'App\\Api\\V1\\Controllers\\UsersController2@change_password');
		
		$api->post('del_multiple', 'App\\Api\\V1\\Controllers\\UsersController2@del_multiple');
		$api->post('inventory_filter', 'App\\Api\\V1\\Controllers\\UsersController2@inventory_filter');
		$api->post('add_sales_payment', 'App\\Api\\V1\\Controllers\\UsersController2@add_sales_payment');
		$api->post('get_stores', 'App\\Api\\V1\\Controllers\\UsersController2@get_stores');
		$api->post('signup', 'App\\Api\\V1\\Controllers\\UsersController2@signup');
		
		$api->post('user_list', 'App\\Api\\V1\\Controllers\\UsersController2@user_list');
		$api->post('blocked_user_list', 'App\\Api\\V1\\Controllers\\UsersController2@blocked_user_list');
		$api->post('add_user', 'App\\Api\\V1\\Controllers\\UsersController2@add_user');
		$api->post('edit_user', 'App\\Api\\V1\\Controllers\\UsersController2@edit_user');
		$api->post('update_user_info', 'App\\Api\\V1\\Controllers\\UsersController2@update_user_info');
		$api->post('delete_user', 'App\\Api\\V1\\Controllers\\UsersController2@delete_user');
		$api->post('del_user', 'App\\Api\\V1\\Controllers\\UsersController2@del_user');
		
		$api->post('add_cigarette', 'App\\Api\\V1\\Controllers\\UsersController2@add_cigarette');
		$api->post('add_atm', 'App\\Api\\V1\\Controllers\\UsersController2@add_atm');
		$api->post('get_all_messages', 'App\\Api\\V1\\Controllers\\UsersController2@get_all_messages');
		
		$api->post('store_list', 'App\\Api\\V1\\Controllers\\UsersController2@store_list');
		$api->post('store_list_new', 'App\\Api\\V1\\Controllers\\UsersController2@store_list_new');
		$api->post('add_store', 'App\\Api\\V1\\Controllers\\UsersController2@add_store');
		$api->post('edit_store', 'App\\Api\\V1\\Controllers\\UsersController2@edit_store');
		$api->post('update_store_info', 'App\\Api\\V1\\Controllers\\UsersController2@update_store_info');
		$api->post('delete_store', 'App\\Api\\V1\\Controllers\\UsersController2@delete_store');
		
		$api->post('item_list', 'App\\Api\\V1\\Controllers\\UsersController2@item_list');
		$api->post('add_item', 'App\\Api\\V1\\Controllers\\UsersController2@add_item');
		$api->post('edit_item', 'App\\Api\\V1\\Controllers\\UsersController2@edit_item');
		$api->post('update_item_info', 'App\\Api\\V1\\Controllers\\UsersController2@update_item_info');
		$api->post('delete_item', 'App\\Api\\V1\\Controllers\\UsersController2@delete_item');
		
		$api->post('vendor_list', 'App\\Api\\V1\\Controllers\\UsersController2@vendor_list');
		$api->post('add_vendor', 'App\\Api\\V1\\Controllers\\UsersController2@add_vendor');
		$api->post('edit_vendor', 'App\\Api\\V1\\Controllers\\UsersController2@edit_vendor');
		$api->post('update_vendor_info', 'App\\Api\\V1\\Controllers\\UsersController2@update_vendor_info');
		$api->post('delete_vendor', 'App\\Api\\V1\\Controllers\\UsersController2@delete_vendor');
		
		$api->post('get_store_data', 'App\\Api\\V1\\Controllers\\UsersController2@get_store_data');
		$api->post('store_in_profit', 'App\\Api\\V1\\Controllers\\UsersController2@store_in_profit');
		$api->post('store_in_profit2', 'App\\Api\\V1\\Controllers\\UsersController2@store_in_profit2');
		$api->post('store_info', 'App\\Api\\V1\\Controllers\\UsersController2@store_info');
		$api->post('store_info2', 'App\\Api\\V1\\Controllers\\UsersController2@store_info2');
		$api->post('store_Info_detail', 'App\\Api\\V1\\Controllers\\UsersController2@store_Info_detail');
		$api->post('latest', 'App\\Api\\V1\\Controllers\\UsersController2@latest');
		$api->post('user_entry_details', 'App\\Api\\V1\\Controllers\\UsersController2@user_entry_details');
		$api->post('all_daily_report', 'App\\Api\\V1\\Controllers\\UsersController2@all_daily_report');
		
		$api->post('admin_sales_edit', 'App\\Api\\V1\\Controllers\\UsersController2@admin_sales_edit');
		$api->post('admin_payment_edit', 'App\\Api\\V1\\Controllers\\UsersController2@admin_payment_edit');
		$api->post('admin_inventory_edit', 'App\\Api\\V1\\Controllers\\UsersController2@admin_inventory_edit');
		$api->post('admin_atm_edit', 'App\\Api\\V1\\Controllers\\UsersController2@admin_atm_edit');
		$api->post('admin_cigarette_edit', 'App\\Api\\V1\\Controllers\\UsersController2@admin_cigarette_edit');
		$api->post('admin_lottery_edit', 'App\\Api\\V1\\Controllers\\UsersController2@admin_lottery_edit');
		$api->post('admin_expense_edit', 'App\\Api\\V1\\Controllers\\UsersController2@admin_expense_edit');
		$api->post('admin_sales_delete', 'App\\Api\\V1\\Controllers\\UsersController2@admin_sales_delete');
		$api->post('admin_payment_delete', 'App\\Api\\V1\\Controllers\\UsersController2@admin_payment_delete');
		$api->post('admin_inventory_delete', 'App\\Api\\V1\\Controllers\\UsersController2@admin_inventory_delete');
		$api->post('admin_atm_delete', 'App\\Api\\V1\\Controllers\\UsersController2@admin_atm_delete');
		$api->post('admin_cigarette_delete', 'App\\Api\\V1\\Controllers\\UsersController2@admin_cigarette_delete');
		$api->post('admin_lottery_delete', 'App\\Api\\V1\\Controllers\\UsersController2@admin_lottery_delete');
		$api->post('admin_expense_delete', 'App\\Api\\V1\\Controllers\\UsersController2@admin_expense_delete');
		
		$api->post('add_lottery', 'App\\Api\\V1\\Controllers\\UsersController2@add_lottery');
		$api->post('add_expense', 'App\\Api\\V1\\Controllers\\UsersController2@add_expense');
		$api->post('send_message', 'App\\Api\\V1\\Controllers\\UsersController2@send_message');
		
		$api->post('add_inventory', 'App\\Api\\V1\\Controllers\\UsersController2@add_inventory');
		$api->post('add_sales_report', 'App\\Api\\V1\\Controllers\\UsersController2@add_sales_report');
		$api->post('add_payment_report', 'App\\Api\\V1\\Controllers\\UsersController2@add_payment_report');
		$api->post('get_vendor_items', 'App\\Api\\V1\\Controllers\\UsersController2@get_vendor_items');
		
		$api->post('get_expense_items', 'App\\Api\\V1\\Controllers\\UsersController2@get_expense_items');
		$api->post('get_config', 'App\\Api\\V1\\Controllers\\UsersController2@get_config');
    });
	
	$api->group(['prefix' => 'v2'], function(Router $api) {
        $api->post('login', 'App\\Api\\V2\\Controllers\\UsersController2@login');
		$api->post('forgot_password', 'App\\Api\\V2\\Controllers\\UsersController2@forgotPassword');
		$api->post('edit_profile', 'App\\Api\\V2\\Controllers\\UsersController2@editProfile');
		$api->post('update_profile', 'App\\Api\\V2\\Controllers\\UsersController2@updateProfileData');
		$api->post('logout', 'App\\Api\\V2\\Controllers\\UsersController2@logout');
		$api->post('change_password', 'App\\Api\\V2\\Controllers\\UsersController2@change_password');
		
		$api->post('del_multiple', 'App\\Api\\V2\\Controllers\\UsersController2@del_multiple');
		$api->post('inventory_filter', 'App\\Api\\V2\\Controllers\\UsersController2@inventory_filter');
		$api->post('add_sales_payment', 'App\\Api\\V2\\Controllers\\UsersController2@add_sales_payment');
		$api->post('get_stores', 'App\\Api\\V2\\Controllers\\UsersController2@get_stores');
		$api->post('signup', 'App\\Api\\V2\\Controllers\\UsersController2@signup');
		
		$api->post('user_list', 'App\\Api\\V2\\Controllers\\UsersController2@user_list');
		$api->post('blocked_user_list', 'App\\Api\\V2\\Controllers\\UsersController2@blocked_user_list');
		$api->post('add_user', 'App\\Api\\V2\\Controllers\\UsersController2@add_user');
		$api->post('edit_user', 'App\\Api\\V2\\Controllers\\UsersController2@edit_user');
		$api->post('update_user_info', 'App\\Api\\V2\\Controllers\\UsersController2@update_user_info');
		$api->post('delete_user', 'App\\Api\\V2\\Controllers\\UsersController2@delete_user');
		$api->post('del_user', 'App\\Api\\V2\\Controllers\\UsersController2@del_user');
		
		$api->post('add_cigarette', 'App\\Api\\V2\\Controllers\\UsersController2@add_cigarette');
		$api->post('add_atm', 'App\\Api\\V2\\Controllers\\UsersController2@add_atm');
		$api->post('get_all_messages', 'App\\Api\\V2\\Controllers\\UsersController2@get_all_messages');
		
		$api->post('store_list', 'App\\Api\\V2\\Controllers\\UsersController2@store_list');
		$api->post('store_list_new', 'App\\Api\\V2\\Controllers\\UsersController2@store_list_new');
		$api->post('add_store', 'App\\Api\\V2\\Controllers\\UsersController2@add_store');
		$api->post('edit_store', 'App\\Api\\V2\\Controllers\\UsersController2@edit_store');
		$api->post('update_store_info', 'App\\Api\\V2\\Controllers\\UsersController2@update_store_info');
		$api->post('delete_store', 'App\\Api\\V2\\Controllers\\UsersController2@delete_store');
		
		$api->post('item_list', 'App\\Api\\V2\\Controllers\\UsersController2@item_list');
		$api->post('add_item', 'App\\Api\\V2\\Controllers\\UsersController2@add_item');
		$api->post('edit_item', 'App\\Api\\V2\\Controllers\\UsersController2@edit_item');
		$api->post('update_item_info', 'App\\Api\\V2\\Controllers\\UsersController2@update_item_info');
		$api->post('delete_item', 'App\\Api\\V2\\Controllers\\UsersController2@delete_item');
		
		$api->post('vendor_list', 'App\\Api\\V2\\Controllers\\UsersController2@vendor_list');
		$api->post('add_vendor', 'App\\Api\\V2\\Controllers\\UsersController2@add_vendor');
		$api->post('edit_vendor', 'App\\Api\\V2\\Controllers\\UsersController2@edit_vendor');
		$api->post('update_vendor_info', 'App\\Api\\V2\\Controllers\\UsersController2@update_vendor_info');
		$api->post('delete_vendor', 'App\\Api\\V2\\Controllers\\UsersController2@delete_vendor');
		
		$api->post('get_store_data', 'App\\Api\\V2\\Controllers\\UsersController2@get_store_data');
		$api->post('store_in_profit', 'App\\Api\\V2\\Controllers\\UsersController2@store_in_profit');
		$api->post('store_in_profit2', 'App\\Api\\V2\\Controllers\\UsersController2@store_in_profit2');
		$api->post('store_info', 'App\\Api\\V2\\Controllers\\UsersController2@store_info');
		$api->post('store_info2', 'App\\Api\\V2\\Controllers\\UsersController2@store_info2');
		$api->post('store_Info_detail', 'App\\Api\\V2\\Controllers\\UsersController2@store_Info_detail');
		$api->post('latest', 'App\\Api\\V2\\Controllers\\UsersController2@latest');
		$api->post('user_entry_details', 'App\\Api\\V2\\Controllers\\UsersController2@user_entry_details');
		$api->post('all_daily_report', 'App\\Api\\V2\\Controllers\\UsersController2@all_daily_report');
		
		$api->post('admin_sales_edit', 'App\\Api\\V2\\Controllers\\UsersController2@admin_sales_edit');
		$api->post('admin_payment_edit', 'App\\Api\\V2\\Controllers\\UsersController2@admin_payment_edit');
		$api->post('admin_inventory_edit', 'App\\Api\\V2\\Controllers\\UsersController2@admin_inventory_edit');
		$api->post('admin_atm_edit', 'App\\Api\\V2\\Controllers\\UsersController2@admin_atm_edit');
		$api->post('admin_cigarette_edit', 'App\\Api\\V2\\Controllers\\UsersController2@admin_cigarette_edit');
		$api->post('admin_lottery_edit', 'App\\Api\\V2\\Controllers\\UsersController2@admin_lottery_edit');
		$api->post('admin_expense_edit', 'App\\Api\\V2\\Controllers\\UsersController2@admin_expense_edit');
		$api->post('admin_sales_delete', 'App\\Api\\V2\\Controllers\\UsersController2@admin_sales_delete');
		$api->post('admin_payment_delete', 'App\\Api\\V2\\Controllers\\UsersController2@admin_payment_delete');
		$api->post('admin_inventory_delete', 'App\\Api\\V2\\Controllers\\UsersController2@admin_inventory_delete');
		$api->post('admin_atm_delete', 'App\\Api\\V2\\Controllers\\UsersController2@admin_atm_delete');
		$api->post('admin_cigarette_delete', 'App\\Api\\V2\\Controllers\\UsersController2@admin_cigarette_delete');
		$api->post('admin_lottery_delete', 'App\\Api\\V2\\Controllers\\UsersController2@admin_lottery_delete');
		$api->post('admin_expense_delete', 'App\\Api\\V2\\Controllers\\UsersController2@admin_expense_delete');
		
		$api->post('add_lottery', 'App\\Api\\V2\\Controllers\\UsersController2@add_lottery');
		$api->post('add_expense', 'App\\Api\\V2\\Controllers\\UsersController2@add_expense');
		$api->post('send_message', 'App\\Api\\V2\\Controllers\\UsersController2@send_message');
		
		$api->post('add_inventory', 'App\\Api\\V2\\Controllers\\UsersController2@add_inventory');
		$api->post('add_sales_report', 'App\\Api\\V2\\Controllers\\UsersController2@add_sales_report');
		$api->post('add_payment_report', 'App\\Api\\V2\\Controllers\\UsersController2@add_payment_report');
		$api->post('get_vendor_items', 'App\\Api\\V2\\Controllers\\UsersController2@get_vendor_items');
		
		$api->post('get_expense_items', 'App\\Api\\V2\\Controllers\\UsersController2@get_expense_items');
		$api->post('get_config', 'App\\Api\\V2\\Controllers\\UsersController2@get_config');
    });
	
	$api->group(['prefix' => 'v3'], function(Router $api) {
        $api->post('login', 'App\\Api\\V3\\Controllers\\UsersController2@login');
		$api->post('forgot_password', 'App\\Api\\V3\\Controllers\\UsersController2@forgotPassword');
		$api->post('edit_profile', 'App\\Api\\V3\\Controllers\\UsersController2@editProfile');
		$api->post('update_profile', 'App\\Api\\V3\\Controllers\\UsersController2@updateProfileData');
		$api->post('logout', 'App\\Api\\V3\\Controllers\\UsersController2@logout');
		$api->post('change_password', 'App\\Api\\V3\\Controllers\\UsersController2@change_password');
		
		$api->post('del_multiple', 'App\\Api\\V3\\Controllers\\UsersController2@del_multiple');
		$api->post('inventory_filter', 'App\\Api\\V3\\Controllers\\UsersController2@inventory_filter');
		$api->post('inventory_filter_page2', 'App\\Api\\V3\\Controllers\\UsersController2@inventory_filter_page2');
		$api->post('add_sales_payment', 'App\\Api\\V3\\Controllers\\UsersController2@add_sales_payment');
		$api->post('get_stores', 'App\\Api\\V3\\Controllers\\UsersController2@get_stores');
		$api->post('signup', 'App\\Api\\V3\\Controllers\\UsersController2@signup');
		
		$api->post('user_list', 'App\\Api\\V3\\Controllers\\UsersController2@user_list');
		$api->post('blocked_user_list', 'App\\Api\\V3\\Controllers\\UsersController2@blocked_user_list');
		$api->post('add_user', 'App\\Api\\V3\\Controllers\\UsersController2@add_user');
		$api->post('edit_user', 'App\\Api\\V3\\Controllers\\UsersController2@edit_user');
		$api->post('update_user_info', 'App\\Api\\V3\\Controllers\\UsersController2@update_user_info');
		$api->post('delete_user', 'App\\Api\\V3\\Controllers\\UsersController2@delete_user');
		$api->post('del_user', 'App\\Api\\V3\\Controllers\\UsersController2@del_user');
		
		$api->post('add_cigarette', 'App\\Api\\V3\\Controllers\\UsersController2@add_cigarette');
		$api->post('add_atm', 'App\\Api\\V3\\Controllers\\UsersController2@add_atm');
		$api->post('get_all_messages', 'App\\Api\\V3\\Controllers\\UsersController2@get_all_messages');
		
		$api->post('store_list', 'App\\Api\\V3\\Controllers\\UsersController2@store_list');
		$api->post('store_list_new', 'App\\Api\\V3\\Controllers\\UsersController2@store_list_new');
		$api->post('add_store', 'App\\Api\\V3\\Controllers\\UsersController2@add_store');
		$api->post('edit_store', 'App\\Api\\V3\\Controllers\\UsersController2@edit_store');
		$api->post('update_store_info', 'App\\Api\\V3\\Controllers\\UsersController2@update_store_info');
		$api->post('delete_store', 'App\\Api\\V3\\Controllers\\UsersController2@delete_store');
		
		$api->post('item_list', 'App\\Api\\V3\\Controllers\\UsersController2@item_list');
		$api->post('add_item', 'App\\Api\\V3\\Controllers\\UsersController2@add_item');
		$api->post('edit_item', 'App\\Api\\V3\\Controllers\\UsersController2@edit_item');
		$api->post('update_item_info', 'App\\Api\\V3\\Controllers\\UsersController2@update_item_info');
		$api->post('delete_item', 'App\\Api\\V3\\Controllers\\UsersController2@delete_item');
		
		$api->post('vendor_list', 'App\\Api\\V3\\Controllers\\UsersController2@vendor_list');
		$api->post('add_vendor', 'App\\Api\\V3\\Controllers\\UsersController2@add_vendor');
		$api->post('edit_vendor', 'App\\Api\\V3\\Controllers\\UsersController2@edit_vendor');
		$api->post('update_vendor_info', 'App\\Api\\V3\\Controllers\\UsersController2@update_vendor_info');
		$api->post('delete_vendor', 'App\\Api\\V3\\Controllers\\UsersController2@delete_vendor');
		
		$api->post('get_store_data', 'App\\Api\\V3\\Controllers\\UsersController2@get_store_data');
		$api->post('store_in_profit', 'App\\Api\\V3\\Controllers\\UsersController2@store_in_profit');
		$api->post('store_in_profit2', 'App\\Api\\V3\\Controllers\\UsersController2@store_in_profit2');
		$api->post('user_store_in_profit', 'App\\Api\\V3\\Controllers\\UsersController2@user_store_in_profit');
		$api->post('user_report', 'App\\Api\\V3\\Controllers\\UsersController2@user_report');
		$api->post('store_info', 'App\\Api\\V3\\Controllers\\UsersController2@store_info');
		$api->post('store_info2', 'App\\Api\\V3\\Controllers\\UsersController2@store_info2');
		$api->post('user_report_store', 'App\\Api\\V3\\Controllers\\UsersController2@user_report_store');
		$api->post('store_Info_detail', 'App\\Api\\V3\\Controllers\\UsersController2@store_Info_detail');
		$api->post('latest', 'App\\Api\\V3\\Controllers\\UsersController2@latest');
		$api->post('user_entry_details', 'App\\Api\\V3\\Controllers\\UsersController2@user_entry_details');
		$api->post('user_report_date', 'App\\Api\\V3\\Controllers\\UsersController2@user_report_date');
		$api->post('all_daily_report', 'App\\Api\\V3\\Controllers\\UsersController2@all_daily_report');
		
		$api->post('admin_sales_edit', 'App\\Api\\V3\\Controllers\\UsersController2@admin_sales_edit');
		$api->post('admin_payment_edit', 'App\\Api\\V3\\Controllers\\UsersController2@admin_payment_edit');
		$api->post('admin_inventory_edit', 'App\\Api\\V3\\Controllers\\UsersController2@admin_inventory_edit');
		$api->post('admin_atm_edit', 'App\\Api\\V3\\Controllers\\UsersController2@admin_atm_edit');
		$api->post('admin_cigarette_edit', 'App\\Api\\V3\\Controllers\\UsersController2@admin_cigarette_edit');
		$api->post('admin_lottery_edit', 'App\\Api\\V3\\Controllers\\UsersController2@admin_lottery_edit');
		$api->post('admin_expense_edit', 'App\\Api\\V3\\Controllers\\UsersController2@admin_expense_edit');
		$api->post('admin_sales_delete', 'App\\Api\\V3\\Controllers\\UsersController2@admin_sales_delete');
		$api->post('admin_payment_delete', 'App\\Api\\V3\\Controllers\\UsersController2@admin_payment_delete');
		$api->post('admin_inventory_delete', 'App\\Api\\V3\\Controllers\\UsersController2@admin_inventory_delete');
		$api->post('admin_atm_delete', 'App\\Api\\V3\\Controllers\\UsersController2@admin_atm_delete');
		$api->post('admin_cigarette_delete', 'App\\Api\\V3\\Controllers\\UsersController2@admin_cigarette_delete');
		$api->post('admin_lottery_delete', 'App\\Api\\V3\\Controllers\\UsersController2@admin_lottery_delete');
		$api->post('admin_expense_delete', 'App\\Api\\V3\\Controllers\\UsersController2@admin_expense_delete');
		
		$api->post('add_lottery', 'App\\Api\\V3\\Controllers\\UsersController2@add_lottery');
		$api->post('add_expense', 'App\\Api\\V3\\Controllers\\UsersController2@add_expense');
		$api->post('send_message', 'App\\Api\\V3\\Controllers\\UsersController2@send_message');
		
		$api->post('add_inventory', 'App\\Api\\V3\\Controllers\\UsersController2@add_inventory');
		$api->post('add_sales_report', 'App\\Api\\V3\\Controllers\\UsersController2@add_sales_report');
		$api->post('add_payment_report', 'App\\Api\\V3\\Controllers\\UsersController2@add_payment_report');
		$api->post('get_vendor_items', 'App\\Api\\V3\\Controllers\\UsersController2@get_vendor_items');
		
		$api->post('get_expense_items', 'App\\Api\\V3\\Controllers\\UsersController2@get_expense_items');
		$api->post('get_config', 'App\\Api\\V3\\Controllers\\UsersController2@get_config');
	});
	
	$api->group(['prefix' => 'v4'], function(Router $api) {
        $api->post('login', 'App\\Api\\V4\\Controllers\\UsersController2@login');
		$api->post('forgot_password', 'App\\Api\\V4\\Controllers\\UsersController2@forgotPassword');
		$api->post('edit_profile', 'App\\Api\\V4\\Controllers\\UsersController2@editProfile');
		$api->post('update_profile', 'App\\Api\\V4\\Controllers\\UsersController2@updateProfileData');
		$api->post('logout', 'App\\Api\\V4\\Controllers\\UsersController2@logout');
		$api->post('change_password', 'App\\Api\\V4\\Controllers\\UsersController2@change_password');
		
		$api->post('del_multiple', 'App\\Api\\V4\\Controllers\\UsersController2@del_multiple');
		$api->post('inventory_filter', 'App\\Api\\V4\\Controllers\\UsersController2@inventory_filter');
		$api->post('inventory_filter_page2', 'App\\Api\\V4\\Controllers\\UsersController2@inventory_filter_page2');
		$api->post('add_sales_payment', 'App\\Api\\V4\\Controllers\\UsersController2@add_sales_payment');
		$api->post('get_stores', 'App\\Api\\V4\\Controllers\\UsersController2@get_stores');
		$api->post('signup', 'App\\Api\\V4\\Controllers\\UsersController2@signup');
		
		$api->post('user_list', 'App\\Api\\V4\\Controllers\\UsersController2@user_list');
		$api->post('blocked_user_list', 'App\\Api\\V4\\Controllers\\UsersController2@blocked_user_list');
		$api->post('add_user', 'App\\Api\\V4\\Controllers\\UsersController2@add_user');
		$api->post('edit_user', 'App\\Api\\V4\\Controllers\\UsersController2@edit_user');
		$api->post('update_user_info', 'App\\Api\\V4\\Controllers\\UsersController2@update_user_info');
		$api->post('delete_user', 'App\\Api\\V4\\Controllers\\UsersController2@delete_user');
		$api->post('del_user', 'App\\Api\\V4\\Controllers\\UsersController2@del_user');
		
		$api->post('add_cigarette', 'App\\Api\\V4\\Controllers\\UsersController2@add_cigarette');
		$api->post('add_atm', 'App\\Api\\V4\\Controllers\\UsersController2@add_atm');
		$api->post('get_all_messages', 'App\\Api\\V4\\Controllers\\UsersController2@get_all_messages');
		
		$api->post('store_list', 'App\\Api\\V4\\Controllers\\UsersController2@store_list');
		$api->post('store_list_new', 'App\\Api\\V4\\Controllers\\UsersController2@store_list_new');
		$api->post('add_store', 'App\\Api\\V4\\Controllers\\UsersController2@add_store');
		$api->post('edit_store', 'App\\Api\\V4\\Controllers\\UsersController2@edit_store');
		$api->post('update_store_info', 'App\\Api\\V4\\Controllers\\UsersController2@update_store_info');
		$api->post('delete_store', 'App\\Api\\V4\\Controllers\\UsersController2@delete_store');
		
		$api->post('item_list', 'App\\Api\\V4\\Controllers\\UsersController2@item_list');
		$api->post('add_item', 'App\\Api\\V4\\Controllers\\UsersController2@add_item');
		$api->post('edit_item', 'App\\Api\\V4\\Controllers\\UsersController2@edit_item');
		$api->post('update_item_info', 'App\\Api\\V4\\Controllers\\UsersController2@update_item_info');
		$api->post('delete_item', 'App\\Api\\V4\\Controllers\\UsersController2@delete_item');
		
		$api->post('vendor_list', 'App\\Api\\V4\\Controllers\\UsersController2@vendor_list');
		$api->post('add_vendor', 'App\\Api\\V4\\Controllers\\UsersController2@add_vendor');
		$api->post('edit_vendor', 'App\\Api\\V4\\Controllers\\UsersController2@edit_vendor');
		$api->post('update_vendor_info', 'App\\Api\\V4\\Controllers\\UsersController2@update_vendor_info');
		$api->post('delete_vendor', 'App\\Api\\V4\\Controllers\\UsersController2@delete_vendor');
		
		$api->post('get_store_data', 'App\\Api\\V4\\Controllers\\UsersController2@get_store_data');
		$api->post('store_in_profit', 'App\\Api\\V4\\Controllers\\UsersController2@store_in_profit');
		$api->post('store_in_profit2', 'App\\Api\\V4\\Controllers\\UsersController2@store_in_profit2');
		$api->post('user_store_in_profit', 'App\\Api\\V4\\Controllers\\UsersController2@user_store_in_profit');
		$api->post('user_report', 'App\\Api\\V4\\Controllers\\UsersController2@user_report');
		$api->post('store_info', 'App\\Api\\V4\\Controllers\\UsersController2@store_info');
		$api->post('store_info2', 'App\\Api\\V4\\Controllers\\UsersController2@store_info2');
		$api->post('user_report_store', 'App\\Api\\V4\\Controllers\\UsersController2@user_report_store');
		$api->post('store_Info_detail', 'App\\Api\\V4\\Controllers\\UsersController2@store_Info_detail');
		$api->post('latest', 'App\\Api\\V4\\Controllers\\UsersController2@latest');
		$api->post('user_entry_details', 'App\\Api\\V4\\Controllers\\UsersController2@user_entry_details');
		$api->post('user_report_date', 'App\\Api\\V4\\Controllers\\UsersController2@user_report_date');
		$api->post('all_daily_report', 'App\\Api\\V4\\Controllers\\UsersController2@all_daily_report');
		
		$api->post('admin_sales_edit', 'App\\Api\\V4\\Controllers\\UsersController2@admin_sales_edit');
		$api->post('admin_payment_edit', 'App\\Api\\V4\\Controllers\\UsersController2@admin_payment_edit');
		$api->post('admin_inventory_edit', 'App\\Api\\V4\\Controllers\\UsersController2@admin_inventory_edit');
		$api->post('admin_atm_edit', 'App\\Api\\V4\\Controllers\\UsersController2@admin_atm_edit');
		$api->post('admin_cigarette_edit', 'App\\Api\\V4\\Controllers\\UsersController2@admin_cigarette_edit');
		$api->post('admin_lottery_edit', 'App\\Api\\V4\\Controllers\\UsersController2@admin_lottery_edit');
		$api->post('admin_expense_edit', 'App\\Api\\V4\\Controllers\\UsersController2@admin_expense_edit');
		$api->post('admin_sales_delete', 'App\\Api\\V4\\Controllers\\UsersController2@admin_sales_delete');
		$api->post('admin_payment_delete', 'App\\Api\\V4\\Controllers\\UsersController2@admin_payment_delete');
		$api->post('admin_inventory_delete', 'App\\Api\\V4\\Controllers\\UsersController2@admin_inventory_delete');
		$api->post('admin_atm_delete', 'App\\Api\\V4\\Controllers\\UsersController2@admin_atm_delete');
		$api->post('admin_cigarette_delete', 'App\\Api\\V4\\Controllers\\UsersController2@admin_cigarette_delete');
		$api->post('admin_lottery_delete', 'App\\Api\\V4\\Controllers\\UsersController2@admin_lottery_delete');
		$api->post('admin_expense_delete', 'App\\Api\\V4\\Controllers\\UsersController2@admin_expense_delete');
		
		$api->post('add_lottery', 'App\\Api\\V4\\Controllers\\UsersController2@add_lottery');
		$api->post('add_expense', 'App\\Api\\V4\\Controllers\\UsersController2@add_expense');
		$api->post('send_message', 'App\\Api\\V4\\Controllers\\UsersController2@send_message');
		
		$api->post('add_inventory', 'App\\Api\\V4\\Controllers\\UsersController2@add_inventory');
		$api->post('add_sales_report', 'App\\Api\\V4\\Controllers\\UsersController2@add_sales_report');
		$api->post('add_payment_report', 'App\\Api\\V4\\Controllers\\UsersController2@add_payment_report');
		$api->post('get_vendor_items', 'App\\Api\\V4\\Controllers\\UsersController2@get_vendor_items');
		
		$api->post('get_expense_items', 'App\\Api\\V4\\Controllers\\UsersController2@get_expense_items');
		$api->post('get_config', 'App\\Api\\V4\\Controllers\\UsersController2@get_config');
		
		// New Changes
		// Western Union
		$api->post('add_western_union', 'App\\Api\\V4\\Controllers\\UsersController2@add_western_union');
		$api->post('admin_western_union_edit', 'App\\Api\\V4\\Controllers\\UsersController2@admin_western_union_edit');
		$api->post('admin_western_union_delete', 'App\\Api\\V4\\Controllers\\UsersController2@admin_western_union_delete');
		$api->post('western_union_report', 'App\\Api\\V4\\Controllers\\UsersController2@western_union_report');
		$api->post('western_union_report2', 'App\\Api\\V4\\Controllers\\UsersController2@western_union_report2');
		$api->post('western_union_report3', 'App\\Api\\V4\\Controllers\\UsersController2@western_union_report3');
		
		// Show Messages Admin
		$api->post('messages', 'App\\Api\\V4\\Controllers\\UsersController2@messages');
		$api->post('get_messages', 'App\\Api\\V4\\Controllers\\UsersController2@get_messages');
		
	});
	
	
	$api->group(['prefix' => 'v5'], function(Router $api) {
        $api->post('login', 'App\\Api\\V5\\Controllers\\UsersController2@login');
		$api->post('forgot_password', 'App\\Api\\V5\\Controllers\\UsersController2@forgotPassword');
		$api->post('edit_profile', 'App\\Api\\V5\\Controllers\\UsersController2@editProfile');
		$api->post('update_profile', 'App\\Api\\V5\\Controllers\\UsersController2@updateProfileData');
		$api->post('logout', 'App\\Api\\V5\\Controllers\\UsersController2@logout');
		$api->post('change_password', 'App\\Api\\V5\\Controllers\\UsersController2@change_password');
		
		$api->post('del_multiple', 'App\\Api\\V5\\Controllers\\UsersController2@del_multiple');
		$api->post('inventory_filter', 'App\\Api\\V5\\Controllers\\UsersController2@inventory_filter');
		$api->post('inventory_filter_page2', 'App\\Api\\V5\\Controllers\\UsersController2@inventory_filter_page2');
		$api->post('add_sales_payment', 'App\\Api\\V5\\Controllers\\UsersController2@add_sales_payment');
		$api->post('get_stores', 'App\\Api\\V5\\Controllers\\UsersController2@get_stores');
		$api->post('signup', 'App\\Api\\V5\\Controllers\\UsersController2@signup');
		
		$api->post('user_list', 'App\\Api\\V5\\Controllers\\UsersController2@user_list');
		$api->post('blocked_user_list', 'App\\Api\\V5\\Controllers\\UsersController2@blocked_user_list');
		$api->post('add_user', 'App\\Api\\V5\\Controllers\\UsersController2@add_user');
		$api->post('edit_user', 'App\\Api\\V5\\Controllers\\UsersController2@edit_user');
		$api->post('update_user_info', 'App\\Api\\V5\\Controllers\\UsersController2@update_user_info');
		$api->post('delete_user', 'App\\Api\\V5\\Controllers\\UsersController2@delete_user');
		$api->post('del_user', 'App\\Api\\V5\\Controllers\\UsersController2@del_user');
		
		$api->post('add_cigarette', 'App\\Api\\V5\\Controllers\\UsersController2@add_cigarette');
		$api->post('add_atm', 'App\\Api\\V5\\Controllers\\UsersController2@add_atm');
		$api->post('get_all_messages', 'App\\Api\\V5\\Controllers\\UsersController2@get_all_messages');
		
		$api->post('store_list', 'App\\Api\\V5\\Controllers\\UsersController2@store_list');
		$api->post('store_list_new', 'App\\Api\\V5\\Controllers\\UsersController2@store_list_new');
		$api->post('add_store', 'App\\Api\\V5\\Controllers\\UsersController2@add_store');
		$api->post('edit_store', 'App\\Api\\V5\\Controllers\\UsersController2@edit_store');
		$api->post('update_store_info', 'App\\Api\\V5\\Controllers\\UsersController2@update_store_info');
		$api->post('delete_store', 'App\\Api\\V5\\Controllers\\UsersController2@delete_store');
		
		$api->post('item_list', 'App\\Api\\V5\\Controllers\\UsersController2@item_list');
		$api->post('add_item', 'App\\Api\\V5\\Controllers\\UsersController2@add_item');
		$api->post('edit_item', 'App\\Api\\V5\\Controllers\\UsersController2@edit_item');
		$api->post('update_item_info', 'App\\Api\\V5\\Controllers\\UsersController2@update_item_info');
		$api->post('delete_item', 'App\\Api\\V5\\Controllers\\UsersController2@delete_item');
		
		$api->post('vendor_list', 'App\\Api\\V5\\Controllers\\UsersController2@vendor_list');
		$api->post('add_vendor', 'App\\Api\\V5\\Controllers\\UsersController2@add_vendor');
		$api->post('edit_vendor', 'App\\Api\\V5\\Controllers\\UsersController2@edit_vendor');
		$api->post('update_vendor_info', 'App\\Api\\V5\\Controllers\\UsersController2@update_vendor_info');
		$api->post('delete_vendor', 'App\\Api\\V5\\Controllers\\UsersController2@delete_vendor');
		
		$api->post('get_store_data', 'App\\Api\\V5\\Controllers\\UsersController2@get_store_data');
		$api->post('store_in_profit', 'App\\Api\\V5\\Controllers\\UsersController2@store_in_profit');
		$api->post('store_in_profit2', 'App\\Api\\V5\\Controllers\\UsersController2@store_in_profit2');
		$api->post('user_store_in_profit', 'App\\Api\\V5\\Controllers\\UsersController2@user_store_in_profit');
		$api->post('user_report', 'App\\Api\\V5\\Controllers\\UsersController2@user_report');
		$api->post('store_info', 'App\\Api\\V5\\Controllers\\UsersController2@store_info');
		$api->post('store_info2', 'App\\Api\\V5\\Controllers\\UsersController2@store_info2');
		$api->post('user_report_store', 'App\\Api\\V5\\Controllers\\UsersController2@user_report_store');
		$api->post('store_Info_detail', 'App\\Api\\V5\\Controllers\\UsersController2@store_Info_detail');
		$api->post('latest', 'App\\Api\\V5\\Controllers\\UsersController2@latest');
		$api->post('user_entry_details', 'App\\Api\\V5\\Controllers\\UsersController2@user_entry_details');
		$api->post('user_report_date', 'App\\Api\\V5\\Controllers\\UsersController2@user_report_date');
		$api->post('all_daily_report', 'App\\Api\\V5\\Controllers\\UsersController2@all_daily_report');
		
		$api->post('admin_sales_edit', 'App\\Api\\V5\\Controllers\\UsersController2@admin_sales_edit');
		$api->post('admin_payment_edit', 'App\\Api\\V5\\Controllers\\UsersController2@admin_payment_edit');
		$api->post('admin_inventory_edit', 'App\\Api\\V5\\Controllers\\UsersController2@admin_inventory_edit');
		$api->post('admin_atm_edit', 'App\\Api\\V5\\Controllers\\UsersController2@admin_atm_edit');
		$api->post('admin_cigarette_edit', 'App\\Api\\V5\\Controllers\\UsersController2@admin_cigarette_edit');
		$api->post('admin_lottery_edit', 'App\\Api\\V5\\Controllers\\UsersController2@admin_lottery_edit');
		$api->post('admin_expense_edit', 'App\\Api\\V5\\Controllers\\UsersController2@admin_expense_edit');
		$api->post('admin_sales_delete', 'App\\Api\\V5\\Controllers\\UsersController2@admin_sales_delete');
		$api->post('admin_payment_delete', 'App\\Api\\V5\\Controllers\\UsersController2@admin_payment_delete');
		$api->post('admin_inventory_delete', 'App\\Api\\V5\\Controllers\\UsersController2@admin_inventory_delete');
		$api->post('admin_atm_delete', 'App\\Api\\V5\\Controllers\\UsersController2@admin_atm_delete');
		$api->post('admin_cigarette_delete', 'App\\Api\\V5\\Controllers\\UsersController2@admin_cigarette_delete');
		$api->post('admin_lottery_delete', 'App\\Api\\V5\\Controllers\\UsersController2@admin_lottery_delete');
		$api->post('admin_expense_delete', 'App\\Api\\V5\\Controllers\\UsersController2@admin_expense_delete');
		
		$api->post('add_lottery', 'App\\Api\\V5\\Controllers\\UsersController2@add_lottery');
		$api->post('add_expense', 'App\\Api\\V5\\Controllers\\UsersController2@add_expense');
		$api->post('send_message', 'App\\Api\\V5\\Controllers\\UsersController2@send_message');
		
		$api->post('add_inventory', 'App\\Api\\V5\\Controllers\\UsersController2@add_inventory');
		$api->post('add_sales_report', 'App\\Api\\V5\\Controllers\\UsersController2@add_sales_report');
		$api->post('add_payment_report', 'App\\Api\\V5\\Controllers\\UsersController2@add_payment_report');
		$api->post('get_vendor_items', 'App\\Api\\V5\\Controllers\\UsersController2@get_vendor_items');
		
		$api->post('get_expense_items', 'App\\Api\\V5\\Controllers\\UsersController2@get_expense_items');
		$api->post('get_config', 'App\\Api\\V5\\Controllers\\UsersController2@get_config');
		
		// New Changes
		// Western Union
		$api->post('add_western_union', 'App\\Api\\V5\\Controllers\\UsersController2@add_western_union');
		$api->post('admin_western_union_edit', 'App\\Api\\V5\\Controllers\\UsersController2@admin_western_union_edit');
		$api->post('admin_western_union_delete', 'App\\Api\\V5\\Controllers\\UsersController2@admin_western_union_delete');
		$api->post('western_union_report', 'App\\Api\\V5\\Controllers\\UsersController2@western_union_report');
		$api->post('western_union_report2', 'App\\Api\\V5\\Controllers\\UsersController2@western_union_report2');
		$api->post('western_union_report3', 'App\\Api\\V5\\Controllers\\UsersController2@western_union_report3');
		
		// Show Messages Admin
		$api->post('messages', 'App\\Api\\V5\\Controllers\\UsersController2@messages');
		$api->post('get_messages', 'App\\Api\\V5\\Controllers\\UsersController2@get_messages');
		
		// iOS send message
		$api->post('ios_upload_image', 'App\\Api\\V5\\Controllers\\UsersController2@ios_upload_image');
		$api->post('ios_send_message', 'App\\Api\\V5\\Controllers\\UsersController2@ios_send_message');
	});
	
	$api->group(['prefix' => 'v6'], function(Router $api) {
        $api->post('login', 'App\\Api\\V6\\Controllers\\UsersController2@login');
		$api->post('forgot_password', 'App\\Api\\V6\\Controllers\\UsersController2@forgotPassword');
		$api->post('edit_profile', 'App\\Api\\V6\\Controllers\\UsersController2@editProfile');
		$api->post('update_profile', 'App\\Api\\V6\\Controllers\\UsersController2@updateProfileData');
		$api->post('logout', 'App\\Api\\V6\\Controllers\\UsersController2@logout');
		$api->post('change_password', 'App\\Api\\V6\\Controllers\\UsersController2@change_password');
		
		$api->post('del_multiple', 'App\\Api\\V6\\Controllers\\UsersController2@del_multiple');
		$api->post('inventory_filter', 'App\\Api\\V6\\Controllers\\UsersController2@inventory_filter');
		$api->post('inventory_filter_page2', 'App\\Api\\V6\\Controllers\\UsersController2@inventory_filter_page2');
		$api->post('add_sales_payment', 'App\\Api\\V6\\Controllers\\UsersController2@add_sales_payment');
		$api->post('get_stores', 'App\\Api\\V6\\Controllers\\UsersController2@get_stores');
		$api->post('signup', 'App\\Api\\V6\\Controllers\\UsersController2@signup');
		
		$api->post('user_list', 'App\\Api\\V6\\Controllers\\UsersController2@user_list');
		$api->post('blocked_user_list', 'App\\Api\\V6\\Controllers\\UsersController2@blocked_user_list');
		$api->post('add_user', 'App\\Api\\V6\\Controllers\\UsersController2@add_user');
		$api->post('edit_user', 'App\\Api\\V6\\Controllers\\UsersController2@edit_user');
		$api->post('update_user_info', 'App\\Api\\V6\\Controllers\\UsersController2@update_user_info');
		$api->post('delete_user', 'App\\Api\\V6\\Controllers\\UsersController2@delete_user');
		$api->post('del_user', 'App\\Api\\V6\\Controllers\\UsersController2@del_user');
		
		$api->post('add_cigarette', 'App\\Api\\V6\\Controllers\\UsersController2@add_cigarette');
		$api->post('add_atm', 'App\\Api\\V6\\Controllers\\UsersController2@add_atm');
		$api->post('get_all_messages', 'App\\Api\\V6\\Controllers\\UsersController2@get_all_messages');
		
		$api->post('store_list', 'App\\Api\\V6\\Controllers\\UsersController2@store_list');
		$api->post('store_list_new', 'App\\Api\\V6\\Controllers\\UsersController2@store_list_new');
		$api->post('add_store', 'App\\Api\\V6\\Controllers\\UsersController2@add_store');
		$api->post('edit_store', 'App\\Api\\V6\\Controllers\\UsersController2@edit_store');
		$api->post('update_store_info', 'App\\Api\\V6\\Controllers\\UsersController2@update_store_info');
		$api->post('delete_store', 'App\\Api\\V6\\Controllers\\UsersController2@delete_store');
		
		$api->post('item_list', 'App\\Api\\V6\\Controllers\\UsersController2@item_list');
		$api->post('add_item', 'App\\Api\\V6\\Controllers\\UsersController2@add_item');
		$api->post('edit_item', 'App\\Api\\V6\\Controllers\\UsersController2@edit_item');
		$api->post('update_item_info', 'App\\Api\\V6\\Controllers\\UsersController2@update_item_info');
		$api->post('delete_item', 'App\\Api\\V6\\Controllers\\UsersController2@delete_item');
		
		$api->post('vendor_list', 'App\\Api\\V6\\Controllers\\UsersController2@vendor_list');
		$api->post('add_vendor', 'App\\Api\\V6\\Controllers\\UsersController2@add_vendor');
		$api->post('edit_vendor', 'App\\Api\\V6\\Controllers\\UsersController2@edit_vendor');
		$api->post('update_vendor_info', 'App\\Api\\V6\\Controllers\\UsersController2@update_vendor_info');
		$api->post('delete_vendor', 'App\\Api\\V6\\Controllers\\UsersController2@delete_vendor');
		
		$api->post('get_store_data', 'App\\Api\\V6\\Controllers\\UsersController2@get_store_data');
		$api->post('store_in_profit', 'App\\Api\\V6\\Controllers\\UsersController2@store_in_profit');
		$api->post('store_in_profit2', 'App\\Api\\V6\\Controllers\\UsersController2@store_in_profit2');
		$api->post('user_store_in_profit', 'App\\Api\\V6\\Controllers\\UsersController2@user_store_in_profit');
		$api->post('user_report', 'App\\Api\\V6\\Controllers\\UsersController2@user_report');
		$api->post('store_info', 'App\\Api\\V6\\Controllers\\UsersController2@store_info');
		$api->post('store_info2', 'App\\Api\\V6\\Controllers\\UsersController2@store_info2');
		$api->post('user_report_store', 'App\\Api\\V6\\Controllers\\UsersController2@user_report_store');
		$api->post('store_Info_detail', 'App\\Api\\V6\\Controllers\\UsersController2@store_Info_detail');
		$api->post('latest', 'App\\Api\\V6\\Controllers\\UsersController2@latest');
		$api->post('user_entry_details', 'App\\Api\\V6\\Controllers\\UsersController2@user_entry_details');
		$api->post('user_report_date', 'App\\Api\\V6\\Controllers\\UsersController2@user_report_date');
		$api->post('all_daily_report', 'App\\Api\\V6\\Controllers\\UsersController2@all_daily_report');
		
		$api->post('admin_sales_edit', 'App\\Api\\V6\\Controllers\\UsersController2@admin_sales_edit');
		$api->post('admin_payment_edit', 'App\\Api\\V6\\Controllers\\UsersController2@admin_payment_edit');
		$api->post('admin_inventory_edit', 'App\\Api\\V6\\Controllers\\UsersController2@admin_inventory_edit');
		$api->post('admin_atm_edit', 'App\\Api\\V6\\Controllers\\UsersController2@admin_atm_edit');
		$api->post('admin_cigarette_edit', 'App\\Api\\V6\\Controllers\\UsersController2@admin_cigarette_edit');
		$api->post('admin_lottery_edit', 'App\\Api\\V6\\Controllers\\UsersController2@admin_lottery_edit');
		$api->post('admin_expense_edit', 'App\\Api\\V6\\Controllers\\UsersController2@admin_expense_edit');
		$api->post('admin_sales_delete', 'App\\Api\\V6\\Controllers\\UsersController2@admin_sales_delete');
		$api->post('admin_payment_delete', 'App\\Api\\V6\\Controllers\\UsersController2@admin_payment_delete');
		$api->post('admin_inventory_delete', 'App\\Api\\V6\\Controllers\\UsersController2@admin_inventory_delete');
		$api->post('admin_atm_delete', 'App\\Api\\V6\\Controllers\\UsersController2@admin_atm_delete');
		$api->post('admin_cigarette_delete', 'App\\Api\\V6\\Controllers\\UsersController2@admin_cigarette_delete');
		$api->post('admin_lottery_delete', 'App\\Api\\V6\\Controllers\\UsersController2@admin_lottery_delete');
		$api->post('admin_expense_delete', 'App\\Api\\V6\\Controllers\\UsersController2@admin_expense_delete');
		
		$api->post('add_lottery', 'App\\Api\\V6\\Controllers\\UsersController2@add_lottery');
		$api->post('add_expense', 'App\\Api\\V6\\Controllers\\UsersController2@add_expense');
		$api->post('send_message', 'App\\Api\\V6\\Controllers\\UsersController2@send_message');
		
		$api->post('add_inventory', 'App\\Api\\V6\\Controllers\\UsersController2@add_inventory');
		$api->post('add_sales_report', 'App\\Api\\V6\\Controllers\\UsersController2@add_sales_report');
		$api->post('add_payment_report', 'App\\Api\\V6\\Controllers\\UsersController2@add_payment_report');
		$api->post('get_vendor_items', 'App\\Api\\V6\\Controllers\\UsersController2@get_vendor_items');
		
		$api->post('get_expense_items', 'App\\Api\\V6\\Controllers\\UsersController2@get_expense_items');
		$api->post('get_config', 'App\\Api\\V6\\Controllers\\UsersController2@get_config');
		
		// New Changes
		// Western Union
		$api->post('add_western_union', 'App\\Api\\V6\\Controllers\\UsersController2@add_western_union');
		$api->post('admin_western_union_edit', 'App\\Api\\V6\\Controllers\\UsersController2@admin_western_union_edit');
		$api->post('admin_western_union_delete', 'App\\Api\\V6\\Controllers\\UsersController2@admin_western_union_delete');
		$api->post('western_union_report', 'App\\Api\\V6\\Controllers\\UsersController2@western_union_report');
		$api->post('western_union_report2', 'App\\Api\\V6\\Controllers\\UsersController2@western_union_report2');
		$api->post('western_union_report3', 'App\\Api\\V6\\Controllers\\UsersController2@western_union_report3');
		
		// Show Messages Admin
		$api->post('messages', 'App\\Api\\V6\\Controllers\\UsersController2@messages');
		$api->post('get_messages', 'App\\Api\\V6\\Controllers\\UsersController2@get_messages');
		
		// iOS send message
		$api->post('ios_upload_image', 'App\\Api\\V6\\Controllers\\UsersController2@ios_upload_image');
		$api->post('ios_send_message', 'App\\Api\\V6\\Controllers\\UsersController2@ios_send_message');
	});

	$api->group(['prefix' => 'v7'], function(Router $api) {
		$api->post('login', 'App\\Api\\V7\\Controllers\\UsersController2@login');
		$api->post('forgot_password', 'App\\Api\\V7\\Controllers\\UsersController2@forgotPassword');
		$api->post('edit_profile', 'App\\Api\\V7\\Controllers\\UsersController2@editProfile');
		$api->post('update_profile', 'App\\Api\\V7\\Controllers\\UsersController2@updateProfileData');
		$api->post('logout', 'App\\Api\\V7\\Controllers\\UsersController2@logout');
		$api->post('change_password', 'App\\Api\\V7\\Controllers\\UsersController2@change_password');
		
		$api->post('del_multiple', 'App\\Api\\V7\\Controllers\\UsersController2@del_multiple');
		$api->post('inventory_filter', 'App\\Api\\V7\\Controllers\\UsersController2@inventory_filter');
		$api->post('inventory_filter_page2', 'App\\Api\\V7\\Controllers\\UsersController2@inventory_filter_page2');
		$api->post('add_sales_payment', 'App\\Api\\V7\\Controllers\\UsersController2@add_sales_payment');
		$api->post('get_stores', 'App\\Api\\V7\\Controllers\\UsersController2@get_stores');
		$api->post('signup', 'App\\Api\\V7\\Controllers\\UsersController2@signup');
		
		$api->post('user_list', 'App\\Api\\V7\\Controllers\\UsersController2@user_list');
		$api->post('blocked_user_list', 'App\\Api\\V7\\Controllers\\UsersController2@blocked_user_list');
		$api->post('add_user', 'App\\Api\\V7\\Controllers\\UsersController2@add_user');
		$api->post('edit_user', 'App\\Api\\V7\\Controllers\\UsersController2@edit_user');
		$api->post('update_user_info', 'App\\Api\\V7\\Controllers\\UsersController2@update_user_info');
		$api->post('delete_user', 'App\\Api\\V7\\Controllers\\UsersController2@delete_user');
		$api->post('del_user', 'App\\Api\\V7\\Controllers\\UsersController2@del_user');
		
		$api->post('add_cigarette', 'App\\Api\\V7\\Controllers\\UsersController2@add_cigarette');
		$api->post('add_atm', 'App\\Api\\V7\\Controllers\\UsersController2@add_atm');
		$api->post('get_all_messages', 'App\\Api\\V7\\Controllers\\UsersController2@get_all_messages');
		
		$api->post('store_list', 'App\\Api\\V7\\Controllers\\UsersController2@store_list');
		$api->post('store_list_new', 'App\\Api\\V7\\Controllers\\UsersController2@store_list_new');
		$api->post('add_store', 'App\\Api\\V7\\Controllers\\UsersController2@add_store');
		$api->post('edit_store', 'App\\Api\\V7\\Controllers\\UsersController2@edit_store');
		$api->post('update_store_info', 'App\\Api\\V7\\Controllers\\UsersController2@update_store_info');
		$api->post('delete_store', 'App\\Api\\V7\\Controllers\\UsersController2@delete_store');
		
		$api->post('item_list', 'App\\Api\\V7\\Controllers\\UsersController2@item_list');
		$api->post('add_item', 'App\\Api\\V7\\Controllers\\UsersController2@add_item');
		$api->post('edit_item', 'App\\Api\\V7\\Controllers\\UsersController2@edit_item');
		$api->post('update_item_info', 'App\\Api\\V7\\Controllers\\UsersController2@update_item_info');
		$api->post('delete_item', 'App\\Api\\V7\\Controllers\\UsersController2@delete_item');
		
		$api->post('vendor_list', 'App\\Api\\V7\\Controllers\\UsersController2@vendor_list');
		$api->post('add_vendor', 'App\\Api\\V7\\Controllers\\UsersController2@add_vendor');
		$api->post('edit_vendor', 'App\\Api\\V7\\Controllers\\UsersController2@edit_vendor');
		$api->post('update_vendor_info', 'App\\Api\\V7\\Controllers\\UsersController2@update_vendor_info');
		$api->post('delete_vendor', 'App\\Api\\V7\\Controllers\\UsersController2@delete_vendor');
		
		$api->post('get_store_data', 'App\\Api\\V7\\Controllers\\UsersController2@get_store_data');
		$api->post('store_in_profit', 'App\\Api\\V7\\Controllers\\UsersController2@store_in_profit');
		$api->post('store_in_profit2', 'App\\Api\\V7\\Controllers\\UsersController2@store_in_profit2');
		$api->post('user_store_in_profit', 'App\\Api\\V7\\Controllers\\UsersController2@user_store_in_profit');
		$api->post('user_report', 'App\\Api\\V7\\Controllers\\UsersController2@user_report');
		$api->post('store_info', 'App\\Api\\V7\\Controllers\\UsersController2@store_info');
		$api->post('store_info2', 'App\\Api\\V7\\Controllers\\UsersController2@store_info2');
		$api->post('user_report_store', 'App\\Api\\V7\\Controllers\\UsersController2@user_report_store');
		$api->post('store_Info_detail', 'App\\Api\\V7\\Controllers\\UsersController2@store_Info_detail');
		$api->post('latest', 'App\\Api\\V7\\Controllers\\UsersController2@latest');
		$api->post('user_entry_details', 'App\\Api\\V7\\Controllers\\UsersController2@user_entry_details');
		$api->post('user_report_date', 'App\\Api\\V7\\Controllers\\UsersController2@user_report_date');
		$api->post('all_daily_report', 'App\\Api\\V7\\Controllers\\UsersController2@all_daily_report');
		
		$api->post('admin_sales_edit', 'App\\Api\\V7\\Controllers\\UsersController2@admin_sales_edit');
		$api->post('admin_payment_edit', 'App\\Api\\V7\\Controllers\\UsersController2@admin_payment_edit');
		$api->post('admin_inventory_edit', 'App\\Api\\V7\\Controllers\\UsersController2@admin_inventory_edit');
		$api->post('admin_atm_edit', 'App\\Api\\V7\\Controllers\\UsersController2@admin_atm_edit');
		$api->post('admin_cigarette_edit', 'App\\Api\\V7\\Controllers\\UsersController2@admin_cigarette_edit');
		$api->post('admin_lottery_edit', 'App\\Api\\V7\\Controllers\\UsersController2@admin_lottery_edit');
		$api->post('admin_expense_edit', 'App\\Api\\V7\\Controllers\\UsersController2@admin_expense_edit');
		$api->post('admin_sales_delete', 'App\\Api\\V7\\Controllers\\UsersController2@admin_sales_delete');
		$api->post('admin_payment_delete', 'App\\Api\\V7\\Controllers\\UsersController2@admin_payment_delete');
		$api->post('admin_inventory_delete', 'App\\Api\\V7\\Controllers\\UsersController2@admin_inventory_delete');
		$api->post('admin_atm_delete', 'App\\Api\\V7\\Controllers\\UsersController2@admin_atm_delete');
		$api->post('admin_cigarette_delete', 'App\\Api\\V7\\Controllers\\UsersController2@admin_cigarette_delete');
		$api->post('admin_lottery_delete', 'App\\Api\\V7\\Controllers\\UsersController2@admin_lottery_delete');
		$api->post('admin_expense_delete', 'App\\Api\\V7\\Controllers\\UsersController2@admin_expense_delete');
		
		$api->post('add_lottery', 'App\\Api\\V7\\Controllers\\UsersController2@add_lottery');
		$api->post('add_expense', 'App\\Api\\V7\\Controllers\\UsersController2@add_expense');
		$api->post('send_message', 'App\\Api\\V7\\Controllers\\UsersController2@send_message');
		
		$api->post('add_inventory', 'App\\Api\\V7\\Controllers\\UsersController2@add_inventory');
		$api->post('add_sales_report', 'App\\Api\\V7\\Controllers\\UsersController2@add_sales_report');
		$api->post('add_payment_report', 'App\\Api\\V7\\Controllers\\UsersController2@add_payment_report');
		$api->post('get_vendor_items', 'App\\Api\\V7\\Controllers\\UsersController2@get_vendor_items');
		
		$api->post('get_expense_items', 'App\\Api\\V7\\Controllers\\UsersController2@get_expense_items');
		$api->post('get_config', 'App\\Api\\V7\\Controllers\\UsersController2@get_config');
		
		// New Changes
		// Western Union
		$api->post('add_western_union', 'App\\Api\\V7\\Controllers\\UsersController2@add_western_union');
		$api->post('admin_western_union_edit', 'App\\Api\\V7\\Controllers\\UsersController2@admin_western_union_edit');
		$api->post('admin_western_union_delete', 'App\\Api\\V7\\Controllers\\UsersController2@admin_western_union_delete');
		$api->post('western_union_report', 'App\\Api\\V7\\Controllers\\UsersController2@western_union_report');
		$api->post('western_union_report2', 'App\\Api\\V7\\Controllers\\UsersController2@western_union_report2');
		$api->post('western_union_report3', 'App\\Api\\V7\\Controllers\\UsersController2@western_union_report3');
		
		// Show Messages Admin
		$api->post('messages', 'App\\Api\\V7\\Controllers\\UsersController2@messages');
		$api->post('get_messages', 'App\\Api\\V7\\Controllers\\UsersController2@get_messages');
		
		// iOS send message
		$api->post('ios_upload_image', 'App\\Api\\V7\\Controllers\\UsersController2@ios_upload_image');
		$api->post('ios_send_message', 'App\\Api\\V7\\Controllers\\UsersController2@ios_send_message');
		// New list by vishal
		$api->post('overshort_report', 'App\\Api\\V7\\Controllers\\UsersController2@overshort');
		$api->post('overshort_report_user', 'App\\Api\\V7\\Controllers\\UsersController2@store_info_overshort2');
		$api->post('cigarettes_report', 'App\\Api\\V7\\Controllers\\UsersController2@cigarettes');
		$api->post('cigarettes_report_user', 'App\\Api\\V7\\Controllers\\UsersController2@store_cigarettes_user_report');
		$api->post('lottery_report', 'App\\Api\\V7\\Controllers\\UsersController2@lottery_report');
		$api->post('lottery_report_user', 'App\\Api\\V7\\Controllers\\UsersController2@store_lottery_user_report');
		$api->post('profit_lost_report', 'App\\Api\\V7\\Controllers\\UsersController2@profit_lost_report');
		$api->post('profit_lost_user_report', 'App\\Api\\V7\\Controllers\\UsersController2@profit_lost_user_report');
	});
	
	$api->group(['prefix' => 'v8'], function(Router $api) {
		$api->post('login', 'App\\Api\\V8\\Controllers\\UsersController2@login');
		$api->post('forgot_password', 'App\\Api\\V8\\Controllers\\UsersController2@forgotPassword');
		$api->post('edit_profile', 'App\\Api\\V8\\Controllers\\UsersController2@editProfile');
		$api->post('update_profile', 'App\\Api\\V8\\Controllers\\UsersController2@updateProfileData');
		$api->post('logout', 'App\\Api\\V8\\Controllers\\UsersController2@logout');
		$api->post('change_password', 'App\\Api\\V8\\Controllers\\UsersController2@change_password');
		
		$api->post('del_multiple', 'App\\Api\\V8\\Controllers\\UsersController2@del_multiple');
		$api->post('inventory_filter', 'App\\Api\\V8\\Controllers\\UsersController2@inventory_filter');
		$api->post('inventory_filter_page2', 'App\\Api\\V8\\Controllers\\UsersController2@inventory_filter_page2');
		$api->post('add_sales_payment', 'App\\Api\\V8\\Controllers\\UsersController2@add_sales_payment');
		$api->post('get_stores', 'App\\Api\\V8\\Controllers\\UsersController2@get_stores');
		$api->post('signup', 'App\\Api\\V8\\Controllers\\UsersController2@signup');
		
		$api->post('user_list', 'App\\Api\\V8\\Controllers\\UsersController2@user_list');
		$api->post('blocked_user_list', 'App\\Api\\V8\\Controllers\\UsersController2@blocked_user_list');
		$api->post('add_user', 'App\\Api\\V8\\Controllers\\UsersController2@add_user');
		$api->post('edit_user', 'App\\Api\\V8\\Controllers\\UsersController2@edit_user');
		$api->post('update_user_info', 'App\\Api\\V8\\Controllers\\UsersController2@update_user_info');
		$api->post('delete_user', 'App\\Api\\V8\\Controllers\\UsersController2@delete_user');
		$api->post('del_user', 'App\\Api\\V8\\Controllers\\UsersController2@del_user');
		
		$api->post('add_cigarette', 'App\\Api\\V8\\Controllers\\UsersController2@add_cigarette');
		$api->post('add_atm', 'App\\Api\\V8\\Controllers\\UsersController2@add_atm');
		$api->post('get_all_messages', 'App\\Api\\V8\\Controllers\\UsersController2@get_all_messages');
		
		$api->post('store_list', 'App\\Api\\V8\\Controllers\\UsersController2@store_list');
		$api->post('store_list_new', 'App\\Api\\V8\\Controllers\\UsersController2@store_list_new');
		$api->post('add_store', 'App\\Api\\V8\\Controllers\\UsersController2@add_store');
		$api->post('edit_store', 'App\\Api\\V8\\Controllers\\UsersController2@edit_store');
		$api->post('update_store_info', 'App\\Api\\V8\\Controllers\\UsersController2@update_store_info');
		$api->post('delete_store', 'App\\Api\\V8\\Controllers\\UsersController2@delete_store');
		
		$api->post('item_list', 'App\\Api\\V8\\Controllers\\UsersController2@item_list');
		$api->post('add_item', 'App\\Api\\V8\\Controllers\\UsersController2@add_item');
		$api->post('edit_item', 'App\\Api\\V8\\Controllers\\UsersController2@edit_item');
		$api->post('update_item_info', 'App\\Api\\V8\\Controllers\\UsersController2@update_item_info');
		$api->post('delete_item', 'App\\Api\\V8\\Controllers\\UsersController2@delete_item');
		
		$api->post('vendor_list', 'App\\Api\\V8\\Controllers\\UsersController2@vendor_list');
		$api->post('add_vendor', 'App\\Api\\V8\\Controllers\\UsersController2@add_vendor');
		$api->post('edit_vendor', 'App\\Api\\V8\\Controllers\\UsersController2@edit_vendor');
		$api->post('update_vendor_info', 'App\\Api\\V8\\Controllers\\UsersController2@update_vendor_info');
		$api->post('delete_vendor', 'App\\Api\\V8\\Controllers\\UsersController2@delete_vendor');
		
		$api->post('get_store_data', 'App\\Api\\V8\\Controllers\\UsersController2@get_store_data');
		$api->post('store_in_profit', 'App\\Api\\V8\\Controllers\\UsersController2@store_in_profit');
		$api->post('store_in_profit2', 'App\\Api\\V8\\Controllers\\UsersController2@store_in_profit2');
		$api->post('user_store_in_profit', 'App\\Api\\V8\\Controllers\\UsersController2@user_store_in_profit');
		$api->post('user_report', 'App\\Api\\V8\\Controllers\\UsersController2@user_report');
		$api->post('store_info', 'App\\Api\\V8\\Controllers\\UsersController2@store_info');
		$api->post('store_info2', 'App\\Api\\V8\\Controllers\\UsersController2@store_info2');
		$api->post('user_report_store', 'App\\Api\\V8\\Controllers\\UsersController2@user_report_store');
		$api->post('store_Info_detail', 'App\\Api\\V8\\Controllers\\UsersController2@store_Info_detail');
		$api->post('latest', 'App\\Api\\V8\\Controllers\\UsersController2@latest');
		$api->post('user_entry_details', 'App\\Api\\V8\\Controllers\\UsersController2@user_entry_details');
		$api->post('user_report_date', 'App\\Api\\V8\\Controllers\\UsersController2@user_report_date');
		$api->post('all_daily_report', 'App\\Api\\V8\\Controllers\\UsersController2@all_daily_report');
		
		$api->post('admin_sales_edit', 'App\\Api\\V8\\Controllers\\UsersController2@admin_sales_edit');
		$api->post('admin_payment_edit', 'App\\Api\\V8\\Controllers\\UsersController2@admin_payment_edit');
		$api->post('admin_inventory_edit', 'App\\Api\\V8\\Controllers\\UsersController2@admin_inventory_edit');
		$api->post('admin_atm_edit', 'App\\Api\\V8\\Controllers\\UsersController2@admin_atm_edit');
		$api->post('admin_cigarette_edit', 'App\\Api\\V8\\Controllers\\UsersController2@admin_cigarette_edit');
		$api->post('admin_lottery_edit', 'App\\Api\\V8\\Controllers\\UsersController2@admin_lottery_edit');
		$api->post('admin_expense_edit', 'App\\Api\\V8\\Controllers\\UsersController2@admin_expense_edit');
		$api->post('admin_sales_delete', 'App\\Api\\V8\\Controllers\\UsersController2@admin_sales_delete');
		$api->post('admin_payment_delete', 'App\\Api\\V8\\Controllers\\UsersController2@admin_payment_delete');
		$api->post('admin_inventory_delete', 'App\\Api\\V8\\Controllers\\UsersController2@admin_inventory_delete');
		$api->post('admin_atm_delete', 'App\\Api\\V8\\Controllers\\UsersController2@admin_atm_delete');
		$api->post('admin_cigarette_delete', 'App\\Api\\V8\\Controllers\\UsersController2@admin_cigarette_delete');
		$api->post('admin_lottery_delete', 'App\\Api\\V8\\Controllers\\UsersController2@admin_lottery_delete');
		$api->post('admin_expense_delete', 'App\\Api\\V8\\Controllers\\UsersController2@admin_expense_delete');
		
		$api->post('add_lottery', 'App\\Api\\V8\\Controllers\\UsersController2@add_lottery');
		$api->post('add_expense', 'App\\Api\\V8\\Controllers\\UsersController2@add_expense');
		$api->post('send_message', 'App\\Api\\V8\\Controllers\\UsersController2@send_message');
		
		$api->post('add_inventory', 'App\\Api\\V8\\Controllers\\UsersController2@add_inventory');
		$api->post('add_sales_report', 'App\\Api\\V8\\Controllers\\UsersController2@add_sales_report');
		$api->post('add_payment_report', 'App\\Api\\V8\\Controllers\\UsersController2@add_payment_report');
		$api->post('get_vendor_items', 'App\\Api\\V8\\Controllers\\UsersController2@get_vendor_items');
		
		$api->post('get_expense_items', 'App\\Api\\V8\\Controllers\\UsersController2@get_expense_items');
		$api->post('get_config', 'App\\Api\\V8\\Controllers\\UsersController2@get_config');
		
		// New Changes
		// Western Union
		$api->post('add_western_union', 'App\\Api\\V8\\Controllers\\UsersController2@add_western_union');
		$api->post('admin_western_union_edit', 'App\\Api\\V8\\Controllers\\UsersController2@admin_western_union_edit');
		$api->post('admin_western_union_delete', 'App\\Api\\V8\\Controllers\\UsersController2@admin_western_union_delete');
		$api->post('western_union_report', 'App\\Api\\V8\\Controllers\\UsersController2@western_union_report');
		$api->post('western_union_report2', 'App\\Api\\V8\\Controllers\\UsersController2@western_union_report2');
		$api->post('western_union_report3', 'App\\Api\\V8\\Controllers\\UsersController2@western_union_report3');
		
		// Show Messages Admin
		$api->post('messages', 'App\\Api\\V8\\Controllers\\UsersController2@messages');
		$api->post('get_messages', 'App\\Api\\V8\\Controllers\\UsersController2@get_messages');
		
		// iOS send message
		$api->post('ios_upload_image', 'App\\Api\\V8\\Controllers\\UsersController2@ios_upload_image');
		$api->post('ios_send_message', 'App\\Api\\V8\\Controllers\\UsersController2@ios_send_message');
		// New list by vishal
		$api->post('overshort_report', 'App\\Api\\V8\\Controllers\\UsersController2@overshort');
		$api->post('overshort_report_user', 'App\\Api\\V8\\Controllers\\UsersController2@store_info_overshort2');
		$api->post('cigarettes_report', 'App\\Api\\V8\\Controllers\\UsersController2@cigarettes');
		$api->post('cigarettes_report_user', 'App\\Api\\V8\\Controllers\\UsersController2@store_cigarettes_user_report');
		$api->post('lottery_report', 'App\\Api\\V8\\Controllers\\UsersController2@lottery_report');
		$api->post('lottery_report_user', 'App\\Api\\V8\\Controllers\\UsersController2@store_lottery_user_report');
		$api->post('profit_lost_report', 'App\\Api\\V8\\Controllers\\UsersController2@profit_lost_report');
		$api->post('profit_lost_user_report', 'App\\Api\\V8\\Controllers\\UsersController2@profit_lost_user_report');
		$api->post('get_messages_id', 'App\\Api\\V8\\Controllers\\UsersController2@get_messages_id');
	});
	$api->group(['prefix' => 'v9'], function(Router $api) {
		$api->post('login', 'App\\Api\\V9\\Controllers\\UsersController2@login');
		$api->post('forgot_password', 'App\\Api\\V9\\Controllers\\UsersController2@forgotPassword');
		$api->post('edit_profile', 'App\\Api\\V9\\Controllers\\UsersController2@editProfile');
		$api->post('update_profile', 'App\\Api\\V9\\Controllers\\UsersController2@updateProfileData');
		$api->post('logout', 'App\\Api\\V9\\Controllers\\UsersController2@logout');
		$api->post('change_password', 'App\\Api\\V9\\Controllers\\UsersController2@change_password');
		
		$api->post('del_multiple', 'App\\Api\\V9\\Controllers\\UsersController2@del_multiple');
		$api->post('inventory_filter', 'App\\Api\\V9\\Controllers\\UsersController2@inventory_filter');
		$api->post('inventory_filter_page2', 'App\\Api\\V9\\Controllers\\UsersController2@inventory_filter_page2');
		$api->post('add_sales_payment', 'App\\Api\\V9\\Controllers\\UsersController2@add_sales_payment');
		$api->post('get_stores', 'App\\Api\\V9\\Controllers\\UsersController2@get_stores');
		$api->post('signup', 'App\\Api\\V9\\Controllers\\UsersController2@signup');
		
		$api->post('user_list', 'App\\Api\\V9\\Controllers\\UsersController2@user_list');
		$api->post('blocked_user_list', 'App\\Api\\V9\\Controllers\\UsersController2@blocked_user_list');
		$api->post('add_user', 'App\\Api\\V9\\Controllers\\UsersController2@add_user');
		$api->post('edit_user', 'App\\Api\\V9\\Controllers\\UsersController2@edit_user');
		$api->post('update_user_info', 'App\\Api\\V9\\Controllers\\UsersController2@update_user_info');
		$api->post('delete_user', 'App\\Api\\V9\\Controllers\\UsersController2@delete_user');
		$api->post('del_user', 'App\\Api\\V9\\Controllers\\UsersController2@del_user');
		
		$api->post('add_cigarette', 'App\\Api\\V9\\Controllers\\UsersController2@add_cigarette');
		$api->post('add_atm', 'App\\Api\\V9\\Controllers\\UsersController2@add_atm');
		$api->post('get_all_messages', 'App\\Api\\V9\\Controllers\\UsersController2@get_all_messages');
		
		$api->post('store_list', 'App\\Api\\V9\\Controllers\\UsersController2@store_list');
		$api->post('store_list_new', 'App\\Api\\V9\\Controllers\\UsersController2@store_list_new');
		$api->post('add_store', 'App\\Api\\V9\\Controllers\\UsersController2@add_store');
		$api->post('edit_store', 'App\\Api\\V9\\Controllers\\UsersController2@edit_store');
		$api->post('update_store_info', 'App\\Api\\V9\\Controllers\\UsersController2@update_store_info');
		$api->post('delete_store', 'App\\Api\\V9\\Controllers\\UsersController2@delete_store');
		
		$api->post('item_list', 'App\\Api\\V9\\Controllers\\UsersController2@item_list');
		$api->post('add_item', 'App\\Api\\V9\\Controllers\\UsersController2@add_item');
		$api->post('edit_item', 'App\\Api\\V9\\Controllers\\UsersController2@edit_item');
		$api->post('update_item_info', 'App\\Api\\V9\\Controllers\\UsersController2@update_item_info');
		$api->post('delete_item', 'App\\Api\\V9\\Controllers\\UsersController2@delete_item');
		
		$api->post('vendor_list', 'App\\Api\\V9\\Controllers\\UsersController2@vendor_list');
		$api->post('add_vendor', 'App\\Api\\V9\\Controllers\\UsersController2@add_vendor');
		$api->post('edit_vendor', 'App\\Api\\V9\\Controllers\\UsersController2@edit_vendor');
		$api->post('update_vendor_info', 'App\\Api\\V9\\Controllers\\UsersController2@update_vendor_info');
		$api->post('delete_vendor', 'App\\Api\\V9\\Controllers\\UsersController2@delete_vendor');
		
		$api->post('get_store_data', 'App\\Api\\V9\\Controllers\\UsersController2@get_store_data');
		$api->post('store_in_profit', 'App\\Api\\V9\\Controllers\\UsersController2@store_in_profit');
		$api->post('store_in_profit2', 'App\\Api\\V9\\Controllers\\UsersController2@store_in_profit2');
		$api->post('user_store_in_profit', 'App\\Api\\V9\\Controllers\\UsersController2@user_store_in_profit');
		$api->post('user_report', 'App\\Api\\V9\\Controllers\\UsersController2@user_report');
		$api->post('store_info', 'App\\Api\\V9\\Controllers\\UsersController2@store_info');
		$api->post('store_info2', 'App\\Api\\V9\\Controllers\\UsersController2@store_info2');
		$api->post('user_report_store', 'App\\Api\\V9\\Controllers\\UsersController2@user_report_store');
		$api->post('store_Info_detail', 'App\\Api\\V9\\Controllers\\UsersController2@store_Info_detail');
		$api->post('latest', 'App\\Api\\V9\\Controllers\\UsersController2@latest');
		$api->post('user_entry_details', 'App\\Api\\V9\\Controllers\\UsersController2@user_entry_details');
		$api->post('user_report_date', 'App\\Api\\V9\\Controllers\\UsersController2@user_report_date');
		$api->post('all_daily_report', 'App\\Api\\V9\\Controllers\\UsersController2@all_daily_report');
		
		$api->post('admin_sales_edit', 'App\\Api\\V9\\Controllers\\UsersController2@admin_sales_edit');
		$api->post('admin_payment_edit', 'App\\Api\\V9\\Controllers\\UsersController2@admin_payment_edit');
		$api->post('admin_inventory_edit', 'App\\Api\\V9\\Controllers\\UsersController2@admin_inventory_edit');
		$api->post('admin_atm_edit', 'App\\Api\\V9\\Controllers\\UsersController2@admin_atm_edit');
		$api->post('admin_cigarette_edit', 'App\\Api\\V9\\Controllers\\UsersController2@admin_cigarette_edit');
		$api->post('admin_lottery_edit', 'App\\Api\\V9\\Controllers\\UsersController2@admin_lottery_edit');
		$api->post('admin_expense_edit', 'App\\Api\\V9\\Controllers\\UsersController2@admin_expense_edit');
		$api->post('admin_sales_delete', 'App\\Api\\V9\\Controllers\\UsersController2@admin_sales_delete');
		$api->post('admin_payment_delete', 'App\\Api\\V9\\Controllers\\UsersController2@admin_payment_delete');
		$api->post('admin_inventory_delete', 'App\\Api\\V9\\Controllers\\UsersController2@admin_inventory_delete');
		$api->post('admin_atm_delete', 'App\\Api\\V9\\Controllers\\UsersController2@admin_atm_delete');
		$api->post('admin_cigarette_delete', 'App\\Api\\V9\\Controllers\\UsersController2@admin_cigarette_delete');
		$api->post('admin_lottery_delete', 'App\\Api\\V9\\Controllers\\UsersController2@admin_lottery_delete');
		$api->post('admin_expense_delete', 'App\\Api\\V9\\Controllers\\UsersController2@admin_expense_delete');
		
		$api->post('add_lottery', 'App\\Api\\V9\\Controllers\\UsersController2@add_lottery');
		$api->post('add_expense', 'App\\Api\\V9\\Controllers\\UsersController2@add_expense');
		$api->post('send_message', 'App\\Api\\V9\\Controllers\\UsersController2@send_message');
		
		$api->post('add_inventory', 'App\\Api\\V9\\Controllers\\UsersController2@add_inventory');
		$api->post('add_sales_report', 'App\\Api\\V9\\Controllers\\UsersController2@add_sales_report');
		$api->post('add_payment_report', 'App\\Api\\V9\\Controllers\\UsersController2@add_payment_report');
		$api->post('get_vendor_items', 'App\\Api\\V9\\Controllers\\UsersController2@get_vendor_items');
		
		$api->post('get_expense_items', 'App\\Api\\V9\\Controllers\\UsersController2@get_expense_items');
		$api->post('get_config', 'App\\Api\\V9\\Controllers\\UsersController2@get_config');
		
		// New Changes
		// Western Union
		$api->post('add_western_union', 'App\\Api\\V9\\Controllers\\UsersController2@add_western_union');
		$api->post('admin_western_union_edit', 'App\\Api\\V9\\Controllers\\UsersController2@admin_western_union_edit');
		$api->post('admin_western_union_delete', 'App\\Api\\V9\\Controllers\\UsersController2@admin_western_union_delete');
		$api->post('western_union_report', 'App\\Api\\V9\\Controllers\\UsersController2@western_union_report');
		$api->post('western_union_report2', 'App\\Api\\V9\\Controllers\\UsersController2@western_union_report2');
		$api->post('western_union_report3', 'App\\Api\\V9\\Controllers\\UsersController2@western_union_report3');
		
		// Show Messages Admin
		$api->post('messages', 'App\\Api\\V9\\Controllers\\UsersController2@messages');
		$api->post('get_messages', 'App\\Api\\V9\\Controllers\\UsersController2@get_messages');
		
		// iOS send message
		$api->post('ios_upload_image', 'App\\Api\\V9\\Controllers\\UsersController2@ios_upload_image');
		$api->post('ios_send_message', 'App\\Api\\V9\\Controllers\\UsersController2@ios_send_message');
		// New list by vishal
		$api->post('overshort_report', 'App\\Api\\V9\\Controllers\\UsersController2@overshort');
		$api->post('overshort_report_user', 'App\\Api\\V9\\Controllers\\UsersController2@store_info_overshort2');
		$api->post('cigarettes_report', 'App\\Api\\V9\\Controllers\\UsersController2@cigarettes');
		$api->post('cigarettes_report_user', 'App\\Api\\V9\\Controllers\\UsersController2@store_cigarettes_user_report');
		$api->post('lottery_report', 'App\\Api\\V9\\Controllers\\UsersController2@lottery_report');
		$api->post('lottery_report_user', 'App\\Api\\V9\\Controllers\\UsersController2@store_lottery_user_report');
		$api->post('profit_lost_report', 'App\\Api\\V9\\Controllers\\UsersController2@profit_lost_report');
		$api->post('profit_lost_user_report', 'App\\Api\\V9\\Controllers\\UsersController2@profit_lost_user_report');
		$api->post('get_messages_id', 'App\\Api\\V9\\Controllers\\UsersController2@get_messages_id');
	});
	$api->group(['prefix' => 'v10'], function(Router $api) {
		$api->post('login', 'App\\Api\\V10\\Controllers\\UsersController2@login');
		$api->post('forgot_password', 'App\\Api\\V10\\Controllers\\UsersController2@forgotPassword');
		$api->post('edit_profile', 'App\\Api\\V10\\Controllers\\UsersController2@editProfile');
		$api->post('update_profile', 'App\\Api\\V10\\Controllers\\UsersController2@updateProfileData');
		$api->post('logout', 'App\\Api\\V10\\Controllers\\UsersController2@logout');
		$api->post('change_password', 'App\\Api\\V10\\Controllers\\UsersController2@change_password');
		
		$api->post('del_multiple', 'App\\Api\\V10\\Controllers\\UsersController2@del_multiple');
		$api->post('inventory_filter', 'App\\Api\\V10\\Controllers\\UsersController2@inventory_filter');
		$api->post('inventory_filter_page2', 'App\\Api\\V10\\Controllers\\UsersController2@inventory_filter_page2');
		$api->post('add_sales_payment', 'App\\Api\\V10\\Controllers\\UsersController2@add_sales_payment');
		$api->post('get_stores', 'App\\Api\\V10\\Controllers\\UsersController2@get_stores');
		$api->post('signup', 'App\\Api\\V10\\Controllers\\UsersController2@signup');
		
		$api->post('user_list', 'App\\Api\\V10\\Controllers\\UsersController2@user_list');
		$api->post('blocked_user_list', 'App\\Api\\V10\\Controllers\\UsersController2@blocked_user_list');
		$api->post('add_user', 'App\\Api\\V10\\Controllers\\UsersController2@add_user');
		$api->post('edit_user', 'App\\Api\\V10\\Controllers\\UsersController2@edit_user');
		$api->post('update_user_info', 'App\\Api\\V10\\Controllers\\UsersController2@update_user_info');
		$api->post('delete_user', 'App\\Api\\V10\\Controllers\\UsersController2@delete_user');
		$api->post('del_user', 'App\\Api\\V10\\Controllers\\UsersController2@del_user');
		
		$api->post('add_cigarette', 'App\\Api\\V10\\Controllers\\UsersController2@add_cigarette');
		$api->post('add_atm', 'App\\Api\\V10\\Controllers\\UsersController2@add_atm');
		$api->post('get_all_messages', 'App\\Api\\V10\\Controllers\\UsersController2@get_all_messages');
		
		$api->post('store_list', 'App\\Api\\V10\\Controllers\\UsersController2@store_list');
		$api->post('store_list_new', 'App\\Api\\V10\\Controllers\\UsersController2@store_list_new');
		$api->post('add_store', 'App\\Api\\V10\\Controllers\\UsersController2@add_store');
		$api->post('edit_store', 'App\\Api\\V10\\Controllers\\UsersController2@edit_store');
		$api->post('update_store_info', 'App\\Api\\V10\\Controllers\\UsersController2@update_store_info');
		$api->post('delete_store', 'App\\Api\\V10\\Controllers\\UsersController2@delete_store');
		
		$api->post('item_list', 'App\\Api\\V10\\Controllers\\UsersController2@item_list');
		$api->post('add_item', 'App\\Api\\V10\\Controllers\\UsersController2@add_item');
		$api->post('edit_item', 'App\\Api\\V10\\Controllers\\UsersController2@edit_item');
		$api->post('update_item_info', 'App\\Api\\V10\\Controllers\\UsersController2@update_item_info');
		$api->post('delete_item', 'App\\Api\\V10\\Controllers\\UsersController2@delete_item');
		
		$api->post('vendor_list', 'App\\Api\\V10\\Controllers\\UsersController2@vendor_list');
		$api->post('add_vendor', 'App\\Api\\V10\\Controllers\\UsersController2@add_vendor');
		$api->post('edit_vendor', 'App\\Api\\V10\\Controllers\\UsersController2@edit_vendor');
		$api->post('update_vendor_info', 'App\\Api\\V10\\Controllers\\UsersController2@update_vendor_info');
		$api->post('delete_vendor', 'App\\Api\\V10\\Controllers\\UsersController2@delete_vendor');
		
		$api->post('get_store_data', 'App\\Api\\V10\\Controllers\\UsersController2@get_store_data');
		$api->post('store_in_profit', 'App\\Api\\V10\\Controllers\\UsersController2@store_in_profit');
		$api->post('store_in_profit2', 'App\\Api\\V10\\Controllers\\UsersController2@store_in_profit2');
		$api->post('user_store_in_profit', 'App\\Api\\V10\\Controllers\\UsersController2@user_store_in_profit');
		$api->post('user_report', 'App\\Api\\V10\\Controllers\\UsersController2@user_report');
		$api->post('store_info', 'App\\Api\\V10\\Controllers\\UsersController2@store_info');
		$api->post('store_info2', 'App\\Api\\V10\\Controllers\\UsersController2@store_info2');
		$api->post('user_report_store', 'App\\Api\\V10\\Controllers\\UsersController2@user_report_store');
		$api->post('store_Info_detail', 'App\\Api\\V10\\Controllers\\UsersController2@store_Info_detail');
		$api->post('latest', 'App\\Api\\V10\\Controllers\\UsersController2@latest');
		$api->post('user_entry_details', 'App\\Api\\V10\\Controllers\\UsersController2@user_entry_details');
		$api->post('user_report_date', 'App\\Api\\V10\\Controllers\\UsersController2@user_report_date');
		$api->post('all_daily_report', 'App\\Api\\V10\\Controllers\\UsersController2@all_daily_report');
		
		$api->post('admin_sales_edit', 'App\\Api\\V10\\Controllers\\UsersController2@admin_sales_edit');
		$api->post('admin_payment_edit', 'App\\Api\\V10\\Controllers\\UsersController2@admin_payment_edit');
		$api->post('admin_inventory_edit', 'App\\Api\\V10\\Controllers\\UsersController2@admin_inventory_edit');
		$api->post('admin_atm_edit', 'App\\Api\\V10\\Controllers\\UsersController2@admin_atm_edit');
		$api->post('admin_cigarette_edit', 'App\\Api\\V10\\Controllers\\UsersController2@admin_cigarette_edit');
		$api->post('admin_lottery_edit', 'App\\Api\\V10\\Controllers\\UsersController2@admin_lottery_edit');
		$api->post('admin_expense_edit', 'App\\Api\\V10\\Controllers\\UsersController2@admin_expense_edit');
		$api->post('admin_sales_delete', 'App\\Api\\V10\\Controllers\\UsersController2@admin_sales_delete');
		$api->post('admin_payment_delete', 'App\\Api\\V10\\Controllers\\UsersController2@admin_payment_delete');
		$api->post('admin_inventory_delete', 'App\\Api\\V10\\Controllers\\UsersController2@admin_inventory_delete');
		$api->post('admin_atm_delete', 'App\\Api\\V10\\Controllers\\UsersController2@admin_atm_delete');
		$api->post('admin_cigarette_delete', 'App\\Api\\V10\\Controllers\\UsersController2@admin_cigarette_delete');
		$api->post('admin_lottery_delete', 'App\\Api\\V10\\Controllers\\UsersController2@admin_lottery_delete');
		$api->post('admin_expense_delete', 'App\\Api\\V10\\Controllers\\UsersController2@admin_expense_delete');
		
		$api->post('add_lottery', 'App\\Api\\V10\\Controllers\\UsersController2@add_lottery');
		$api->post('add_expense', 'App\\Api\\V10\\Controllers\\UsersController2@add_expense');
		$api->post('send_message', 'App\\Api\\V10\\Controllers\\UsersController2@send_message');
		
		$api->post('add_inventory', 'App\\Api\\V10\\Controllers\\UsersController2@add_inventory');
		$api->post('add_sales_report', 'App\\Api\\V10\\Controllers\\UsersController2@add_sales_report');
		$api->post('add_payment_report', 'App\\Api\\V10\\Controllers\\UsersController2@add_payment_report');
		$api->post('get_vendor_items', 'App\\Api\\V10\\Controllers\\UsersController2@get_vendor_items');
		
		$api->post('get_expense_items', 'App\\Api\\V10\\Controllers\\UsersController2@get_expense_items');
		$api->post('get_config', 'App\\Api\\V10\\Controllers\\UsersController2@get_config');
		
		// New Changes
		// Western Union
		$api->post('add_western_union', 'App\\Api\\V10\\Controllers\\UsersController2@add_western_union');
		$api->post('admin_western_union_edit', 'App\\Api\\V10\\Controllers\\UsersController2@admin_western_union_edit');
		$api->post('admin_western_union_delete', 'App\\Api\\V10\\Controllers\\UsersController2@admin_western_union_delete');
		$api->post('western_union_report', 'App\\Api\\V10\\Controllers\\UsersController2@western_union_report');
		$api->post('western_union_report2', 'App\\Api\\V10\\Controllers\\UsersController2@western_union_report2');
		$api->post('western_union_report3', 'App\\Api\\V10\\Controllers\\UsersController2@western_union_report3');
		
		// Show Messages Admin
		$api->post('messages', 'App\\Api\\V10\\Controllers\\UsersController2@messages');
		$api->post('get_messages', 'App\\Api\\V10\\Controllers\\UsersController2@get_messages');
		
		// iOS send message
		$api->post('ios_upload_image', 'App\\Api\\V10\\Controllers\\UsersController2@ios_upload_image');
		$api->post('ios_send_message', 'App\\Api\\V10\\Controllers\\UsersController2@ios_send_message');
		// New list by vishal
		$api->post('overshort_report', 'App\\Api\\V10\\Controllers\\UsersController2@overshort');
		$api->post('overshort_report_user', 'App\\Api\\V10\\Controllers\\UsersController2@store_info_overshort2');
		$api->post('cigarettes_report', 'App\\Api\\V10\\Controllers\\UsersController2@cigarettes');
		$api->post('cigarettes_report_user', 'App\\Api\\V10\\Controllers\\UsersController2@store_cigarettes_user_report');
		$api->post('lottery_report', 'App\\Api\\V10\\Controllers\\UsersController2@lottery_report');
		$api->post('lottery_report_user', 'App\\Api\\V10\\Controllers\\UsersController2@store_lottery_user_report');
		$api->post('profit_lost_report', 'App\\Api\\V10\\Controllers\\UsersController2@profit_lost_report');
		$api->post('profit_lost_user_report', 'App\\Api\\V10\\Controllers\\UsersController2@profit_lost_user_report');
		$api->post('get_messages_id', 'App\\Api\\V10\\Controllers\\UsersController2@get_messages_id');
		$api->post('item_profit_lost', 'App\\Api\\V10\\Controllers\\UsersController2@item_profit_lost');
	});
	
	$api->group(['prefix' => 'v11'], function(Router $api) {
		$api->post('login', 'App\\Api\\V11\\Controllers\\UsersController2@login');
		$api->post('forgot_password', 'App\\Api\\V11\\Controllers\\UsersController2@forgotPassword');
		$api->post('edit_profile', 'App\\Api\\V11\\Controllers\\UsersController2@editProfile');
		$api->post('update_profile', 'App\\Api\\V11\\Controllers\\UsersController2@updateProfileData');
		$api->post('logout', 'App\\Api\\V11\\Controllers\\UsersController2@logout');
		$api->post('change_password', 'App\\Api\\V11\\Controllers\\UsersController2@change_password');
		
		$api->post('del_multiple', 'App\\Api\\V11\\Controllers\\UsersController2@del_multiple');
		$api->post('inventory_filter', 'App\\Api\\V11\\Controllers\\UsersController2@inventory_filter');
		$api->post('inventory_filter_page2', 'App\\Api\\V11\\Controllers\\UsersController2@inventory_filter_page2');
		$api->post('add_sales_payment', 'App\\Api\\V11\\Controllers\\UsersController2@add_sales_payment');
		$api->post('get_stores', 'App\\Api\\V11\\Controllers\\UsersController2@get_stores');
		$api->post('signup', 'App\\Api\\V11\\Controllers\\UsersController2@signup');
		
		$api->post('user_list', 'App\\Api\\V11\\Controllers\\UsersController2@user_list');
		$api->post('blocked_user_list', 'App\\Api\\V11\\Controllers\\UsersController2@blocked_user_list');
		$api->post('add_user', 'App\\Api\\V11\\Controllers\\UsersController2@add_user');
		$api->post('edit_user', 'App\\Api\\V11\\Controllers\\UsersController2@edit_user');
		$api->post('update_user_info', 'App\\Api\\V11\\Controllers\\UsersController2@update_user_info');
		$api->post('delete_user', 'App\\Api\\V11\\Controllers\\UsersController2@delete_user');
		$api->post('del_user', 'App\\Api\\V11\\Controllers\\UsersController2@del_user');
		
		$api->post('add_cigarette', 'App\\Api\\V11\\Controllers\\UsersController2@add_cigarette');
		$api->post('add_atm', 'App\\Api\\V11\\Controllers\\UsersController2@add_atm');
		$api->post('get_all_messages', 'App\\Api\\V11\\Controllers\\UsersController2@get_all_messages');
		
		$api->post('store_list', 'App\\Api\\V11\\Controllers\\UsersController2@store_list');
		$api->post('store_list_new', 'App\\Api\\V11\\Controllers\\UsersController2@store_list_new');
		$api->post('add_store', 'App\\Api\\V11\\Controllers\\UsersController2@add_store');
		$api->post('edit_store', 'App\\Api\\V11\\Controllers\\UsersController2@edit_store');
		$api->post('update_store_info', 'App\\Api\\V11\\Controllers\\UsersController2@update_store_info');
		$api->post('delete_store', 'App\\Api\\V11\\Controllers\\UsersController2@delete_store');
		
		$api->post('item_list', 'App\\Api\\V11\\Controllers\\UsersController2@item_list');
		$api->post('add_item', 'App\\Api\\V11\\Controllers\\UsersController2@add_item');
		$api->post('edit_item', 'App\\Api\\V11\\Controllers\\UsersController2@edit_item');
		$api->post('update_item_info', 'App\\Api\\V11\\Controllers\\UsersController2@update_item_info');
		$api->post('delete_item', 'App\\Api\\V11\\Controllers\\UsersController2@delete_item');
		
		$api->post('vendor_list', 'App\\Api\\V11\\Controllers\\UsersController2@vendor_list');
		$api->post('add_vendor', 'App\\Api\\V11\\Controllers\\UsersController2@add_vendor');
		$api->post('edit_vendor', 'App\\Api\\V11\\Controllers\\UsersController2@edit_vendor');
		$api->post('update_vendor_info', 'App\\Api\\V11\\Controllers\\UsersController2@update_vendor_info');
		$api->post('delete_vendor', 'App\\Api\\V11\\Controllers\\UsersController2@delete_vendor');
		
		$api->post('get_store_data', 'App\\Api\\V11\\Controllers\\UsersController2@get_store_data');
		$api->post('store_in_profit', 'App\\Api\\V11\\Controllers\\UsersController2@store_in_profit');
		$api->post('store_in_profit2', 'App\\Api\\V11\\Controllers\\UsersController2@store_in_profit2');
		$api->post('user_store_in_profit', 'App\\Api\\V11\\Controllers\\UsersController2@user_store_in_profit');
		$api->post('user_report', 'App\\Api\\V11\\Controllers\\UsersController2@user_report');
		$api->post('store_info', 'App\\Api\\V11\\Controllers\\UsersController2@store_info');
		$api->post('store_info2', 'App\\Api\\V11\\Controllers\\UsersController2@store_info2');
		$api->post('user_report_store', 'App\\Api\\V11\\Controllers\\UsersController2@user_report_store');
		$api->post('store_Info_detail', 'App\\Api\\V11\\Controllers\\UsersController2@store_Info_detail');
		$api->post('latest', 'App\\Api\\V11\\Controllers\\UsersController2@latest');
		$api->post('user_entry_details', 'App\\Api\\V11\\Controllers\\UsersController2@user_entry_details');
		$api->post('user_report_date', 'App\\Api\\V11\\Controllers\\UsersController2@user_report_date');
		$api->post('all_daily_report', 'App\\Api\\V11\\Controllers\\UsersController2@all_daily_report');
		
		$api->post('admin_sales_edit', 'App\\Api\\V11\\Controllers\\UsersController2@admin_sales_edit');
		$api->post('admin_payment_edit', 'App\\Api\\V11\\Controllers\\UsersController2@admin_payment_edit');
		$api->post('admin_inventory_edit', 'App\\Api\\V11\\Controllers\\UsersController2@admin_inventory_edit');
		$api->post('admin_atm_edit', 'App\\Api\\V11\\Controllers\\UsersController2@admin_atm_edit');
		$api->post('admin_cigarette_edit', 'App\\Api\\V11\\Controllers\\UsersController2@admin_cigarette_edit');
		$api->post('admin_lottery_edit', 'App\\Api\\V11\\Controllers\\UsersController2@admin_lottery_edit');
		$api->post('admin_expense_edit', 'App\\Api\\V11\\Controllers\\UsersController2@admin_expense_edit');
		$api->post('admin_sales_delete', 'App\\Api\\V11\\Controllers\\UsersController2@admin_sales_delete');
		$api->post('admin_payment_delete', 'App\\Api\\V11\\Controllers\\UsersController2@admin_payment_delete');
		$api->post('admin_inventory_delete', 'App\\Api\\V11\\Controllers\\UsersController2@admin_inventory_delete');
		$api->post('admin_atm_delete', 'App\\Api\\V11\\Controllers\\UsersController2@admin_atm_delete');
		$api->post('admin_cigarette_delete', 'App\\Api\\V11\\Controllers\\UsersController2@admin_cigarette_delete');
		$api->post('admin_lottery_delete', 'App\\Api\\V11\\Controllers\\UsersController2@admin_lottery_delete');
		$api->post('admin_expense_delete', 'App\\Api\\V11\\Controllers\\UsersController2@admin_expense_delete');
		
		$api->post('add_lottery', 'App\\Api\\V11\\Controllers\\UsersController2@add_lottery');
		$api->post('add_expense', 'App\\Api\\V11\\Controllers\\UsersController2@add_expense');
		$api->post('send_message', 'App\\Api\\V11\\Controllers\\UsersController2@send_message');
		
		$api->post('add_inventory', 'App\\Api\\V11\\Controllers\\UsersController2@add_inventory');
		$api->post('add_sales_report', 'App\\Api\\V11\\Controllers\\UsersController2@add_sales_report');
		$api->post('add_payment_report', 'App\\Api\\V11\\Controllers\\UsersController2@add_payment_report');
		$api->post('get_vendor_items', 'App\\Api\\V11\\Controllers\\UsersController2@get_vendor_items');
		
		$api->post('get_expense_items', 'App\\Api\\V11\\Controllers\\UsersController2@get_expense_items');
		$api->post('get_config', 'App\\Api\\V11\\Controllers\\UsersController2@get_config');
		
		// New Changes
		// Western Union
		$api->post('add_western_union', 'App\\Api\\V11\\Controllers\\UsersController2@add_western_union');
		$api->post('admin_western_union_edit', 'App\\Api\\V11\\Controllers\\UsersController2@admin_western_union_edit');
		$api->post('admin_western_union_delete', 'App\\Api\\V11\\Controllers\\UsersController2@admin_western_union_delete');
		$api->post('western_union_report', 'App\\Api\\V11\\Controllers\\UsersController2@western_union_report');
		$api->post('western_union_report2', 'App\\Api\\V11\\Controllers\\UsersController2@western_union_report2');
		$api->post('western_union_report3', 'App\\Api\\V11\\Controllers\\UsersController2@western_union_report3');
		
		// Show Messages Admin
		$api->post('messages', 'App\\Api\\V11\\Controllers\\UsersController2@messages');
		$api->post('get_messages', 'App\\Api\\V11\\Controllers\\UsersController2@get_messages');
		
		// iOS send message
		$api->post('ios_upload_image', 'App\\Api\\V11\\Controllers\\UsersController2@ios_upload_image');
		$api->post('ios_send_message', 'App\\Api\\V11\\Controllers\\UsersController2@ios_send_message');
		// New list by vishal
		$api->post('overshort_report', 'App\\Api\\V11\\Controllers\\UsersController2@overshort');
		$api->post('overshort_report_user', 'App\\Api\\V11\\Controllers\\UsersController2@store_info_overshort2');
		$api->post('cigarettes_report', 'App\\Api\\V11\\Controllers\\UsersController2@cigarettes');
		$api->post('cigarettes_report_user', 'App\\Api\\V11\\Controllers\\UsersController2@store_cigarettes_user_report');
		$api->post('lottery_report', 'App\\Api\\V11\\Controllers\\UsersController2@lottery_report');
		$api->post('lottery_report_user', 'App\\Api\\V11\\Controllers\\UsersController2@store_lottery_user_report');
		$api->post('profit_lost_report', 'App\\Api\\V11\\Controllers\\UsersController2@profit_lost_report');
		$api->post('profit_lost_user_report', 'App\\Api\\V11\\Controllers\\UsersController2@profit_lost_user_report');
		$api->post('get_messages_id', 'App\\Api\\V11\\Controllers\\UsersController2@get_messages_id');
		$api->post('item_profit_lost', 'App\\Api\\V11\\Controllers\\UsersController2@item_profit_lost');
	});
	
	$api->group(['prefix' => 'v12'], function(Router $api) {
		$api->post('login', 'App\\Api\\V12\\Controllers\\UsersController2@login');
		$api->post('forgot_password', 'App\\Api\\V12\\Controllers\\UsersController2@forgotPassword');
		$api->post('edit_profile', 'App\\Api\\V12\\Controllers\\UsersController2@editProfile');
		$api->post('update_profile', 'App\\Api\\V12\\Controllers\\UsersController2@updateProfileData');
		$api->post('logout', 'App\\Api\\V12\\Controllers\\UsersController2@logout');
		$api->post('change_password', 'App\\Api\\V12\\Controllers\\UsersController2@change_password');
		
		$api->post('del_multiple', 'App\\Api\\V12\\Controllers\\UsersController2@del_multiple');
		$api->post('inventory_filter', 'App\\Api\\V12\\Controllers\\UsersController2@inventory_filter');
		$api->post('inventory_filter_page2', 'App\\Api\\V12\\Controllers\\UsersController2@inventory_filter_page2');
		$api->post('add_sales_payment', 'App\\Api\\V12\\Controllers\\UsersController2@add_sales_payment');
		$api->post('get_stores', 'App\\Api\\V12\\Controllers\\UsersController2@get_stores');
		$api->post('signup', 'App\\Api\\V12\\Controllers\\UsersController2@signup');
		
		$api->post('user_list', 'App\\Api\\V12\\Controllers\\UsersController2@user_list');
		$api->post('blocked_user_list', 'App\\Api\\V12\\Controllers\\UsersController2@blocked_user_list');
		$api->post('add_user', 'App\\Api\\V12\\Controllers\\UsersController2@add_user');
		$api->post('edit_user', 'App\\Api\\V12\\Controllers\\UsersController2@edit_user');
		$api->post('update_user_info', 'App\\Api\\V12\\Controllers\\UsersController2@update_user_info');
		$api->post('delete_user', 'App\\Api\\V12\\Controllers\\UsersController2@delete_user');
		$api->post('del_user', 'App\\Api\\V12\\Controllers\\UsersController2@del_user');
		
		$api->post('add_cigarette', 'App\\Api\\V12\\Controllers\\UsersController2@add_cigarette');
		$api->post('add_atm', 'App\\Api\\V12\\Controllers\\UsersController2@add_atm');
		$api->post('get_all_messages', 'App\\Api\\V12\\Controllers\\UsersController2@get_all_messages');
		
		$api->post('store_list', 'App\\Api\\V12\\Controllers\\UsersController2@store_list');
		$api->post('store_list_new', 'App\\Api\\V12\\Controllers\\UsersController2@store_list_new');
		$api->post('add_store', 'App\\Api\\V12\\Controllers\\UsersController2@add_store');
		$api->post('edit_store', 'App\\Api\\V12\\Controllers\\UsersController2@edit_store');
		$api->post('update_store_info', 'App\\Api\\V12\\Controllers\\UsersController2@update_store_info');
		$api->post('delete_store', 'App\\Api\\V12\\Controllers\\UsersController2@delete_store');
		
		$api->post('item_list', 'App\\Api\\V12\\Controllers\\UsersController2@item_list');
		$api->post('add_item', 'App\\Api\\V12\\Controllers\\UsersController2@add_item');
		$api->post('edit_item', 'App\\Api\\V12\\Controllers\\UsersController2@edit_item');
		$api->post('update_item_info', 'App\\Api\\V12\\Controllers\\UsersController2@update_item_info');
		$api->post('delete_item', 'App\\Api\\V12\\Controllers\\UsersController2@delete_item');
		
		$api->post('vendor_list', 'App\\Api\\V12\\Controllers\\UsersController2@vendor_list');
		$api->post('add_vendor', 'App\\Api\\V12\\Controllers\\UsersController2@add_vendor');
		$api->post('edit_vendor', 'App\\Api\\V12\\Controllers\\UsersController2@edit_vendor');
		$api->post('update_vendor_info', 'App\\Api\\V12\\Controllers\\UsersController2@update_vendor_info');
		$api->post('delete_vendor', 'App\\Api\\V12\\Controllers\\UsersController2@delete_vendor');
		
		$api->post('get_store_data', 'App\\Api\\V12\\Controllers\\UsersController2@get_store_data');
		$api->post('store_in_profit', 'App\\Api\\V12\\Controllers\\UsersController2@store_in_profit');
		$api->post('store_in_profit2', 'App\\Api\\V12\\Controllers\\UsersController2@store_in_profit2');
		$api->post('user_store_in_profit', 'App\\Api\\V12\\Controllers\\UsersController2@user_store_in_profit');
		$api->post('user_report', 'App\\Api\\V12\\Controllers\\UsersController2@user_report');
		$api->post('store_info', 'App\\Api\\V12\\Controllers\\UsersController2@store_info');
		$api->post('store_info2', 'App\\Api\\V12\\Controllers\\UsersController2@store_info2');
		$api->post('user_report_store', 'App\\Api\\V12\\Controllers\\UsersController2@user_report_store');
		$api->post('store_Info_detail', 'App\\Api\\V12\\Controllers\\UsersController2@store_Info_detail');
		$api->post('latest', 'App\\Api\\V12\\Controllers\\UsersController2@latest');
		$api->post('user_entry_details', 'App\\Api\\V12\\Controllers\\UsersController2@user_entry_details');
		$api->post('user_report_date', 'App\\Api\\V12\\Controllers\\UsersController2@user_report_date');
		$api->post('all_daily_report', 'App\\Api\\V12\\Controllers\\UsersController2@all_daily_report');
		
		$api->post('admin_sales_edit', 'App\\Api\\V12\\Controllers\\UsersController2@admin_sales_edit');
		$api->post('admin_payment_edit', 'App\\Api\\V12\\Controllers\\UsersController2@admin_payment_edit');
		$api->post('admin_inventory_edit', 'App\\Api\\V12\\Controllers\\UsersController2@admin_inventory_edit');
		$api->post('admin_atm_edit', 'App\\Api\\V12\\Controllers\\UsersController2@admin_atm_edit');
		$api->post('admin_cigarette_edit', 'App\\Api\\V12\\Controllers\\UsersController2@admin_cigarette_edit');
		$api->post('admin_lottery_edit', 'App\\Api\\V12\\Controllers\\UsersController2@admin_lottery_edit');
		$api->post('admin_expense_edit', 'App\\Api\\V12\\Controllers\\UsersController2@admin_expense_edit');
		$api->post('admin_sales_delete', 'App\\Api\\V12\\Controllers\\UsersController2@admin_sales_delete');
		$api->post('admin_payment_delete', 'App\\Api\\V12\\Controllers\\UsersController2@admin_payment_delete');
		$api->post('admin_inventory_delete', 'App\\Api\\V12\\Controllers\\UsersController2@admin_inventory_delete');
		$api->post('admin_atm_delete', 'App\\Api\\V12\\Controllers\\UsersController2@admin_atm_delete');
		$api->post('admin_cigarette_delete', 'App\\Api\\V12\\Controllers\\UsersController2@admin_cigarette_delete');
		$api->post('admin_lottery_delete', 'App\\Api\\V12\\Controllers\\UsersController2@admin_lottery_delete');
		$api->post('admin_expense_delete', 'App\\Api\\V12\\Controllers\\UsersController2@admin_expense_delete');
		
		$api->post('add_lottery', 'App\\Api\\V12\\Controllers\\UsersController2@add_lottery');
		$api->post('add_expense', 'App\\Api\\V12\\Controllers\\UsersController2@add_expense');
		$api->post('send_message', 'App\\Api\\V12\\Controllers\\UsersController2@send_message');
		
		$api->post('add_inventory', 'App\\Api\\V12\\Controllers\\UsersController2@add_inventory');
		$api->post('add_sales_report', 'App\\Api\\V12\\Controllers\\UsersController2@add_sales_report');
		$api->post('add_payment_report', 'App\\Api\\V12\\Controllers\\UsersController2@add_payment_report');
		$api->post('get_vendor_items', 'App\\Api\\V12\\Controllers\\UsersController2@get_vendor_items');
		
		$api->post('get_expense_items', 'App\\Api\\V12\\Controllers\\UsersController2@get_expense_items');
		$api->post('get_config', 'App\\Api\\V12\\Controllers\\UsersController2@get_config');
		
		// New Changes
		// Western Union
		$api->post('add_western_union', 'App\\Api\\V12\\Controllers\\UsersController2@add_western_union');
		$api->post('admin_western_union_edit', 'App\\Api\\V12\\Controllers\\UsersController2@admin_western_union_edit');
		$api->post('admin_western_union_delete', 'App\\Api\\V12\\Controllers\\UsersController2@admin_western_union_delete');
		$api->post('western_union_report', 'App\\Api\\V12\\Controllers\\UsersController2@western_union_report');
		$api->post('western_union_report2', 'App\\Api\\V12\\Controllers\\UsersController2@western_union_report2');
		$api->post('western_union_report3', 'App\\Api\\V12\\Controllers\\UsersController2@western_union_report3');
		
		// Show Messages Admin
		$api->post('messages', 'App\\Api\\V12\\Controllers\\UsersController2@messages');
		$api->post('get_messages', 'App\\Api\\V12\\Controllers\\UsersController2@get_messages');
		
		// iOS send message
		$api->post('ios_upload_image', 'App\\Api\\V12\\Controllers\\UsersController2@ios_upload_image');
		$api->post('ios_send_message', 'App\\Api\\V12\\Controllers\\UsersController2@ios_send_message');
		// New list by vishal
		$api->post('overshort_report', 'App\\Api\\V12\\Controllers\\UsersController2@overshort');
		$api->post('overshort_report_user', 'App\\Api\\V12\\Controllers\\UsersController2@store_info_overshort2');
		$api->post('cigarettes_report', 'App\\Api\\V12\\Controllers\\UsersController2@cigarettes');
		$api->post('cigarettes_report_user', 'App\\Api\\V12\\Controllers\\UsersController2@store_cigarettes_user_report');
		$api->post('lottery_report', 'App\\Api\\V12\\Controllers\\UsersController2@lottery_report');
		$api->post('lottery_report_user', 'App\\Api\\V12\\Controllers\\UsersController2@store_lottery_user_report');
		$api->post('profit_lost_report', 'App\\Api\\V12\\Controllers\\UsersController2@profit_lost_report');
		$api->post('profit_lost_user_report', 'App\\Api\\V12\\Controllers\\UsersController2@profit_lost_user_report');
		$api->post('get_messages_id', 'App\\Api\\V12\\Controllers\\UsersController2@get_messages_id');
		$api->post('item_profit_lost', 'App\\Api\\V12\\Controllers\\UsersController2@item_profit_lost');
		$api->post('user_sift', 'App\\Api\\V12\\Controllers\\UsersController2@user_sift');
	});
	$api->group(['prefix' => 'v13'], function(Router $api) {
		$api->post('login', 'App\\Api\\V13\\Controllers\\UsersController2@login');
		$api->post('forgot_password', 'App\\Api\\V13\\Controllers\\UsersController2@forgotPassword');
		$api->post('edit_profile', 'App\\Api\\V13\\Controllers\\UsersController2@editProfile');
		$api->post('update_profile', 'App\\Api\\V13\\Controllers\\UsersController2@updateProfileData');
		$api->post('logout', 'App\\Api\\V13\\Controllers\\UsersController2@logout');
		$api->post('change_password', 'App\\Api\\V13\\Controllers\\UsersController2@change_password');
		
		$api->post('del_multiple', 'App\\Api\\V13\\Controllers\\UsersController2@del_multiple');
		$api->post('inventory_filter', 'App\\Api\\V13\\Controllers\\UsersController2@inventory_filter');
		$api->post('inventory_filter_page2', 'App\\Api\\V13\\Controllers\\UsersController2@inventory_filter_page2');
		$api->post('add_sales_payment', 'App\\Api\\V13\\Controllers\\UsersController2@add_sales_payment');
		$api->post('get_stores', 'App\\Api\\V13\\Controllers\\UsersController2@get_stores');
		$api->post('signup', 'App\\Api\\V13\\Controllers\\UsersController2@signup');
		
		$api->post('user_list', 'App\\Api\\V13\\Controllers\\UsersController2@user_list');
		$api->post('blocked_user_list', 'App\\Api\\V13\\Controllers\\UsersController2@blocked_user_list');
		$api->post('add_user', 'App\\Api\\V13\\Controllers\\UsersController2@add_user');
		$api->post('edit_user', 'App\\Api\\V13\\Controllers\\UsersController2@edit_user');
		$api->post('update_user_info', 'App\\Api\\V13\\Controllers\\UsersController2@update_user_info');
		$api->post('delete_user', 'App\\Api\\V13\\Controllers\\UsersController2@delete_user');
		$api->post('del_user', 'App\\Api\\V13\\Controllers\\UsersController2@del_user');
		
		$api->post('add_cigarette', 'App\\Api\\V13\\Controllers\\UsersController2@add_cigarette');
		$api->post('add_atm', 'App\\Api\\V13\\Controllers\\UsersController2@add_atm');
		$api->post('get_all_messages', 'App\\Api\\V13\\Controllers\\UsersController2@get_all_messages');
		
		$api->post('store_list', 'App\\Api\\V13\\Controllers\\UsersController2@store_list');
		$api->post('store_list_new', 'App\\Api\\V13\\Controllers\\UsersController2@store_list_new');
		$api->post('add_store', 'App\\Api\\V13\\Controllers\\UsersController2@add_store');
		$api->post('edit_store', 'App\\Api\\V13\\Controllers\\UsersController2@edit_store');
		$api->post('update_store_info', 'App\\Api\\V13\\Controllers\\UsersController2@update_store_info');
		$api->post('delete_store', 'App\\Api\\V13\\Controllers\\UsersController2@delete_store');
		
		$api->post('item_list', 'App\\Api\\V13\\Controllers\\UsersController2@item_list');
		$api->post('add_item', 'App\\Api\\V13\\Controllers\\UsersController2@add_item');
		$api->post('edit_item', 'App\\Api\\V13\\Controllers\\UsersController2@edit_item');
		$api->post('update_item_info', 'App\\Api\\V13\\Controllers\\UsersController2@update_item_info');
		$api->post('delete_item', 'App\\Api\\V13\\Controllers\\UsersController2@delete_item');
		
		$api->post('vendor_list', 'App\\Api\\V13\\Controllers\\UsersController2@vendor_list');
		$api->post('add_vendor', 'App\\Api\\V13\\Controllers\\UsersController2@add_vendor');
		$api->post('edit_vendor', 'App\\Api\\V13\\Controllers\\UsersController2@edit_vendor');
		$api->post('update_vendor_info', 'App\\Api\\V13\\Controllers\\UsersController2@update_vendor_info');
		$api->post('delete_vendor', 'App\\Api\\V13\\Controllers\\UsersController2@delete_vendor');
		
		$api->post('get_store_data', 'App\\Api\\V13\\Controllers\\UsersController2@get_store_data');
		$api->post('store_in_profit', 'App\\Api\\V13\\Controllers\\UsersController2@store_in_profit');
		$api->post('store_in_profit2', 'App\\Api\\V13\\Controllers\\UsersController2@store_in_profit2');
		$api->post('game_report', 'App\\Api\\V13\\Controllers\\UsersController2@game_report');
		$api->post('user_store_in_profit', 'App\\Api\\V13\\Controllers\\UsersController2@user_store_in_profit');
		$api->post('user_report', 'App\\Api\\V13\\Controllers\\UsersController2@user_report');
		$api->post('store_info', 'App\\Api\\V13\\Controllers\\UsersController2@store_info');
		$api->post('store_info2', 'App\\Api\\V13\\Controllers\\UsersController2@store_info2');
		$api->post('user_report_store', 'App\\Api\\V13\\Controllers\\UsersController2@user_report_store');
		$api->post('store_Info_detail', 'App\\Api\\V13\\Controllers\\UsersController2@store_Info_detail');
		$api->post('latest', 'App\\Api\\V13\\Controllers\\UsersController2@latest');
		$api->post('user_entry_details', 'App\\Api\\V13\\Controllers\\UsersController2@user_entry_details');
		$api->post('user_report_date', 'App\\Api\\V13\\Controllers\\UsersController2@user_report_date');
		$api->post('all_daily_report', 'App\\Api\\V13\\Controllers\\UsersController2@all_daily_report');
		
		$api->post('admin_sales_edit', 'App\\Api\\V13\\Controllers\\UsersController2@admin_sales_edit');
		$api->post('admin_payment_edit', 'App\\Api\\V13\\Controllers\\UsersController2@admin_payment_edit');
		$api->post('admin_inventory_edit', 'App\\Api\\V13\\Controllers\\UsersController2@admin_inventory_edit');
		$api->post('admin_atm_edit', 'App\\Api\\V13\\Controllers\\UsersController2@admin_atm_edit');
		$api->post('admin_cigarette_edit', 'App\\Api\\V13\\Controllers\\UsersController2@admin_cigarette_edit');
		$api->post('admin_lottery_edit', 'App\\Api\\V13\\Controllers\\UsersController2@admin_lottery_edit');
		$api->post('admin_expense_edit', 'App\\Api\\V13\\Controllers\\UsersController2@admin_expense_edit');
		$api->post('admin_sales_delete', 'App\\Api\\V13\\Controllers\\UsersController2@admin_sales_delete');
		$api->post('admin_payment_delete', 'App\\Api\\V13\\Controllers\\UsersController2@admin_payment_delete');
		$api->post('admin_inventory_delete', 'App\\Api\\V13\\Controllers\\UsersController2@admin_inventory_delete');
		$api->post('admin_atm_delete', 'App\\Api\\V13\\Controllers\\UsersController2@admin_atm_delete');
		$api->post('admin_cigarette_delete', 'App\\Api\\V13\\Controllers\\UsersController2@admin_cigarette_delete');
		$api->post('admin_lottery_delete', 'App\\Api\\V13\\Controllers\\UsersController2@admin_lottery_delete');
		$api->post('admin_expense_delete', 'App\\Api\\V13\\Controllers\\UsersController2@admin_expense_delete');
		
		$api->post('add_lottery', 'App\\Api\\V13\\Controllers\\UsersController2@add_lottery');
		$api->post('add_expense', 'App\\Api\\V13\\Controllers\\UsersController2@add_expense');
		$api->post('send_message', 'App\\Api\\V13\\Controllers\\UsersController2@send_message');
		
		$api->post('add_inventory', 'App\\Api\\V13\\Controllers\\UsersController2@add_inventory');
		$api->post('add_sales_report', 'App\\Api\\V13\\Controllers\\UsersController2@add_sales_report');
		$api->post('add_payment_report', 'App\\Api\\V13\\Controllers\\UsersController2@add_payment_report');
		$api->post('get_vendor_items', 'App\\Api\\V13\\Controllers\\UsersController2@get_vendor_items');
		
		$api->post('get_expense_items', 'App\\Api\\V13\\Controllers\\UsersController2@get_expense_items');
		$api->post('get_config', 'App\\Api\\V13\\Controllers\\UsersController2@get_config');
		
		// New Changes
		// Western Union
		$api->post('add_western_union', 'App\\Api\\V13\\Controllers\\UsersController2@add_western_union');
		$api->post('admin_western_union_edit', 'App\\Api\\V13\\Controllers\\UsersController2@admin_western_union_edit');
		$api->post('admin_western_union_delete', 'App\\Api\\V13\\Controllers\\UsersController2@admin_western_union_delete');
		$api->post('western_union_report', 'App\\Api\\V13\\Controllers\\UsersController2@western_union_report');
		$api->post('western_union_report2', 'App\\Api\\V13\\Controllers\\UsersController2@western_union_report2');
		$api->post('western_union_report3', 'App\\Api\\V13\\Controllers\\UsersController2@western_union_report3');
		
		// Show Messages Admin
		$api->post('messages', 'App\\Api\\V13\\Controllers\\UsersController2@messages');
		$api->post('get_messages', 'App\\Api\\V13\\Controllers\\UsersController2@get_messages');
		
		// iOS send message
		$api->post('ios_upload_image', 'App\\Api\\V13\\Controllers\\UsersController2@ios_upload_image');
		$api->post('ios_send_message', 'App\\Api\\V13\\Controllers\\UsersController2@ios_send_message');
		// New list by vishal
		$api->post('overshort_report', 'App\\Api\\V13\\Controllers\\UsersController2@overshort');
		$api->post('overshort_report_user', 'App\\Api\\V13\\Controllers\\UsersController2@store_info_overshort2');
		$api->post('cigarettes_report', 'App\\Api\\V13\\Controllers\\UsersController2@cigarettes');
		$api->post('cigarettes_report_user', 'App\\Api\\V13\\Controllers\\UsersController2@store_cigarettes_user_report');
		$api->post('lottery_report', 'App\\Api\\V13\\Controllers\\UsersController2@lottery_report');
		$api->post('lottery_report_user', 'App\\Api\\V13\\Controllers\\UsersController2@store_lottery_user_report');
		$api->post('profit_lost_report', 'App\\Api\\V13\\Controllers\\UsersController2@profit_lost_report');
		$api->post('profit_lost_user_report', 'App\\Api\\V13\\Controllers\\UsersController2@profit_lost_user_report');
		$api->post('get_messages_id', 'App\\Api\\V13\\Controllers\\UsersController2@get_messages_id');
		$api->post('item_profit_lost', 'App\\Api\\V13\\Controllers\\UsersController2@item_profit_lost');
		$api->post('user_sift', 'App\\Api\\V13\\Controllers\\UsersController2@user_sift');
	});
	$api->group(['prefix' => 'v14'], function(Router $api) {
		$api->post('login', 'App\\Api\\V14\\Controllers\\UsersController2@login');
		$api->post('forgot_password', 'App\\Api\\V14\\Controllers\\UsersController2@forgotPassword');
		$api->post('edit_profile', 'App\\Api\\V14\\Controllers\\UsersController2@editProfile');
		$api->post('update_profile', 'App\\Api\\V14\\Controllers\\UsersController2@updateProfileData');
		$api->post('logout', 'App\\Api\\V14\\Controllers\\UsersController2@logout');
		$api->post('change_password', 'App\\Api\\V14\\Controllers\\UsersController2@change_password');
		
		$api->post('del_multiple', 'App\\Api\\V14\\Controllers\\UsersController2@del_multiple');
		$api->post('inventory_filter', 'App\\Api\\V14\\Controllers\\UsersController2@inventory_filter');
		$api->post('inventory_filter_page2', 'App\\Api\\V14\\Controllers\\UsersController2@inventory_filter_page2');
		$api->post('add_sales_payment', 'App\\Api\\V14\\Controllers\\UsersController2@add_sales_payment');
		$api->post('get_stores', 'App\\Api\\V14\\Controllers\\UsersController2@get_stores');
		$api->post('signup', 'App\\Api\\V14\\Controllers\\UsersController2@signup');
		
		$api->post('user_list', 'App\\Api\\V14\\Controllers\\UsersController2@user_list');
		$api->post('blocked_user_list', 'App\\Api\\V14\\Controllers\\UsersController2@blocked_user_list');
		$api->post('add_user', 'App\\Api\\V14\\Controllers\\UsersController2@add_user');
		$api->post('edit_user', 'App\\Api\\V14\\Controllers\\UsersController2@edit_user');
		$api->post('update_user_info', 'App\\Api\\V14\\Controllers\\UsersController2@update_user_info');
		$api->post('delete_user', 'App\\Api\\V14\\Controllers\\UsersController2@delete_user');
		$api->post('del_user', 'App\\Api\\V14\\Controllers\\UsersController2@del_user');
		
		$api->post('add_cigarette', 'App\\Api\\V14\\Controllers\\UsersController2@add_cigarette');
		$api->post('add_atm', 'App\\Api\\V14\\Controllers\\UsersController2@add_atm');
		
		//add game
		$api->post('add_game_atm', 'App\\Api\\V14\\Controllers\\UsersController2@add_game_atm');
		$api->post('check_game_atm_access', 'App\\Api\\V14\\Controllers\\UsersController2@check_game_atm_access');
		//add game
		$api->post('get_all_messages', 'App\\Api\\V14\\Controllers\\UsersController2@get_all_messages');
		
		$api->post('store_list', 'App\\Api\\V14\\Controllers\\UsersController2@store_list');
		///game access store list
		$api->post('store_game_list', 'App\\Api\\V14\\Controllers\\UsersController2@store_game_list');
		//game access store list
		$api->post('store_list_new', 'App\\Api\\V14\\Controllers\\UsersController2@store_list_new');
		$api->post('add_store', 'App\\Api\\V14\\Controllers\\UsersController2@add_store');
		$api->post('edit_store', 'App\\Api\\V14\\Controllers\\UsersController2@edit_store');
		$api->post('update_store_info', 'App\\Api\\V14\\Controllers\\UsersController2@update_store_info');
		$api->post('delete_store', 'App\\Api\\V14\\Controllers\\UsersController2@delete_store');
		
		$api->post('item_list', 'App\\Api\\V14\\Controllers\\UsersController2@item_list');
		$api->post('add_item', 'App\\Api\\V14\\Controllers\\UsersController2@add_item');
		$api->post('edit_item', 'App\\Api\\V14\\Controllers\\UsersController2@edit_item');
		$api->post('update_item_info', 'App\\Api\\V14\\Controllers\\UsersController2@update_item_info');
		$api->post('delete_item', 'App\\Api\\V14\\Controllers\\UsersController2@delete_item');
		
		$api->post('vendor_list', 'App\\Api\\V14\\Controllers\\UsersController2@vendor_list');
		$api->post('add_vendor', 'App\\Api\\V14\\Controllers\\UsersController2@add_vendor');
		$api->post('edit_vendor', 'App\\Api\\V14\\Controllers\\UsersController2@edit_vendor');
		$api->post('update_vendor_info', 'App\\Api\\V14\\Controllers\\UsersController2@update_vendor_info');
		$api->post('delete_vendor', 'App\\Api\\V14\\Controllers\\UsersController2@delete_vendor');
		
		$api->post('get_store_data', 'App\\Api\\V14\\Controllers\\UsersController2@get_store_data');
		$api->post('store_in_profit', 'App\\Api\\V14\\Controllers\\UsersController2@store_in_profit');
		$api->post('store_in_profit2', 'App\\Api\\V14\\Controllers\\UsersController2@store_in_profit2');
		$api->post('game_report', 'App\\Api\\V14\\Controllers\\UsersController2@game_report');
		$api->post('user_store_in_profit', 'App\\Api\\V14\\Controllers\\UsersController2@user_store_in_profit');
		$api->post('user_report', 'App\\Api\\V14\\Controllers\\UsersController2@user_report');
		$api->post('store_info', 'App\\Api\\V14\\Controllers\\UsersController2@store_info');
		$api->post('store_info2', 'App\\Api\\V14\\Controllers\\UsersController2@store_info2');
		$api->post('user_report_store', 'App\\Api\\V14\\Controllers\\UsersController2@user_report_store');
		$api->post('store_Info_detail', 'App\\Api\\V14\\Controllers\\UsersController2@store_Info_detail');
		$api->post('latest', 'App\\Api\\V14\\Controllers\\UsersController2@latest');
		$api->post('user_entry_details', 'App\\Api\\V14\\Controllers\\UsersController2@user_entry_details');
		$api->post('user_report_date', 'App\\Api\\V14\\Controllers\\UsersController2@user_report_date');
		$api->post('all_daily_report', 'App\\Api\\V14\\Controllers\\UsersController2@all_daily_report');
		
		$api->post('admin_sales_edit', 'App\\Api\\V14\\Controllers\\UsersController2@admin_sales_edit');
		$api->post('admin_payment_edit', 'App\\Api\\V14\\Controllers\\UsersController2@admin_payment_edit');
		$api->post('admin_inventory_edit', 'App\\Api\\V14\\Controllers\\UsersController2@admin_inventory_edit');
		$api->post('admin_atm_edit', 'App\\Api\\V14\\Controllers\\UsersController2@admin_atm_edit');
		$api->post('admin_cigarette_edit', 'App\\Api\\V14\\Controllers\\UsersController2@admin_cigarette_edit');
		$api->post('admin_lottery_edit', 'App\\Api\\V14\\Controllers\\UsersController2@admin_lottery_edit');
		$api->post('admin_expense_edit', 'App\\Api\\V14\\Controllers\\UsersController2@admin_expense_edit');
		$api->post('admin_sales_delete', 'App\\Api\\V14\\Controllers\\UsersController2@admin_sales_delete');
		$api->post('admin_payment_delete', 'App\\Api\\V14\\Controllers\\UsersController2@admin_payment_delete');
		$api->post('admin_inventory_delete', 'App\\Api\\V14\\Controllers\\UsersController2@admin_inventory_delete');
		$api->post('admin_atm_delete', 'App\\Api\\V14\\Controllers\\UsersController2@admin_atm_delete');
		$api->post('admin_cigarette_delete', 'App\\Api\\V14\\Controllers\\UsersController2@admin_cigarette_delete');
		$api->post('admin_lottery_delete', 'App\\Api\\V14\\Controllers\\UsersController2@admin_lottery_delete');
		$api->post('admin_expense_delete', 'App\\Api\\V14\\Controllers\\UsersController2@admin_expense_delete');
		
		$api->post('add_lottery', 'App\\Api\\V14\\Controllers\\UsersController2@add_lottery');
		$api->post('add_expense', 'App\\Api\\V14\\Controllers\\UsersController2@add_expense');
		$api->post('send_message', 'App\\Api\\V14\\Controllers\\UsersController2@send_message');
		
		$api->post('add_inventory', 'App\\Api\\V14\\Controllers\\UsersController2@add_inventory');
		$api->post('add_sales_report', 'App\\Api\\V14\\Controllers\\UsersController2@add_sales_report');
		$api->post('add_payment_report', 'App\\Api\\V14\\Controllers\\UsersController2@add_payment_report');
		$api->post('get_vendor_items', 'App\\Api\\V14\\Controllers\\UsersController2@get_vendor_items');
		
		$api->post('get_expense_items', 'App\\Api\\V14\\Controllers\\UsersController2@get_expense_items');
		$api->post('get_config', 'App\\Api\\V14\\Controllers\\UsersController2@get_config');
		
		// New Changes
		// Western Union
		$api->post('add_western_union', 'App\\Api\\V14\\Controllers\\UsersController2@add_western_union');
		$api->post('admin_western_union_edit', 'App\\Api\\V14\\Controllers\\UsersController2@admin_western_union_edit');
		$api->post('admin_western_union_delete', 'App\\Api\\V14\\Controllers\\UsersController2@admin_western_union_delete');
		$api->post('western_union_report', 'App\\Api\\V14\\Controllers\\UsersController2@western_union_report');
		$api->post('western_union_report2', 'App\\Api\\V14\\Controllers\\UsersController2@western_union_report2');
		$api->post('western_union_report3', 'App\\Api\\V14\\Controllers\\UsersController2@western_union_report3');
		
		// Show Messages Admin
		$api->post('messages', 'App\\Api\\V14\\Controllers\\UsersController2@messages');
		$api->post('get_messages', 'App\\Api\\V14\\Controllers\\UsersController2@get_messages');
		
		// iOS send message
		$api->post('ios_upload_image', 'App\\Api\\V14\\Controllers\\UsersController2@ios_upload_image');
		$api->post('ios_send_message', 'App\\Api\\V14\\Controllers\\UsersController2@ios_send_message');
		// New list by vishal
		$api->post('overshort_report', 'App\\Api\\V14\\Controllers\\UsersController2@overshort');
		$api->post('overshort_report_user', 'App\\Api\\V14\\Controllers\\UsersController2@store_info_overshort2');
		$api->post('cigarettes_report', 'App\\Api\\V14\\Controllers\\UsersController2@cigarettes');
		$api->post('cigarettes_report_user', 'App\\Api\\V14\\Controllers\\UsersController2@store_cigarettes_user_report');
		$api->post('lottery_report', 'App\\Api\\V14\\Controllers\\UsersController2@lottery_report');
		$api->post('lottery_report_user', 'App\\Api\\V14\\Controllers\\UsersController2@store_lottery_user_report');
		$api->post('profit_lost_report', 'App\\Api\\V14\\Controllers\\UsersController2@profit_lost_report');
		$api->post('profit_lost_user_report', 'App\\Api\\V14\\Controllers\\UsersController2@profit_lost_user_report');
		$api->post('get_messages_id', 'App\\Api\\V14\\Controllers\\UsersController2@get_messages_id');
		$api->post('item_profit_lost', 'App\\Api\\V14\\Controllers\\UsersController2@item_profit_lost');
		$api->post('user_sift', 'App\\Api\\V14\\Controllers\\UsersController2@user_sift');
		$api->post('check_atm_entry', 'App\\Api\\V14\\Controllers\\UsersController2@check_atm_entry');
	});
	
	
    $api->group(array('middleware' => 'jwt.auth'), function(Router $api) {
        $api->get('protected', function() {
			//$token = JWTAuth::parseToken();
			$user = JWTAuth::parseToken()->authenticate();
			$current_token = JWTAuth::getToken();
			//$user = JWTAuth::GetUserFromToken();
            return response()->json([
                'message' => 'Access to this item is only for authenticated user.',
				'token' => $current_token,
				'user' => $user
            ]);
        });
	});
	
	
	$api->group(array('after' => 'jwt.refresh'), function(Router $api) {
        $api->get('refresh', function() {
			$token = JWTAuth::getToken();
			//echo $token; die();
			$newToken = JWTAuth::refresh();
            return response()->json([
                'token' => $newToken
            ]);
        });
	});

    $api->get('hello', function() {
        return response()->json([
            'message' => 'Hello from Aarya group.'
        ]);
    });
});
