@include ('admin.includes.header_admin')
    
<title>Order Reports</title>
<div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
          <h1>
            Order Reports
            <small></small>
          </h1>
          <ol class="breadcrumb">
            <li><a href="{{ URL::to('home') }}"><i class="fa fa-dashboard"></i>Dashboard</a></li>
            <li><a href="{{ URL::to('admin/order_reports') }}"><i class="fa fa-users"></i>Order Reports</a></li>
            
          </ol>
        </section>

        <!-- Main content -->
        <section class="content">
          <div class="row">
            <div class="col-xs-12">
              <div class="box box-primary">
                <div class="box-header">
                  <h3 class="box-title">Order Reports</h3>
				  <a style="float:right;" class="btn btn-primary btn-sm"  href="{{ URL::to('admin/export_orders') }}?<?php if(!empty($_GET['page'])){ echo "page=".$_GET['page']; } else { echo "page=1"; } ?>" ><i class="fa fa-plus-circle" ></i><strong > Export to csv</strong></a>					
                    </div><!-- /.box-header -->
                <div class="box-body">
			<div class="widget">
                <?php if (Session::has('success')){ ?>
                    <div class="alert alert-success alert-dismissable">
                    <button aria-hidden="true" data-dismiss="alert" class="close" type="button">×</button>
                    {{ Session::get('success') }}
                    </div>
               <?php } ?>
					<?php if (Session::has('error')){ ?>
                    <div class="alert alert-danger alert-dismissable">
                    <button aria-hidden="true" data-dismiss="alert" class="close" type="button">×</button>
                    {{ Session::get('error') }}
                    </div>
               <?php } ?>
                        
			</div>
<div class="tableclass">
                  <table id="example3" class="table table-bordered table-striped">
                    <thead>
                      <tr>
								<th>Date</th>
								<th>Order No</th>
								<th>Store</th>
								<th>Customer Name</th>
								<th>Customer Mobile</th>
								<th>Order total</th>
								<th>Order status</th>
								<th>Pickup Time</th>
								<th>Action</th>
                      </tr>
                    </thead>
                    <tbody>
						<?php
                      
                      foreach ($orders as $row) { 
                  ?>
							<tr>
                        <td><?php echo date('d-m-Y',strtotime($row->date)); ?></td>
						<td><?php echo $row->order_number;?></td>
						<td><?php echo $row->store_name;?></td>
						<td><?php echo $row->customer_name;?></td>
						<td><?php echo $row->customer_mobile;?></td>
						<td><?php echo $row->order_total;?></td>
						<td>
						<?php if($row->order_status == "booked") { ?>
						<p style="color:red">Booked</p>
						<?php } else if($row->order_status == "ready_for_shipment") { ?>
						<p style="color:blue">Ready For Shipment</p>
						<?php } else { ?>
						<p style="color:green">Shipped</p>
						<?php } ?>
						</td>
						<td><?php echo date('d-m-Y H:i:s',strtotime($row->pickup_time)); ?></td>
						
                        <td>
						<?php if($row->order_status == "booked") { ?>
						<a href="{{ URL::to('admin/confirm_order',array($row->id)) }}" data-toggle="tooltip" data-original-title="Make order ready for shipment"><i class="fa fa-cart-plus"></i></a>
						<?php } ?>
						
						<?php if($row->order_status == "ready_for_shipment") { ?>
						<a href="{{ URL::to('admin/mark_as_shiped',array($row->id)) }}" data-toggle="tooltip" data-original-title="Set order status to shiped"><i class="fa fa-cart-plus"></i></a>
						<?php } ?>
						  <a href="{{ URL::to('admin/view_order',array($row->id)) }}" data-toggle="tooltip" data-original-title="View Order"><i class="fa fa-info"></i></a>
						  
						  <a href="{{ URL::to('admin/edit_order',array($row->id)) }}" data-toggle="tooltip" data-original-title="Edit Order"><i class="fa fa-edit"></i></a>
						  
					      <a  href="{{ URL::to('admin/delete_order',array($row->id)) }}" data-toggle="tooltip" data-original-title="Remove" onclick="return confirm('Are you sure you want to remove this order?');"><i class="fa fa-trash-o"></i></a>
						  
						  
                       </td>
                      </tr>
						<?php } ?>
                    </tbody>
                  </table>
                  </div>
                <div style="text-align:right;" class="box-tools">
					<ul class="pagination pagination-sm no-margin pull-right">
 {{ $orders->links() }} 
						</ul>
				</div>
				   </div><!-- /.box-body -->
              </div><!-- /.box -->
            </div><!-- /.col -->
          </div><!-- /.row -->
        </section><!-- /.content -->
      </div><!-- /.content-wrapper -->
@include ('admin.includes.footer_admin')