<?php


namespace App\Http\Controllers\Auth;
namespace App\Http\Controllers;

use Maatwebsite\Excel\Facades\Excel;
use App\MyCart;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Hash;
use App\User;
use App\User2;
use App\Cigarettes;
use App\ATM;
use App\Inventory;
use App\Inventory2;
use App\Stores;
use App\Sales;
use App\ExpenseItems;
use App\Payments;
use App\Vendors;
use App\Items;
use App\Lottery;
use App\Expense;
use App\Messages;
use App\Customers;
use App\OrderItems;
use App\OrderCategories;
use App\Orders;
use App\OrderDetails;
use App\WesternUnion;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\DB;
use App\Http\Requests;
use Illuminate\Support\Facades\Input;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\View;
use Illuminate\Support\Facades\Mail;
use Config;
use Illuminate\Support\Facades\Validator;
use Illuminate\Http\Request;
use Dompdf\Dompdf;

define("api_url", "http://aaryagroup.us/api/v10/");
//define("api_url", "http://websitedemo.co.in/phpdemoz/Aarya/api/v6/");
//define("api_url", "http://localhost:8000/api/v6/");
class AdminController extends Controller
{
	function privacyPolicy(){
		//echo "here"; die();
		return view('privacy_policy');
	}
	function web_index(){
		//echo "here"; die();
		return view('web_index');
	}
	function web_signup(){
		//echo "here"; die();
		return view('web_signup');
	}
	function web_signup_entry(Request $request){
		$validator = Validator::make($request->all(), [
			'name' => 'required|regex:/^[\pL\s]+$/u',
            'email' => 'required|email',
			'password' => 'required|confirmed',
			'password_confirmation' => '',
        	'contact_no' => 'required|numeric|min:11',
			'address' => 'required',
        ]);
		if ($validator->fails()) {
            return redirect('signup')
                        ->withErrors($validator,'login')
                        ->withInput();
        }
		$count = User::where(array("email"=>$request->get('email')))->count();
		if($count>0){
			return redirect('signup')->with(array("error"=>"Email already exists in database"));
		}
		$hashed_password = Hash::make($request->get('password'));
		$data1=array(
				"name"=>$request->get('name'),
				"email"=>$request->get('email'),
				"password"=>$hashed_password,
				"mobile"=>$request->get('contact_no'),
				"address"=>$request->get('address'),
				'role' => 'admin',
				'can_edit_reports' => 'yes',
     	 		);
     	 		$user = new User($data1);
				$user->save();
				if($user) {
				Session::flash('success', 'User successfully register.');
        	   return redirect('signup');
        	   }else {
        	   Session::flash('error', 'Some error. please try again.');
        	   return redirect('signup');
        	   	}
	}
	//--------------------- Login --------------------------------//	
	function index(){
    return view('admin.login_view');
	}
	//---------------------Verify Login --------------------------//
	function verify_login(Request $request){
			$about = User::all();
		   $validator = Validator::make($request->all(), [
            'email' => 'required|email',
            'password' => 'required',
        ]);
        if ($validator->fails()) {
            return redirect('login')
                        ->withErrors($validator,'login')
                        ->withInput();
        } else {
       $email=$request->get('email');
	   $password = $request->get('password');
       $users = User::where('email', '=', $email)->take(1)->get();
	   if(!empty($users[0])){
			if($users[0]['status']== 0){
		   return redirect('login')->with(array('error' => 'Sorry! Your account is blocked!'));
	   }else if($users[0]['status']== 2){
		   return redirect('login')->with(array('error' => 'Sorry! Your account is no longer active!'));
	   }else if($users[0]['role']== "staff"){
		   return redirect('login')->with(array('error' => 'Sorry! You are not allowed to log in here!'));
	   }else if($users[0]['status']==1){
			if(!empty($users[0])) {  
        		if(Hash::check($request->get('password'),$users[0]['password']))
				{
        			$data=array(
        				"id"=>$users[0]['id'],
        				"name"=>$users[0]['name'],
						"role"=>$users[0]['role'],
						"can_edit_reports"=>$users[0]['can_edit_reports'],
        			);
					Session::put('user_role',$users[0]['role']);
					Session::put('login_id',$users[0]['id']);
					Session::put('can_edit_reports',$users[0]['can_edit_reports']);
        			Session::put('login_admin', $data);
            	return redirect('home');
            }else {
            	Session::flash('error','Invalid email or password');
        	  		return redirect('login');
            }
        	}else{
				Session::flash('error', 'Invalid email or password');
        	   return redirect('login');
        	}
	   }
	   }else{
		   Session::flash('error', 'Invalid email or password');
        	   return redirect('login');
	   }
      }
    	return view('admin.login_view');
    	
	}
	//------------------------ Home -------------------------//
	function admin_home(){
		if (Session::has('login_admin')){
		
     		$login_data = Session::get('login_admin');
     		$data['login']=$login_data;
     		return view("admin.home_view", $data);
		}else {
			 return redirect('login');	
		}
	}
	//--------------------------------- Edit Profile View------------------------------//
	function edit_profile(){
		if (Session::has('login_admin')){
					
     		$login_data = Session::get('login_admin');
     		$data['login']=$login_data;
     	 	$data['user'] = User::where('id', '=', $login_data['id'])->take(1)->get();
      	return view("admin.edit_user", $data);
		}else {
			 return redirect('login');	
		}
	}
	//-------------------------------Update Profile -----------------------------------//
	function update_profile(Request $request){
		if (Session::has('login_admin')){
					
     		$login_data = Session::get('login_admin');
     		$data['login']=$login_data;
     		if($request->get('chng_pwd')  == '1' ) {
     	 	$validator = Validator::make($request->all(), [
				'email' => 'required|email',
        		'name' => 'required|regex:/^[\pL\s]+$/u',
				'mobile' => 'required|min:11|numeric',
				'password' => 'required'
        ]);
        } else {
        		$validator = Validator::make($request->all(), [
				'email' => 'required|email',
        		'name' => 'required|regex:/^[\pL\s]+$/u',
				'mobile' => 'required|min:11|numeric',
        ]);
        	}
        if ($validator->fails()) {
            return redirect('edit_profile')
                        ->withErrors($validator,'login')
                        ->withInput();
        } else {
			
				$count = User::where("id",'!=',Session::get('login_id'))->where("email",'=',$request->get('email'))->count();
				if($count>0){
					return redirect('edit_profile')->with(array("error"=>"Email already exists in database"));
				}
				$data1=array(
				"email"=>$request->get('email'),
     	 		"name"=>$request->get('name'),
				"mobile"=>$request->get('mobile'),
     	 		);
     		if($request->get('chng_pwd')  == '1' ) {
     			$data1['password'] = Hash::make($request->get('password'));
     			}
     	 		$chng_pwd=$request->get('chng_pwd');
     	 		$update = User::where(array("id"=>$data['login']['id']))->update($data1);
				if(!empty($request->get('password'))){
					$user_data = User::where(array("id"=>$data['login']['id']))->first();
						$data1['name'] = $user_data['name'];
						$data1['email'] = $user_data['email'];
						$data1['password']= $request->get('password');
						Mail::send('admin.password_changed_email',$data1, function($message) use ($data1){
								$message->from('support@aaryagroup.com', 'Aarya Group');
								$message->to($data1['email']);
								$message->subject('Account password changed');
							});
				}
     	 		if($update) {
				Session::flash('success', 'Profile updated successfully');
        	   return redirect('edit_profile');
        	   }else {
        	   Session::flash('success', 'Some error . Profile not updated');
        	   return redirect('edit_profile');
        	   	}
        }
     		return view("admin.edit_user", $data);
		}else {
			 return redirect('login');	
		}
	}
	function forgot_view()
	{
		return view("admin.forgot_view");
	}
	function check_email(Request $request)
	{
		$validator = Validator::make($request->all(), [
            'email' => 'required|email',
        ]);
        	
        if ($validator->fails()) {
            return redirect('forgot')
                        ->withErrors($validator,'login')
                        ->withInput();
        }
		else{
			$count = User::where(array("email" =>$request->get('email')))->count();
			if($count>0)
			{
				$user = User::where(array("email" =>$request->get('email')))->first();
						
						$data1['name'] = $user['name'];
						$data1['email'] = $user['email'];
						$token = str_random(50);
						$data1['link']= url('reset_password')."/".$token;
						Mail::send('admin.forgot_pass_email',$data1, function($message) use ($data1){
								 $message->from('support@aaryagroup.com', 'Aarya Group');
        						$message->to($data1['email']);
       						 $message->subject('Reset Password');
    			       });
					   $where = array("email"=>$data1['email']);
					   User::where($where)->update(array("password_token"=>$token));
					   Session::flash('success', 'Link has been sent to your email for password reset.');
						return redirect('login');
			}
			else
			{
				Session::flash('error', 'This email does not belong to any account');
				return redirect('forgot');
			}
		}
		
	}
	function check_token($token)
	{
		$token_exist = User::where(array("password_token"=>$token))->count();
			if($token_exist>0)
			{
				$data['token']=$token;
				return view("admin.reset_password_view",$data);
			}
			else
			{
				Session::flash('error', 'Password reset code might be expired or you have already changed password with this code.');
        	  	return redirect('forgot');
			}
	}
	function set_new_password($token,Request $request)
	{
		$messages = [
				'confirm_pass.same' => 'Passwords does not match',
				'confirm_pass.required' => 'Confirm password is required',
		];
		$validator = Validator::make($request->all(), [
            'password' => 'required|min:5|max:15',
            'confirm_pass' => 'required|same:password',
        ],$messages);
        	
        if ($validator->fails()) {
            return redirect('reset_password/'.$token)
                        ->withErrors($validator,'login')
                        ->withInput();
        }
		else {
				$old_data = User::where(array("password_token"=>$token))->first();
							$data2['name'] = $old_data['name'];
							$data2['email'] = $old_data['email'];
							$data2['password'] = $request->get('password');
							Mail::send('admin.password_changed_email',$data2, function($message) use ($data2){
								$message->from('support@aaryagroup.com', 'Aarya Group');
								$message->to($data2['email']);
								$message->subject('Account password changed');
							});
				
				$password = Hash::make($request->get('password'));
				$update = array('password'=>$password, 'password_token'=>'');
				User::where('password_token','=',$token)->update($update);
				
				Session::flash('success', 'Password successfully changed. Please login');
        	  	return redirect('login');
		}
	}
	//---------------------------- Logout -----------------------------//
	function admin_logout(){
		Session::forget('login_admin');
		Session::forget('user_role');
		Session::forget('permissions');
		Session::forget('login_id');
		
		return redirect('login');	
	}
	function report_list()
	{
		if (Session::has('login_admin') && Session::get('user_role') == 'admin'){
		
     		$login_data = Session::get('login_admin');
     		$data['login']=$login_data;
			//$data['user'] = User::where(array("status"=>1, "role"=>"staff"))->paginate(10);
			return view("admin.reports_dashboard",$data);
		}else {
			 return redirect('login');	
		}
		
	}
	function user_list(Request $request)
	{
		if (Session::has('login_admin') && Session::get('user_role') == 'admin'){
		
     		$login_data = Session::get('login_admin');
     		$data['login']=$login_data;
			$search = $request->get('search');
			$login_id = Session::get('login_id');
			$user = User::where(array("id"=>$login_id))->first();
			$store_access = $user['store_access'];
			if(!empty($search) && !empty($store_access)){
				$data['user'] = User::whereRaw("store_id IN(".$store_access.") AND (status=1 OR status=0) AND(name like '%$search%' or email like '%$search%' or mobile like '%$search%')")->orderBy('users.id','DESC')->paginate(20);
				$data['search'] = $search;
			}else if(!empty($search) && empty($store_access)){
				$data['user'] = User::whereRaw("(status=1 OR status=0) AND(name like '%$search%' or email like '%$search%' or mobile like '%$search%')")->orderBy('users.id','DESC')->paginate(20);
				$data['search'] = $search;
			}else if(empty($search) && !empty($store_access)){
				$data['user'] = User::whereRaw("store_id IN(".$store_access.") AND (status=1 OR status=0)")->orderBy('users.id','DESC')->paginate(20);
				$data['search'] = "";
			}else{
				$data['user'] = User::whereRaw('status=1 OR status=0')->orderBy('users.id','DESC')->paginate(20);
				$data['search'] = "";
			}
			return view("admin.user_list",$data);
		}else {
			 return redirect('login');	
		}
		
	}
	
	function add_user_view()
	{
		if (Session::has('login_admin') && Session::get('user_role') == 'admin'){
		
     		$login_data = Session::get('login_admin');
     		$data['login']=$login_data;
			$data['stores']=Stores::where(array("status"=>1))->get();
			return view("admin.add_user",$data);
		}else {
			 return redirect('login');	
		}
	}
	function add_user(Request $request)
	{
		if (Session::has('login_admin') && Session::get('user_role') == 'admin'){
					
			$login_id = Session::get('login_id');
     		$login_data = Session::get('login_admin');
     		$data['login']=$login_data;
			$validator = Validator::make($request->all(), [
			'name' => 'required|regex:/^[\pL\s]+$/u',
            'email' => 'required|email',
        	'mobile' => 'required|numeric|min:11',
			'role' => 'required',
        ]);
		//print_r($request->get('store')); die();
        if ($validator->fails()) {
            return redirect('admin/add_user_view')
                        ->withErrors($validator,'login')
                        ->withInput();
        }
		$count = User::where(array("email"=>$request->get('email')))->count();
		if($count>0){
			return redirect('admin/add_user_view')->with(array("error"=>"Email already exists in database"));
		}
		if($request->get('role') == "admin"){
			$val = array("store"=>$request->get('store'));
			$validator = Validator::make($val, [
			'store' => 'required',
        ]);
		}if ($validator->fails()) {
            return redirect('admin/add_user_view')
                        ->withErrors($validator,'login')
                        ->withInput();
        }if($request->get('role') == "staff"){
			$val2 = array("store_id"=>$request->get('store_id'), "shift"=>$request->get('shift'));
			$validator = Validator::make($val2, [
			'store_id' => 'required',
			'shift' => 'required'
        ]);
		}if ($validator->fails()) {
            return redirect('admin/add_user_view')
                        ->withErrors($validator,'login')
                        ->withInput();
        } 
		else {
			
			$password = str_random(5);
			$hashed_password = Hash::make($password);
			if($request->get('role')=="admin"){
				$store = implode(',',$request->get('store'));
				$store_game = "";
				if($request->get('store_game') != ""){
				$store_game = implode(',',$request->get('store_game'));
				}
				$data1=array(
				"name"=>$request->get('name'),
				"email"=>$request->get('email'),
				"password"=>$hashed_password,
				"mobile"=>$request->get('mobile'),
				"can_edit_reports"=>$request->get('can_edit_reports'),
				"role"=>"admin",
				"store_access"=>$store,
				"store_game_access"=>$store_game,
				"created_by"=>$login_id
     	 		);
     	 		$user = new User($data1);
				$user->save();
				$data1['email'] = $request->get('email');
				$data1['name'] = $request->get('name');
				$data1['password'] = $password;
					Mail::send('admin.account_password_email',$data1, function($message) use ($data1){
								$message->from('support@aaryagroup.com', 'Aarya Group');
								$message->to($data1['email']);
								$message->subject('Account Password');
					});
     	 		if($user) {
				Session::flash('success', 'User successfully added');
        	   return redirect('admin/user_list');
        	   }else {
        	   Session::flash('error', 'Some error. User not added');
        	   return redirect('admin/add_user_view');
        	   	}
			}else if($request->get('role')=="staff"){
				$data1=array(
				"name"=>$request->get('name'),
				"email"=>$request->get('email'),
				"password"=>$hashed_password,
				"mobile"=>$request->get('mobile'),
				"shift"=>$request->get('shift'),
				"role"=>"staff",
				"store_id"=>$request->get('store_id'),
				"created_by"=>$login_id,
     	 		);
     	 		$user = new User($data1);
				$user->save();
				
				$data1['email'] = $request->get('email');
				$data1['name'] = $request->get('name');
				$data1['password'] = $password;
					Mail::send('admin.account_password_email',$data1, function($message) use ($data1){
								$message->from('support@aaryagroup.com', 'Aarya Group');
								$message->to($data1['email']);
								$message->subject('Account Password');
					});
     	 		if($user) {
				Session::flash('success', 'User successfully added');
        	   return redirect('admin/user_list');
        	   }else {
        	   Session::flash('error', 'Some error. User not added');
        	   return redirect('admin/add_user_view');
        	   	}
			}
        }
     		return view("admin.user_list", $data);
		}else {
			 return redirect('login');	
		}
	}
	function edit_user($id)
	{
		if (Session::has('login_admin') && Session::get('user_role') == 'admin'){
		
     		$login_data = Session::get('login_admin');
			$user = User::where(array("id"=>$id))->first();
     		$data['login']=$login_data;
			$data['user'] = User::where(array("id"=>$id))->get();
			$data['stores'] = Stores::where(array("status"=>1))->get();
			if(!empty($user['store_access'])){
				$data['store_access'] = explode(',',$user['store_access']);
			}
			if(!empty($user['store_game_access'])){
				$data['store_game_access'] = explode(',',$user['store_game_access']);
			}
			return view("admin.edit_user_info",$data);
		}else {
			 return redirect('login');	
		}
	}
	function update_user_data($id,Request $request)
	{
		
		if (Session::has('login_admin') && Session::get('user_role') == 'admin'){
			
			
			$old_data = User::where(array("id"=>$id))->first();
			$login_id = Session::get('login_id');
     		$login_data = Session::get('login_admin');
     		$data['login']=$login_data;
			$validator = Validator::make($request->all(), [
			'name' => 'required|regex:/^[\pL\s]+$/u',
            'email' => 'required|email',
			'mobile' => 'required|numeric|min:11',
			'role' => 'required',
        ]);
        	
        if ($validator->fails()) {
            return redirect("admin/edit_user/$id")
                        ->withErrors($validator,'login')
                        ->withInput();
        }
		$count = User::where("id",'!=',$id)->where("email",'=',$request->get('email'))->count();
				if($count>0){
					return redirect("admin/edit_user/$id")->with(array("error"=>"Email already exists in database"));
				}
		if($request->get('role') == "admin"){
			$val = array("store"=>$request->get('store'));
			$validator = Validator::make($val, [
			'store' => 'required',
        ]);
		}if ($validator->fails()) {
            return redirect("admin/edit_user/$id")
                        ->withErrors($validator,'login')
                        ->withInput();
        }if($request->get('role') == "staff"){
			$val2 = array("store_id"=>$request->get('store_id'),"shift"=>$request->get('shift'));
			$validator = Validator::make($val2, [
			'store_id' => 'required',
			'shift' => 'required',
        ]);
		}if ($validator->fails()) {
            return redirect("admin/edit_user/$id")
                        ->withErrors($validator,'login')
                        ->withInput();
        }
		else {
				if($request->get('chng_pwd')== "1"){
					$val2 = array("password"=>$request->get('password'));
					$validator = Validator::make($val2, [
					'password' => 'required|min:5'
					]);
					if ($validator->fails()) {
					return redirect("admin/edit_user/$id")
                        ->withErrors($validator,'login')
                        ->withInput();
					}
					else{
						$password = $request->get('password');
						$hashed_password = Hash::make($password);
						
						if($request->get('role')=="admin"){
							$store = implode(',',$request->get('store'));
							$store_game = "";
							if($request->get('store_game') != ""){
							$store_game = implode(',',$request->get('store_game'));
							}
							$data1=array(
							"name"=>$request->get('name'),
							"email"=>$request->get('email'),
							"mobile"=>$request->get('mobile'),
							"role"=>$request->get('role'),
							"can_edit_reports"=>$request->get('can_edit_reports'),
							"store_access"=>$store,
							"store_game_access"=>$store_game,
							"password"=>$hashed_password,
							"updated_by"=>$login_id,
							);		
							
							$data2['name'] = $old_data['name'];
							$data2['email'] = $old_data['email'];
							$data2['password'] = $request->get('password');
							Mail::send('admin.password_changed_email',$data2, function($message) use ($data1){
								$message->from('support@aaryagroup.com', 'Aarya Group');
								$message->to($data1['email']);
								$message->subject('Account password changed');
							});
						}else if($request->get('role')=="staff"){
						
						
							$data1=array(
							"name"=>$request->get('name'),
							"email"=>$request->get('email'),
							"mobile"=>$request->get('mobile'),
							"role"=>$request->get('role'),
							"store_id"=>$request->get('store_id'),
							"shift"=>$request->get('shift'),
							"password"=>$hashed_password,
							"updated_by"=>$login_id,
							);
							
							$data2['name'] = $old_data['name'];
							$data2['email'] = $old_data['email'];
							$data2['password'] = $request->get('password');
							Mail::send('admin.password_changed_email',$data2, function($message) use ($data2){
								$message->from('support@aaryagroup.com', 'Aarya Group');
								$message->to($data2['email']);
								$message->subject('Account password changed');
							});
						}
					}
					}else if($request->get('chng_pwd') != "1"){
						
						if($request->get('role')=="admin"){
							$store = implode(',',$request->get('store'));
							$store_game = "";
							if($request->get('store_game') != ""){ 
							$store_game = implode(',',$request->get('store_game'));
							}
							$data1=array(
							"name"=>$request->get('name'),
							"email"=>$request->get('email'),
							"mobile"=>$request->get('mobile'),
							"role"=>$request->get('role'),
							"can_edit_reports"=>$request->get('can_edit_reports'),
							"store_access"=>$store,
							"store_game_access"=>$store_game,
							"updated_by"=>$login_id,
							);
						}else if($request->get('role')=="staff"){
						
						
							$data1=array(
							"name"=>$request->get('name'),
							"email"=>$request->get('email'),
							"mobile"=>$request->get('mobile'),
							"role"=>$request->get('role'),
							"store_id"=>$request->get('store_id'),
							"shift"=>$request->get('shift'),
							"updated_by"=>$login_id,
							);
						}
					}
					
				}
				$update = User::where(array("id"=>$id))->update($data1);
				
     	 		if($update) {
				Session::flash('success', 'User successfully updated');
        	   return redirect("admin/user_list");
        	   }else {
        	   Session::flash('success', 'Some error. User info is not updated');
        	   return redirect("admin/edit_user/$id");
        	   	}
        
     		//return view("admin.user_list", $data);
		}else {
			 return redirect('login');	
		}
	}
	function block_user($id)
	{
		if (Session::has('login_admin') && Session::get('user_role') == 'admin'){
		
			$login_id = Session::get('login_id');
     		$login_data = Session::get('login_admin');
     		$data['login']=$login_data;
			$del = User::where(array("id"=>$id))->update(array("status"=>0, "blocked_by"=>$login_id));
			if($del){
				Session::flash('success', 'User successfully blocked');
				return redirect('admin/user_list');	
			}
			else{
				Session::flash('success', 'Some error. User is not blocked');
				return redirect("admin/user_list");
			}
		}else {
			 return redirect('login');	
		}
	}
	
	function unblock_user($id)
	{
		if (Session::has('login_admin') && Session::get('user_role') == 'admin'){
		
			$login_id = Session::get('login_id');
     		$login_data = Session::get('login_admin');
     		$data['login']=$login_data;
			$del = User::where(array("id"=>$id))->update(array("status"=>1));
			if($del){
				Session::flash('success', 'User successfully unblocked');
				return redirect('admin/user_list');	
			}
			else{
				Session::flash('success', 'Some error. User is not unblocked');
				return redirect("admin/user_list");
			}
		}else {
			 return redirect('login');	
		}
	}
	
	function delete_user($id)
	{
		if (Session::has('login_admin') && Session::get('user_role') == 'admin'){
		
			$login_id = Session::get('login_id');
     		$login_data = Session::get('login_admin');
     		$data['login']=$login_data;
			$del = User::where(array("id"=>$id))->update(array("status"=>2, "deleted_by"=>$login_id));
			if($del){
				Session::flash('success', 'User successfully deleted');
				return redirect('admin/user_list');	
			}
			else{
				Session::flash('success', 'Some error. User is not deleted');
				return redirect("admin/user_list");
			}
		}else {
			 return redirect('login');	
		}
	}
	function store_list(Request $request)
	{
		if (Session::has('login_admin') && Session::get('user_role') == 'admin'){
			$search = $request->get('search');
     		$login_data = Session::get('login_admin');
     		$data['login']=$login_data;
			$user_data = User::where(array("id"=>Session::get('login_id')))->first();
			
			if(!empty($user_data['store_access']) && !empty($search)){
				
				$data['store'] = Stores::whereRaw("status=1 AND id IN(".$user_data['store_access'].") AND(name like '%$search%' OR address like '%$search%' or contact_no like '%$search%')")->paginate(20);
				$data['search'] = $search;
				
			}else if(empty($user_data['store_access']) && !empty($search)){
				
				$data['store'] = Stores::whereRaw("status=1 AND (name like '%$search%' OR address like '%$search%' or contact_no like '%$search%')")->paginate(20);
				$data['search'] = $search;
				
			}else if(!empty($user_data['store_access']) && empty($search)){
				
				$data['store'] = Stores::whereRaw("status=1 AND id IN(".$user_data['store_access'].")")->paginate(20);
				$data['search'] = "";
				
			}else{
				
				$data['search'] = "";
				$data['store'] = Stores::where(array("status"=>1))->paginate(20);
			}
			return view("admin.store_list",$data);
		}else {
			 return redirect('login');	
		}
	}
	function add_store_view()
	{
		if (Session::has('login_admin') && Session::get('user_role') == 'admin'){
		
     		$login_data = Session::get('login_admin');
     		$data['login']=$login_data;
			return view("admin.add_store",$data);
		}else {
			 return redirect('login');	
		}
	}
	function add_store(Request $request)
	{
		if (Session::has('login_admin') && Session::get('user_role') == 'admin'){
					
     		$login_data = Session::get('login_admin');
     		$data['login']=$login_data;
			$validator = Validator::make($request->all(), [
			'name' => 'required',
			'address' => 'required',
        	'contact_no' => 'required|numeric',
        ]);
        	
        if ($validator->fails()) {
            return redirect('admin/add_store_view')
                        ->withErrors($validator,'login')
                        ->withInput();
        } else {
				$login_id = Session::get('login_id');
				$data1=array(
				"name"=>$request->get('name'),
     	 		"address"=>$request->get('address'),
				"contact_no"=>$request->get('contact_no'),
				"created_by"=>$login_id,
     	 		);
     	 		$store = new Stores($data1);
				$store->save();
     	 		if($store) {
				Session::flash('success', 'Store successfully added');
        	   return redirect('admin/store_list');
        	   }else {
        	   Session::flash('error', 'Some error. Store not added');
        	   return redirect('admin/add_store_view');
        	   	}
        }
     		return view("admin.store_list", $data);
		}else {
			 return redirect('login');	
		}
	}
	function edit_store($id)
	{
		if (Session::has('login_admin') && Session::get('user_role') == 'admin'){
		
     		$login_data = Session::get('login_admin');
     		$data['login']=$login_data;
			$data['store'] = Stores::where(array("id"=>$id))->get();
			return view("admin.edit_store_info",$data);
		}else {
			 return redirect('login');	
		}
	}
	function update_store_data($id,Request $request)
	{
		if (Session::has('login_admin') && Session::get('user_role') == 'admin'){
     		$login_data = Session::get('login_admin');
     		$data['login']=$login_data;
			$validator = Validator::make($request->all(), [
			'name' => 'required',
			'address' => 'required',
        	'contact_no' => 'required|numeric',
        ]);
        	
        if ($validator->fails()) {
            return redirect("admin/edit_store/$id")
                        ->withErrors($validator,'login')
                        ->withInput();
        } else {
				$login_id = Session::get('login_id');
				$data1=array(
				"name"=>$request->get('name'),
     	 		"address"=>$request->get('address'),
				"contact_no"=>$request->get('contact_no'),
				"updated_by"=>$login_id,
     	 		);
     	 		$update = Stores::where(array("id"=>$id))->update($data1);
     	 		if($update) {
				Session::flash('success', 'Store successfully updated');
        	   return redirect("admin/store_list");
        	   }else {
        	   Session::flash('error', 'Some error. Store info is not updated');
        	   return redirect("admin/edit_store/$id");
        	   	}
        }
     		return view("admin.store_list", $data);
		}else {
			 return redirect('login');	
		}
	}
	function delete_store($id)
	{
		if (Session::has('login_admin') && Session::get('user_role') == 'admin'){
		
     		$login_data = Session::get('login_admin');
     		$data['login']=$login_data;
			
			$login_id = Session::get('login_id');
			$del = Stores::where(array("id"=>$id))->update(array("status"=>0, "deleted_by"=>$login_id));
			if($del){
				Session::flash('success', 'Store successfully deleted');
				return redirect('admin/store_list');	
			}
			else{
				Session::flash('success', 'Some error. Store is not deleted');
				return redirect("admin/store_list");
			}
		}else {
			 return redirect('login');	
		}
	}
	function item_list()
	{
		if (Session::has('login_admin') && Session::get('user_role') == 'admin'){
		
     		$login_data = Session::get('login_admin');
     		$data['login']=$login_data;
			$data['item'] = Items::where(array("status"=>1))->paginate(20);
			return view("admin.item_list",$data);
		}else {
			 return redirect('login');	
		}
	}
	function add_item_view()
	{
		if (Session::has('login_admin') && Session::get('user_role') == 'admin'){
		
     		$login_data = Session::get('login_admin');
     		$data['login']=$login_data;
			return view("admin.add_item",$data);
		}else {
			 return redirect('login');	
		}
	}
	function add_item(Request $request)
	{
		if (Session::has('login_admin') && Session::get('user_role') == 'admin'){
					
     		$login_data = Session::get('login_admin');
     		$data['login']=$login_data;
			$validator = Validator::make($request->all(), [
			'name' => 'required'
        ]);
        	
        if ($validator->fails()) {
            return redirect('admin/add_item_view')
                        ->withErrors($validator,'login')
                        ->withInput();
        } else {
				$data1=array(
				"name"=>$request->get('name')		
     	 		);
     	 		$item = new Items($data1);
				$item->save();
     	 		if($item) {
				Session::flash('success', 'Item successfully added');
        	   return redirect('admin/item_list');
        	   }else {
        	   Session::flash('error', 'Some error. Item not added');
        	   return redirect('admin/add_item_view');
        	   	}
        }
     		return view("admin.item_list", $data);
		}else {
			 return redirect('login');	
		}
	}
	function edit_item($id)
	{
		if (Session::has('login_admin') && Session::get('user_role') == 'admin'){
		
     		$login_data = Session::get('login_admin');
     		$data['login']=$login_data;
			$data['item'] = Items::where(array("id"=>$id))->get();
			return view("admin.edit_item_info",$data);
		}else {
			 return redirect('login');	
		}
	}
	function update_item_data($id,Request $request)
	{
		if (Session::has('login_admin') && Session::get('user_role') == 'admin'){
     		$login_data = Session::get('login_admin');
     		$data['login']=$login_data;
			$validator = Validator::make($request->all(), [
			'name' => 'required'
        ]);
        	
        if ($validator->fails()) {
            return redirect("admin/edit_item/$id")
                        ->withErrors($validator,'login')
                        ->withInput();
        } else {
				$data1=array(
				"name"=>$request->get('name')
     	 		);
     	 		$update = Items::where(array("id"=>$id))->update($data1);
     	 		if($update) {
				Session::flash('success', 'Item successfully updated');
        	   return redirect("admin/item_list");
        	   }else {
        	   Session::flash('error', 'Some error. Item info is not updated');
        	   return redirect("admin/edit_item/$id");
        	   	}
        }
     		return view("admin.item_list", $data);
		}else {
			 return redirect('login');	
		}
	}
	function delete_item($id)
	{
		if (Session::has('login_admin') && Session::get('user_role') == 'admin'){
		
     		$login_data = Session::get('login_admin');
     		$data['login']=$login_data;
			$del = Items::where(array("id"=>$id))->update(array("status"=>0));
			if($del){
				Session::flash('success', 'Item successfully deleted');
				return redirect('admin/item_list');	
			}
			else{
				Session::flash('error', 'Some error. Item is not deleted');
				return redirect("admin/item_list");
			}
		}else {
			 return redirect('login');	
		}
	}
	function expense_item_list()
	{
		if (Session::has('login_admin') && Session::get('user_role') == 'admin'){
		
     		$login_data = Session::get('login_admin');
     		$data['login']=$login_data;
			$data['item'] = ExpenseItems::where(array("status"=>1))->orderBy('id','desc')->paginate(20);
			return view("admin.expense_item_list",$data);
		}else {
			 return redirect('login');	
		}
	}
	function add_expense_item_view()
	{
		if (Session::has('login_admin') && Session::get('user_role') == 'admin'){
		
     		$login_data = Session::get('login_admin');
     		$data['login']=$login_data;
			return view("admin.add_expense_item",$data);
		}else {
			 return redirect('login');	
		}
	}
	function add_expense_item(Request $request)
	{
		if (Session::has('login_admin') && Session::get('user_role') == 'admin'){
					
     		$login_data = Session::get('login_admin');
     		$data['login']=$login_data;
			$validator = Validator::make($request->all(), [
			'name' => 'required'
        ]);
        	
        if ($validator->fails()) {
            return redirect('admin/add_expense_item_view')
                        ->withErrors($validator,'login')
                        ->withInput();
        } else {
				$data1=array(
				"expense_item"=>$request->get('name')		
     	 		);
     	 		$item = new ExpenseItems($data1);
				$item->save();
     	 		if($item) {
				Session::flash('success', 'Expense item successfully added');
        	   return redirect('admin/expense_item_list');
        	   }else {
        	   Session::flash('error', 'Some error. Expense item not added');
        	   return redirect('admin/add_expsense_item_view');
        	   	}
        }
     		return view("admin.expense_item_list", $data);
		}else {
			 return redirect('login');	
		}
	}
	function edit_expense_item($id)
	{
		if (Session::has('login_admin') && Session::get('user_role') == 'admin'){
		
     		$login_data = Session::get('login_admin');
     		$data['login']=$login_data;
			$data['item'] = ExpenseItems::where(array("id"=>$id))->get();
			return view("admin.edit_expense_item_info",$data);
		}else {
			 return redirect('login');	
		}
	}
	function update_expense_item_data($id,Request $request)
	{
		if (Session::has('login_admin') && Session::get('user_role') == 'admin'){
     		$login_data = Session::get('login_admin');
     		$data['login']=$login_data;
			$validator = Validator::make($request->all(), [
			'name' => 'required'
        ]);
        	
        if ($validator->fails()) {
            return redirect("admin/edit_expense_item/$id")
                        ->withErrors($validator,'login')
                        ->withInput();
        } else {
				$data1=array(
				"expense_item"=>$request->get('name')
     	 		);
     	 		$update = ExpenseItems::where(array("id"=>$id))->update($data1);
     	 		if($update) {
				Session::flash('success', 'Expense item successfully updated');
        	   return redirect("admin/expense_item_list");
        	   }else {
        	   Session::flash('error', 'Some error. Expense item info is not updated');
        	   return redirect("admin/edit_expense_item/$id");
        	   	}
        }
     		return view("admin.expense_item_list", $data);
		}else {
			 return redirect('login');	
		}
	}
	function delete_expense_item($id)
	{
		if (Session::has('login_admin') && Session::get('user_role') == 'admin'){
		
     		$login_data = Session::get('login_admin');
     		$data['login']=$login_data;
			$del = ExpenseItems::where(array("id"=>$id))->update(array("status"=>0));
			if($del){
				Session::flash('success', 'Expense item successfully deleted');
				return redirect('admin/expense_item_list');	
			}
			else{
				Session::flash('error', 'Some error. Expense item is not deleted');
				return redirect("admin/expense_item_list");
			}
		}else {
			 return redirect('login');	
		}
	}
	function vendor_list()
	{
		if (Session::has('login_admin') && Session::get('user_role') == 'admin'){
		
     		$login_data = Session::get('login_admin');
     		$data['login']=$login_data;
			$data['vendor'] = Vendors::where(array("status"=>1))->paginate(20);
			return view("admin.vendor_list",$data);
		}else {
			 return redirect('login');	
		}
	}
	function add_vendor_view()
	{
		if (Session::has('login_admin') && Session::get('user_role') == 'admin'){
		
     		$login_data = Session::get('login_admin');
     		$data['login']=$login_data;
			return view("admin.add_vendor",$data);
		}else {
			 return redirect('login');	
		}
	}
	function add_vendor(Request $request)
	{
		if (Session::has('login_admin') && Session::get('user_role') == 'admin'){
					
     		$login_data = Session::get('login_admin');
     		$data['login']=$login_data;
			$validator = Validator::make($request->all(), [
			'name' => 'required'
        ]);
        	
        if ($validator->fails()) {
            return redirect('admin/add_vendor_view')
                        ->withErrors($validator,'login')
                        ->withInput();
        } else {
				$data1=array(
				"name"=>$request->get('name')		
     	 		);
     	 		$vendor = new Vendors($data1);
				$vendor->save();
     	 		if($vendor) {
				Session::flash('success', 'Vendor successfully added');
        	   return redirect('admin/vendor_list');
        	   }else {
        	   Session::flash('error', 'Some error. Vendor not added');
        	   return redirect('admin/add_vendor_view');
        	   	}
        }
     		return view("admin.vendor_list", $data);
		}else {
			 return redirect('login');	
		}
	}
	function edit_vendor($id)
	{
		if (Session::has('login_admin') && Session::get('user_role') == 'admin'){
		
     		$login_data = Session::get('login_admin');
     		$data['login']=$login_data;
			$data['vendor'] = Vendors::where(array("id"=>$id))->get();
			return view("admin.edit_vendor_info",$data);
		}else {
			 return redirect('login');	
		}
	}
	function update_vendor_data($id,Request $request)
	{
		if (Session::has('login_admin') && Session::get('user_role') == 'admin'){
     		$login_data = Session::get('login_admin');
     		$data['login']=$login_data;
			$validator = Validator::make($request->all(), [
			'name' => 'required'
        ]);
        	
        if ($validator->fails()) {
            return redirect("admin/edit_vendor/$id")
                        ->withErrors($validator,'login')
                        ->withInput();
        } else {
				$data1=array(
				"name"=>$request->get('name')
     	 		);
     	 		$update = Vendors::where(array("id"=>$id))->update($data1);
     	 		if($update) {
				Session::flash('success', 'Vendor successfully updated');
        	   return redirect("admin/vendor_list");
        	   }else {
        	   Session::flash('error', 'Some error. Vendor info is not updated');
        	   return redirect("admin/edit_vendor/$id");
        	   	}
        }
     		return view("admin.vendor_list", $data);
		}else {
			 return redirect('login');	
		}
	}
	function delete_vendor($id)
	{
		if (Session::has('login_admin') && Session::get('user_role') == 'admin'){
		
     		$login_data = Session::get('login_admin');
     		$data['login']=$login_data;
			$del = Vendors::where(array("id"=>$id))->update(array("status"=>0));
			if($del){
				Session::flash('success', 'Vendor successfully deleted');
				return redirect('admin/vendor_list');	
			}
			else{
				Session::flash('error', 'Some error. Vendor is not deleted');
				return redirect("admin/vendor_list");
			}
		}else {
			 return redirect('login');	
		}
	}
	function add_inventory()
	{
		if (Session::has('login_admin')){
		
     		$login_data = Session::get('login_admin');
     		$data['login']=$login_data;
			$data['stores']= Stores::where(array("status"=>1))->get();
			$data['items']= Items::where(array("status"=>1))->get();
			$data['vendors']= Vendors::where(array("status"=>1))->get();
			return view("admin.add_inventory",$data);
		}else {
			 return redirect('login');	
		}
	}
	function save_inventory(Request $request)
	{
		if (Session::has('login_admin')){
					
     		$login_data = Session::get('login_admin');
     		$data['login']=$login_data;
			$validator = Validator::make($request->all(), [
			'store' => 'required',
			'date' => 'required',
			'invoice_no' => 'required',
			'item' => 'required',
			'vendor' => 'required',
			'quantity' => 'required|numeric',
			'price' => 'required|numeric',
        ]);
        	
        if ($validator->fails()) {
            return redirect('admin/add_inventory')
                        ->withErrors($validator,'login')
                        ->withInput();
        } else {
				$date = $request->get('date');
				$date = str_replace('/', '-', $date);
				$date = date('Y:m:d',strtotime($date));
				$date = $date." 00:00:00";
				$quantity = $request->get('quantity');
				$price = $request->get('price');
				$total_price = $quantity * $price;
				$data1=array(
				"store_id"=>$request->get('store'),
				"date"=>$request->$date,
				"invoice_no"=>$request->get('invoice_no'),
				"item"=>$request->get('item'),
				"vendor"=>$request->get('vendor'),
				"quantity"=>$request->get('quantity'),
				"price"=>$request->get('price'),
				"total_price"=>$total_price,
     	 		);
     	 		$inventory = new Inventory($data1);
				$inventory->save();
     	 		if($inventory) {
				Session::flash('success', 'Inventory successfully added');
        	   return redirect('admin/add_inventory');
        	   }else {
        	   Session::flash('error', 'Some error. Inventory not added');
        	   return redirect('admin/add_inventory');
        	   	}
        }
     		return view("admin.add_inventory", $data);
		}else {
			 return redirect('login');	
		}
	}
	function daily_sales_entry()
	{
		if (Session::has('login_admin')){
	
     		$login_data = Session::get('login_admin');
     		$data['login']=$login_data;
			$data['stores']= Stores::where(array("status"=>1))->get();
			return view("admin.daily_sales_entry",$data);
		}else {
			 return redirect('login');	
		}
		
	}
	function save_daily_sales_entry(Request $request)
	{
		if (Session::has('login_admin') && Session::get('user_role') == 'staff'){
     		$login_data = Session::get('login_admin');
     		$data['login']=$login_data;
			$validator = Validator::make($request->all(), [
			'store' => 'required',
			'inside' => 'required|numeric',
			'tex' => 'required|numeric',
			'gas' => 'required|numeric',
			'phone_card' => 'required|numeric',
			'instant' => 'required|numeric',
			'lottery' => 'required|numeric',
        ]);
        	
        if ($validator->fails()) {
            return redirect("staff/daily_sales_entry")
                        ->withErrors($validator,'login')
                        ->withInput();
        } else {
				$inside = $request->get('inside');
				$tax = $request->get('tex');
				$gas = $request->get('gas');
				$phone_card = $request->get('phone_card');
				$instant = $request->get('instant');
				$lottery = $request->get('lottery');
				$total_sales = $inside + $tax + $gas + $phone_card + $instant + $lottery;
				$data1=array(
				"store_id"=>$request->get('store'),
				"inside"=>$request->get('inside'),
				"tax"=>$request->get('tex'),
				"gas"=>$request->get('gas'),
				"phone_card"=>$request->get('phone_card'),
				"instant"=>$request->get('instant'),
				"lottery"=>$request->get('lottery'),
				"total_sales"=>$total_sales,
     	 		);
     	 	$sales = new Sales($data1);
			$sales->save();
     	 	if($sales) {
				Session::flash('success', 'Daily sales entry successfully added');
				return redirect('staff/daily_sales_entry');
			}else {
				Session::flash('error', 'Some error. Daily sales entry not added');
				return redirect('staff/daily_sales_entry');
        	 }
        }
     		return view("admin.daily_sales_entry", $data);
		}else {
			 return redirect('login');	
		}
	}
	function daily_payment_report()
	{
		if (Session::has('login_admin')){
	
     		$login_data = Session::get('login_admin');
     		$data['login']=$login_data;
			$data['stores']= Stores::where(array("status"=>1))->get();
			return view("admin.daily_payment_report",$data);
		}else {
			 return redirect('login');	
		}
	}
	function save_daily_payment_report(Request $request)
	{
		if (Session::has('login_admin') && Session::get('user_role') == 'staff'){
     		$login_data = Session::get('login_admin');
     		$data['login']=$login_data;
			$validator = Validator::make($request->all(), [
			'store' => 'required',
			'total_cash' => 'required|numeric',
			'total_credit' => 'required|numeric',
			'total_debit' => 'required|numeric',
			'lottery_out' => 'required|numeric',
        ]);
        	
        if ($validator->fails()) {
            return redirect("staff/daily_payment_report")
                        ->withErrors($validator,'login')
                        ->withInput();
        } else {
				//$inside = $request->get('inside');
				//$tax = $request->get('tex');
				//$gas = $request->get('gas');
				//$phone_card = $request->get('phone_card');
				//$instant = $request->get('instant');
				//$lottery = $request->get('lottery');
				//$total_sales = $inside + $tax + $gas + $phone_card + $instant + $lottery;
				$data1=array(
				"store_id"=>$request->get('store'),
				"total_cash"=>$request->get('total_cash'),
				"total_credit"=>$request->get('total_credit'),
				"total_debit"=>$request->get('total_debit'),
				"lottery_out"=>$request->get('lottery_out'),
				"total"=>$request->get('total'),
     	 		);
     	 	$payment = new Payments($data1);
			$payment->save();
     	 	if($payment) {
				Session::flash('success', 'Daily payment report successfully added');
				return redirect('staff/daily_payment_report');
			}else {
				Session::flash('error', 'Some error. Daily payment report not added');
				return redirect('staff/daily_payment_report');
        	 }
        }
     		return view("admin.daily_payment_report", $data);
		}else {
			 return redirect('login');	
		}
	}
	
	function view_store_details($id)
	{
		if (Session::has('login_admin') && Session::get('user_role') == 'admin'){
	
     		$login_data = Session::get('login_admin');
     		$data['login']=$login_data;
			$data['stores'] = DB::table('stores')
						->select(DB::raw(
									'stores.*,
									SUM(daily_payment_report.total) as payment,
									SUM(daily_sales_entry.total_sales) as sales,
									SUM(inventory.total_price) as inventory,
									
									SUM(daily_sales_entry.inside) as inside,
									SUM(daily_sales_entry.tax) as tax,
									SUM(daily_sales_entry.gas) as gas,
									SUM(daily_sales_entry.phone_card) as phone_card,
									SUM(daily_sales_entry.lottery) as lottery,
									
									SUM(daily_payment_report.total_cash) as total_cash,
									SUM(daily_payment_report.total_credit) as total_credit,
									SUM(daily_payment_report.total_debit) as total_debit,
									SUM(daily_payment_report.lottery_out) as lottery_out
									'))
						->leftJoin('daily_payment_report', 'daily_payment_report.store_id', '=', 'stores.id')
						->leftJoin('daily_sales_entry', 'daily_sales_entry.store_id', '=', 'stores.id')
						->leftJoin('inventory', 'inventory.store_id', '=', 'stores.id')
						->where('stores.id','=',$id)
						->groupBy('stores.id')
						->first();
			return view("admin.store_details",$data);
		}else {
			 return redirect('login');	
		}
	}
	
	public function view_report(Request $request)
	{
		if (Session::has('login_admin') && Session::get('user_role') == 'admin'){
			$login_data = Session::get('login_admin');
			$data['login']=$login_data;
			
			$user_data = User::where(array("id"=>Session::get('login_id')))->first();
			$store_access = $user_data['store_access'];
		
			if(!empty($store_access)){
				$data['store'] = Stores::whereRaw('status=1 AND id IN('.$store_access.')')->get();
			}
			if(empty($store_access)){
				$data['store'] = Stores::where(array("status"=>1))->get();
			}
			$id = $request->get('store');
			$login_id = Session::get('login_id');
			$date_from = $request->get('date_from');
			$date_to = $request->get('date_to');
			// $date_from = str_replace('/','-',$date_from);
			// $date_from = date("Y-m-d",strtotime($date_from));
			// $date_to = str_replace('/','-',$date_to);
			// $date_to = date("Y-m-d",strtotime($date_to));
			// if(empty($date_from)){
				// $data['from'] = date('d/m/Y');
			// }else{
				// $data['from'] = $request->get('date_from');
			// }
			// if(empty($date_to)){
				// $data['to'] = date('d/m/Y');
			// }else{
				// $data['to'] = $request->get('date_to');
			// }
			// if(empty($date_from)){
				// $date_from = date('Y-m-d');
			// }
			// if(empty($date_to)){
				// $date_to = date('Y-m-d');
			// }
			if(empty($date_from)){
				$data['from'] = date('m/d/Y');
				$date_from = date('Y-m-d');
			}else{
				$date_from_temp = explode('/',$date_from);
				$date_from = $date_from_temp[2]."-".$date_from_temp[0]."-".$date_from_temp[1];
				$data['from'] = $request->get('date_from');
			}
			if(empty($date_to)){
				$data['to'] = date('m/d/Y');
				$date_to = date('Y-m-d');
			}else{
				$date_to_temp = explode('/',$date_to);
				$date_to = $date_to_temp[2]."-".$date_to_temp[0]."-".$date_to_temp[1];
				$data['to'] = $request->get('date_to');
			}
			
			$data['old_store'] = $request->get('store');
			$data['send_from'] = $date_from;
			$data['send_to'] = $date_to;
			$user_id = Session::get('login_id');
			$data2 = array("user_id"=>Session::get('login_id'),"id"=>$id, "from"=>$date_from, "to"=>$date_to);
			$url = api_url."store_in_profit2?id=".$id."&from=".$date_from."&to=".$date_to."&user_id=".$user_id."";
			$header = array();
			$header[] = 'Content-length: 0';
			$header[] = 'Content-type: application/json';
			$header[] = "Authorization: bearer eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJzdWIiOjQ3LCJpc3MiOiJodHRwOlwvXC9hYXJ5YWdyb3VwLnVzXC9hcGlcL3YxM1wvbG9naW4iLCJpYXQiOjE1NTMwMDEzMDcsImV4cCI6MTYxNTIwOTMwNywibmJmIjoxNTUzMDAxMzA3LCJqdGkiOiJiNmU4NzM5NjQwMzMxM2U0YjAwODkzODE2MjQ2YWY5NiJ9.hO0tSwzLhkLQhIVnKQaW1PGFkoyQkORACnD__tiQMRA";
			$post = curl_init();
			curl_setopt($post, CURLOPT_URL, $url);
			curl_setopt($post, CURLOPT_HTTPHEADER,$header);
			curl_setopt($post, CURLOPT_POST, true);
			curl_setopt($post, CURLOPT_POSTFIELDS,json_encode($data2));
			curl_setopt($post, CURLOPT_RETURNTRANSFER, true);
			$result = curl_exec($post);
			curl_close($post);
			$result = json_decode($result);
			
			$new_array = array();
			//while (list($key, $val) = each($result)) {
			foreach($result as $key=>$val){
				$new_array[''.$key]=$val;	
			}
			$new_store=array();
			foreach($new_array['stores'] as $s){
				$news=array();
				//while (list($key, $val) = each($s)) {
				foreach($s as $key=>$val){
				$news[''.$key]=$val;
				}
				$new_store[]=$news;
			}
			$data['stores']=$new_store;
			$data['total']=(array) $new_array['total'];
			//echo "<pre>"; 
			//print_r($data); die();
			return view('admin.view_report',$data);
		}else{
			return redirect('login');
		}
	}
	public function store_info($id, $date_from, $date_to, Request $request)
	{
		//echo Hash::make('Pal6068'); die();
		if (Session::has('login_admin') && Session::get('user_role') == 'admin'){
			$login_data = Session::get('login_admin');
     		$data['login']=$login_data;
			
			
			$user_id = Session::get('login_id');
			$data2 = array("user_id"=>Session::get('login_id'),"id"=>$id, "from"=>$date_from, "to"=>$date_to);
			$url = api_url."store_info2?id=".$id."&from=".$date_from."&to=".$date_to."&user_id=".$user_id."";
			$header = array();
			$header[] = 'Content-length: 0';
			$header[] = 'Content-type: application/json';
			$header[] = "Authorization: bearer eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJzdWIiOjQ3LCJpc3MiOiJodHRwOlwvXC9hYXJ5YWdyb3VwLnVzXC9hcGlcL3YxM1wvbG9naW4iLCJpYXQiOjE1NTMwMDEzMDcsImV4cCI6MTYxNTIwOTMwNywibmJmIjoxNTUzMDAxMzA3LCJqdGkiOiJiNmU4NzM5NjQwMzMxM2U0YjAwODkzODE2MjQ2YWY5NiJ9.hO0tSwzLhkLQhIVnKQaW1PGFkoyQkORACnD__tiQMRA";
			$post = curl_init();
			curl_setopt($post, CURLOPT_URL, $url);
			curl_setopt($post, CURLOPT_HTTPHEADER,$header);
			curl_setopt($post, CURLOPT_POST, true);
			curl_setopt($post, CURLOPT_POSTFIELDS,json_encode($data2));
			curl_setopt($post, CURLOPT_RETURNTRANSFER, true);

			$result = curl_exec($post);
			curl_close($post);
			$result = json_decode($result);
			//echo "<pre>"; print_r($result); die();
			$new_array = array();
			//while (list($key, $val) = each($result)) {
			foreach($result as $key=>$val){
				$new_array[''.$key]=$val;	
			}
			$new_store=array();
			foreach($new_array['data'] as $s){
				$news=array();
				//while (list($key, $val) = each($s)) {
				foreach($s as $key=>$val){
				$news[''.$key]=$val;
				}
				$new_store[]=$news;
			}
			$data['store'] = $new_store;
			//echo "<pre>"; print_r($new_store); die();
			return view("admin.store_info",$data);
		}else{
			return redirect('login');
		}
	}
	public function user_entry_details($id, $date, $store_id,Request $request)
	{
		if (Session::has('login_admin') && Session::get('user_role') == 'admin'){
			$login_data = Session::get('login_admin');
			$date = str_replace('/','-',$date);
			$date = date("Y-m-d",strtotime($date));
			
			$user_id = Session::get('login_id');
			$data2 = array("user_id"=>Session::get('login_id'),"id"=>$id, "date"=>$date);
			$url = api_url."user_entry_details?id=".$id."&date=".$date."&user_id=".$user_id."&store_id=".$store_id."";
			$header = array();
			$header[] = 'Content-length: 0';
			$header[] = 'Content-type: application/json';
			$header[] = "Authorization: bearer eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJzdWIiOjQ3LCJpc3MiOiJodHRwOlwvXC9hYXJ5YWdyb3VwLnVzXC9hcGlcL3YxM1wvbG9naW4iLCJpYXQiOjE1NTMwMDEzMDcsImV4cCI6MTYxNTIwOTMwNywibmJmIjoxNTUzMDAxMzA3LCJqdGkiOiJiNmU4NzM5NjQwMzMxM2U0YjAwODkzODE2MjQ2YWY5NiJ9.hO0tSwzLhkLQhIVnKQaW1PGFkoyQkORACnD__tiQMRA";
			$post = curl_init();
			curl_setopt($post, CURLOPT_URL, $url);
			curl_setopt($post, CURLOPT_HTTPHEADER,$header);
			curl_setopt($post, CURLOPT_POST, true);
			curl_setopt($post, CURLOPT_POSTFIELDS,json_encode($data2));
			curl_setopt($post, CURLOPT_RETURNTRANSFER, true);

			$result = curl_exec($post);
			curl_close($post);
			$result = json_decode($result);
			//echo "<pre>"; print_r($result); die();
			$new_array = array();
			//while (list($key, $val) = each($result)) {
			foreach($result as $key=>$val){
				$new_array[''.$key]=$val;	
			}
			$data = (array)$new_array['data'];
			$data['login']=$login_data;
			$admin = User2::where(array("id"=>Session::get('login_id')))->first();
			$data['can_edit_reports'] = $admin['can_edit_reports'];
			return view("admin.user_entry_details",$data);
		}else{
			return redirect('login');
		}
	}
	public function user_reports(Request $request)
	{
		if (Session::has('login_admin') && Session::get('user_role') == 'admin'){
			$login_data = Session::get('login_admin');
			$data['login']=$login_data;
			
			$user_data = User::where(array("id"=>Session::get('login_id')))->first();
			$store_access = $user_data['store_access'];
		
			if(!empty($store_access)){
				$data['user'] = User2::whereRaw('status=1 AND store_id IN('.$store_access.')')->get();
			}
			if(empty($store_access)){
				$data['user'] = User2::where(array("status"=>1))->get();
			}
			$user_id = Session::get('login_id');
			$id = $request->get('user');
			$shift = $request->get('shift');
			$date_from = $request->get('date_from');
			$date_to = $request->get('date_to');
			// $date_from = str_replace('/','-',$date_from);
			// $date_from = date("Y-m-d",strtotime($date_from));
			// $date_to = str_replace('/','-',$date_to);
			// $date_to = date("Y-m-d",strtotime($date_to));
			// if(empty($date_from)){
				// $data['from'] = date('d/m/Y');
			// }else{
				// $data['from'] = $request->get('date_from');
			// }
			// if(empty($date_to)){
				// $data['to'] = date('d/m/Y');
			// }else{
				// $data['to'] = $request->get('date_to');
			// }
			// if(empty($date_from)){
				// $date_from = date('Y-m-d');
			// }
			// if(empty($date_to)){
				// $date_to = date('Y-m-d');
			// }
			if(empty($date_from)){
				$data['from'] = date('m/d/Y');
				$date_from = date('Y-m-d');
			}else{
				$date_from_temp = explode('/',$date_from);
				$date_from = $date_from_temp[2]."-".$date_from_temp[0]."-".$date_from_temp[1];
				$data['from'] = $request->get('date_from');
			}
			if(empty($date_to)){
				$data['to'] = date('m/d/Y');
				$date_to = date('Y-m-d');
			}else{
				$date_to_temp = explode('/',$date_to);
				$date_to = $date_to_temp[2]."-".$date_to_temp[0]."-".$date_to_temp[1];
				$data['to'] = $request->get('date_to');
			}
			if(empty($shift)){
				$shift= "ALL";
			}
			if(empty($id)){
				$id = "0";
			}
			$data['old_user'] = $request->get('user');
			$data['send_from'] = $date_from;
			$data['send_to'] = $date_to;
			$data['shift'] = $shift;
			$data2 = array("user_id"=>Session::get('login_id'),"id"=>$id, "from"=>$date_from, "to"=>$date_to);
			$url = api_url."user_report?id=".$id."&from=".$date_from."&to=".$date_to."&user_id=".$user_id.""."&shift=".$shift."";
			$header = array();
			$header[] = 'Content-length: 0';
			$header[] = 'Content-type: application/json';
			$header[] = "Authorization: bearer eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJzdWIiOjQ3LCJpc3MiOiJodHRwOlwvXC9hYXJ5YWdyb3VwLnVzXC9hcGlcL3YxM1wvbG9naW4iLCJpYXQiOjE1NTMwMDEzMDcsImV4cCI6MTYxNTIwOTMwNywibmJmIjoxNTUzMDAxMzA3LCJqdGkiOiJiNmU4NzM5NjQwMzMxM2U0YjAwODkzODE2MjQ2YWY5NiJ9.hO0tSwzLhkLQhIVnKQaW1PGFkoyQkORACnD__tiQMRA";
			$post = curl_init();
			curl_setopt($post, CURLOPT_URL, $url);
			curl_setopt($post, CURLOPT_HTTPHEADER,$header);
			curl_setopt($post, CURLOPT_POST, true);
			curl_setopt($post, CURLOPT_POSTFIELDS,json_encode($data2));
			curl_setopt($post, CURLOPT_RETURNTRANSFER, true);

			$result = curl_exec($post);
			curl_close($post);
			$result = json_decode($result);
			$new_array = array();
			//while (list($key, $val) = each($result)) {
			foreach ($result as $key => $val) {
				$new_array[''.$key]=$val;	
			}

			$new_store=array();
			if(!empty($new_array)){
			foreach($new_array['stores'] as $s){
				$news=array();
				//while (list($key, $val) = each($s)) {
					foreach($s as $key=>$val){
				$news[''.$key]=$val;
				}
				$new_store[]=$news;
			}

			$data['stores']=$new_store;
			$data['total']=(array)$new_array['total'];
			}else{
				$data['stores']=array();
				$data['total']=array();
			}
			//echo "<pre>";
			//print_r($data); die();
			return view('admin.user_reports',$data);
		}else{
			return redirect('login');
		}
	}
	public function user_reports2(Request $request, $id, $from, $to, $shift)
	{
		if (Session::has('login_admin') && Session::get('user_role') == 'admin'){
			$login_data = Session::get('login_admin');
			$data['login']=$login_data;
			
			$user_data = User::where(array("id"=>Session::get('login_id')))->first();
			$store_access = $user_data['store_access'];
		
			if(!empty($store_access)){
				$data['user'] = User2::whereRaw('status=1 AND store_id IN('.$store_access.')')->get();
			}
			if(empty($store_access)){
				$data['user'] = User2::where(array("status"=>1))->get();
			}
			$user_id = Session::get('login_id');
			$date_from = $from;
			$date_to = $to;
			$data['from'] = $from;
			$data['to'] = $to;
			
			$data['old_user'] = $id;
			$data['send_from'] = $from;
			$data['send_to'] = $to;
			$data['shift'] = $shift;
			$data2 = array("user_id"=>Session::get('login_id'),"id"=>$id, "from"=>$date_from, "to"=>$date_to);
			$url = api_url."user_store_in_profit?id=".$id."&from=".$date_from."&to=".$date_to."&user_id=".$user_id.""."&shift=".$shift."";
			$header = array();
			$header[] = 'Content-length: 0';
			$header[] = 'Content-type: application/json';
			$header[] = "Authorization: bearer eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJzdWIiOjQ3LCJpc3MiOiJodHRwOlwvXC9hYXJ5YWdyb3VwLnVzXC9hcGlcL3YxM1wvbG9naW4iLCJpYXQiOjE1NTMwMDEzMDcsImV4cCI6MTYxNTIwOTMwNywibmJmIjoxNTUzMDAxMzA3LCJqdGkiOiJiNmU4NzM5NjQwMzMxM2U0YjAwODkzODE2MjQ2YWY5NiJ9.hO0tSwzLhkLQhIVnKQaW1PGFkoyQkORACnD__tiQMRA";
			$post = curl_init();
			curl_setopt($post, CURLOPT_URL, $url);
			curl_setopt($post, CURLOPT_HTTPHEADER,$header);
			curl_setopt($post, CURLOPT_POST, true);
			curl_setopt($post, CURLOPT_POSTFIELDS,json_encode($data2));
			curl_setopt($post, CURLOPT_RETURNTRANSFER, true);

			$result = curl_exec($post);
			curl_close($post);
			$result = json_decode($result);
			//echo "<pre>"; print_r($result); die();
			$new_array = array();
			//while (list($key, $val) = each($result)) {
			foreach($result as $key=>$val){
				$new_array[''.$key]=$val;	
			}
			$new_store=array();
			if(!empty($new_array)){
			foreach($new_array['stores'] as $s){
				$news=array();
				//while (list($key, $val) = each($s)) {
				foreach($s as $key=>$val){
				$news[''.$key]=$val;
				}
				$new_store[]=$news;
			}
			$data['stores']=$new_store;
			$data['total']=(array)$new_array['total'];
			}else{
				$data['stores']=array();
				$data['total']=array();
			}
			return view('admin.user_reports2',$data);
		}else{
			return redirect('login');
		}
	}
	public function user_report_store($user_id, $store_id, $from, $to, $shift, Request $request)
	{
		if (Session::has('login_admin') && Session::get('user_role') == 'admin'){
			$login_data = Session::get('login_admin');
     		$data['login']=$login_data;
			
			$data2 = array("user_id"=>Session::get('login_id'),"id"=>$user_id, "from"=>$from, "to"=>$to);
			$url = api_url."user_report_store?id=".$user_id."&from=".$from."&to=".$to."&user_id=".Session::get('login_id').""."&store_id=".$store_id."";
			$header = array();
			$header[] = 'Content-length: 0';
			$header[] = 'Content-type: application/json';
			$header[] = "Authorization: bearer eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJzdWIiOjQ3LCJpc3MiOiJodHRwOlwvXC9hYXJ5YWdyb3VwLnVzXC9hcGlcL3YxM1wvbG9naW4iLCJpYXQiOjE1NTMwMDEzMDcsImV4cCI6MTYxNTIwOTMwNywibmJmIjoxNTUzMDAxMzA3LCJqdGkiOiJiNmU4NzM5NjQwMzMxM2U0YjAwODkzODE2MjQ2YWY5NiJ9.hO0tSwzLhkLQhIVnKQaW1PGFkoyQkORACnD__tiQMRA";
			$post = curl_init();
			curl_setopt($post, CURLOPT_URL, $url);
			curl_setopt($post, CURLOPT_HTTPHEADER,$header);
			curl_setopt($post, CURLOPT_POST, true);
			curl_setopt($post, CURLOPT_POSTFIELDS,json_encode($data2));
			curl_setopt($post, CURLOPT_RETURNTRANSFER, true);

			$result = curl_exec($post);
			curl_close($post);
			
			$result = json_decode($result);
			$new_array = array();
			//while (list($key, $val) = each($result)) {
			foreach($result as $key=>$val){
				$new_array[''.$key]=$val;	
			}
			$new_store=array();
			foreach($new_array['data'] as $s){
				$news=array();
				//while (list($key, $val) = each($s)) {
				foreach($s as $key=>$val){
				$news[''.$key]=$val;
				}
				$new_store[]=$news;
			}
			$data['store'] = $new_store;
			
			//echo "<pre>"; print_r($result); die();
			
			return view("admin.user_report_store",$data);
		}else{
			return redirect('login');
		}
	}
	public function user_report_date_wise($id, $date, $store_id,Request $request)
	{
		if (Session::has('login_admin') && Session::get('user_role') == 'admin'){
			$login_data = Session::get('login_admin');
			$date = str_replace('/','-',$date);
			$date = date("Y-m-d",strtotime($date));
			
			$user_id = Session::get('login_id');
			$data2 = array("user_id"=>Session::get('login_id'),"id"=>$id, "date"=>$date);
			$url = api_url."user_entry_details?id=".$id."&date=".$date."&user_id=".$user_id."&store_id=".$store_id."";
			//echo $url; die();
			$header = array();
			$header[] = 'Content-length: 0';
			$header[] = 'Content-type: application/json';
			$header[] = "Authorization: bearer eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJzdWIiOjQ3LCJpc3MiOiJodHRwOlwvXC9hYXJ5YWdyb3VwLnVzXC9hcGlcL3YxM1wvbG9naW4iLCJpYXQiOjE1NTMwMDEzMDcsImV4cCI6MTYxNTIwOTMwNywibmJmIjoxNTUzMDAxMzA3LCJqdGkiOiJiNmU4NzM5NjQwMzMxM2U0YjAwODkzODE2MjQ2YWY5NiJ9.hO0tSwzLhkLQhIVnKQaW1PGFkoyQkORACnD__tiQMRA";
			$post = curl_init();
			curl_setopt($post, CURLOPT_URL, $url);
			curl_setopt($post, CURLOPT_HTTPHEADER,$header);
			curl_setopt($post, CURLOPT_POST, true);
			curl_setopt($post, CURLOPT_POSTFIELDS,json_encode($data2));
			curl_setopt($post, CURLOPT_RETURNTRANSFER, true);

			$result = curl_exec($post);
			curl_close($post);
			$result = json_decode($result);
			//echo "<pre>"; print_r($result); die();
			$new_array = array();
			//while (list($key, $val) = each($result)) {
			foreach($result as $key=>$val){
				$new_array[''.$key]=$val;	
			}
			$data = (array)$new_array['data'];
			$data['login']=$login_data;
			$admin = User2::where(array("id"=>Session::get('login_id')))->first();
			$data['can_edit_reports'] = $admin['can_edit_reports'];
			return view("admin.user_entry_details",$data);
		}else{
			return redirect('login');
		}
	}
	public function edit_sales($id)
	{
		if (Session::has('login_admin') && Session::get('user_role') == 'admin'){
			$login_data = Session::get('login_admin');
     		$data['login']=$login_data;
			
			$data['sales'] = Sales::where(array("id"=>$id))->first();
			return view("admin.edit_sales",$data);
		}else{
			return redirect('login');
		}
	}
	function update_sales($id,Request $request)
	{
		if (Session::has('login_admin') && Session::get('user_role') == 'admin'){
     		$login_data = Session::get('login_admin');
     		$data['login']=$login_data;
			$validator = Validator::make($request->all(), [
			'date' => 'required',
            'inside' => 'required|numeric',
			'beer' => 'required|numeric',
			'grocery' => 'required|numeric',
			'pizza' => 'required|numeric',
			'deli' => 'required|numeric',
			'cigarette' => 'required|numeric',
			'ebt' => 'required|numeric',
			'nontax' => 'required|numeric',
			'novelty' => 'required|numeric',
			'merchandise' => 'required|numeric',
			'tax' => 'required|numeric',
			'gas' => 'required|numeric',
			'phone_card' => 'required|numeric',
			'instant' => 'required|numeric',
			'lottery_mrg' => 'required|numeric',
			'lottery_eve' => 'required|numeric',
			'lottery_nght' => 'numeric',
			'lottery' => 'required|numeric',
			'total_sales' => 'required',
			'add_money_order' => 'required',
			'wu_amount' => 'required|numeric',
        ]);
        	
        if ($validator->fails()) {
            return redirect("admin/edit_sales/$id")
                        ->withErrors($validator,'login')
                        ->withInput();
        } else {
				//$date = str_replace('/', '-',$request->get('date'));
				$date = date('Y-m-d',strtotime($request->get('date')));
				$data1=array(
				"date"=>$date,
     	 		"inside"=>$request->get('inside'),
				"beer"=>$request->get('beer'),
				"grocery"=>$request->get('grocery'),
				"pizza"=>$request->get('pizza'),
				"deli"=>$request->get('deli'),
				"cigarette"=>$request->get('cigarette'),
				"ebt"=>$request->get('ebt'),
				"nontax"=>$request->get('nontax'),
				"novelty"=>$request->get('novelty'),
				"merchandise"=>$request->get('merchandise'),
				"meat"=>$request->get('meat'),
				"tax"=>$request->get('tax'),
				"gas"=>$request->get('gas'),
				"phone_card"=>$request->get('phone_card'),
				"instant"=>$request->get('instant'),
				"lottery_mrg"=>$request->get('lottery_mrg'),
				"lottery_eve"=>$request->get('lottery_eve'),
				"lottery_nght"=>$request->get('lottery_nght'),
				"lottery"=>$request->get('lottery'),
				"total_sales"=>$request->get('total_sales'),
				"add_money_order"=>$request->get('add_money_order'),
				"wu_amount"=>$request->get('wu_amount'),
     	 		);
     	 		$update = Sales::where(array("id"=>$id))->update($data1);
     	 		if($update) {
				Session::flash('success', 'Sales entry successfully updated');
        	   return back();
        	   }else {
        	   Session::flash('error', 'Some error. Sales entry is not updated');
        	   return redirect("admin/edit_sales/$id");
        	   	}
        }
     		return view("admin.view_report", $data);
		}else {
			 return redirect('login');	
		}
	}
	public function edit_payment($id)
	{
		if (Session::has('login_admin') && Session::get('user_role') == 'admin'){
			$login_data = Session::get('login_admin');
     		$data['login']=$login_data;
			
			$data['payment'] = Payments::where(array("id"=>$id))->first();
			return view("admin.edit_payment",$data);
		}else{
			return redirect('login');
		}
	}
	function update_payment($id,Request $request)
	{
		if (Session::has('login_admin') && Session::get('user_role') == 'admin'){
     		$login_data = Session::get('login_admin');
     		$data['login']=$login_data;
			$validator = Validator::make($request->all(), [
			'date' => 'required',
            'total_cash' => 'required|numeric',
			'total_credit' => 'required|numeric',
			'total_debit' => 'required|numeric',
			'total' => 'required|numeric',
			'lottery_out' => 'required|numeric',
			'lottery_online_cashout_mrg' => 'required|numeric',
			'lottery_online_cashout_eve' => 'required|numeric',
			'lottery_online_cashout_nght' => 'numeric',
			'lottery_online_cashout' => 'required|numeric',
			'lottery_instant_cashout_mrg' => 'required|numeric',
			'lottery_instant_cashout_eve' => 'required|numeric',
			'lottery_instant_cashout_nght' => 'numeric',
			'lottery_instant_cashout' => 'required|numeric',
			'lottery_cash' => 'required|numeric',
			'wu_pay_out' => 'required|numeric',
			'coupon' => 'required|numeric',
			'mobile_coupon' => 'required|numeric',
        ]);
        	
        if ($validator->fails()) {
            return redirect("admin/edit_payment/$id")
                        ->withErrors($validator,'login')
                        ->withInput();
        } else {
				//$date = str_replace('/', '-',$request->get('date'));
				$date = date('Y-m-d',strtotime($request->get('date')));
				$data1=array(
				"date"=>$date,
     	 		"total_cash"=>$request->get('total_cash'),
				"total_credit"=>$request->get('total_credit'),
				"total_debit"=>$request->get('total_debit'),
				"total"=>$request->get('total'),
				"lottery_out"=>$request->get('lottery_out'),
				"lottery_online_cashout_mrg" => $request->get('lottery_online_cashout_mrg'),
				"lottery_online_cashout_eve" => $request->get('lottery_online_cashout_eve'),
				"lottery_online_cashout_nght" => $request->get('lottery_online_cashout_nght'),
				"lottery_online_cashout"=>$request->get('lottery_online_cashout'),
				"lottery_instant_cashout_mrg" => $request->get('lottery_instant_cashout_mrg'),
				"lottery_instant_cashout_eve" => $request->get('lottery_instant_cashout_eve'),
				"lottery_instant_cashout_nght" => $request->get('lottery_instant_cashout_nght'),
				"lottery_instant_cashout"=>$request->get('lottery_instant_cashout'),
				"lottery_cash"=>$request->get('lottery_cash'),
				"wu_pay_out" => $request->get('wu_pay_out'),
				"coupon" => $request->get('coupon'),
				"mobile_coupon" => $request->get('mobile_coupon'),
     	 		);
     	 		$update = Payments::where(array("id"=>$id))->update($data1);
     	 		if($update) {
				Session::flash('success', 'Payment entry successfully updated');
        	   return back();
        	   }else {
        	   Session::flash('error', 'Some error. Payment entry is not updated');
        	   return redirect("admin/edit_payment/$id");
        	   	}
        }
     		return view("admin.view_report", $data);
		}else {
			 return redirect('login');	
		}
	}
	public function edit_inventory($id)
	{
		if (Session::has('login_admin') && Session::get('user_role') == 'admin'){
			$login_data = Session::get('login_admin');
     		$data['login']=$login_data;
			
			$data['items'] = Items::where(array("status"=>1))->get();
			$data['inventory'] = Inventory::where(array("id"=>$id))->first();
			return view("admin.edit_inventory",$data);
		}else{
			return redirect('login');
		}
	}
	function update_inventory($id,Request $request)
	{
		if (Session::has('login_admin') && Session::get('user_role') == 'admin'){
     		$login_data = Session::get('login_admin');
     		$data['login']=$login_data;
			if($request->get('pay_by') == "Cheque"){
				$validator = Validator::make($request->all(), [
				'date' => 'required',
				'invoice_no' => 'required',
				'item' => 'required',
				'vendor' => 'required',
				'quantity' => 'required|numeric',
				'price' => 'required|numeric',
				'total_price' => 'required|numeric',
				'cheque_no' => 'required',
				]);
			}else{
				$validator = Validator::make($request->all(), [
				'date' => 'required',
				'invoice_no' => 'required',
				'item' => 'required',
				'vendor' => 'required',
				'quantity' => 'required|numeric',
				'price' => 'required|numeric',
				'total_price' => 'required|numeric',
				]);
			}
        	
        if ($validator->fails()) {
            return redirect("admin/edit_inventory/$id")
                        ->withErrors($validator,'login')
                        ->withInput();
        } else {
				//$date = str_replace('/', '-',$request->get('date'));
				$date = date('Y-m-d',strtotime($request->get('date')));
				$data1=array(
				"date"=>$date,
     	 		"invoice_no"=>$request->get('invoice_no'),
				"item"=>$request->get('item'),
				"vendor"=>$request->get('vendor'),
				"quantity"=>$request->get('quantity'),
				"price"=>$request->get('price'),
				"total_price"=>$request->get('price'),
				"pay_by"=>$request->get('pay_by'),
     	 		);
				if($request->get('pay_by') == "Cheque"){
					$data1['cheque_no'] = $request->get('cheque_no');
				}
     	 		$update = Inventory::where(array("id"=>$id))->update($data1);
     	 		if($update) {
				Session::flash('success', 'Inventory entry successfully updated');
        	   return back();
        	   }else {
        	   Session::flash('error', 'Some error. Payment entry is not updated');
        	   return redirect("admin/edit_inventory/$id");
        	   	}
        }
     		return view("admin.view_report", $data);
		}else {
			 return redirect('login');	
		}
	}
	public function edit_atm($id)
	{
		if (Session::has('login_admin') && Session::get('user_role') == 'admin'){
			$login_data = Session::get('login_admin');
     		$data['login']=$login_data;
			
			$data['atm'] = ATM::where(array("id"=>$id))->first();
			return view("admin.edit_atm",$data);
		}else{
			return redirect('login');
		}
	}
	function update_atm($id,Request $request)
	{
		if (Session::has('login_admin') && Session::get('user_role') == 'admin'){
     		$login_data = Session::get('login_admin');
     		$data['login']=$login_data;
			$validator = Validator::make($request->all(), [
			'date' => 'required',
            'money' => 'required',
			'add_money' => 'required',
			'total_money' => 'required',
			'cash' => 'required',
			'fp' => 'required',
        ]);
        	
        if ($validator->fails()) {
            return redirect("admin/edit_atm/$id")
                        ->withErrors($validator,'login')
                        ->withInput();
        } else {
				//$date = str_replace('/', '-',$request->get('date'));
				$date = date('Y-m-d',strtotime($request->get('date')));
				$data1=array(
				"date"=>$date,
     	 		"money"=>$request->get('money'),
				"add_money"=>$request->get('add_money'),
				"total_money"=>$request->get('total_money'),
				"cash"=>$request->get('cash'),
				"fp"=>$request->get('fp'),
     	 		);
     	 		$update = ATM::where(array("id"=>$id))->update($data1);
     	 		if($update) {
				Session::flash('success', 'ATM entry successfully updated');
        	   return back();
        	   }else {
        	   Session::flash('error', 'Some error. ATM entry is not updated');
        	   return redirect("admin/edit_atm/$id");
        	   	}
        }
     		return view("admin.view_report", $data);
		}else {
			 return redirect('login');	
		}
	}
	function update_atm_cash(Request $request)
	{
		if (Session::has('login_admin') && Session::get('user_role') == 'admin'){
     		/* $login_data = Session::get('login_admin');
     		$data['login']=$login_data;
			$validator = Validator::make($request->all(), [
			'date' => 'required',
            'money' => 'required',
			'add_money' => 'required',
			'total_money' => 'required',
			'cash' => 'required',
			'fp' => 'required',
        ]);
        	
        if ($validator->fails()) {
            return redirect("admin/edit_atm/$id")
                        ->withErrors($validator,'login')
                        ->withInput();
        } else {
				//$date = str_replace('/', '-',$request->get('date'));
				$date = date('Y-m-d',strtotime($request->get('date')));
				$data1=array(
				"date"=>$date,
     	 		"money"=>$request->get('money'),
				"add_money"=>$request->get('add_money'),
				"total_money"=>$request->get('total_money'),
				"cash"=>$request->get('cash'),
				"fp"=>$request->get('fp'),
     	 		);
     	 		$update = ATM::where(array("id"=>$id))->update($data1);
     	 		if($update) {
				Session::flash('success', 'ATM entry successfully updated');
        	   return back();
        	   }else {
        	   Session::flash('error', 'Some error. ATM entry is not updated');
        	   return redirect("admin/edit_atm/$id");
        	   	}
        }
     		return view("admin.view_report", $data); */
			$alldata = $_POST;
			foreach($alldata as $key=>$value){
				$ids = explode("_",$key);
				if(isset($ids[2])){
					$id = $ids[2];
					$update = ATM::where(array("id"=>$id))->update(array("fp"=>$value));
				}
			}
			echo 'ATM entrys successfully updated';
		}else {
			 return redirect('login');	
		}
	}
	
		function update_atm_total_cash(Request $request)
	{
		if (Session::has('login_admin') && Session::get('user_role') == 'admin'){
     	
			$alldata = $_POST;
			foreach($alldata as $key=>$value){
				$ids = explode("_",$key);
				if(isset($ids[2])){
					$id = $ids[2];
					
					$update = ATM::where(array("id"=>$id))->update(array("cash"=>$value));
				}
			}
			echo 'ATM entrys successfully updated';
		}else {
			 return redirect('login');	
		}
	}
	
	public function edit_cigarette($id)
	{
		if (Session::has('login_admin') && Session::get('user_role') == 'admin'){
			$login_data = Session::get('login_admin');
     		$data['login']=$login_data;
			
			$data['cigarette'] = Cigarettes::where(array("id"=>$id))->first();
			return view("admin.edit_cigarette",$data);
		}else{
			return redirect('login');
		}
	}
	function update_cigarette($id,Request $request)
	{
		if (Session::has('login_admin') && Session::get('user_role') == 'admin'){
     		$login_data = Session::get('login_admin');
     		$data['login']=$login_data;
			$validator = Validator::make($request->all(), [
			'date' => 'required',
            'inventory' => 'required',
			'add_cigarette' => 'required',
			'sale_cigarette' => 'required',
			'available_stock' => 'required',
        ]);
        	
        if ($validator->fails()) {
            return redirect("admin/edit_cigarette/$id")
                        ->withErrors($validator,'login')
                        ->withInput();
        } else {
				//$date = str_replace('/', '-',$request->get('date'));
				$date = date('Y-m-d',strtotime($request->get('date')));
				$data1=array(
				"date"=>$date,
     	 		"inventory"=>$request->get('inventory'),
				"add_cigarette"=>$request->get('add_cigarette'),
				"sale_cigarette"=>$request->get('sale_cigarette'),
				"available_stock"=>$request->get('available_stock'),
     	 		);
     	 		$update = Cigarettes::where(array("id"=>$id))->update($data1);
     	 		if($update) {
				Session::flash('success', 'Cigarette entry successfully updated');
        	   return back();
        	   }else {
        	   Session::flash('error', 'Some error. Cigarette entry is not updated');
        	   return redirect("admin/edit_cigarette/$id");
        	   	}
        }
     		return view("admin.view_report", $data);
		}else {
			 return redirect('login');	
		}
	}
	public function edit_lottery($id)
	{
		if (Session::has('login_admin') && Session::get('user_role') == 'admin'){
			$login_data = Session::get('login_admin');
     		$data['login']=$login_data;
			
			$data['lottery'] = Lottery::where(array("id"=>$id))->first();
			return view("admin.edit_lottery",$data);
		}else{
			return redirect('login');
		}
	}
	function update_lottery($id,Request $request)
	{
		if (Session::has('login_admin') && Session::get('user_role') == 'admin'){
     		$login_data = Session::get('login_admin');
     		$data['login']=$login_data;
			$validator = Validator::make($request->all(), [
			'date' => 'required',
			'inventory' => 'required',
            'add_book' => 'required',
			'active_book' => 'required',
			'total' => 'required',
			'weekly_eft_ammount' => 'required',
			'weekly_commission' => 'required',
        ]);
        	
        if ($validator->fails()) {
            return redirect("admin/edit_lottery/$id")
                        ->withErrors($validator,'login')
                        ->withInput();
        } else {
				//$date = str_replace('/', '-',$request->get('date'));
				$date = date('Y-m-d',strtotime($request->get('date')));
				$data1=array(
				"date"=>$date,
     	 		"inventory"=>$request->get('inventory'),
				"add_book"=>$request->get('add_book'),
				"active_book"=>$request->get('active_book'),
				"total"=>$request->get('total'),
				"weekly_eft_ammount"=>$request->get('weekly_eft_ammount'),
				"weekly_commission"=>$request->get('weekly_commission'),
     	 		);
     	 		$update = Lottery::where(array("id"=>$id))->update($data1);
     	 		if($update) {
				Session::flash('success', 'Lottery entry successfully updated');
        	   return back();
        	   }else {
        	   Session::flash('error', 'Some error. Lottery entry is not updated');
        	   return redirect("admin/edit_lottery/$id");
        	   	}
        }
     		return view("admin.view_report", $data);
		}else {
			 return redirect('login');	
		}
	}
	public function edit_expense($id)
	{
		if (Session::has('login_admin') && Session::get('user_role') == 'admin'){
			$login_data = Session::get('login_admin');
     		$data['login']=$login_data;
			
			$data['items'] = ExpenseItems::where(array("status"=>1))->get();
			$data['expense'] = Expense::where(array("id"=>$id))->first();
			return view("admin.edit_expense",$data);
		}else{
			return redirect('login');
		}
	}
	function update_expense($id,Request $request)
	{
		if (Session::has('login_admin') && Session::get('user_role') == 'admin'){
     		$login_data = Session::get('login_admin');
     		$data['login']=$login_data;
			$validator = Validator::make($request->all(), [
			'item_id' => 'required',
			'title' => 'required',
            'price' => 'required',
			'date' => 'required',
        ]);
        	
        if ($validator->fails()) {
            return redirect("admin/edit_expense/$id")
                        ->withErrors($validator,'login')
                        ->withInput();
        } else {
				//$date = str_replace('/', '-',$request->get('date'));
				$date = date('Y-m-d',strtotime($request->get('date')));
				$data1=array(
				"date"=>$date,
     	 		"item_id"=>$request->get('item_id'),
				"title"=>$request->get('title'),
				"price"=>$request->get('price'),
     	 		);
     	 		$update = Expense::where(array("id"=>$id))->update($data1);
     	 		if($update) {
				Session::flash('success', 'Expense entry successfully updated');
        	   return back();
        	   }else {
        	   Session::flash('error', 'Some error. Expense entry is not updated');
        	   return redirect("admin/edit_expense/$id");
        	   	}
        }
     		return view("admin.view_report", $data);
		}else {
			 return redirect('login');	
		}
	}
	function delete_sales($id)
	{
		if (Session::has('login_admin') && Session::get('user_role') == 'admin'){
		
     		$login_data = Session::get('login_admin');
     		$data['login']=$login_data;
			
			$del = Sales::where(array("id"=>$id))->update(array("status"=>0));
			if($del){
				Session::flash('success', 'Sales entry successfully deleted');
				return back();
			}
			else{
				Session::flash('success', 'Some error. Sales entry is not deleted');
				return redirect("admin/view_report");
			}
		}else {
			 return redirect('login');	
		}
	}
	function delete_payment($id)
	{
		if (Session::has('login_admin') && Session::get('user_role') == 'admin'){
		
     		$login_data = Session::get('login_admin');
     		$data['login']=$login_data;
			
			$del = Payments::where(array("id"=>$id))->update(array("status"=>0));
			if($del){
				Session::flash('success', 'Payment entry successfully deleted');
				return back();
			}
			else{
				Session::flash('success', 'Some error. Payment entry is not deleted');
				return redirect("admin/view_report");
			}
		}else {
			 return redirect('login');	
		}
	}
	function delete_inventory($id)
	{
		if (Session::has('login_admin') && Session::get('user_role') == 'admin'){
		
     		$login_data = Session::get('login_admin');
     		$data['login']=$login_data;
			
			$del = Inventory::where(array("id"=>$id))->update(array("status"=>0));
			if($del){
				Session::flash('success', 'Inventory entry successfully deleted');
				return back();
			}
			else{
				Session::flash('success', 'Some error. Inventory entry is not deleted');
				return redirect("admin/view_report");
			}
		}else {
			 return redirect('login');	
		}
	}
	function delete_atm($id)
	{
		if (Session::has('login_admin') && Session::get('user_role') == 'admin'){
		
     		$login_data = Session::get('login_admin');
     		$data['login']=$login_data;
			
			$del = ATM::where(array("id"=>$id))->update(array("status"=>0));
			if($del){
				Session::flash('success', 'ATM entry successfully deleted');
				return back();
			}
			else{
				Session::flash('success', 'Some error. ATM entry is not deleted');
				return redirect("admin/view_report");
			}
		}else {
			 return redirect('login');	
		}
	}
	function delete_cigarette($id)
	{
		if (Session::has('login_admin') && Session::get('user_role') == 'admin'){
		
     		$login_data = Session::get('login_admin');
     		$data['login']=$login_data;
			
			$del = Cigarettes::where(array("id"=>$id))->update(array("status"=>0));
			if($del){
				Session::flash('success', 'Cigarette entry successfully deleted');
				return back();
			}
			else{
				Session::flash('success', 'Some error. Cigarette entry is not deleted');
				return redirect("admin/view_report");
			}
		}else {
			 return redirect('login');	
		}
	}
	function delete_lottery($id)
	{
		if (Session::has('login_admin') && Session::get('user_role') == 'admin'){
		
     		$login_data = Session::get('login_admin');
     		$data['login']=$login_data;
			
			$del = Lottery::where(array("id"=>$id))->update(array("status"=>0));
			if($del){
				Session::flash('success', 'Lottery entry successfully deleted');
				return back();	
			}
			else{
				Session::flash('success', 'Some error. Lottery entry is not deleted');
				return redirect("admin/view_report");
			}
		}else {
			 return redirect('login');	
		}
	}
	function delete_expense($id)
	{
		if (Session::has('login_admin') && Session::get('user_role') == 'admin'){
		
     		$login_data = Session::get('login_admin');
     		$data['login']=$login_data;
			
			$del = Expense::where(array("id"=>$id))->update(array("status"=>0));
			if($del){
				Session::flash('success', 'Expense entry successfully deleted');
				return back();	
			}
			else{
				Session::flash('success', 'Some error. Expense entry is not deleted');
				return redirect("admin/view_report");
			}
		}else {
			 return redirect('login');	
		}
	}
	public function inventory_filter(Request $request)
	{
		/* $pdf = \App::make('dompdf.wrapper');
		$pdf->loadHTML('<h1>Test</h1>');
		return $pdf->download('invoice.pdf');
		die(); */
		if (Session::has('login_admin') && Session::get('user_role') == 'admin'){
		
		$login_data = Session::get('login_admin');
     	$data['login']=$login_data;
		$user_data = User::where(array("id"=>Session::get('login_id')))->first();
		$store_access = $user_data['store_access'];
		
		if(!empty($store_access)){
			$data['stores'] = Stores::whereRaw('status=1 AND id IN('.$store_access.')')->get();
			$data['items'] = Items::where(array("status"=>1))->get();
		}
		if(empty($store_access)){
			$data['stores'] = Stores::where(array("status"=>1))->get();
			$data['items'] = Items::where(array("status"=>1))->get();
		}
		$store_id = $request->get('store_id');
		
		$item_id = $request->get('id');
		$date_from = $request->get('date_from');
		$date_to = $request->get('date_to');
		
		// $date_from = str_replace('/','-',$date_from);
		// $date_from = date("Y-m-d",strtotime($date_from));
		// $date_to = str_replace('/','-',$date_to);
		// $date_to = date("Y-m-d",strtotime($date_to));
		//echo $date_from, $date_to, $store_id, $item_id; die();
		
		// if(empty($date_from)){
			// $date_from = date('Y-m-d');
		// }
		// if(empty($date_to)){
			// $date_to = date('Y-m-d');
		// }
		if(empty($date_from)){
				$data['from'] = date('m/d/Y');
				$date_from = date('Y-m-d');
			}else{
				$date_from_temp = explode('/',$date_from);
				$date_from = $date_from_temp[2]."-".$date_from_temp[0]."-".$date_from_temp[1];
				$data['from'] = $request->get('date_from');
			}
			if(empty($date_to)){
				$data['to'] = date('m/d/Y');
				$date_to = date('Y-m-d');
			}else{
				$date_to_temp = explode('/',$date_to);
				$date_to = $date_to_temp[2]."-".$date_to_temp[0]."-".$date_to_temp[1];
				$data['to'] = $request->get('date_to');
			}
		if(empty($store_id)){
			$store_id = 0;
		}
		if(empty($item_id)){
			$item_id = 0;
		}
		if($item_id == 10){
			$data['item_id'] = 10;
		}else{
			$data['item_id'] = 0;
		}
		$user_id = Session::get('login_id');
			$data2 = array("user_id"=>Session::get('login_id'),"item_id"=>$item_id, "from"=>$date_from, "to"=>$date_to);
			$url = api_url."inventory_filter?id=".$item_id."&from=".$date_from."&to=".$date_to."&store_id=".$store_id."&user_id=".Session::get('login_id')."";
			$header = array();
			$header[] = 'Content-length: 0';
			$header[] = 'Content-type: application/json';
			$header[] = "Authorization: bearer eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJzdWIiOjQ3LCJpc3MiOiJodHRwOlwvXC9hYXJ5YWdyb3VwLnVzXC9hcGlcL3YxM1wvbG9naW4iLCJpYXQiOjE1NTMwMDEzMDcsImV4cCI6MTYxNTIwOTMwNywibmJmIjoxNTUzMDAxMzA3LCJqdGkiOiJiNmU4NzM5NjQwMzMxM2U0YjAwODkzODE2MjQ2YWY5NiJ9.hO0tSwzLhkLQhIVnKQaW1PGFkoyQkORACnD__tiQMRA";
			$post = curl_init();
			curl_setopt($post, CURLOPT_URL, $url);
			curl_setopt($post, CURLOPT_HTTPHEADER,$header);
			curl_setopt($post, CURLOPT_POST, true);
			curl_setopt($post, CURLOPT_POSTFIELDS,json_encode($data2));
			curl_setopt($post, CURLOPT_RETURNTRANSFER, true);

			$result = curl_exec($post);
			curl_close($post);
			$result = json_decode($result);
			$new_array = array();
			if(!empty($result)){
				//while (list($key, $val) = each($result)) {
					foreach($result as $key=>$val){
				$new_array[''.$key]=$val;	
			}
			$new_store=array();
			foreach($new_array['data'] as $s){
				$news=array();
				//while (list($key, $val) = each($s)) {
					foreach($s as $key=>$val){
				$news[''.$key]=$val;
				}
				$new_store[]=$news;
			}
			$data['inventory'] = $new_array['data'];
			}else{
				$data['inventory'] = array();
			}
			//echo "<pre>"; print_r($new_array); die();
			
		return view('admin.inventory_filter',$data);
     	
		}else {
			 return redirect('login');	
		}
	}
	public function inventory_filter_detail(Request $request)
	{
		if (Session::has('login_admin') && Session::get('user_role') == 'admin'){
		
		$login_data = Session::get('login_admin');
     	$data['login']=$login_data;
		$user_data = User::where(array("id"=>Session::get('login_id')))->first();
		
		$store_id = $request->get('store_id');
		$id = $request->get('id');
		$date_from = $request->get('date_from');
		$date_to = $request->get('date_to');
		$item_id = $request->get('item_id');
		
		// if(empty($date_from)){
			// $date_from = date('Y-m-d');
		// }else{
			// $date_from = str_replace('/','-',$date_from);
			// $date_from = date("Y-m-d",strtotime($date_from));
		// }
		// if(empty($date_to)){
			// $date_to = date('Y-m-d');
		// }else{
			// $date_to = str_replace('/','-',$date_to);
			// $date_to = date("Y-m-d",strtotime($date_to));
		// }
		if(empty($date_from)){
				$data['from'] = date('m/d/Y');
				$date_from = date('Y-m-d');
			}else{
				$date_from_temp = explode('-',$date_from);
				$date_from = $date_from_temp[2]."-".$date_from_temp[0]."-".$date_from_temp[1];
				$data['from'] = $request->get('date_from');
			}
			if(empty($date_to)){
				$data['to'] = date('m/d/Y');
				$date_to = date('Y-m-d');
			}else{
				$date_to_temp = explode('-',$date_to);
				$date_to = $date_to_temp[2]."-".$date_to_temp[0]."-".$date_to_temp[1];
				$data['to'] = $request->get('date_to');
			}
		if(empty($store_id)){
			$store_id = 0;
		}
		if(empty($item_id)){
			$item_id = 0;
		}
			$user_id = Session::get('login_id');
			$data2 = array("user_id"=>Session::get('login_id'),"item_id"=>$item_id, "from"=>$date_from, "to"=>$date_to);
			$url = api_url."inventory_filter_page2?id=".$item_id."&from=".$date_from."&to=".$date_to."&store_id=".$store_id."&user_id=".Session::get('login_id')."";
			
			$header = array();
			$header[] = 'Content-length: 0';
			$header[] = 'Content-type: application/json';
			$header[] = "Authorization: bearer eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJzdWIiOjQ3LCJpc3MiOiJodHRwOlwvXC9hYXJ5YWdyb3VwLnVzXC9hcGlcL3YxM1wvbG9naW4iLCJpYXQiOjE1NTMwMDEzMDcsImV4cCI6MTYxNTIwOTMwNywibmJmIjoxNTUzMDAxMzA3LCJqdGkiOiJiNmU4NzM5NjQwMzMxM2U0YjAwODkzODE2MjQ2YWY5NiJ9.hO0tSwzLhkLQhIVnKQaW1PGFkoyQkORACnD__tiQMRA";
			$post = curl_init();
			curl_setopt($post, CURLOPT_URL, $url);
			curl_setopt($post, CURLOPT_HTTPHEADER,$header);
			curl_setopt($post, CURLOPT_POST, true);
			curl_setopt($post, CURLOPT_POSTFIELDS,json_encode($data2));
			curl_setopt($post, CURLOPT_RETURNTRANSFER, true);

			$result = curl_exec($post);
			curl_close($post);
			$result = json_decode($result);
			
			$new_array = array();
			if(!empty($result)){
				//while (list($key, $val) = each($result)) {
				foreach($result as $key=>$val){
				$new_array[''.$key]=$val;	
			}
			$new_store=array();
			foreach($new_array['data'] as $s){
				$news=array();
				//while (list($key, $val) = each($s)) {
				foreach($s as $key=>$val){
				$news[''.$key]=$val;
				}
				$new_store[]=$news;
			}
			$data['inventory'] = $new_array['data'];
			}else{
				$data['inventory'] = array();
			}
			//echo "<pre>"; print_r($new_array); die();
			
		return view('admin.inventory_filter_page2',$data);
     	
		}else {
			 return redirect('login');	
		}
	}
	public function view_report_export(Request $request)
	{
		if (Session::has('login_admin') && Session::get('user_role') == 'admin'){
		
			$id = $request->get('store');
			$date_from = $request->get('date_from');
			$date_to = $request->get('date_to');
			
			// $date_from = str_replace('/','-',$date_from);
			// $date_from = date("Y-m-d",strtotime($date_from));
			// $date_to = str_replace('/','-',$date_to);
			// $date_to = date("Y-m-d",strtotime($date_to));
			if(empty($date_from)){
			}else{
				$date_from_temp = explode('/',$date_from);
				$date_from = $date_from_temp[2]."-".$date_from_temp[0]."-".$date_from_temp[1];
			}
			if(empty($date_to)){
			}else{
				$date_to_temp = explode('/',$date_to);
				$date_to = $date_to_temp[2]."-".$date_to_temp[0]."-".$date_to_temp[1];
			}
			
			$user_id = Session::get('login_id');
			$data2 = array("user_id"=>Session::get('login_id'),"id"=>$id, "from"=>$date_from, "to"=>$date_to);
			$url = api_url."store_in_profit2?id=".$id."&from=".$date_from."&to=".$date_to."&user_id=".$user_id."";
			$header = array();
			$header[] = 'Content-length: 0';
			$header[] = 'Content-type: application/json';
			$header[] = "Authorization: bearer eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJzdWIiOjQ3LCJpc3MiOiJodHRwOlwvXC9hYXJ5YWdyb3VwLnVzXC9hcGlcL3YxM1wvbG9naW4iLCJpYXQiOjE1NTMwMDEzMDcsImV4cCI6MTYxNTIwOTMwNywibmJmIjoxNTUzMDAxMzA3LCJqdGkiOiJiNmU4NzM5NjQwMzMxM2U0YjAwODkzODE2MjQ2YWY5NiJ9.hO0tSwzLhkLQhIVnKQaW1PGFkoyQkORACnD__tiQMRA";
			$post = curl_init();
			curl_setopt($post, CURLOPT_URL, $url);
			curl_setopt($post, CURLOPT_HTTPHEADER,$header);
			curl_setopt($post, CURLOPT_POST, true);
			curl_setopt($post, CURLOPT_POSTFIELDS,json_encode($data2));
			curl_setopt($post, CURLOPT_RETURNTRANSFER, true);

			$result = curl_exec($post);
			curl_close($post);
			$result = json_decode($result);
			$new_array = array();
			//while (list($key, $val) = each($result)) {
			foreach($result as $key=>$val){
				$new_array[''.$key]=$val;	
			}
			$new_store=array();
			foreach($new_array['stores'] as $s){
				$news=array();
				//while (list($key, $val) = each($s)) {
				foreach($s as $key=>$val){
				$news[''.$key]=$val;
				}
				$new_store[]=$news;
			}
			$data['stores']=$new_store;
			$data['total']=(array) $new_array['total'];
			$file = array();
			$cnt = 0;
			foreach($data['stores'] as $s){
				$file[$cnt]['store_name'] = $s['name'];
				$file[$cnt]['sales'] = $s['sales'];
				$file[$cnt]['payments'] = $s['payments'];
				$file[$cnt]['inside'] = $s['total_inside'];
				$file[$cnt]['tax'] = $s['total_tax'];
				$file[$cnt]['gas'] = $s['total_gas'];
				$file[$cnt]['phone_card'] = $s['phone_card'];
				$file[$cnt]['inventory'] = $s['inventory'];
				$file[$cnt]['atm'] = $s['atm'];
				$file[$cnt]['cigarettes'] = $s['cigarettes'];
				$file[$cnt]['expenses'] = $s['expense'];
				$file[$cnt]['lottery'] = $s['lottery'];
				$file[$cnt]['lottery_sale'] = $s['total_lottery_sale'];
				$file[$cnt]['weekly_lottery_cash'] = $s['weekly_cash_out'];
				$file[$cnt]['oversort'] = $s['oversort'];
				$file[$cnt]['weekly_eft_ammount'] = $s['weekly_eft_ammount'];
				$file[$cnt]['weekly_commission'] = $s['weekly_commission'];
				$file[$cnt]['fp'] = $s['total_fp'];
				$file[$cnt]['cash'] = $s['total_cash'];
				$cnt++;
			}
			$total_sales = 0;
			$total_payments = 0;
			$total_inside = 0;
			$total_tax = 0;
			$total_gas = 0;
			$total_phone_card = 0;
			$total_inventory = 0;
			$total_atm = 0;
			$total_cigarettes = 0;
			$total_expense = 0;
			$total_lottery = 0;
			$total_lottery_sale = 0;
			$total_weekly_cash_out = 0;
			$total_oversort = 0;
			$total_weekly_eft_ammount = 0;
			$total_weekly_commission = 0;
			$total_fp = 0;
			$total_cash = 0;
			
				$total_sales = $data['total']['total_sales'];
				$total_payments = $data['total']['total_payments'];
				$total_inside = $data['total']['total_inside'];
				$total_tax = $data['total']['total_tax'];
				$total_gas = $data['total']['total_gas'];
				$total_phone_card = $data['total']['phone_card'];
				$total_inventory = $data['total']['total_inventory'];
				$total_atm = $data['total']['total_atm'];
				$total_cigarettes = $data['total']['total_cigarettes'];
				$total_expense = $data['total']['total_expense'];
				$total_lottery = $data['total']['total_lottery'];
				$total_lottery_sale = $data['total']['total_lottery_sale'];
				$total_weekly_cash_out = $data['total']['total_weekly_cash_out'];
				$total_oversort = $data['total']['oversort'];
				$total_weekly_eft_ammount = $data['total']['total_weekly_eft_ammount'];
				$total_weekly_commission = $data['total']['total_weekly_commission'];
				$total_fp = $data['total']['total_fp'];
				$total_cash = $data['total']['total_cash'];
						
						$op = array(" "=>"Total","  "=>strval($total_sales),"   "=>strval($total_payments),"    "=>strval($total_inside),"     "=>strval($total_tax),"                                         "=>strval($total_gas),"                                                                   "=>strval($total_phone_card),"      "=>strval($total_inventory),"                                                                                             "=>strval($total_atm),"        "=>strval($total_cigarettes),"         "=>strval($total_expense),"          "=>strval($total_lottery), "           "=>strval($total_lottery_sale), "            "=>strval($total_weekly_cash_out), "             "=>strval($total_oversort), "                "=>strval($total_weekly_eft_ammount), "                  "=>strval($total_weekly_commission), "                      "=>strval($total_fp), "                           "=>strval($total_cash));
			
			$test = array("stores"=>$file,"total"=>$op);
					Excel::create('Report', function($excel) use($test) {
					$excel->sheet('Sheetname', function($sheet) use($test) {
					$sheet->fromArray($test['stores']);
					$sheet->appendRow($test['total']);
				}); })->export('xls');
		}else {
			 return redirect('login');	
		}
		
	}
	function store_info_export($id, $date_from, $date_to, Request $request)
	{
		if (Session::has('login_admin') && Session::get('user_role') == 'admin'){
		
			$user_id = Session::get('login_id');
			$data2 = array("id"=>$id, "from"=>$date_from, "to"=>$date_to);
			$url = api_url."store_info2?id=".$id."&from=".$date_from."&to=".$date_to."&user_id=".$user_id."";
			$header = array();
			$header[] = 'Content-length: 0';
			$header[] = 'Content-type: application/json';
			$header[] = "Authorization: bearer eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJzdWIiOjQ3LCJpc3MiOiJodHRwOlwvXC9hYXJ5YWdyb3VwLnVzXC9hcGlcL3YxM1wvbG9naW4iLCJpYXQiOjE1NTMwMDEzMDcsImV4cCI6MTYxNTIwOTMwNywibmJmIjoxNTUzMDAxMzA3LCJqdGkiOiJiNmU4NzM5NjQwMzMxM2U0YjAwODkzODE2MjQ2YWY5NiJ9.hO0tSwzLhkLQhIVnKQaW1PGFkoyQkORACnD__tiQMRA";
			$post = curl_init();
			curl_setopt($post, CURLOPT_URL, $url);
			curl_setopt($post, CURLOPT_HTTPHEADER,$header);
			curl_setopt($post, CURLOPT_POST, true);
			curl_setopt($post, CURLOPT_POSTFIELDS,json_encode($data2));
			curl_setopt($post, CURLOPT_RETURNTRANSFER, true);

			$result = curl_exec($post);
			curl_close($post);
			$result = json_decode($result);
			$new_array = array();
			//while (list($key, $val) = each($result)) {
			foreach($result as $key=>$val){
				$new_array[''.$key]=$val;	
			}
			$new_store=array();
			foreach($new_array['data'] as $s){
				$news=array();
				//while (list($key, $val) = each($s)) {
				foreach($s as $key=>$val){
				$news[''.$key]=$val;
				}
				$new_store[]=$news;
			}
			$file = array();
			$cnt = 0;
			
			foreach($new_store as $n){
				$file[$cnt]['date'] = $n['date'];
				$file[$cnt]['username'] = $n['user_name'];
				$file[$cnt]['store_name'] = $n['store_name'];
				$file[$cnt]['sales'] = $n['sales'];
				$file[$cnt]['payment'] = $n['payement'];
				$file[$cnt]['inside'] = $n['total_inside'];
				$file[$cnt]['tax'] = $n['total_tax'];
				$file[$cnt]['gas'] = $n['total_gas'];
				$file[$cnt]['phone_card'] = $n['phone_card'];
				$file[$cnt]['inventory'] = $n['inventory'];
				$file[$cnt]['atm'] = $n['atm'];
				$file[$cnt]['cigarettes'] = $n['cigarettes'];
				$file[$cnt]['expense'] = $n['expense'];
				$file[$cnt]['lottery'] = $n['lottery'];
				$file[$cnt]['total_lottery_sale'] = $n['total_lottery_sale'];
				$file[$cnt]['weekly_cash_out'] = $n['weekly_lottery_cash'];
				$file[$cnt]['overshort'] = $n['oversort'];
				$file[$cnt]['weekly_eft_ammount'] = $n['weekly_eft_ammount'];
				$file[$cnt]['weekly_commission'] = $n['weekly_commission'];
				$file[$cnt]['total_fp'] = $n['total_fp'];
				$file[$cnt]['total_cash'] = $n['total_cash'];
				$cnt++;
			}
		Excel::create('Report', function($excel) use($file) {
				$excel->sheet('Sheetname', function($sheet) use($file) {
					$sheet->fromArray($file);
				});
			})->export('xls');
			
		}else {
			 return redirect('login');	
		}
	}
	public function user_entry_details_export($id, $date, $store_id, Request $request)
	{
		if (Session::has('login_admin') && Session::get('user_role') == 'admin'){
			$login_data = Session::get('login_admin');
     		$data['login']=$login_data;
			
			$date = str_replace('/','-',$date);
			$date = date("Y-m-d",strtotime($date));
			
			$user_id = Session::get('login_id');
			$data2 = array("user_id"=>Session::get('login_id'),"id"=>$id, "date"=>$date);
			$url = api_url."user_entry_details?id=".$id."&date=".$date."&user_id=".$user_id."&store_id=".$store_id."";
			$header = array();
			$header[] = 'Content-length: 0';
			$header[] = 'Content-type: application/json';
			$header[] = "Authorization: bearer eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJzdWIiOjQ3LCJpc3MiOiJodHRwOlwvXC9hYXJ5YWdyb3VwLnVzXC9hcGlcL3YxM1wvbG9naW4iLCJpYXQiOjE1NTMwMDEzMDcsImV4cCI6MTYxNTIwOTMwNywibmJmIjoxNTUzMDAxMzA3LCJqdGkiOiJiNmU4NzM5NjQwMzMxM2U0YjAwODkzODE2MjQ2YWY5NiJ9.hO0tSwzLhkLQhIVnKQaW1PGFkoyQkORACnD__tiQMRA";
			$post = curl_init();
			curl_setopt($post, CURLOPT_URL, $url);
			curl_setopt($post, CURLOPT_HTTPHEADER,$header);
			curl_setopt($post, CURLOPT_POST, true);
			curl_setopt($post, CURLOPT_POSTFIELDS,json_encode($data2));
			curl_setopt($post, CURLOPT_RETURNTRANSFER, true);

			$result = curl_exec($post);
			curl_close($post);
			$result = json_decode($result);
			$new_array = array();
			//while (list($key, $val) = each($result)) {
			foreach($result as $key=>$val){
				$new_array[''.$key]=(array)$val;	
			}
			$cnt = 0;
			//echo "<pre>"; print_R($new_array); die();
			$new = array();
			foreach($new_array['data'] as $key=>$value){
				foreach($value as $v){
					$cnt = 0;
					$new[$key][$cnt] = (array)$v;
					$cnt++;
				}
			}
			//echo "<pre>"; print_R($new); die();
			if(empty($new['sales'][0])){
				$new['sales'] = array();
			}
			if(empty($new['payment'][0])){
				$new['payment'] = array();
			}
			if(empty($new['inventory'][0])){
				$new['inventory'] = array();
			}
			if(empty($new['atm'])){
				$new['atm'] = array();
			}
			if(empty($new['cigarette'][0])){
				$new['cigarette'] = array();
			}
			if(empty($new['lottery'][0])){
				$new['lottery'] = array();
			}
			if(empty($new['expense'][0])){
				$new['expense'] = array();
			}
			Excel::create('Report', function($excel) use($new) {
				$excel->sheet('Sheetname', function($sheet) use($new) {
					$sheet->fromArray($new['sales']);
					$sheet->fromArray($new['payment']);
					$sheet->fromArray($new['inventory']);
					$sheet->fromArray($new['atm']);
					$sheet->fromArray($new['cigarette']);
					$sheet->fromArray($new['lottery']);
					$sheet->fromArray($new['expense']);
				});
			})->export('xls');	
		}else{
			return redirect('login');
		}
	}
	public function inventory_filter_export(Request $request)
	{
		if (Session::has('login_admin') && Session::get('user_role') == 'admin'){
			DB::connection()->setFetchMode(\PDO::FETCH_ASSOC);
     		$login_data = Session::get('login_admin');
     		$data['login']=$login_data;
			
			if(!empty($_GET['id'])) { $item_id = $_GET['id']; }else { $item_id = 0; }
			if(!empty($_GET['store_id'])){ $store_id = $_GET['store_id']; } else{ $store_id = 0; }
			if(!empty($_GET['date_from'])){ $date_from = $_GET['date_from']; } else{ $date_from = date('m-d-Y'); }
			if(!empty($_GET['date_to'])){ $date_to = $_GET['date_to']; }else { $date_to = date('m-d-Y'); }
			
			$date_from_temp = explode('-',$date_from);
				$date_from = $date_from_temp[2]."-".$date_from_temp[0]."-".$date_from_temp[1];
			$date_to_temp = explode('-',$date_to);
				$date_to = $date_to_temp[2]."-".$date_to_temp[0]."-".$date_to_temp[1];
			//$date_from = date("Y-m-d",strtotime($date_from));
			//$date_to = date("Y-m-d",strtotime($date_to));
			
			
		//echo $item_id."  ".$store_id."  ".$date_from."  ".$date_to; die();
		$user_id = Session::get('login_id');
			$data2 = array("user_id"=>Session::get('login_id'),"item_id"=>strval($item_id), "from"=>$date_from, "to"=>$date_to);
			$url = api_url."inventory_filter?id=".$item_id."&from=".$date_from."&to=".$date_to."&store_id=".$store_id."&user_id=".Session::get('login_id')."";
			$header = array();
			$header[] = 'Content-length: 0';
			$header[] = 'Content-type: application/json';
			$header[] = "Authorization: bearer eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJzdWIiOjQ3LCJpc3MiOiJodHRwOlwvXC9hYXJ5YWdyb3VwLnVzXC9hcGlcL3YxM1wvbG9naW4iLCJpYXQiOjE1NTMwMDEzMDcsImV4cCI6MTYxNTIwOTMwNywibmJmIjoxNTUzMDAxMzA3LCJqdGkiOiJiNmU4NzM5NjQwMzMxM2U0YjAwODkzODE2MjQ2YWY5NiJ9.hO0tSwzLhkLQhIVnKQaW1PGFkoyQkORACnD__tiQMRA";
			$post = curl_init();
			curl_setopt($post, CURLOPT_URL, $url);
			curl_setopt($post, CURLOPT_HTTPHEADER,$header);
			curl_setopt($post, CURLOPT_POST, true);
			curl_setopt($post, CURLOPT_POSTFIELDS,json_encode($data2));
			curl_setopt($post, CURLOPT_RETURNTRANSFER, true);

			$result = curl_exec($post);
			curl_close($post);
			$result = json_decode($result);
			$new_array = array();
			//while (list($key, $val) = each($result)) {
			foreach($result as $key=>$val){
				$new_array[''.$key]=$val;	
			}
			$new_store=array();
			//echo "<pre>"; print_r($new_array); die();
			foreach($new_array['data'] as $s){
				$news=array();
				//while (list($key, $val) = each($s)) {
					foreach($s as $key=>$val){
				$news[''.$key]=$val;
				}
				$new_store[]=$news;
			}
			//echo "<pre>"; print_r($new_store); die();
		
				
			$cnt = 0;
			$op = array();
			foreach($new_store as $i){
				$op[$cnt]['item'] = $i['name'];
				$op[$cnt]['cash'] = $i['cash'];
				$op[$cnt]['cheque'] = $i['cheque'];
				$op[$cnt]['card'] = $i['card'];
				$op[$cnt]['total'] = $i['total'];
				$cnt++;
			}
			$total = array();
			$total_cash = 0;
			$total_cheque = 0;
			$total_card = 0;
			$grand_total = 0;
			$count = 0;
			foreach($new_store as $i){
				
				$total_cash += $i['cash'];
				$total_cheque += $i['cheque'];
				$total_card += $i['card'];
				$grand_total += $i['total'];
			}
			$temp = array("total"=>"          ","  "=>$total_cash, "   "=>$total_cheque, "     "=>$total_card, "       "=>$grand_total);
			$test = array("data"=>$op, "total"=>$temp);
			Excel::create('Inventory Report', function($excel) use($test) {
				$excel->sheet('Inventory Report', function($sheet) use($test) {
					$sheet->fromArray($test['data']);
					$sheet->appendRow($test['total']);
				});
			})->export('xls');
		}else {
			 return redirect('login');	
		}
		
	}
	public function user_reports_export(Request $request)
	{
		if (Session::has('login_admin') && Session::get('user_role') == 'admin'){
		
			$login_data = Session::get('login_admin');
			$data['login']=$login_data;
			
			$user_data = User::where(array("id"=>Session::get('login_id')))->first();
			$store_access = $user_data['store_access'];
		
			if(!empty($store_access)){
				$data['user'] = User2::whereRaw('status=1 AND store_id IN('.$store_access.')')->get();
			}
			if(empty($store_access)){
				$data['user'] = User2::where(array("status"=>1))->get();
			}
			$user_id = Session::get('login_id');
			$id = $request->get('user');
			$shift = $request->get('shift');
			$date_from = $request->get('date_from');
			$date_to = $request->get('date_to');
			// $date_from = str_replace('/','-',$date_from);
			// $date_from = date("Y-m-d",strtotime($date_from));
			// $date_to = str_replace('/','-',$date_to);
			// $date_to = date("Y-m-d",strtotime($date_to));
			// if(empty($date_from)){
				// $data['from'] = date('d/m/Y');
			// }else{
				// $data['from'] = $request->get('date_from');
			// }
			// if(empty($date_to)){
				// $data['to'] = date('d/m/Y');
			// }else{
				// $data['to'] = $request->get('date_to');
			// }
			// if(empty($date_from)){
				// $date_from = date('Y-m-d');
			// }
			// if(empty($date_to)){
				// $date_to = date('Y-m-d');
			// }
			if(empty($date_from)){
				$data['from'] = date('m/d/Y');
				$date_from = date('Y-m-d');
			}else{
				$date_from_temp = explode('/',$date_from);
				$date_from = $date_from_temp[2]."-".$date_from_temp[0]."-".$date_from_temp[1];
				$data['from'] = $request->get('date_from');
			}
			if(empty($date_to)){
				$data['to'] = date('m/d/Y');
				$date_to = date('Y-m-d');
			}else{
				$date_to_temp = explode('/',$date_to);
				$date_to = $date_to_temp[2]."-".$date_to_temp[0]."-".$date_to_temp[1];
				$data['to'] = $request->get('date_to');
			}
			if(empty($shift)){
				$shift= "ALL";
			}
			if(empty($id)){
				$id = "0";
			}
			$data['old_user'] = $request->get('user');
			$data['send_from'] = $date_from;
			$data['send_to'] = $date_to;
			$data['shift'] = $shift;
			$data2 = array("user_id"=>Session::get('login_id'),"id"=>$id, "from"=>$date_from, "to"=>$date_to);
			$url = api_url."user_report?id=".$id."&from=".$date_from."&to=".$date_to."&user_id=".$user_id.""."&shift=".$shift."";
			$header = array();
			$header[] = 'Content-length: 0';
			$header[] = 'Content-type: application/json';
			$header[] = "Authorization: bearer eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJzdWIiOjQ3LCJpc3MiOiJodHRwOlwvXC9hYXJ5YWdyb3VwLnVzXC9hcGlcL3YxM1wvbG9naW4iLCJpYXQiOjE1NTMwMDEzMDcsImV4cCI6MTYxNTIwOTMwNywibmJmIjoxNTUzMDAxMzA3LCJqdGkiOiJiNmU4NzM5NjQwMzMxM2U0YjAwODkzODE2MjQ2YWY5NiJ9.hO0tSwzLhkLQhIVnKQaW1PGFkoyQkORACnD__tiQMRA";
			$post = curl_init();
			curl_setopt($post, CURLOPT_URL, $url);
			curl_setopt($post, CURLOPT_HTTPHEADER,$header);
			curl_setopt($post, CURLOPT_POST, true);
			curl_setopt($post, CURLOPT_POSTFIELDS,json_encode($data2));
			curl_setopt($post, CURLOPT_RETURNTRANSFER, true);

			$result = curl_exec($post);
			curl_close($post);
			$result = json_decode($result);
			$new_array = array();
			//while (list($key, $val) = each($result)) {
				foreach($result as $key=>$val){
				$new_array[''.$key]=$val;	
			}
			$new_store=array();
			foreach($new_array['stores'] as $s){
				$news=array();
				//while (list($key, $val) = each($s)) {
					foreach($s as $key=>$val){
				$news[''.$key]=$val;
				}
				$new_store[]=$news;
			}
			$data['stores']=$new_store;
			$data['total']=(array) $new_array['total'];
			$file = array();
			$cnt = 0;
			foreach($data['stores'] as $s){
				$file[$cnt]['username'] = $s['name'];
				$file[$cnt]['sales'] = $s['sales'];
				$file[$cnt]['payments'] = $s['payments'];
				$file[$cnt]['inside'] = $s['total_inside'];
				$file[$cnt]['tax'] = $s['total_tax'];
				$file[$cnt]['gas'] = $s['total_gas'];
				$file[$cnt]['phone_card'] = $s['phone_card'];
				$file[$cnt]['inventory'] = $s['inventory'];
				$file[$cnt]['atm'] = $s['atm'];
				$file[$cnt]['cigarettes'] = $s['cigarettes'];
				$file[$cnt]['expenses'] = $s['expense'];
				$file[$cnt]['lottery'] = $s['lottery'];
				$file[$cnt]['lottery_sale'] = $s['total_lottery_sale'];
				$file[$cnt]['weekly_lottery_cash'] = $s['weekly_cash_out'];
				$file[$cnt]['oversort'] = $s['oversort'];
				$file[$cnt]['weekly_eft_ammount'] = $s['weekly_eft_ammount'];
				$file[$cnt]['weekly_commission'] = $s['weekly_commission'];
				$file[$cnt]['fp'] = $s['total_fp'];
				$file[$cnt]['cash'] = $s['total_cash'];
				$cnt++;
			}
			$total_sales = 0;
			$total_payments = 0;
			$total_inside = 0;
			$total_tax = 0;
			$total_gas = 0;
			$total_phone_card = 0;
			$total_inventory = 0;
			$total_atm = 0;
			$total_cigarettes = 0;
			$total_expense = 0;
			$total_lottery = 0;
			$total_lottery_sale = 0;
			$total_weekly_cash_out = 0;
			$total_oversort = 0;
			$total_weekly_eft_ammount = 0;
			$total_weekly_commission = 0;
			$total_fp = 0;
			$total_cash = 0;
			
				$total_sales = $data['total']['total_sales'];
				$total_payments = $data['total']['total_payments'];
				$total_inside = $data['total']['total_inside'];
				$total_tax = $data['total']['total_tax'];
				$total_gas = $data['total']['total_gas'];
				$total_phone_card = $data['total']['phone_card'];
				$total_inventory = $data['total']['total_inventory'];
				$total_atm = $data['total']['total_atm'];
				$total_cigarettes = $data['total']['total_cigarettes'];
				$total_expense = $data['total']['total_expense'];
				$total_lottery = $data['total']['total_lottery'];
				$total_lottery_sale = $data['total']['total_lottery_sale'];
				$total_weekly_cash_out = $data['total']['total_weekly_cash_out'];
				$total_oversort = $data['total']['oversort'];
				$total_weekly_eft_ammount = $data['total']['total_weekly_eft_ammount'];
				$total_weekly_commission = $data['total']['total_weekly_commission'];
				$total_fp = $data['total']['total_fp'];
				$total_cash = $data['total']['total_cash'];
						
						$op = array(" "=>"Total","  "=>strval($total_sales),"   "=>strval($total_payments),"    "=>strval($total_inside),"     "=>strval($total_tax),"                                         "=>strval($total_gas),"                                                                   "=>strval($total_phone_card),"      "=>strval($total_inventory),"                                                                                             "=>strval($total_atm),"        "=>strval($total_cigarettes),"         "=>strval($total_expense),"          "=>strval($total_lottery), "           "=>strval($total_lottery_sale), "            "=>strval($total_weekly_cash_out), "             "=>strval($total_oversort), "                "=>strval($total_weekly_eft_ammount), "                  "=>strval($total_weekly_commission), "                      "=>strval($total_fp), "                           "=>strval($total_cash));
			
			$test = array("stores"=>$file,"total"=>$op);
					Excel::create('Report', function($excel) use($test) {
					$excel->sheet('Sheetname', function($sheet) use($test) {
					$sheet->fromArray($test['stores']);
					$sheet->appendRow($test['total']);
				}); })->export('xls');
		}else {
			 return redirect('login');	
		}
		
	}
	public function user_reports_export2(Request $request, $id, $from, $to, $shift)
	{
		if (Session::has('login_admin') && Session::get('user_role') == 'admin'){
			$login_data = Session::get('login_admin');
			$data['login']=$login_data;
			
			$user_data = User::where(array("id"=>Session::get('login_id')))->first();
			$store_access = $user_data['store_access'];
		
			if(!empty($store_access)){
				$data['user'] = User2::whereRaw('status=1 AND store_id IN('.$store_access.')')->get();
			}
			if(empty($store_access)){
				$data['user'] = User2::where(array("status"=>1))->get();
			}
			$user_id = Session::get('login_id');
			$date_from = $from;
			$date_to = $to;
			$data['from'] = $from;
			$data['to'] = $to;
			
			$data['old_user'] = $id;
			$data['send_from'] = $from;
			$data['send_to'] = $to;
			$data['shift'] = $shift;
			$data2 = array("user_id"=>Session::get('login_id'),"id"=>$id, "from"=>$date_from, "to"=>$date_to);
			$url = api_url."user_store_in_profit?id=".$id."&from=".$date_from."&to=".$date_to."&user_id=".$user_id.""."&shift=".$shift."";
			$header = array();
			$header[] = 'Content-length: 0';
			$header[] = 'Content-type: application/json';
			$header[] = "Authorization: bearer eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJzdWIiOjQ3LCJpc3MiOiJodHRwOlwvXC9hYXJ5YWdyb3VwLnVzXC9hcGlcL3YxM1wvbG9naW4iLCJpYXQiOjE1NTMwMDEzMDcsImV4cCI6MTYxNTIwOTMwNywibmJmIjoxNTUzMDAxMzA3LCJqdGkiOiJiNmU4NzM5NjQwMzMxM2U0YjAwODkzODE2MjQ2YWY5NiJ9.hO0tSwzLhkLQhIVnKQaW1PGFkoyQkORACnD__tiQMRA";
			$post = curl_init();
			curl_setopt($post, CURLOPT_URL, $url);
			curl_setopt($post, CURLOPT_HTTPHEADER,$header);
			curl_setopt($post, CURLOPT_POST, true);
			curl_setopt($post, CURLOPT_POSTFIELDS,json_encode($data2));
			curl_setopt($post, CURLOPT_RETURNTRANSFER, true);

			$result = curl_exec($post);
			curl_close($post);
			$result = json_decode($result);
			$new_array = array();
			//while (list($key, $val) = each($result)) {
			foreach($result as $key=>$val){
				$new_array[''.$key]=$val;	
			}
			$new_store=array();
			foreach($new_array['stores'] as $s){
				$news=array();
				//while (list($key, $val) = each($s)) {
				foreach($s as $key=>$val){
				$news[''.$key]=$val;
				}
				$new_store[]=$news;
			}
			$data['stores']=$new_store;
			$data['total']=(array) $new_array['total'];
			$file = array();
			$cnt = 0;
			foreach($data['stores'] as $s){
				$file[$cnt]['store_name'] = $s['name'];
				$file[$cnt]['sales'] = $s['sales'];
				$file[$cnt]['payments'] = $s['payments'];
				$file[$cnt]['inside'] = $s['total_inside'];
				$file[$cnt]['tax'] = $s['total_tax'];
				$file[$cnt]['gas'] = $s['total_gas'];
				$file[$cnt]['phone_card'] = $s['phone_card'];
				$file[$cnt]['inventory'] = $s['inventory'];
				$file[$cnt]['atm'] = $s['atm'];
				$file[$cnt]['cigarettes'] = $s['cigarettes'];
				$file[$cnt]['expenses'] = $s['expense'];
				$file[$cnt]['lottery'] = $s['lottery'];
				$file[$cnt]['lottery_sale'] = $s['total_lottery_sale'];
				$file[$cnt]['weekly_lottery_cash'] = $s['weekly_cash_out'];
				$file[$cnt]['oversort'] = $s['oversort'];
				$file[$cnt]['weekly_eft_ammount'] = $s['weekly_eft_ammount'];
				$file[$cnt]['weekly_commission'] = $s['weekly_commission'];
				$file[$cnt]['fp'] = $s['total_fp'];
				$file[$cnt]['cash'] = $s['total_cash'];
				$cnt++;
			}
			$total_sales = 0;
			$total_payments = 0;
			$total_inside = 0;
			$total_tax = 0;
			$total_gas = 0;
			$total_phone_card = 0;
			$total_inventory = 0;
			$total_atm = 0;
			$total_cigarettes = 0;
			$total_expense = 0;
			$total_lottery = 0;
			$total_lottery_sale = 0;
			$total_weekly_cash_out = 0;
			$total_oversort = 0;
			$total_weekly_eft_ammount = 0;
			$total_weekly_commission = 0;
			$total_fp = 0;
			$total_cash = 0;
			
				$total_sales = $data['total']['total_sales'];
				$total_payments = $data['total']['total_payments'];
				$total_inside = $data['total']['total_inside'];
				$total_tax = $data['total']['total_tax'];
				$total_gas = $data['total']['total_gas'];
				$total_phone_card = $data['total']['phone_card'];
				$total_inventory = $data['total']['total_inventory'];
				$total_atm = $data['total']['total_atm'];
				$total_cigarettes = $data['total']['total_cigarettes'];
				$total_expense = $data['total']['total_expense'];
				$total_lottery = $data['total']['total_lottery'];
				$total_lottery_sale = $data['total']['total_lottery_sale'];
				$total_weekly_cash_out = $data['total']['total_weekly_cash_out'];
				$total_oversort = $data['total']['oversort'];
				$total_weekly_eft_ammount = $data['total']['total_weekly_eft_ammount'];
				$total_weekly_commission = $data['total']['total_weekly_commission'];
				$total_fp = $data['total']['total_fp'];
				$total_cash = $data['total']['total_cash'];
						
						$op = array(" "=>"Total","  "=>strval($total_sales),"   "=>strval($total_payments),"    "=>strval($total_inside),"     "=>strval($total_tax),"                                         "=>strval($total_gas),"                                                                   "=>strval($total_phone_card),"      "=>strval($total_inventory),"                                                                                             "=>strval($total_atm),"        "=>strval($total_cigarettes),"         "=>strval($total_expense),"          "=>strval($total_lottery), "           "=>strval($total_lottery_sale), "            "=>strval($total_weekly_cash_out), "             "=>strval($total_oversort), "                "=>strval($total_weekly_eft_ammount), "                  "=>strval($total_weekly_commission), "                      "=>strval($total_fp), "                           "=>strval($total_cash));
			
			$test = array("stores"=>$file,"total"=>$op);
					Excel::create('Report', function($excel) use($test) {
					$excel->sheet('Sheetname', function($sheet) use($test) {
					$sheet->fromArray($test['stores']);
					$sheet->appendRow($test['total']);
				}); })->export('xls');
		}else{
			return redirect('login');
		}
	}
	public function user_report_store_export($user_id, $store_id, $from, $to, $shift, Request $request)
	{
		if (Session::has('login_admin') && Session::get('user_role') == 'admin'){
			$login_data = Session::get('login_admin');
     		$data['login']=$login_data;
			
			$data2 = array("user_id"=>Session::get('login_id'),"id"=>$user_id, "from"=>$from, "to"=>$to);
			$url = api_url."user_report_store?id=".$user_id."&from=".$from."&to=".$to."&user_id=".Session::get('login_id').""."&store_id=".$store_id."";
			$header = array();
			$header[] = 'Content-length: 0';
			$header[] = 'Content-type: application/json';
			$header[] = "Authorization: bearer eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJzdWIiOjQ3LCJpc3MiOiJodHRwOlwvXC9hYXJ5YWdyb3VwLnVzXC9hcGlcL3YxM1wvbG9naW4iLCJpYXQiOjE1NTMwMDEzMDcsImV4cCI6MTYxNTIwOTMwNywibmJmIjoxNTUzMDAxMzA3LCJqdGkiOiJiNmU4NzM5NjQwMzMxM2U0YjAwODkzODE2MjQ2YWY5NiJ9.hO0tSwzLhkLQhIVnKQaW1PGFkoyQkORACnD__tiQMRA";
			$post = curl_init();
			curl_setopt($post, CURLOPT_URL, $url);
			curl_setopt($post, CURLOPT_HTTPHEADER,$header);
			curl_setopt($post, CURLOPT_POST, true);
			curl_setopt($post, CURLOPT_POSTFIELDS,json_encode($data2));
			curl_setopt($post, CURLOPT_RETURNTRANSFER, true);

			$result = curl_exec($post);
			curl_close($post);
			
			$result = json_decode($result);
			$new_array = array();
			//while (list($key, $val) = each($result)) {
			foreach($result as $key=>$val){
				$new_array[''.$key]=$val;	
			}
			$new_store=array();
			foreach($new_array['data'] as $s){
				$news=array();
				//while (list($key, $val) = each($s)) {
				foreach($s as $key=>$val){
				$news[''.$key]=$val;
				}
				$new_store[]=$news;
			}
			$file = array();
			$cnt = 0;
			
			foreach($new_store as $n){
				$file[$cnt]['date'] = $n['date'];
				$file[$cnt]['username'] = $n['user_name'];
				$file[$cnt]['store_name'] = $n['store_name'];
				$file[$cnt]['sales'] = $n['sales'];
				$file[$cnt]['payment'] = $n['payement'];
				$file[$cnt]['inside'] = $n['total_inside'];
				$file[$cnt]['tax'] = $n['total_tax'];
				$file[$cnt]['gas'] = $n['total_gas'];
				$file[$cnt]['phone_card'] = $n['phone_card'];
				$file[$cnt]['inventory'] = $n['inventory'];
				$file[$cnt]['atm'] = $n['atm'];
				$file[$cnt]['cigarettes'] = $n['cigarettes'];
				$file[$cnt]['expense'] = $n['expense'];
				$file[$cnt]['lottery'] = $n['lottery'];
				$file[$cnt]['total_lottery_sale'] = $n['total_lottery_sale'];
				$file[$cnt]['weekly_cash_out'] = $n['weekly_lottery_cash'];
				$file[$cnt]['overshort'] = $n['oversort'];
				$file[$cnt]['weekly_eft_ammount'] = $n['weekly_eft_ammount'];
				$file[$cnt]['weekly_commission'] = $n['weekly_commission'];
				$file[$cnt]['total_fp'] = $n['total_fp'];
				$file[$cnt]['total_cash'] = $n['total_cash'];
				$cnt++;
			}
		Excel::create('Report', function($excel) use($file) {
				$excel->sheet('Sheetname', function($sheet) use($file) {
					$sheet->fromArray($file);
				});
			})->export('xls');
			
		}else{
			return redirect('login');
		}
	}
	public function user_report_date_wise_export($id, $date, $store_id,Request $request)
	{
		if (Session::has('login_admin') && Session::get('user_role') == 'admin'){
			$login_data = Session::get('login_admin');
			$date = str_replace('/','-',$date);
			$date = date("Y-m-d",strtotime($date));
			
			$user_id = Session::get('login_id');
			$data2 = array("user_id"=>Session::get('login_id'),"id"=>$id, "date"=>$date);
			$url = api_url."user_entry_details?id=".$id."&date=".$date."&user_id=".$user_id."&store_id=".$store_id."";
			//echo $url; die();
			$header = array();
			$header[] = 'Content-length: 0';
			$header[] = 'Content-type: application/json';
			$header[] = "Authorization: bearer eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJzdWIiOjQ3LCJpc3MiOiJodHRwOlwvXC9hYXJ5YWdyb3VwLnVzXC9hcGlcL3YxM1wvbG9naW4iLCJpYXQiOjE1NTMwMDEzMDcsImV4cCI6MTYxNTIwOTMwNywibmJmIjoxNTUzMDAxMzA3LCJqdGkiOiJiNmU4NzM5NjQwMzMxM2U0YjAwODkzODE2MjQ2YWY5NiJ9.hO0tSwzLhkLQhIVnKQaW1PGFkoyQkORACnD__tiQMRA";
			$post = curl_init();
			curl_setopt($post, CURLOPT_URL, $url);
			curl_setopt($post, CURLOPT_HTTPHEADER,$header);
			curl_setopt($post, CURLOPT_POST, true);
			curl_setopt($post, CURLOPT_POSTFIELDS,json_encode($data2));
			curl_setopt($post, CURLOPT_RETURNTRANSFER, true);

			$result = curl_exec($post);
			curl_close($post);
			$result = json_decode($result);
			$new_array = array();
			//while (list($key, $val) = each($result)) {
			foreach($result as $key=>$val){
				$new_array[''.$key]=(array)$val;	
			}
			$cnt = 0;
			//echo "<pre>"; print_R($new_array); die();
			$new = array();
			foreach($new_array['data'] as $key=>$value){
				foreach($value as $v){
					$cnt = 0;
					$new[$key][$cnt] = (array)$v;
					$cnt++;
				}
			}
			//echo "<pre>"; print_R($new); die();
			if(empty($new['sales'][0])){
				$new['sales'] = array();
			}
			if(empty($new['payment'][0])){
				$new['payment'] = array();
			}
			if(empty($new['inventory'][0])){
				$new['inventory'] = array();
			}
			if(empty($new['atm'])){
				$new['atm'] = array();
			}
			if(empty($new['cigarette'][0])){
				$new['cigarette'] = array();
			}
			if(empty($new['lottery'][0])){
				$new['lottery'] = array();
			}
			if(empty($new['expense'][0])){
				$new['expense'] = array();
			}
			Excel::create('Report', function($excel) use($new) {
				$excel->sheet('Sheetname', function($sheet) use($new) {
					$sheet->fromArray($new['sales']);
					$sheet->fromArray($new['payment']);
					$sheet->fromArray($new['inventory']);
					$sheet->fromArray($new['atm']);
					$sheet->fromArray($new['cigarette']);
					$sheet->fromArray($new['lottery']);
					$sheet->fromArray($new['expense']);
				});
			})->export('xls');
			
		}else{
			return redirect('login');
		}
	}
	public function inventory_filter_detail_export(Request $request)
	{
		if (Session::has('login_admin') && Session::get('user_role') == 'admin'){
		
		$login_data = Session::get('login_admin');
     	$data['login']=$login_data;
		$user_data = User::where(array("id"=>Session::get('login_id')))->first();
		
		$store_id = $request->get('store_id');
		$id = $request->get('id');
		$date_from = $request->get('date_from');
		$date_to = $request->get('date_to');
		$item_id = $request->get('item_id');
		
		// if(empty($date_from)){
			// $date_from = date('Y-m-d');
		// }else{
			// $date_from = str_replace('/','-',$date_from);
			// $date_from = date("Y-m-d",strtotime($date_from));
		// }
		// if(empty($date_to)){
			// $date_to = date('Y-m-d');
		// }else{
			// $date_to = str_replace('/','-',$date_to);
			// $date_to = date("Y-m-d",strtotime($date_to));
		// }
		if(empty($date_from)){
				$data['from'] = date('m/d/Y');
				$date_from = date('Y-m-d');
			}else{
				$date_from_temp = explode('-',$date_from);
				$date_from = $date_from_temp[2]."-".$date_from_temp[0]."-".$date_from_temp[1];
				$data['from'] = $request->get('date_from');
			}
			if(empty($date_to)){
				$data['to'] = date('m/d/Y');
				$date_to = date('Y-m-d');
			}else{
				$date_to_temp = explode('-',$date_to);
				$date_to = $date_to_temp[2]."-".$date_to_temp[0]."-".$date_to_temp[1];
				$data['to'] = $request->get('date_to');
			}
		if(empty($store_id)){
			$store_id = 0;
		}
		if(empty($item_id)){
			$item_id = 0;
		}
			$user_id = Session::get('login_id');
			$data2 = array("user_id"=>Session::get('login_id'),"item_id"=>$item_id, "from"=>$date_from, "to"=>$date_to);
			$url = api_url."inventory_filter_page2?id=".$item_id."&from=".$date_from."&to=".$date_to."&store_id=".$store_id."&user_id=".Session::get('login_id')."";
			
			$header = array();
			$header[] = 'Content-length: 0';
			$header[] = 'Content-type: application/json';
			$header[] = "Authorization: bearer eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJzdWIiOjQ3LCJpc3MiOiJodHRwOlwvXC9hYXJ5YWdyb3VwLnVzXC9hcGlcL3YxM1wvbG9naW4iLCJpYXQiOjE1NTMwMDEzMDcsImV4cCI6MTYxNTIwOTMwNywibmJmIjoxNTUzMDAxMzA3LCJqdGkiOiJiNmU4NzM5NjQwMzMxM2U0YjAwODkzODE2MjQ2YWY5NiJ9.hO0tSwzLhkLQhIVnKQaW1PGFkoyQkORACnD__tiQMRA";
			$post = curl_init();
			curl_setopt($post, CURLOPT_URL, $url);
			curl_setopt($post, CURLOPT_HTTPHEADER,$header);
			curl_setopt($post, CURLOPT_POST, true);
			curl_setopt($post, CURLOPT_POSTFIELDS,json_encode($data2));
			curl_setopt($post, CURLOPT_RETURNTRANSFER, true);

			$result = curl_exec($post);
			curl_close($post);
			$result = json_decode($result);
			
			$new_array = array();
			if(!empty($result)){
				//while (list($key, $val) = each($result)) {
				foreach($result as $key=>$val){
				$new_array[''.$key]=$val;	
			}
			}
			$new_store=array();
			foreach($new_array['data'] as $s){
				$news=array();
				//while (list($key, $val) = each($s)) {
				foreach($r as $key=>$val){
				$news[''.$key]=$val;
				}
				$new_store[]=$news;
			}
			//echo "<pre>"; print_r($new_array); die();
			$cnt = 0;
			$op = array();
			foreach($new_store as $i){
				$op[$cnt]['store_name'] = $i['store_name'];
				$op[$cnt]['item_name'] = $i['item_name'];
				$op[$cnt]['quantity'] = $i['quantity'];
				$op[$cnt]['price'] = $i['price'];
				$op[$cnt]['type'] = $i['pay_by'];
				$op[$cnt]['vendor'] = $i['vendor'];
				$op[$cnt]['date'] = date('m/d/Y',strtotime($i['idate']));
				$op[$cnt]['cheque_no'] = $i['cheque_no'];
				$cnt++;
			}
			Excel::create('Report', function($excel) use($op) {
				$excel->sheet('Sheetname', function($sheet) use($op) {
					$sheet->fromArray($op);
				});
			})->export('xls');
     	
		
		}else {
			 return redirect('login');	
		}
	}
	public function western_union_reports(Request $request)
	{
		if (Session::has('login_admin') && Session::get('user_role') == 'admin'){
		
			$login_data = Session::get('login_admin');
			$data['login']=$login_data;
			
			$user_data = User::where(array("id"=>Session::get('login_id')))->first();
			$store_access = $user_data['store_access'];
		
			if(!empty($store_access)){
				$data['store'] = Stores::whereRaw('status=1 AND id IN('.$store_access.')')->get();
			}
			if(empty($store_access)){
				$data['store'] = Stores::where(array("status"=>1))->get();
			}
			$id = $request->get('store');
			$login_id = Session::get('login_id');
			$date_from = $request->get('date_from');
			$date_to = $request->get('date_to');
			// $date_from = str_replace('/','-',$date_from);
			// $date_from = date("Y-m-d",strtotime($date_from));
			// $date_to = str_replace('/','-',$date_to);
			// $date_to = date("Y-m-d",strtotime($date_to));
			// if(empty($date_from)){
				// $data['from'] = date('d/m/Y');
			// }else{
				// $data['from'] = $request->get('date_from');
			// }
			// if(empty($date_to)){
				// $data['to'] = date('d/m/Y');
			// }else{
				// $data['to'] = $request->get('date_to');
			// }
			// if(empty($date_from)){
				// $date_from = date('Y-m-d');
			// }
			// if(empty($date_to)){
				// $date_to = date('Y-m-d');
			// }
			
			if(empty($date_from)){
				$data['from'] = date('m/d/Y');
				$date_from = date('Y-m-d');
			}else{
				$date_from_temp = explode('/',$date_from);
				$date_from = $date_from_temp[2]."-".$date_from_temp[0]."-".$date_from_temp[1];
				$data['from'] = $request->get('date_from');
			}
			if(empty($date_to)){
				$data['to'] = date('m/d/Y');
				$date_to = date('Y-m-d');
			}else{
				$date_to_temp = explode('/',$date_to);
				$date_to = $date_to_temp[2]."-".$date_to_temp[0]."-".$date_to_temp[1];
				$data['to'] = $request->get('date_to');
			}
			
			$data['old_store'] = $request->get('store');
			$data['send_from'] = $date_from;
			$data['send_to'] = $date_to;
			$user_id = Session::get('login_id');
			$data2 = array("user_id"=>Session::get('login_id'),"store_id"=>$id, "from"=>$date_from, "to"=>$date_to);
			$url = api_url."western_union_report?store_id=".$id."&from=".$date_from."&to=".$date_to."&user_id=".$user_id."";
			$header = array();
			$header[] = 'Content-length: 0';
			$header[] = 'Content-type: application/json';
			$header[] = "Authorization: bearer eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJzdWIiOjQ3LCJpc3MiOiJodHRwOlwvXC9hYXJ5YWdyb3VwLnVzXC9hcGlcL3YxM1wvbG9naW4iLCJpYXQiOjE1NTMwMDEzMDcsImV4cCI6MTYxNTIwOTMwNywibmJmIjoxNTUzMDAxMzA3LCJqdGkiOiJiNmU4NzM5NjQwMzMxM2U0YjAwODkzODE2MjQ2YWY5NiJ9.hO0tSwzLhkLQhIVnKQaW1PGFkoyQkORACnD__tiQMRA";
			$post = curl_init();
			curl_setopt($post, CURLOPT_URL, $url);
			curl_setopt($post, CURLOPT_HTTPHEADER,$header);
			curl_setopt($post, CURLOPT_POST, true);
			curl_setopt($post, CURLOPT_POSTFIELDS,json_encode($data2));
			curl_setopt($post, CURLOPT_RETURNTRANSFER, true);

			$result = curl_exec($post);
			curl_close($post);
			$result = json_decode($result);
			$result = (array) $result;
			$new_array = array();
			if($result['status'] == 1){
				//while (list($key, $val) = each($result)) {
				foreach($result as $key=>$val){
				$new_array[''.$key]=$val;	
			}
			
			$new_store=array();
			$new_array['data'] = (array)$new_array['data'];
			foreach($new_array['data'] as $s){
				$news=array();
				//while (list($key, $val) = each($s)) {
				foreach($s as $key=>$val){
				$news[''.$key]=$val;
				}
				$new_store[]=$news;
			}
			$data['stores']=$new_store;
			$data['total']=(array) $new_array['total'];
			}else{
				$data['stores'] = array();
				$data['total']['total_in'] = 0;
				$data['total']['total_out'] = 0;
				$data['total']['total'] = 0;
			}
			//echo "<pre>"; 
			//print_r($data['total']); die();
			return view('admin.western_union_report',$data);
		
		}else {
			 return redirect('login');	
		}
	}
	public function western_union_reports_export(Request $request)
	{
		if (Session::has('login_admin') && Session::get('user_role') == 'admin'){
		
			$login_data = Session::get('login_admin');
			$data['login']=$login_data;
			
			$user_data = User::where(array("id"=>Session::get('login_id')))->first();
			$store_access = $user_data['store_access'];
		
			if(!empty($store_access)){
				$data['store'] = Stores::whereRaw('status=1 AND id IN('.$store_access.')')->get();
			}
			if(empty($store_access)){
				$data['store'] = Stores::where(array("status"=>1))->get();
			}
			$id = $request->get('store');
			$login_id = Session::get('login_id');
			$date_from = $request->get('date_from');
			$date_to = $request->get('date_to');
			// $date_from = str_replace('/','-',$date_from);
			// $date_from = date("Y-m-d",strtotime($date_from));
			// $date_to = str_replace('/','-',$date_to);
			// $date_to = date("Y-m-d",strtotime($date_to));
			// if(empty($date_from)){
				// $data['from'] = date('d/m/Y');
			// }else{
				// $data['from'] = $request->get('date_from');
			// }
			// if(empty($date_to)){
				// $data['to'] = date('d/m/Y');
			// }else{
				// $data['to'] = $request->get('date_to');
			// }
			// if(empty($date_from)){
				// $date_from = date('Y-m-d');
			// }
			// if(empty($date_to)){
				// $date_to = date('Y-m-d');
			// }
			if(empty($date_from)){
				$data['from'] = date('m/d/Y');
				$date_from = date('Y-m-d');
			}else{
				$date_from_temp = explode('/',$date_from);
				$date_from = $date_from_temp[2]."-".$date_from_temp[0]."-".$date_from_temp[1];
				$data['from'] = $request->get('date_from');
			}
			if(empty($date_to)){
				$data['to'] = date('m/d/Y');
				$date_to = date('Y-m-d');
			}else{
				$date_to_temp = explode('/',$date_to);
				$date_to = $date_to_temp[2]."-".$date_to_temp[0]."-".$date_to_temp[1];
				$data['to'] = $request->get('date_to');
			}
			$data['old_store'] = $request->get('store');
			$data['send_from'] = $date_from;
			$data['send_to'] = $date_to;
			$user_id = Session::get('login_id');
			$data2 = array("user_id"=>Session::get('login_id'),"store_id"=>$id, "from"=>$date_from, "to"=>$date_to);
			$url = api_url."western_union_report?store_id=".$id."&from=".$date_from."&to=".$date_to."&user_id=".$user_id."";
			$header = array();
			$header[] = 'Content-length: 0';
			$header[] = 'Content-type: application/json';
			$header[] = "Authorization: bearer eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJzdWIiOjQ3LCJpc3MiOiJodHRwOlwvXC9hYXJ5YWdyb3VwLnVzXC9hcGlcL3YxM1wvbG9naW4iLCJpYXQiOjE1NTMwMDEzMDcsImV4cCI6MTYxNTIwOTMwNywibmJmIjoxNTUzMDAxMzA3LCJqdGkiOiJiNmU4NzM5NjQwMzMxM2U0YjAwODkzODE2MjQ2YWY5NiJ9.hO0tSwzLhkLQhIVnKQaW1PGFkoyQkORACnD__tiQMRA";
			$post = curl_init();
			curl_setopt($post, CURLOPT_URL, $url);
			curl_setopt($post, CURLOPT_HTTPHEADER,$header);
			curl_setopt($post, CURLOPT_POST, true);
			curl_setopt($post, CURLOPT_POSTFIELDS,json_encode($data2));
			curl_setopt($post, CURLOPT_RETURNTRANSFER, true);

			$result = curl_exec($post);
			curl_close($post);
			$result = json_decode($result);
			$result = (array) $result;
			$new_array = array();
			if($result['status'] == 1){
				//while (list($key, $val) = each($result)) {
				foreach($result as $key=>$val){
				$new_array[''.$key]=$val;	
			}
			
			$new_store=array();
			$new_array['data'] = (array)$new_array['data'];
			foreach($new_array['data'] as $s){
				$news=array();
				//while (list($key, $val) = each($s)) {
				foreach($s as $key=>$val){
				$news[''.$key]=$val;
				}
				$new_store[]=$news;
			}
			$file = array();
			$cnt = 0;
			foreach($new_store as $s){
				$file[$cnt]['store_name'] = $s['store_name'];
				$file[$cnt]['total_in'] = $s['total_in'];
				$file[$cnt]['total_out'] = $s['total_out'];
				$file[$cnt]['total'] = $s['total'];
				$cnt++;
			}
			$total_in = 0;
			$total_out = 0;
			$total = 0;
			$new_array['total'] = (array) $new_array['total'];
			$total_in = $new_array['total']['total_in'];
			$total_out = $new_array['total']['total_out'];
			$total = $new_array['total']['total'];
				
						
			$op = array(" "=>"Total","  "=>strval($total_in),"   "=>strval($total_out),"    "=>strval($total));
			
			$test = array("stores"=>$file,"total"=>$op);
					Excel::create('Report', function($excel) use($test) {
					$excel->sheet('Sheetname', function($sheet) use($test) {
					$sheet->fromArray($test['stores']);
					$sheet->appendRow($test['total']);
				}); })->export('xls');
			
			}else{
				$file = array();
				Excel::create('Report', function($excel) use($file) {
						$excel->sheet('Sheetname', function($sheet) use($file) {
							$sheet->fromArray($file);
						});
					})->export('xls');
			}
		}else {
			 return redirect('login');	
		}
	}
	public function western_union_reports2($id, $date_from, $date_to, Request $request)
	{
		
		if (Session::has('login_admin') && Session::get('user_role') == 'admin'){
			$login_data = Session::get('login_admin');
     		$data['login']=$login_data;
			
			
			$user_id = Session::get('login_id');
			$data2 = array("user_id"=>Session::get('login_id'),"id"=>$id, "from"=>$date_from, "to"=>$date_to);
			$url = api_url."western_union_report2?store_id=".$id."&from=".$date_from."&to=".$date_to."&user_id=".$user_id."";
			$header = array();
			$header[] = 'Content-length: 0';
			$header[] = 'Content-type: application/json';
			$header[] = "Authorization: bearer eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJzdWIiOjQ3LCJpc3MiOiJodHRwOlwvXC9hYXJ5YWdyb3VwLnVzXC9hcGlcL3YxM1wvbG9naW4iLCJpYXQiOjE1NTMwMDEzMDcsImV4cCI6MTYxNTIwOTMwNywibmJmIjoxNTUzMDAxMzA3LCJqdGkiOiJiNmU4NzM5NjQwMzMxM2U0YjAwODkzODE2MjQ2YWY5NiJ9.hO0tSwzLhkLQhIVnKQaW1PGFkoyQkORACnD__tiQMRA";
			$post = curl_init();
			curl_setopt($post, CURLOPT_URL, $url);
			curl_setopt($post, CURLOPT_HTTPHEADER,$header);
			curl_setopt($post, CURLOPT_POST, true);
			curl_setopt($post, CURLOPT_POSTFIELDS,json_encode($data2));
			curl_setopt($post, CURLOPT_RETURNTRANSFER, true);

			$result = curl_exec($post);
			curl_close($post);
			$result = json_decode($result);
			
			$result = (array) $result;
			$new_array = array();
			if($result['status'] == 1){
			//while (list($key, $val) = each($result)) {
			foreach($result as $key=>$val){
				$new_array[''.$key]=$val;	
			}
			
			$new_store=array();
			foreach($new_array['data'] as $s){
				$news=array();
				//while (list($key, $val) = each($s)) {
				foreach($s as $key=>$val){
				$news[''.$key]=$val;
				}
				$new_store[]=$news;
			}
			$data['store'] = $new_store;
			}else{
				$data['store'] = array();
			}
			//echo "<pre>"; print_r($new_store); die();
			return view("admin.western_union_report2",$data);
		}else{
			return redirect('login');
		}
	}
	function western_union_reports2_export($id, $date_from, $date_to, Request $request)
	{
		if (Session::has('login_admin') && Session::get('user_role') == 'admin'){
		
			$user_id = Session::get('login_id');
			$data2 = array("id"=>$id, "from"=>$date_from, "to"=>$date_to);
			$url = api_url."western_union_report2?store_id=".$id."&from=".$date_from."&to=".$date_to."&user_id=".$user_id."";
			$header = array();
			$header[] = 'Content-length: 0';
			$header[] = 'Content-type: application/json';
			$header[] = "Authorization: bearer eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJzdWIiOjQ3LCJpc3MiOiJodHRwOlwvXC9hYXJ5YWdyb3VwLnVzXC9hcGlcL3YxM1wvbG9naW4iLCJpYXQiOjE1NTMwMDEzMDcsImV4cCI6MTYxNTIwOTMwNywibmJmIjoxNTUzMDAxMzA3LCJqdGkiOiJiNmU4NzM5NjQwMzMxM2U0YjAwODkzODE2MjQ2YWY5NiJ9.hO0tSwzLhkLQhIVnKQaW1PGFkoyQkORACnD__tiQMRA";
			$post = curl_init();
			curl_setopt($post, CURLOPT_URL, $url);
			curl_setopt($post, CURLOPT_HTTPHEADER,$header);
			curl_setopt($post, CURLOPT_POST, true);
			curl_setopt($post, CURLOPT_POSTFIELDS,json_encode($data2));
			curl_setopt($post, CURLOPT_RETURNTRANSFER, true);

			$result = curl_exec($post);
			curl_close($post);
			$result = json_decode($result);
			$result = (array) $result;
			
			if($result['status'] == 1){
				$new_array = array();
			//while (list($key, $val) = each($result)) {
			foreach($result as $key=>$val){
				$new_array[''.$key]=$val;	
			}
			$new_store=array();
			foreach($new_array['data'] as $s){
				$news=array();
				//while (list($key, $val) = each($s)) {
				foreach($s as $key=>$val){
				$news[''.$key]=$val;
				}
				$new_store[]=$news;
			}
			$file = array();
			$cnt = 0;
			
			foreach($new_store as $n){
				$file[$cnt]['date'] = $n['date'];
				$file[$cnt]['username'] = $n['user_name'];
				$file[$cnt]['store_name'] = $n['store_name'];
				$file[$cnt]['total_in'] = $n['total_in'];
				$file[$cnt]['total_out'] = $n['total_out'];
				$file[$cnt]['total'] = $n['total'];
				$cnt++;
			}
				Excel::create('Report', function($excel) use($file) {
						$excel->sheet('Sheetname', function($sheet) use($file) {
							$sheet->fromArray($file);
						});
					})->export('xls');
			}else{
				$file = array();
				Excel::create('Report', function($excel) use($file) {
						$excel->sheet('Sheetname', function($sheet) use($file) {
							$sheet->fromArray($file);
						});
					})->export('xls');
			}
			
		}else {
			 return redirect('login');	
		}
	}
	public function western_union_reports3($id, $date, $store_id,Request $request)
	{
		if (Session::has('login_admin') && Session::get('user_role') == 'admin'){
			$login_data = Session::get('login_admin');
			$date = str_replace('/','-',$date);
			$date = date("Y-m-d",strtotime($date));
			
			$user_id = Session::get('login_id');
			$data2 = array("user_id"=>Session::get('login_id'),"id"=>$id, "date"=>$date);
			$url = api_url."western_union_report3?user_id=".$id."&date=".$date."&store_id=".$store_id."";
			$header = array();
			$header[] = 'Content-length: 0';
			$header[] = 'Content-type: application/json';
			$header[] = "Authorization: bearer eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJzdWIiOjQ3LCJpc3MiOiJodHRwOlwvXC9hYXJ5YWdyb3VwLnVzXC9hcGlcL3YxM1wvbG9naW4iLCJpYXQiOjE1NTMwMDEzMDcsImV4cCI6MTYxNTIwOTMwNywibmJmIjoxNTUzMDAxMzA3LCJqdGkiOiJiNmU4NzM5NjQwMzMxM2U0YjAwODkzODE2MjQ2YWY5NiJ9.hO0tSwzLhkLQhIVnKQaW1PGFkoyQkORACnD__tiQMRA";
			$post = curl_init();
			curl_setopt($post, CURLOPT_URL, $url);
			curl_setopt($post, CURLOPT_HTTPHEADER,$header);
			curl_setopt($post, CURLOPT_POST, true);
			curl_setopt($post, CURLOPT_POSTFIELDS,json_encode($data2));
			curl_setopt($post, CURLOPT_RETURNTRANSFER, true);

			$result = curl_exec($post);
			curl_close($post);
			$result = json_decode($result);
			$result = (array) $result;
			
			if($result['status'] == 1){
				$new_array = array();
				//while (list($key, $val) = each($result)) {
				foreach($result as $key=>$val){
					$new_array[''.$key]=$val;	
				}
				
				$new_store=array();
			foreach($new_array['data'] as $s){
					$news=array();
					//while (list($key, $val) = each($s)) {
					foreach($s as $key=>$val){
						$news[''.$key]=$val;
					}
					$new_store[]=$news;
			}
			$data['data'] = $new_store;
			}else{
				$data['data'] = array();
			}
			//echo "<pre>"; print_r($new_store); die();
			$data['login']=$login_data;
			
			$admin = User2::where(array("id"=>Session::get('login_id')))->first();
			$data['can_edit_reports'] = $admin['can_edit_reports'];
			return view("admin.western_union_report3",$data);
		}else{
			return redirect('login');
		}
	}
	public function western_union_reports3_export($id, $date, $store_id, Request $request)
	{
		if (Session::has('login_admin') && Session::get('user_role') == 'admin'){
			$login_data = Session::get('login_admin');
     		$data['login']=$login_data;
			
			$date = str_replace('/','-',$date);
			$date = date("Y-m-d",strtotime($date));
			
			$user_id = Session::get('login_id');
			$data2 = array("user_id"=>Session::get('login_id'),"id"=>$id, "date"=>$date);
			$url = api_url."western_union_report3?user_id=".$id."&date=".$date."&store_id=".$store_id."";
			$header = array();
			$header[] = 'Content-length: 0';
			$header[] = 'Content-type: application/json';
			$header[] = "Authorization: bearer eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJzdWIiOjQ3LCJpc3MiOiJodHRwOlwvXC9hYXJ5YWdyb3VwLnVzXC9hcGlcL3YxM1wvbG9naW4iLCJpYXQiOjE1NTMwMDEzMDcsImV4cCI6MTYxNTIwOTMwNywibmJmIjoxNTUzMDAxMzA3LCJqdGkiOiJiNmU4NzM5NjQwMzMxM2U0YjAwODkzODE2MjQ2YWY5NiJ9.hO0tSwzLhkLQhIVnKQaW1PGFkoyQkORACnD__tiQMRA";
			$post = curl_init();
			curl_setopt($post, CURLOPT_URL, $url);
			curl_setopt($post, CURLOPT_HTTPHEADER,$header);
			curl_setopt($post, CURLOPT_POST, true);
			curl_setopt($post, CURLOPT_POSTFIELDS,json_encode($data2));
			curl_setopt($post, CURLOPT_RETURNTRANSFER, true);

			$result = curl_exec($post);
			curl_close($post);
			$result = json_decode($result);
			$result = (array) $result;
			
			if($result['status'] == 1){
				$new_array = array();
				//while (list($key, $val) = each($result)) {
				foreach($result as $key=>$val){
					$new_array[''.$key]=$val;	
				}
				
				$new_store=array();
			foreach($new_array['data'] as $s){
					$news=array();
					//while (list($key, $val) = each($s)) {
					foreach($s as $key=>$val){
						$news[''.$key]=$val;
					}
					$new_store[]=$news;
			}
			
			$file = array();
			$cnt = 0;
			foreach($new_store as $n){
				$file[$cnt]['date'] = $n['date'];
				$file[$cnt]['in'] = $n['total_in'];
				$file[$cnt]['out'] = $n['total_out'];
				$file[$cnt]['total'] = $n['total'];
				$cnt++;
			}
				Excel::create('Report', function($excel) use($file) {
						$excel->sheet('Sheetname', function($sheet) use($file) {
							$sheet->fromArray($file);
						});
					})->export('xls');
			
			}else{
				$file = array();
				Excel::create('Report', function($excel) use($file) {
						$excel->sheet('Sheetname', function($sheet) use($file) {
							$sheet->fromArray($file);
						});
					})->export('xls');
			}
		}else{
			return redirect('login');
		}
	}
	public function edit_western_union($id, Request $request)
	{
		if (Session::has('login_admin') && Session::get('user_role') == 'admin'){
			$login_data = Session::get('login_admin');
     		$data['login']=$login_data;
			$data['wu'] = WesternUnion::where(array("id"=>$id))->first();
			return view('admin.edit_western_union',$data);
			
		}else{
			return redirect('login');
		}
	}
	function update_western_union($id,Request $request)
	{
		if (Session::has('login_admin') && Session::get('user_role') == 'admin'){
     		$login_data = Session::get('login_admin');
     		$data['login']=$login_data;
			$validator = Validator::make($request->all(), [
			'date' => 'required',
            'total_in' => 'required',
			'total_out' => 'required',
			'total' => 'required',
        ]);
        	
        if ($validator->fails()) {
            return redirect("admin/edit-western-union/$id")
                        ->withErrors($validator,'login')
                        ->withInput();
        } else {
				//$date = str_replace('/', '-',$request->get('date'));
				$date = date('Y-m-d',strtotime($request->get('date')));
				$data1=array(
				"date"=>$date,
     	 		"in"=>$request->get('total_in'),
				"out"=>$request->get('total_out'),
				"total"=>$request->get('total'),
     	 		);
     	 		$update = WesternUnion::where(array("id"=>$id))->update($data1);
     	 		if($update) {
				Session::flash('success', 'Western Union entry successfully updated');
        	   return back();
        	   }else {
        	   Session::flash('error', 'Some error. Western Union entry is not updated');
        	   return redirect("admin/edit-western-union/$id");
        	   	}
        }
		}else {
			 return redirect('login');	
		}
	}
	function delete_western_union($id)
	{
		if (Session::has('login_admin') && Session::get('user_role') == 'admin'){
		
     		$login_data = Session::get('login_admin');
     		$data['login']=$login_data;
			$del = WesternUnion::where(array("id"=>$id))->update(array("status"=>0));
			if($del){
				Session::flash('success', 'Western Union entry successfully deleted');
				return back();
			}
			else{
				Session::flash('error', 'Some error. Western Union entry is not deleted');
				return back();
			}
		}else {
			 return redirect('login');	
		}
	}
	function createPDF(Request $request)
	{
		if (Session::has('login_admin') && Session::get('user_role') == 'admin'){
			$data = $request->get('data');
			//echo $data; die();
			$dompdf = new Dompdf();
			$style = "<style>.page-break { page-break-after: always;}</style>";
			//$style = "<style>th, td {border: 1px solid black;padding: 15px;}</style>";
			$dompdf->loadHtml($data);
			$dompdf->setPaper('A4', 'landscape');
			$dompdf->render();
			$dompdf->stream();
			
		}else {
			 return redirect('login');	
		}
	}
}
?>
