<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| This file is where you may define all of the routes that are handled
| by your application. Just tell Laravel the URIs it should respond
| to using a Closure or controller method. Build something great!
|
*/

Route::get('/','AdminController@web_index');
Route::get('/privacy-policy','AdminController@privacyPolicy');
Route::get('/signup','AdminController@web_signup'); 
Route::any('/signup_entry','AdminController@web_signup_entry'); 
// Admin auth and profile
Route::get('/login','AdminController@index');
Route::post('/verify_login','AdminController@verify_login');
Route::get('/home','AdminController@admin_home'); 
Route::get('logout','AdminController@admin_logout');
Route::match(array('GET', 'POST'),'/edit_profile', 'AdminController@edit_profile');
Route::post('/update_profile','AdminController@update_profile');
Route::get('/forgot','AdminController@forgot_view');
Route::post('/check_email','AdminController@check_email');
Route::get('/reset_password/{token}','AdminController@check_token');
Route::post('/set_new_password/{token}','AdminController@set_new_password');

// Admin Edit report via modal

Route::get('admin/edit-reports','ReportsController@editReports');

Route::post('admin/open-report-edit-modal','ReportsController@openModal');
Route::post('admin/update-report-data','ReportsController@updateReportData');

// User reports
Route::get('/admin/user_reports','AdminController@user_reports');
Route::get('/admin/user_reports/{id}/{from}/{to}/{shift}','AdminController@user_reports2');
Route::get('/admin/user_report_store/{user_id}/{store_id}/{from}/{to}/{shift}','AdminController@user_report_store');
Route::get('/admin/user_report_date/{id}/{date}/{store_id}','AdminController@user_report_date_wise');
Route::get('/admin/user_report_graph','ReportGraphController@User_report_view');
// User reports export
Route::get('/admin/user_reports/export','AdminController@user_reports_export');
Route::get('/admin/user_reports/export/{id}/{from}/{to}/{shift}','AdminController@user_reports_export2');
Route::get('/admin/user_report_store/export/{user_id}/{store_id}/{from}/{to}/{shift}','AdminController@user_report_store_export');
Route::get('/admin/user_report_date_export/{id}/{date}/{store_id}','AdminController@user_report_date_wise_export');

// Store reports
Route::get('/admin/view_report','AdminController@view_report');
Route::get('/admin/store_info/{id}/{from}/{to}','AdminController@store_info');
Route::get('/admin/user_entry_details/{id}/{date}/{store_id}','AdminController@user_entry_details');
Route::get('/admin/store_report_graph','ReportGraphController@index');

// Store reports export
Route::get('/admin/view_report/export','AdminController@view_report_export');
Route::get('/admin/store_info/export/{id}/{date_from}/{date_to}','AdminController@store_info_export');
Route::get('/admin/user_entry_details/export/{id}/{date}/{store_id}','AdminController@user_entry_details_export');

// Inventory filter
Route::get('/admin/inventory_filter','AdminController@inventory_filter');
Route::get('/admin/inventory_filter/detail','AdminController@inventory_filter_detail');
Route::get('/admin/inventory_report_graph','ReportGraphController@inventory_graph_report');
// Inventory filter export
Route::get('/admin/inventory_filter/export','AdminController@inventory_filter_export');
Route::get('/admin/inventory_filter/detail/export','AdminController@inventory_filter_detail_export');

// Admin Western Union
Route::get('/admin/western-union-reports','AdminController@western_union_reports');
Route::get('admin/western-union-reports/export','AdminController@western_union_reports_export');
Route::get('/admin/western-union-reports-user/{id}/{date_from}/{date_to}','AdminController@western_union_reports2');
Route::get('/admin/western-union-reports-user/export/{id}/{date_from}/{date_to}','AdminController@western_union_reports2_export');
Route::get('/admin/western-union-reports-entry/{user_id}/{date}/{store_id}','AdminController@western_union_reports3');
Route::get('/admin/western-union-reports-entry/export/{user_id}/{date}/{store_id}','AdminController@western_union_reports3_export');
Route::get('/admin/edit-western-union/{id}','AdminController@edit_western_union');
Route::post('/admin/update-western-union/{id}','AdminController@update_western_union');
Route::get('/admin/delete-western-union/{id}','AdminController@delete_western_union');
Route::post('admin/create-report-pdf','AdminController@createPDF');

// Admin edit reports
Route::get('/admin/edit_sales/{id}','AdminController@edit_sales');
Route::post('/admin/update_sales/{id}','AdminController@update_sales');
Route::get('/admin/edit_payment/{id}','AdminController@edit_payment');
Route::post('/admin/update_payment/{id}','AdminController@update_payment');
Route::get('/admin/edit_inventory/{id}','AdminController@edit_inventory');
Route::post('/admin/update_inventory/{id}','AdminController@update_inventory');
Route::get('/admin/edit_atm/{id}','AdminController@edit_atm');
Route::post('/admin/update_atm/{id}','AdminController@update_atm');
Route::get('/admin/edit_cigarette/{id}','AdminController@edit_cigarette');
Route::post('/admin/update_cigarette/{id}','AdminController@update_cigarette');
Route::get('/admin/edit_lottery/{id}','AdminController@edit_lottery');
Route::post('/admin/update_lottery/{id}','AdminController@update_lottery');
Route::get('/admin/edit_expense/{id}','AdminController@edit_expense');
Route::post('/admin/update_expense/{id}','AdminController@update_expense');
Route::post('/admin/update_atm_fp_cash','AdminController@update_atm_cash');
Route::post('/admin/update_atm_cash','AdminController@update_atm_total_cash');

// Admin delete reports
Route::get('/admin/delete_sales/{id}','AdminController@delete_sales');
Route::get('/admin/delete_payment/{id}','AdminController@delete_payment');
Route::get('/admin/delete_inventory/{id}','AdminController@delete_inventory');
Route::get('/admin/delete_atm/{id}','AdminController@delete_atm');
Route::get('/admin/delete_cigarette/{id}','AdminController@delete_cigarette');
Route::get('/admin/delete_lottery/{id}','AdminController@delete_lottery');
Route::get('/admin/delete_expense/{id}','AdminController@delete_expense');

Route::get('/admin/report_list','AdminController@report_list');
Route::get('/admin/sales_report','AdminController@sales_report');
Route::get('/admin/payment_report','AdminController@payment_report');
Route::get('/admin/inventory_report','AdminController@inventory_report');

// Admin Users management 
Route::get('/admin/user_list','AdminController@user_list');
Route::get('/admin/add_user_view','AdminController@add_user_view');
Route::post('/admin/add_user','AdminController@add_user');
Route::any('/admin/edit_user/{id}','AdminController@edit_user');
Route::post('/admin/edit_user_info/{id}','AdminController@update_user_data');
Route::get('/admin/delete_user/{id}','AdminController@delete_user');
Route::get('/admin/block_user/{id}','AdminController@block_user');
Route::get('/admin/unblock_user/{id}','AdminController@unblock_user');

// Admin Customers management 
Route::get('/admin/customer_list','AdminController@customer_list');
Route::get('/admin/add_customer_view','AdminController@add_customer_view');
Route::post('/admin/add_customer','AdminController@add_customer');
Route::any('/admin/edit_customer/{id}','AdminController@edit_customer');
Route::post('/admin/edit_customer_info/{id}','AdminController@update_customer_data');
Route::get('/admin/delete_customer/{id}','AdminController@delete_customer');
Route::get('/admin/block_customer/{id}','AdminController@block_customer');
Route::get('/admin/unblock_customer/{id}','AdminController@unblock_customer');

// Admin Order Items management
Route::get('/admin/order_item_list','AdminController@order_item_list');
Route::get('/admin/add_order_item_view','AdminController@add_order_item_view');
Route::post('/admin/add_order_item','AdminController@add_order_item');
Route::any('/admin/edit_order_item/{id}','AdminController@edit_order_item');
Route::post('/admin/edit_order_item_info/{id}','AdminController@update_order_item_data');
Route::get('/admin/delete_order_item/{id}','AdminController@delete_order_item');

Route::get('/admin/book_order','AdminController@book_order');
Route::post('/admin/get_user_info','AdminController@get_user_info');
Route::post('/admin/get_cart_data','AdminController@get_cart_data');
Route::post('/admin/get_price','AdminController@get_price');
Route::post('/admin/place_order','AdminController@place_order');
Route::post('/admin/remove_from_cart','AdminController@remove_from_cart');
Route::post('/admin/put_store','AdminController@put_store');
Route::post('/admin/get_user_cart','AdminController@get_user_cart');
Route::post('/admin/is_cart_empty','AdminController@is_cart_empty');
Route::post('/admin/change_quantity','AdminController@change_quantity');


Route::get('/admin/confirm_order/{id}','AdminController@confirm_order');
Route::get('/admin/mark_as_shiped/{id}','AdminController@mark_as_shiped');
Route::get('/admin/edit_order/{id}','AdminController@edit_order');
Route::get('/admin/edit_order_detail/{id}','AdminController@edit_order_detail');
Route::post('/admin/update_order_detail/{id}','AdminController@update_order_detail');

Route::post('/admin/get_order_count','AdminController@get_order_count');


// Admin Order Categories management
Route::get('/admin/order_category_list','AdminController@order_category_list');
Route::get('/admin/add_order_category_view','AdminController@add_order_category_view');
Route::post('/admin/add_order_category','AdminController@add_order_category');
Route::any('/admin/edit_order_category/{id}','AdminController@edit_order_category');
Route::post('/admin/edit_order_category_info/{id}','AdminController@update_order_category_data');
Route::get('/admin/delete_order_category/{id}','AdminController@delete_order_category');

// Admin Stores management
Route::get('/admin/store_list','AdminController@store_list');
Route::get('/admin/add_store_view','AdminController@add_store_view');
Route::post('/admin/add_store','AdminController@add_store');
Route::any('/admin/edit_store/{id}','AdminController@edit_store');
Route::post('/admin/edit_store_info/{id}','AdminController@update_store_data');
Route::get('/admin/delete_store/{id}','AdminController@delete_store');

// Admin Items management
Route::get('/admin/item_list','AdminController@item_list');
Route::get('/admin/add_item_view','AdminController@add_item_view');
Route::post('/admin/add_item','AdminController@add_item');
Route::any('/admin/edit_item/{id}','AdminController@edit_item');
Route::post('/admin/edit_item_info/{id}','AdminController@update_item_data');
Route::get('/admin/delete_item/{id}','AdminController@delete_item');

// Admin Expense Items management
Route::get('/admin/expense_item_list','AdminController@expense_item_list');
Route::get('/admin/add_expense_item_view','AdminController@add_expense_item_view');
Route::post('/admin/add_expense_item','AdminController@add_expense_item');
Route::any('/admin/edit_expense_item/{id}','AdminController@edit_expense_item');
Route::post('/admin/edit_expense_item_info/{id}','AdminController@update_expense_item_data');
Route::get('/admin/delete_expense_item/{id}','AdminController@delete_expense_item');

// Admin Vendors management
Route::get('/admin/vendor_list','AdminController@vendor_list');
Route::get('/admin/add_vendor_view','AdminController@add_vendor_view');
Route::post('/admin/add_vendor','AdminController@add_vendor');
Route::any('/admin/edit_vendor/{id}','AdminController@edit_vendor');
Route::post('/admin/edit_vendor_info/{id}','AdminController@update_vendor_data');
Route::get('/admin/delete_vendor/{id}','AdminController@delete_vendor');

// Admin Inventory management
Route::get('/admin/add_inventory','AdminController@add_inventory');
Route::post('/admin/save_inventory','AdminController@save_inventory');

// Admin Profit and loss of stores
Route::get('/admin/store_in_profit','AdminController@store_in_profit');
Route::get('/admin/view_store_details/{id}','AdminController@view_store_details');
Route::get('/admin/store_in_loss','AdminController@store_in_loss');

// Admin Reports management
Route::get('/admin/add_report','AdminController@add_report');
Route::post('/admin/save_report','AdminController@save_report');

// Staff daily sales entry
Route::get('/staff/daily_sales_entry','AdminController@daily_sales_entry');
Route::post('/staff/save_daily_sales_entry','AdminController@save_daily_sales_entry');

// Staff daily payment report
Route::get('/staff/daily_payment_report','AdminController@daily_payment_report');
Route::post('/staff/save_daily_payment_report','AdminController@save_daily_payment_report');

// Staff inventory management
Route::get('/staff/add_inventory','AdminController@add_inventory');
Route::post('/staff/save_inventory','AdminController@save_inventory');
Route::get('/staff/inventory_report','AdminController@inventory_report');