<?php

namespace App\Http\Controllers;

use Maatwebsite\Excel\Facades\Excel;
use App\MyCart;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Hash;
use App\User;
use App\User2;
use App\Cigarettes;
use App\ATM;
use App\Inventory;
use App\Inventory2;
use App\Stores;
use App\Sales;
use App\ExpenseItems;
use App\Payments;
use App\Vendors;
use App\Items;
use App\Lottery;
use App\Expense;
use App\Messages;
use App\Customers;
use App\OrderItems;
use App\OrderCategories;
use App\Orders;
use App\OrderDetails;
use App\WesternUnion;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\DB;
use App\Http\Requests;
use Illuminate\Support\Facades\Input;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\View;
use Illuminate\Support\Facades\Mail;
use Config;
use Illuminate\Support\Facades\Validator;
use Illuminate\Http\Request;
use Dompdf\Dompdf;

//define("api_url", "http://aaryagroup.us/api/v4/");
define("api_url", "http://websitedemo.co.in/phpdemoz/Aarya/api/v4/");
//define("api_url", "http://localhost:8000/api/v4/");
class ReportsController extends Controller
{
	function editReports(Request $request){
		if (Session::has('login_admin') && Session::get('user_role') == 'admin'){
			$login_data = Session::get('login_admin');
     		$data['login']=$login_data;
			
			$user_data = User::where(array("id"=>Session::get('login_id')))->first();
			$store_access = $user_data['store_access'];
			$data['can_edit_reports'] = $user_data['can_edit_reports'];
			if(!empty($store_access)){
				$data['store'] = Stores::whereRaw('status=1 AND id IN('.$store_access.')')->get();
			}
			if(empty($store_access)){
				$data['store'] = Stores::where(array("status"=>1))->get();
			}
			$id = $request->get('store');
			$store_id = $id;
			$login_id = Session::get('login_id');
			$date_from = $request->get('date_from');
			$date_to = $request->get('date_to');
			// $date_from = str_replace('/','-',$date_from);
			// $date_from = date("Y-m-d",strtotime($date_from));
			// $date_to = str_replace('/','-',$date_to);
			// $date_to = date("Y-m-d",strtotime($date_to));
			// if(empty($date_from)){
				// $data['from'] = date('d/m/Y');
			// }else{
				// $data['from'] = $request->get('date_from');
			// }
			// if(empty($date_to)){
				// $data['to'] = date('d/m/Y');
			// }else{
				// $data['to'] = $request->get('date_to');
			// }
			if(empty($date_from)){
				$data['from'] = date('m/d/Y');
				$date_from = date('Y-m-d');
			}else{
				$date_from_temp = explode('/',$date_from);
				$date_from = $date_from_temp[2]."-".$date_from_temp[0]."-".$date_from_temp[1];
				$data['from'] = $request->get('date_from');
			}
			if(empty($date_to)){
				$data['to'] = date('m/d/Y');
				$date_to = date('Y-m-d');
			}else{
				$date_to_temp = explode('/',$date_to);
				$date_to = $date_to_temp[2]."-".$date_to_temp[0]."-".$date_to_temp[1];
				$data['to'] = $request->get('date_to');
			} 
			if(empty($date_from)){
				$date_from = date('Y-m-d');
			}
			if(empty($date_to)){
				$date_to = date('Y-m-d');
			}
			$data['old_store'] = $request->get('store');
			$data['send_from'] = $date_from;
			$data['send_to'] = $date_to;
			if(!empty($date_from) && !empty($date_to) && !empty($id)){
				
			$data['sales'] = DB::table('daily_sales_entry')
						->select(DB::raw(
									"DATE_FORMAT(daily_sales_entry.date ,'%m/%d/%Y')as sdate,
									daily_sales_entry.id as sales_id,
									ROUND(daily_sales_entry.inside,2) as inside,
									ROUND(daily_sales_entry.gas,2) as gas,
									ROUND(daily_sales_entry.tax,2) as tax,
									ROUND(daily_sales_entry.phone_card,2) as phone_card,
									ROUND(daily_sales_entry.instant,2) as instant,
									ROUND(daily_sales_entry.lottery,2) as lottery,
									ROUND(daily_sales_entry.add_money_order,2) as add_money_order,
									ROUND(daily_sales_entry.total_sales,2) as total_sales,
									users.name as username
									"))
						->leftJoin('users','daily_sales_entry.user_id','=','users.id')
						->where('daily_sales_entry.status', '=',1)
						->where('daily_sales_entry.store_id', '=',$store_id)
						->whereDate('daily_sales_entry.date', '>=',$date_from)
						->whereDate('daily_sales_entry.date', '<=',$date_to)
						->get();
						
					$data['payment'] = DB::table('daily_payment_report')
						->select(DB::raw(
									"DATE_FORMAT(daily_payment_report.date ,'%m/%d/%Y')as pdate,
									daily_payment_report.id as payment_id,
									ROUND(daily_payment_report.total_cash,2) as total_cash,
									ROUND(daily_payment_report.total_credit,2) as total_credit,
									ROUND(daily_payment_report.total_debit,2) as total_debit,
									ROUND(daily_payment_report.lottery_cash,2) as lottery_cash,
									ROUND(daily_payment_report.lottery_online_cashout,2) as lottery_online_cashout,
									ROUND(daily_payment_report.lottery_out,2) as lottery_out,
									ROUND(daily_payment_report.lottery_instant_cashout,2) as lottery_instant_cashout,
									ROUND(daily_payment_report.total,2) as total,
									users.name as username
									"))
						
						->leftJoin('users','users.id','=','daily_payment_report.user_id')
						->where('daily_payment_report.status', '=',1)
						->where('daily_payment_report.store_id', '=',$store_id)
						->whereDate('daily_payment_report.date', '>=',$date_from)
						->whereDate('daily_payment_report.date', '<=',$date_to)
						->get();
						
					$data['inventory'] = DB::table('inventory')
						->select(DB::raw(
						"DATE_FORMAT(inventory.date ,'%m/%d/%Y')as sdate,
									inventory.id as inventory_id,
									inventory.invoice_no,
									inventory.item,
									inventory.vendor,
									inventory.quantity,
									IFNULL(inventory.pay_by,'') as pay_by,
									IFNULL(inventory.cheque_no, '') as cheque_no,
									ROUND(inventory.price,2) as price,
									ROUND(inventory.total_price,2) as total_price,
									items.name as item_name,
									users.name as username
									"))
						
						->leftJoin('users','users.id','=','inventory.user_id')
						->leftJoin('items','items.id','=','inventory.item')
						->where('inventory.status', '=',1)
						->where('inventory.store_id', '=',$store_id)
						->whereDate('inventory.date', '>=',$date_from)
						->whereDate('inventory.date', '<=',$date_to)
						->get();
						
						
				$data['atm'] = DB::table('ATM')
						->select(DB::raw(
						"DATE_FORMAT(ATM.date ,'%m/%d/%Y')as atmdate,
									ATM.id as atmid,
									IFNULL(ROUND(ATM.money,2),'') as money,
									IFNULL(ROUND(ATM.add_money,2),'') as add_money,
									IFNULL(ROUND(ATM.total_money,2),'') as total_money,
									IFNULL(ROUND(ATM.cash,2),'') as cash,
									IFNULL(ROUND(ATM.fp,2),'') as fp,
									IFNULL(ATM.store_id,'') as store_id,
									IFNULL(ATM.user_id,'') as user_id,
									users.name as username
									"))
						->leftJoin('users','users.id','=','ATM.user_id')
						->where('ATM.status', '=',1)
						->where('ATM.store_id', '=',$store_id)
						->whereDate('ATM.date', '>=',$date_from)
						->whereDate('ATM.date', '<=',$date_to)
						->get();
				
				$data['cigarette'] = DB::table('cigarettes')
						->select(DB::raw(
						"DATE_FORMAT(cigarettes.date ,'%m/%d/%Y')as cigdate,
									cigarettes.id as cigid,
									cigarettes.inventory,
									ROUND(cigarettes.add_cigarette,2) as add_cigarette,
									ROUND(cigarettes.sale_cigarette,2) as sale_cigarette,
									ROUND(cigarettes.available_stock,2) as available_stock,
									cigarettes.store_id,
									cigarettes.user_id,
									users.name as username
									"))
						->leftJoin('users','users.id','=','cigarettes.user_id')
						->where('cigarettes.status', '=',1)
						->where('cigarettes.store_id', '=',$store_id)
						->whereDate('cigarettes.date', '>=',$date_from)
						->whereDate('cigarettes.date', '<=',$date_to)
						->get();
				$data['lottery'] = DB::table('lottery')
						->select(DB::raw(
						"DATE_FORMAT(lottery.date ,'%m/%d/%Y')as lotdate,
									lottery.id as lotid,
									ROUND(lottery.inventory,2) as inventory,
									ROUND(lottery.add_book,2) as add_book,
									IFNULL(ROUND(lottery.weekly_eft_ammount,2),'0') as weekly_eft_ammount,
									ROUND(lottery.weekly_commission,2) as weekly_commission,
									ROUND(lottery.active_book,2) as active_book,
									ROUND(lottery.total,2) as total,
									lottery.store_id,
									lottery.user_id,
									users.name as username
									"))
						->leftJoin('users','users.id','=','lottery.user_id')
						->where('lottery.status', '=',1)
						->where('lottery.store_id', '=',$store_id)
						->whereDate('lottery.date', '>=',$date_from)
						->whereDate('lottery.date', '<=',$date_to)
						->get();
				$data['expense'] = DB::table('expense')
						->select(DB::raw(
						"DATE_FORMAT(expense.date ,'%m/%d/%Y')as expdate,
									expense.id as expid,
									expense.title,
									ROUND(expense.price,2) as price,
									expense.user_id,
									expense.store_id,
									expense.item_id,
									expense_items.expense_item as item_name,
									users.name as username
									"))
						->leftJoin('users','users.id','=','expense.user_id')
						->leftJoin('expense_items','expense_items.id','=','expense.item_id')
						->where('expense.status', '=',1)
						->where('expense.store_id', '=',$store_id)
						->whereDate('expense.date', '>=',$date_from)
						->whereDate('expense.date', '<=',$date_to)
						->get();
						//$output = array("sales"=>$sales,"payment"=>$payment,"inventory"=>$inventory,"cigarettes"=>$cigarette, "atm"=>$atm, "lottery"=>$lottery, "expense"=>$expense);
			}else{
				$output = array("sales"=>array(),"payment"=>array(),"inventory"=>array(),"cigarettes"=>array(), "atm"=>array(), "lottery"=>array(), "expense"=>array());
			}
			return view("admin.edit_reports",$data);
		}else{
			return redirect('login');
		}
	}
}
?>