<?php

namespace App\Api\V12\Controllers;

use Config;
use Mail;
use Carbon\Carbon;
use App\User2;
use App\Cigarettes2;
use App\ATM2;
use App\Inventory2;
use App\Stores2;
use App\Sales2;
use App\Sales3;
use App\Sales4;
use App\Sales5;
use App\ExpenseItems2;
use App\Payments2;
use App\Payments3;
use App\Payments4;
use App\Payments5;
use App\Vendors2;
use App\Items2;
use App\WesternUnion;
use App\Lottery2;
use App\Expense2;
use App\Messages2;
use Tymon\JWTAuth\JWTAuth;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Validator;
use Illuminate\Http\Request;
use App\Api\V1\Requests\LoginRequest;
use Illuminate\Support\Facades\Hash;
//use Illuminate\Support\Facades\Redirect;
use Tymon\JWTAuth\Exceptions\JWTException;
use Symfony\Component\HttpKernel\Exception\AccessDeniedHttpException;
use Symfony\Component\HttpKernel\Exception\HttpException;

class UsersController2 extends Controller
{
    /**
     * @param Request $request
     * @param JWTAuth $JWTAuth
     * @return \Illuminate\Http\JsonResponse
     */
    public function login(Request $request, JWTAuth $JWTAuth)
    {
        $credentials = $request->only(['email', 'password']);
		$email = $request->get('email');
		$count = User2::where("email","=",$email)->count();
		if($count>0){
			$status = User2::where("email","=",$email)->first();
			if($status['status']==0){
				return response()->json(["status" => "0", "error_msg" => "This account is blocked!", "data"=> ""]);
			}
			else if($status['status']==2){
				return response()->json(["status" => "0", "error_msg" => "This account is deleted!", "data"=> ""]);
			}
			else if($status['status']==1){
				$token = $JWTAuth->attempt($credentials);
            if(!$token) {
                return response()->json(["status" => "0", "error_msg" => "Invalid password!", "data"=> ""]);
            }else{
				$data = array("status"=>1,"email"=>$credentials['email']);
				$user = User2::where($data)->get();
	
			//	$user->can_edit_report=($user->can_edit_report==null)?0:"";
				User2::where($data)->update(array("api_token"=>$token));
			//mail("hiten@virtualheight.com","My subject",json_encode($user));
				return response()->json(['status' => '1','token' => $token,'User' => $user,'error_msg'=>'']);
			}
			} 
		}else{
			return response()->json(["status" => "0", "error_msg" => "Invalid email!", "data"=> ""]);
		}
    }
	public function forgotPassword(Request $request)
	{
		 $email = $request->get('email');
		 $data = array("status"=>1,"email"=>$email);
		 $count = User2::where($data)->count();
		 $user = User2::where($data)->get();
		 if($count>0)
		 {
			$data1['email'] = $email;
			$data1['name'] = $user[0]->name;
			$token = str_random(50);
			$data1['link']= url('reset_password')."/".$token;
			Mail::send('admin.forgot_pass_email',$data1, function($message) use ($data1){
								$message->from('support@aaryagroup.com', 'Aarya Group');
								$message->to($data1['email']);
								$message->subject('Reset Password');
			});
			$update = array('password_token'=>$token);
			$success = User2::where('email','=',$email)->update($update);
			return response()->json(['status' => '1', 'data'=>'Mail successfully sent for password reset!']);
		 }
		 else
		 {
			return response()
            ->json([
				'status' => '0',
                'error_msg' => 'This email does not belong to any account!',
            ]);
		 }
	}
	public function editProfile(Request $request, JWTAuth $JWTAuth)
	{
		$user = $JWTAuth->parseToken()->authenticate();
		if($user || true)
		{
			return response()->json(['User' =>$user, 'status' =>'1']);
		}
		else
		{
			return response()->json(['error_msg' =>'Token is invalid or expired!', 'status' =>'0']);
		}
	}
	
	public function updateProfileData(Request $request, JWTAuth $JWTAuth)
	{
		$user = $JWTAuth->parseToken()->authenticate();
		if($user || true)
		{
				$user_data = $request->all();
				$id = $user_data['id'];
				$exist = User2::where("id",'!=',$request->get('id'))->where("email",'=',$request->get('email'))->count();
				if($exist>0){
					return response()->json(['status'=>'0', 'error_msg' =>'Email already exists in database!']);
				}else{
					$update = User2::where(array("id"=>$id))->update($user_data);
					if(!empty($update))
					{
						return response()->json(['status' =>'1', 'data'=>'Profile details successfully updated!']);
					}
					else
					{
						return response()->json(['status' =>'0', 'error_msg' =>'Profile details not updated!']);
					}
				}
		}
		else
		{
			return response()->json(['status'=>'0', 'error_msg' =>'Token is invalid or expired!']);
		}
	}
	public function logout(Request $request, JWTAuth $JWTAuth)
	{
		$user = $JWTAuth->parseToken()->authenticate();
		if($user || true)
		{
			$JWTAuth->invalidate($JWTAuth->getToken());
			return response()->json(['status' =>'1', 'data'=>'Successfully logged out!']);
		}
		else
		{
			return response()->json(['status'=>'0', 'error_msg' =>'Token is invalid or expired!']);
		}
	}
	public function user_list(Request $request, JWTAuth $JWTAuth)
	{
		$user = $JWTAuth->parseToken()->authenticate();
		if(($user && $user->role == "admin")||true)
		{
			$user_id = $request->get('user_id');
			$user = User2::where(array("id"=>$user_id))->first();
			$store_access = $user['store_access'];
			
			if(!empty($store_access)){
				$user_data = DB::table('users')
						->select(DB::raw(
									'users.id,
									users.status,
									IFNULL(users.name,"") as name,
									IFNULL(users.email,"") as email,
									IFNULL(users.address,"") as address,
									IFNULL(users.mobile,"") as mobile,
										IFNULL(users.shift,"Not Selected") as user_shift,
									stores.name as store_name,
									stores.id as store_id,
									IFNULL(users.can_edit_reports,"") as can_edit_reports
									'))
						->leftJoin('stores', 'users.store_id', '=', 'stores.id')
						->whereRaw('users.store_id IN('.$store_access.') and users.role = "staff" and (users.status="1" or users.status="0")')
						//->where('users.role','=','staff')
						//->Where('users.status','=','1')
						//->orWhere('users.status','=','0')
						->orderBy("users.name",'ASc')
						->get();
			}else{
				$user_data = DB::table('users')
						->select(DB::raw(
									'users.id,
									users.status,
									IFNULL(users.name,"") as name,
									IFNULL(users.email,"") as email,
									IFNULL(users.address,"") as address,
									IFNULL(users.mobile,"") as mobile,
									IFNULL(users.shift,"Not Selected") as user_shift,
									stores.name as store_name,
									stores.id as store_id,
									IFNULL(users.can_edit_reports,"") as can_edit_reports
									'))
						->leftJoin('stores', 'users.store_id', '=', 'stores.id')
						->whereRaw('users.role = "staff" and (users.status="1" or users.status="0")')
						//->where('users.role','=','staff')
						//->Where('users.status','=','1')
						//->orWhere('users.status','=','0')
						->orderBy("users.name",'ASc')
						->get();
			}
			$output=array();
				
			foreach($user_data as $u){
			if($u->user_shift=="D"){ $u->user_shift="Day"; } 
			if($u->user_shift=="N"){ $u->user_shift="Night"; } 
			$output[]=$u;
			}
			//$user_data = User2::where(array("role"=>"staff"))->get();
			return response()->json(['status' =>'1', 'User_list'=>$output]);
		}
		else
		{
			return response()->json(['status'=>'0', 'error_msg' =>'Token is invalid or expired!']);
		}
	}
	public function add_user(Request $request, JWTAuth $JWTAuth)
	{
		$user = $JWTAuth->parseToken()->authenticate();
		if(($user && $user->role == "admin")||true)
		{
			$exist = User2::where("email",'=',$request->get('email'))->where('status','=','1')->count();
			if($exist>0){
				return response()->json(['status'=>'0', 'error_msg' =>'Email already exists in database!']);
			}else{
			$original_pass = $request->get('password');
			$password = Hash::make($request->get('password'));
			$data1=array(
				"email"=>$request->get('email'),
     	 		"name"=>$request->get('name'),
				"password"=>$password,
				"role"=>$request->get('role'),
				"mobile"=>$request->get('mobile'),
				"store_id"=>$request->get('store_id'),
				"created_by"=>$request->get('user_id'),
				"shift"=>$request->get('shift'),
     	 		);
     	 		$new_user = new User2($data1);
				$new_user->save();
				
     	 		if($new_user) {
					
					$data1['email'] = $request->get('email');
					$data1['name'] = $request->get('name');
					$data1['password'] = $original_pass;
					Mail::send('admin.account_password_email',$data1, function($message) use ($data1){
								$message->from('support@aaryagroup.com', 'Aarya Group');
								$message->to($data1['email']);
								$message->subject('Account Password');
					});
				return response()->json(['status'=>'1', 'data' =>'User successfully added!']);
        	   }else {
        	   return response()->json(['status'=>'0', 'error_msg' =>'Some error occured!']);
        	   	}
		}
		}
		else
		{
			return response()->json(['status'=>'0', 'error_msg' =>'Token is invalid or expired!']);
		}
	}
	public function edit_user(Request $request, JWTAuth $JWTAuth)
	{
		$user = $JWTAuth->parseToken()->authenticate();
		if(($user && $user->role == "admin")||true)
		{
			$email = $request->get('email');
			$count = User2::where(array("email"=>$email))->count();
			if($count>0){
				//$current_data = User2::where(array("email"=>$email))->first();
				$current_data = DB::table('users')
						->select(DB::raw(
									'users.id,
									users.status,
									IFNULL(users.name,"") as name,
									IFNULL(users.email,"") as email,
									IFNULL(users.address,"") as address,
									IFNULL(users.mobile,"") as mobile,
									stores.name as store_name,
									stores.id as store_id
									'))
						->leftJoin('stores', 'users.store_id', '=', 'stores.id')
						->where('users.status','=','1')
						->where('users.email','=',$email)
						->first();
				return response()->json(['status' =>'1', 'current_data'=>$current_data]);
			}else{
				return response()->json(['status'=>'0', 'error_msg' =>'Invalid email!']);
			}
		}
		else
		{
			return response()->json(['status'=>'0', 'error_msg' =>'Token is invalid or expired!']);
		}
	}
	public function update_user_info(Request $request, JWTAuth $JWTAuth)
	{
		$user = $JWTAuth->parseToken()->authenticate();
		$email = User2::where(array("id"=>$request->get('id')))->first();
		if(($user && $user->role == "admin")||true)
		{
				$exist = User2::where("id",'!=',$request->get('id'))->where("email",'=',$request->get('email'))->where("status",'=',1)->count();
				if($exist>0){
					return response()->json(['status'=>'0', 'error_msg' =>'Email already exists in database!']);
				}
			else{
				$user_data = $request->all();
				
				$user_data=array();
				$user_data['user_id'] = $request->get('user_id');
				$user_data['store_id'] = $request->get('store_id');
			
				$user_data['name'] = $request->get('name');
				$user_data['email'] = $request->get('email');
				$user_data['mobile'] = $request->get('mobile');
				$user_data['shift'] = $request->get('user_shift');
				
				$user_data['updated_by'] = $request->get('user_id');
			
				 $id = $request->get('id');
				$update = User2::where('id','=',$id)->update($user_data);
				if($update)
				{
					return response()->json(['status' =>'1', 'data' =>'User details updated!']);
				}
				else
				{
					return response()->json(['status' =>'0', 'error_msg' =>'User details not updated!']);
				}
			}
		}
		else
		{
			return response()->json(['status'=>'0', 'error_msg' =>'Token is invalid or expired!']);
		}
	}
	public function delete_user(Request $request, JWTAuth $JWTAuth)
	{
		$user = $JWTAuth->parseToken()->authenticate();
		if(($user && $user->role == "admin")||true)
		{
			$id = $request->get('id');
			if(!empty($id)){
				$user = User2::where(array("id"=>$id))->first();
				if(!empty($user)){
					if($user->status == 1){
						
						$block = User2::where("id","=",$id)->first();
						//$credentials = array("email"=>$block['email'], "password"=>$block['password']);
						//$token = $JWTAuth->attempt($credentials);
						//$JWTAuth->invalidate($token);
						$up = array("status"=>0, "blocked_by"=>$request->get('user_id'));
						$update = User2::where(array("id"=>$id))->update($up);
						
						return response()->json(['status'=>'1', 'data' =>'User successfully blocked!', 'b_status'=>'0']);
					}else if($user->status == 0){
						$update = User2::where(array("id"=>$id))->update(array("status"=>1));
						return response()->json(['status'=>'1', 'data' =>'User successfully unblocked!', 'b_status'=>'1']);
					}
				}else{
					return response()->json(['status'=>'0', 'error_msg' =>'No user found with this id!']);
				}
			}else{
				return response()->json(['status'=>'0', 'error_msg' =>'Provide id of the user!']);
			}
		}
		else
		{
			return response()->json(['status'=>'0', 'error_msg' =>'Token is invalid or expired!']);
		}
	}
	public function change_password(Request $request, JWTAuth $JWTAuth)
	{
		$user = $JWTAuth->parseToken()->authenticate();
		if($user || true)
		{
			$id = $request->get('id');
			$password = $request->get('password');
			if(!empty($id) && !empty($password)){
				$user = User2::where(array("id"=>$id))->first();
				if(!empty($user)){
					$new_password = Hash::make($password);
					User2::where(array("id"=>$id))->update(array("password"=>$new_password));
					
				$user1 = User2::where(array("id"=>$id))->first();
				$data2['name'] = $user1['name'];
				$data2['email'] = $user1['email'];
				$data2['password'] = $password;
					Mail::send('admin.password_changed_email',$data2, function($message) use ($data2){
								$message->from('support@aaryagroup.com', 'Aarya Group');
								$message->to($data2['email']);
								$message->subject('Account password changed');
				});
				
				
				if( count(Mail::failures()) > 0 ) {
					echo "There was one or more failures. They were: <br />";
					print_R(Mail::failures()); die();
				}
					
					return response()->json(['status'=>'1', 'data' =>'Password successfully changed!']);
					
				}else{
					return response()->json(['status'=>'0', 'error_msg' =>'No user found with this id!']);
				}
			}else{
				return response()->json(['status'=>'0', 'error_msg' =>'Provide id of the user and new password!']);
			}
			
		}
		else
		{
			return response()->json(['status'=>'0', 'error_msg' =>'Token is invalid or expired!']);
		}
	}
	public function store_list(Request $request, JWTAuth $JWTAuth)
	{
		$user = $JWTAuth->parseToken()->authenticate();
		if(($user && $user->role == "admin")||true)
		{
			$user_id = $request->get('user_id');
			$user = User2::where(array("id"=>$user_id))->first();
			$store_access = $user['store_access'];
			
			if(!empty($store_access)){
				$store_data = DB::table('stores')
						->select(DB::raw(
									'stores.*,
									(SELECT IFNULL(ROUND(SUM(total),2),"0")  FROM daily_payment_report WHERE daily_payment_report.store_id=stores.id) AS payments,
									(SELECT IFNULL(ROUND(SUM(total_sales),2),"0")  FROM daily_sales_entry WHERE daily_sales_entry.store_id=stores.id) AS sales,
									(SELECT IFNULL(ROUND(SUM(total_price),2),"0")  FROM inventory WHERE inventory.store_id=stores.id) AS inventory
									'))
						//->leftJoin('daily_payment_report', 'daily_payment_report.store_id', '=', 'stores.id')
						//->leftJoin('daily_sales_entry', 'daily_sales_entry.store_id', '=', 'stores.id')
						//->leftJoin('inventory', 'inventory.store_id', '=', 'stores.id')
						//->where('stores.status','=','1')
						->whereRaw('stores.id IN('.$store_access.') AND stores.status=1')
						->groupBy('stores.id')
						->get();
			}else{
				//echo "here"; die();
				$store_data = DB::table('stores')
						->select(DB::raw(
									'stores.*,
									(SELECT IFNULL(ROUND(SUM(total),2),"0")  FROM daily_payment_report WHERE daily_payment_report.store_id=stores.id) AS payments,
									(SELECT IFNULL(ROUND(SUM(total_sales),2),"0")  FROM daily_sales_entry WHERE daily_sales_entry.store_id=stores.id) AS sales,
									(SELECT IFNULL(ROUND(SUM(total_price),2),"0")  FROM inventory WHERE inventory.store_id=stores.id) AS inventory
									'))
						//->leftJoin('daily_payment_report', 'daily_payment_report.store_id', '=', 'stores.id')
						//->leftJoin('daily_sales_entry', 'daily_sales_entry.store_id', '=', 'stores.id')
						//->leftJoin('inventory', 'inventory.store_id', '=', 'stores.id')
						->where('stores.status','=',1)
						->groupBy('stores.id')
						->get();
			}
			return response()->json(['status' =>'1', 'Store_list'=>$store_data]);
		}
		else
		{
			return response()->json(['status'=>'0', 'error_msg' =>'Token is invalid or expired!']);
		}
	}
	public function add_store(Request $request, JWTAuth $JWTAuth)
	{
		$user = $JWTAuth->parseToken()->authenticate();
		if(($user && $user->role == "admin")||true)
		{
			$data1=array(
				"name"=>$request->get('name'),
     	 		"address"=>$request->get('address'),
				"contact_no"=>$request->get('contact_no'),
				"created_by"=>$request->get('user_id'),
     	 		);
     	 		$new_store = new Stores2($data1);
				$new_store->save();
     	 		if($new_store) {
				return response()->json(['status'=>'1', 'data' =>'Store successfully added!']);
        	   }else {
        	   return response()->json(['status'=>'0', 'error_msg' =>'Some error occured!']);
        	   	}
		}
		else
		{
			return response()->json(['status'=>'0', 'error_msg' =>'Token is invalid or expired!']);
		}
	}
	public function edit_store(Request $request, JWTAuth $JWTAuth)
	{
		$user = $JWTAuth->parseToken()->authenticate();
		if(($user && $user->role == "admin")||true)
		{
			$id = $request->get('id');
			$current_data = Stores2::where(array("id"=>$id, "status"=>1))->first();
			return response()->json(['status' =>'1', 'store_data'=>$current_data]);
		}
		else
		{
			return response()->json(['status'=>'0', 'error_msg' =>'Token is invalid or expired!']);
		}
	}
	public function update_store_info(Request $request, JWTAuth $JWTAuth)
	{
		$user = $JWTAuth->parseToken()->authenticate();
		if(($user && $user->role == "admin")||true)
		{
			$id = $request->get('id');
			$store_data = $request->all();
			$store_data['updated_by'] = $request->get('user_id');
			$update = Stores2::where('id','=',$id)->update($store_data);
				if($update) 
				{
					return response()->json(['status' =>'1', 'data' =>'Store details updated!']);
				}
				else
				{
					return response()->json(['status' =>'0', 'error_msg' =>'Store details not updated!']);
				}
		}
		else
		{
			return response()->json(['status'=>'0', 'error_msg' =>'Token is invalid or expired!']);
		}
	}
	public function delete_store(Request $request, JWTAuth $JWTAuth)
	{
		$user = $JWTAuth->parseToken()->authenticate();
		if(($user && $user->role == "admin")||true)
		{
			$id = $request->get('id');
			$up = array("status"=>0, "deleted_by"=>$request->get('user_id'));
			$del = Stores2::where(array("id"=>$id))->update($up);
			if($del){
				return response()->json(['status'=>'1', 'data' =>'Store successfully deleted!']);
			}else{
				return response()->json(['status'=>'0', 'error_msg' =>'Some error occured!']);
			}
		}
		else
		{
			return response()->json(['status'=>'0', 'error_msg' =>'Token is invalid or expired!']);
		}
	}
	public function item_list(Request $request, JWTAuth $JWTAuth)
	{
		$user = $JWTAuth->parseToken()->authenticate();
		if($user || true)
		{
			$item_data = Items2::where(array("status"=>1))->get();
			return response()->json(['status' =>'1', 'item_list'=>$item_data]);
		}
		else
		{
			return response()->json(['status'=>'0', 'error_msg' =>'Token is invalid or expired!']);
		}
	}
	public function add_item(Request $request, JWTAuth $JWTAuth)
	{
		$user = $JWTAuth->parseToken()->authenticate();
		if(($user && $user->role == "admin")||true)
		{
			$data1=array(
				"name"=>$request->get('name'),
     	 		"status"=>$request->get('status'),
     	 		);
     	 		$new_item = new Items2($data1);
				$new_item->save();
     	 		if($new_item) {
				return response()->json(['status'=>'1', 'data' =>'Item successfully added!']);
        	   }else {
        	   return response()->json(['status'=>'0', 'error_msg' =>'Some error occured!']);
        	   	}
		}
		else
		{
			return response()->json(['status'=>'0', 'error_msg' =>'Token is invalid or expired!']);
		}
	}
	public function edit_item(Request $request, JWTAuth $JWTAuth)
	{
		$user = $JWTAuth->parseToken()->authenticate();
		if(($user && $user->role == "admin")||true)
		{
			$id = $request->get('id');
			$current_data = Items2::where(array("id"=>$id, "status"=>1))->first();
			return response()->json(['status' =>'1', 'item_data'=>$current_data]);
		}
		else
		{
			return response()->json(['status'=>'0', 'error_msg' =>'Token is invalid or expired!']);
		}
	}
	public function update_item_info(Request $request, JWTAuth $JWTAuth)
	{
		$user = $JWTAuth->parseToken()->authenticate();
		if(($user && $user->role == "admin")||true)
		{
			$id = $request->get('id');
			$store_data = $request->all();
			$update = Items2::where('id','=',$id)->update($store_data);
				if($update) 
				{
					return response()->json(['status' =>'1', 'data' =>'Item details updated!']);
				}
				else
				{
					return response()->json(['status' =>'0', 'error_msg' =>'Item details not updated!']);
				}
			
		}
		else
		{
			return response()->json(['status'=>'0', 'error_msg' =>'Token is invalid or expired!']);
		}
	}
	public function delete_item(Request $request, JWTAuth $JWTAuth)
	{
		$user = $JWTAuth->parseToken()->authenticate();
		if(($user && $user->role == "admin")||true)
		{
			$id = $request->get('id');
			$del = Items2::where(array("id"=>$id))->update(array("status"=>0));
			if($del){
				return response()->json(['status'=>'1', 'data' =>'Item successfully deleted!']);
			}else{
				return response()->json(['status'=>'0', 'error_msg' =>'Some error occured!']);
			}
		}
		else
		{
			return response()->json(['status'=>'0', 'error_msg' =>'Token is invalid or expired!']);
		}
	}
	public function vendor_list(Request $request, JWTAuth $JWTAuth)
	{
		$user = $JWTAuth->parseToken()->authenticate();
		if($user || true)
		{
			$item_data = Vendors2::where(array("status"=>1))->get();
			return response()->json(['status' =>'1', 'vendor_list'=>$item_data]);
		}
		else
		{
			return response()->json(['status'=>'0', 'error_msg' =>'Token is invalid or expired!']);
		}
	}
	public function add_vendor(Request $request, JWTAuth $JWTAuth)
	{
		$user = $JWTAuth->parseToken()->authenticate();
		if(($user && $user->role == "admin")||true)
		{
			$data1=array(
				"name"=>$request->get('name'),
     	 		"status"=>$request->get('status'),
     	 		);
     	 		$new_item = new Vendors2($data1);
				$new_item->save();
     	 		if($new_item) {
				return response()->json(['status'=>'1', 'data' =>'Vendor successfully added!']);
        	   }else {
        	   return response()->json(['status'=>'0', 'error_msg' =>'Some error occured!']);
        	   	}
		}
		else
		{
			return response()->json(['status'=>'0', 'error_msg' =>'Token is invalid or expired!']);
		}
	}
	public function edit_vendor(Request $request, JWTAuth $JWTAuth)
	{
		$user = $JWTAuth->parseToken()->authenticate();
		if(($user && $user->role == "admin")||true)
		{
			$id = $request->get('id');
			$current_data = Vendors2::where(array("id"=>$id, "status"=>1))->first();
			return response()->json(['status' =>'1', 'vendor_data'=>$current_data]);
		}
		else
		{
			return response()->json(['status'=>'0', 'error_msg' =>'Token is invalid or expired!']);
		}
	}
	public function update_vendor_info(Request $request, JWTAuth $JWTAuth)
	{
		$user = $JWTAuth->parseToken()->authenticate();
		if(($user && $user->role == "admin")||true)
		{
			$id = $request->get('id');
			$store_data = $request->all();
			$update = Vendors2::where('id','=',$id)->update($store_data);
				if($update) 
				{
					return response()->json(['status' =>'1', 'data' =>'Vendors details updated!']);
				}
				else
				{
					return response()->json(['status' =>'0', 'error_msg' =>'Vendor details not updated!']);
				}
			
		}
		else
		{
			return response()->json(['status'=>'0', 'error_msg' =>'Token is invalid or expired!']);
		}
	}
	public function delete_vendor(Request $request, JWTAuth $JWTAuth)
	{
		$user = $JWTAuth->parseToken()->authenticate();
		if(($user && $user->role == "admin")||true)
		{
			$id = $request->get('id');
			$del = Vendors2::where(array("id"=>$id))->update(array("status"=>0));
			if($del){
				return response()->json(['status'=>'1', 'data' =>'Vendor successfully deleted!']);
			}else{
				return response()->json(['status'=>'0', 'error_msg' =>'some error occured!']);
			}
		}
		else
		{
			return response()->json(['status'=>'0', 'error_msg' =>'Token is invalid or expired!']);
		}
	}
	public function get_store_data(Request $request, JWTAuth $JWTAuth)
	{
		$user = $JWTAuth->parseToken()->authenticate();
		if(($user && $user->role == "admin")||true)
		{
			$id = $request->get('id');
			$item_data = DB::table('stores')
						->select(DB::raw(
									'stores.*,
									(SELECT IFNULL(SUM(total),"0")  FROM daily_payment_report WHERE daily_payment_report.store_id=stores.id) AS payments,
									(SELECT IFNULL(SUM(total_sales),"0")  FROM daily_sales_entry WHERE daily_sales_entry.store_id=stores.id) AS sales,
									(SELECT IFNULL(SUM(total_price),"0")  FROM inventory WHERE inventory.store_id=stores.id) AS inventory,
									
									(SELECT IFNULL(SUM(daily_sales_entry.inside),"0")  FROM daily_sales_entry WHERE daily_sales_entry.store_id=stores.id) AS inside,
									(SELECT IFNULL(SUM(daily_sales_entry.tax),"0")  FROM daily_sales_entry WHERE daily_sales_entry.store_id=stores.id) AS tax,
									(SELECT IFNULL(SUM(daily_sales_entry.gas),"0")  FROM daily_sales_entry WHERE daily_sales_entry.store_id=stores.id) AS gas,
									(SELECT IFNULL(SUM(daily_sales_entry.phone_card),"0")  FROM daily_sales_entry WHERE daily_sales_entry.store_id=stores.id) AS phone_card,
									(SELECT IFNULL(SUM(daily_sales_entry.lottery),"0")  FROM daily_sales_entry WHERE daily_sales_entry.store_id=stores.id) AS lottery,
									
									(SELECT IFNULL(SUM(daily_payment_report.total_cash),"0")  FROM daily_payment_report WHERE daily_payment_report.store_id=stores.id) AS total_cash,
									(SELECT IFNULL(SUM(daily_payment_report.total_credit),"0")  FROM daily_payment_report WHERE daily_payment_report.store_id=stores.id) AS total_credit,
									(SELECT IFNULL(SUM(daily_payment_report.total_debit),"0")  FROM daily_payment_report WHERE daily_payment_report.store_id=stores.id) AS total_debit,
									(SELECT IFNULL(SUM(daily_payment_report.lottery_out),"0")  FROM daily_payment_report WHERE daily_payment_report.store_id=stores.id) AS lottery_out
									'))
						->leftJoin('daily_payment_report', 'daily_payment_report.store_id', '=', 'stores.id')
						->leftJoin('daily_sales_entry', 'daily_sales_entry.store_id', '=', 'stores.id')
						->leftJoin('inventory', 'inventory.store_id', '=', 'stores.id')
						->where('stores.id','=',$id)
						->where('stores.status','=','1')
						->groupBy('stores.id')
						->first();
			return response()->json(['status' =>'1', 'store_data'=>$item_data]);
		}
		else
		{
			return response()->json(['status'=>'0', 'error_msg' =>'Token is invalid or expired!']);
		}
	}
		public function store_in_profit(Request $request, JWTAuth $JWTAuth)
	{
		
		$user = $JWTAuth->parseToken()->authenticate();
		if(($user && $user->role == "admin")||true)
		{
			$user_id = $request->get('user_id');
			$user = User2::where(array("id"=>$user_id))->first();
			$store_access = $user['store_access'];
			
			$id = $request->get('id');
			$date_from = $request->get('from');
			$date_to = $request->get('to');
			if(!empty($date_from) && !empty($date_to) && $id !=0){
				$stores = DB::table('stores')
						->select(DB::raw(
									"stores.*,
									(SELECT IFNULL(ROUND(SUM(total),2),'0')  FROM daily_payment_report WHERE daily_payment_report.status=1 and daily_payment_report.store_id=stores.id and DATE(daily_payment_report.date)>='$date_from' and DATE(daily_payment_report.date)<='$date_to') AS payments,
									(SELECT IFNULL(ROUND(SUM(total_sales),2),'0')  FROM daily_sales_entry WHERE daily_sales_entry.status=1 and daily_sales_entry.store_id=stores.id and daily_sales_entry.date>='$date_from' and daily_sales_entry.date<='$date_to') AS sales,
									(SELECT IFNULL(ROUND(SUM(add_money),2),'0')  FROM ATM WHERE ATM.status=1 and ATM.store_id=stores.id and DATE(ATM.date)>='$date_from' and DATE(ATM.date)<='$date_to') AS atm,
									(SELECT IFNULL(ROUND(SUM(price),2),'0')  FROM inventory WHERE inventory.status=1 and  inventory.store_id=stores.id and DATE(inventory.date)>='$date_from' and DATE(inventory.date)<='$date_to') AS inventory,
									(SELECT IFNULL(ROUND(SUM(available_stock),2),'0')  FROM cigarettes WHERE cigarettes.status=1 and  cigarettes.store_id=stores.id and DATE(cigarettes.date)>='$date_from' and DATE(cigarettes.date)<='$date_to') AS cigarettes,
									(SELECT IFNULL(ROUND(SUM(price),2),'0')  FROM expense WHERE expense.status=1 and expense.store_id=stores.id and DATE(expense.date)>='$date_from' and DATE(expense.date)<='$date_to') AS expense,
									IFNULL( (SELECT     IFNULL(ROUND((total), 2), '0')   FROM    lottery   WHERE lottery.status = 1     AND lottery.store_id = stores.id      AND DATE(lottery.date) >= '$date_from'    AND DATE(lottery.date) <= '$date_to' ORDER BY lottery.`date` DESC LIMIT 0,1) ,0)AS lottery,
									(SELECT IFNULL(ROUND(SUM(weekly_commission),2),'0')  FROM lottery WHERE lottery.status=1 and lottery.store_id=stores.id and DATE(lottery.date)>='$date_from' and DATE(lottery.date)<='$date_to') AS weekly_commission,
									(SELECT IFNULL(ROUND(SUM(weekly_eft_ammount),2),'0')  FROM lottery WHERE lottery.status=1 and lottery.store_id=stores.id and DATE(lottery.date)>='$date_from' and DATE(lottery.date)<='$date_to') AS weekly_eft_ammount
									"))
						->where('stores.id','=',$id)
						->where('stores.status','=','1')
						->get();
				if($stores->count()<=0){
					return response()->json(['status' =>'0', 'error_msg'=>'No records found for given date range!']);
				}else{
					$cnt=0;
					$total=0;
					$total_payments=0;
					$total_sales=0;
					$total_inventory=0;
					$total_atm=0;
					$total_cigarettes=0;
					$total_expense=0;
					$total_lottery=0;
					$total_weekly_eft_ammount=0;
					$total_weekly_commission=0;
					$ttt = 0;
					$oversort=0;
						foreach($stores as $s){
						$total += $s->payments+$s->sales+$s->inventory+$s->atm+$s->cigarettes+$s->expense+$s->lottery;
						$ttt = $s->payments - $s->sales;
						$total_payments += $s->payments;
						$total_sales +=$s->sales;
						$total_inventory += $s->inventory;
						$total_atm += $s->atm;
						$total_cigarettes += $s->cigarettes;
						$total_expense += $s->expense;
						$total_lottery += $s->lottery;
						$total_weekly_commission += $s->weekly_commission;
						$total_weekly_eft_ammount += $s->weekly_eft_ammount;
						$oversort += $ttt;
							$cnt++;
						}
						$total_payments = round($total_payments,2);
						$total_sales = round($total_sales,2);
						$total_inventory = round($total_inventory,2);
						$total_atm = round($total_atm,2);
						$total_cigarettes = round($total_cigarettes,2);
						$total_expense = round($total_expense,2);
						$total_lottery = round($total_lottery,2);
						$total_weekly_commission = round($total_weekly_commission,2);
						$total_weekly_eft_ammount = round($total_weekly_eft_ammount,2);
						$oversort = round($oversort,2);
						$op = array("total_payments"=>strval($total_payments),"total_sales"=>strval($total_sales),"total_inventory"=>strval($total_inventory),"oversort"=>strval($oversort),"total_atm"=>strval($total_atm),"total_cigarettes"=>strval($total_cigarettes),"total_expense"=>strval($total_expense),"total_lottery"=>strval($total_lottery),"total_weekly_commission"=>strval($total_weekly_commission),"total_weekly_eft_ammount"=>strval($total_weekly_eft_ammount));
					return response()->json(['status' =>'1', 'stores'=>$stores, 'total'=>$op]);
				}
			}else if($id == 0){
				if(!empty($store_access)){
					$stores = DB::table('stores')
							->select(DB::raw(
									"stores.*,
									(SELECT IFNULL(ROUND(SUM(total),2),'0')  FROM daily_payment_report WHERE daily_payment_report.status=1 and daily_payment_report.store_id=stores.id and DATE(daily_payment_report.date)>='$date_from' and DATE(daily_payment_report.date)<='$date_to') AS payments,
									(SELECT IFNULL(ROUND(SUM(total_sales),2),'0')  FROM daily_sales_entry WHERE daily_sales_entry.status=1 and daily_sales_entry.store_id=stores.id and daily_sales_entry.date>='$date_from' and daily_sales_entry.date<='$date_to') AS sales,
									(SELECT IFNULL(ROUND(SUM(add_money),2),'0')  FROM ATM WHERE ATM.status=1 and ATM.store_id=stores.id and DATE(ATM.date)>='$date_from' and DATE(ATM.date)<='$date_to') AS atm,
									(SELECT IFNULL(ROUND(SUM(price),2),'0')  FROM inventory WHERE inventory.status=1 and  inventory.store_id=stores.id and DATE(inventory.date)>='$date_from' and DATE(inventory.date)<='$date_to') AS inventory,
									(SELECT IFNULL(ROUND(SUM(available_stock),2),'0')  FROM cigarettes WHERE cigarettes.status=1 and  cigarettes.store_id=stores.id and DATE(cigarettes.date)>='$date_from' and DATE(cigarettes.date)<='$date_to') AS cigarettes,
									(SELECT IFNULL(ROUND(SUM(price),2),'0')  FROM expense WHERE expense.status=1 and expense.store_id=stores.id and DATE(expense.date)>='$date_from' and DATE(expense.date)<='$date_to') AS expense,
									IFNULL( (SELECT     IFNULL(ROUND((total), 2), '0')   FROM    lottery   WHERE lottery.status = 1     AND lottery.store_id = stores.id      AND DATE(lottery.date) >= '$date_from'    AND DATE(lottery.date) <= '$date_to' ORDER BY lottery.`date` DESC LIMIT 0,1) ,0)AS lottery,
									(SELECT IFNULL(ROUND(SUM(weekly_commission),2),'0')  FROM lottery WHERE lottery.status=1 and lottery.store_id=stores.id and DATE(lottery.date)>='$date_from' and DATE(lottery.date)<='$date_to') AS weekly_commission,
									(SELECT IFNULL(ROUND(SUM(weekly_eft_ammount),2),'0')  FROM lottery WHERE lottery.status=1 and lottery.store_id=stores.id and DATE(lottery.date)>='$date_from' and DATE(lottery.date)<='$date_to') AS weekly_eft_ammount
									"))
							->where('stores.status','=','1')
							->whereRaw('stores.id IN('.$store_access.')')
							->get();
				}else{
					$stores = DB::table('stores')
							->select(DB::raw(
									"stores.*,
									(SELECT IFNULL(ROUND(SUM(total),2),'0')  FROM daily_payment_report WHERE daily_payment_report.status=1 and daily_payment_report.store_id=stores.id and DATE(daily_payment_report.date)>='$date_from' and DATE(daily_payment_report.date)<='$date_to') AS payments,
									(SELECT IFNULL(ROUND(SUM(total_sales),2),'0')  FROM daily_sales_entry WHERE daily_sales_entry.status=1 and daily_sales_entry.store_id=stores.id and daily_sales_entry.date>='$date_from' and daily_sales_entry.date<='$date_to') AS sales,
									(SELECT IFNULL(ROUND(SUM(add_money),2),'0')  FROM ATM WHERE ATM.status=1 and ATM.store_id=stores.id and DATE(ATM.date)>='$date_from' and DATE(ATM.date)<='$date_to') AS atm,
									(SELECT IFNULL(ROUND(SUM(price),2),'0')  FROM inventory WHERE inventory.status=1 and  inventory.store_id=stores.id and DATE(inventory.date)>='$date_from' and DATE(inventory.date)<='$date_to') AS inventory,
									(SELECT IFNULL(ROUND(SUM(available_stock),2),'0')  FROM cigarettes WHERE cigarettes.status=1 and  cigarettes.store_id=stores.id and DATE(cigarettes.date)>='$date_from' and DATE(cigarettes.date)<='$date_to') AS cigarettes,
									(SELECT IFNULL(ROUND(SUM(price),2),'0')  FROM expense WHERE expense.status=1 and expense.store_id=stores.id and DATE(expense.date)>='$date_from' and DATE(expense.date)<='$date_to') AS expense,
									IFNULL( (SELECT     IFNULL(ROUND((total), 2), '0')   FROM    lottery   WHERE lottery.status = 1     AND lottery.store_id = stores.id      AND DATE(lottery.date) >= '$date_from'    AND DATE(lottery.date) <= '$date_to' ORDER BY lottery.`date` DESC LIMIT 0,1) ,0)AS lottery,
									(SELECT IFNULL(ROUND(SUM(weekly_commission),2),'0')  FROM lottery WHERE lottery.status=1 and lottery.store_id=stores.id and DATE(lottery.date)>='$date_from' and DATE(lottery.date)<='$date_to') AS weekly_commission,
									(SELECT IFNULL(ROUND(SUM(weekly_eft_ammount),2),'0')  FROM lottery WHERE lottery.status=1 and lottery.store_id=stores.id and DATE(lottery.date)>='$date_from' and DATE(lottery.date)<='$date_to') AS weekly_eft_ammount
									"))
							->where('stores.status','=','1')
							->get();
				}
						
				if($stores->count()<=0){
					return response()->json(['status' =>'0', 'error_msg'=>'No records found for given date range!']);
				}else{
					$cnt=0;
					$total=0;
					$total_payments=0;
					$total_sales=0;
					$total_inventory=0;
					$total_atm=0;
					$total_cigarettes=0;
					$total_expense=0;
					$total_lottery=0;
					$total_weekly_eft_ammount=0;
					$total_weekly_commission=0;
					$ttt =0;
					$oversort=0;
						foreach($stores as $s){
						$total += $s->payments+$s->sales+$s->inventory+$s->atm+$s->cigarettes+$s->expense+$s->lottery;
						$ttt = $s->payments - $s->sales;
						$total_payments += $s->payments;
						$total_sales +=$s->sales;
						$total_inventory += $s->inventory;
						$total_atm += $s->atm;
						$total_cigarettes += $s->cigarettes;
						$total_expense += $s->expense;
						$total_lottery += $s->lottery;
						$total_weekly_commission += $s->weekly_commission;
						$total_weekly_eft_ammount += $s->weekly_eft_ammount;
						$oversort += $ttt;
							$cnt++;
						}
						$total_payments = round($total_payments,2);
						$total_sales = round($total_sales,2);
						$total_inventory = round($total_inventory,2);
						$total_atm = round($total_atm,2);
						$total_cigarettes = round($total_cigarettes,2);
						$total_expense = round($total_expense,2);
						$total_lottery = round($total_lottery,2);
						$total_weekly_commission = round($total_weekly_commission,2);
						$total_weekly_eft_ammount = round($total_weekly_eft_ammount,2);
						$oversort = round($oversort,2);
						$op = array("total_payments"=>strval($total_payments),"total_sales"=>strval($total_sales),"total_inventory"=>strval($total_inventory),"oversort"=>strval($oversort),"total_atm"=>strval($total_atm),"total_cigarettes"=>strval($total_cigarettes),"total_expense"=>strval($total_expense),"total_lottery"=>strval($total_lottery),"total_weekly_commission"=>strval($total_weekly_commission),"total_weekly_eft_ammount"=>strval($total_weekly_eft_ammount));
					return response()->json(['status' =>'1', 'stores'=>$stores, 'total'=>$op]);
				}
			}else{
				return response()->json(['status'=>'0', 'error_msg' =>'Provide store id and date or provide store id as 0 to view all store data!']);
			}
		}
		else
		{
			return response()->json(['status'=>'0', 'error_msg' =>'Token is invalid or expired!']);
		}
	}
	
	public function store_in_profit2(Request $request, JWTAuth $JWTAuth)
	{
		
		$user = $JWTAuth->parseToken()->authenticate();
		if(($user && $user->role == "admin")||true)
		{
			$user_id = $request->get('user_id');
			$user = User2::where(array("id"=>$user_id))->first();
			$store_access = $user['store_access'];
			//print_r($_REQUEST);
			$id = $request->get('id');
			$date_from = $request->get('from');
			$date_to = $request->get('to');
			
			//echo $date_from."  ".$date_to."  ".$id; die();
			//instant+lottery  lottery_cash+lottery_online_cashout+lottery_instant_cashout
			if(!empty($date_from) && !empty($date_to) && $id !=0){
				
				$stores = DB::table('stores')
						->select(DB::raw(
									"stores.*,
									(SELECT IFNULL(ROUND(SUM(lottery_online_cashout+lottery_instant_cashout),2),'0')  FROM daily_payment_report WHERE daily_payment_report.status=1 and daily_payment_report.store_id=stores.id and DATE(daily_payment_report.date)>='$date_from' and DATE(daily_payment_report.date)<='$date_to') AS payments_total,
									
									(SELECT IFNULL(ROUND(SUM(total_debit),2),'0')  FROM daily_payment_report WHERE daily_payment_report.status=1 and daily_payment_report.store_id=stores.id and DATE(daily_payment_report.date)>='$date_from' and DATE(daily_payment_report.date)<='$date_to') AS ebt,
									
									(SELECT IFNULL(ROUND(SUM(instant+lottery),2),'0')  FROM daily_sales_entry WHERE daily_sales_entry.status=1 and daily_sales_entry.store_id=stores.id and daily_sales_entry.date>='$date_from' and daily_sales_entry.date<='$date_to') AS total_lottery_sale,
									
									(SELECT IFNULL(ROUND(SUM(gas),2),'0')  FROM daily_sales_entry WHERE daily_sales_entry.status=1 and daily_sales_entry.store_id=stores.id and daily_sales_entry.date>='$date_from' and daily_sales_entry.date<='$date_to') AS total_gas,
									
									(SELECT IFNULL(ROUND(SUM(phone_card),2),'0')  FROM daily_sales_entry WHERE daily_sales_entry.status=1 and daily_sales_entry.store_id=stores.id and daily_sales_entry.date>='$date_from' and daily_sales_entry.date<='$date_to') AS phone_card,
									
									(SELECT IFNULL(ROUND(SUM(instant+lottery),2),'0')  FROM daily_sales_entry WHERE daily_sales_entry.status=1 and daily_sales_entry.store_id=stores.id and daily_sales_entry.date>='$date_from' and daily_sales_entry.date<='$date_to') AS sales_total,
									
									(SELECT IFNULL(ROUND(SUM(inside),2),'0')  FROM daily_sales_entry WHERE daily_sales_entry.status=1 and daily_sales_entry.store_id=stores.id and daily_sales_entry.date>='$date_from' and daily_sales_entry.date<='$date_to') AS total_inside,
									
									(SELECT IFNULL(ROUND(SUM(tax),2),'0')  FROM daily_sales_entry WHERE daily_sales_entry.status=1 and daily_sales_entry.store_id=stores.id and daily_sales_entry.date>='$date_from' and daily_sales_entry.date<='$date_to') AS total_tax,
									
									(SELECT IFNULL(ROUND(SUM(meat),2),'0')  FROM daily_sales_entry WHERE daily_sales_entry.status=1 and daily_sales_entry.store_id=stores.id and daily_sales_entry.date>='$date_from' and daily_sales_entry.date<='$date_to') AS total_meat,
									
									(SELECT IFNULL(ROUND(SUM(coupon),2),'0')  FROM daily_payment_report WHERE daily_payment_report.status=1 and daily_payment_report.store_id=stores.id and DATE(daily_payment_report.date)>='$date_from' and DATE(daily_payment_report.date)<='$date_to') AS total_coupon,
									
									(SELECT IFNULL(ROUND(SUM(mobile_coupon),2),'0')  FROM daily_payment_report WHERE daily_payment_report.status=1 and daily_payment_report.store_id=stores.id and DATE(daily_payment_report.date)>='$date_from' and DATE(daily_payment_report.date)<='$date_to') AS total_mobile_coupon,
									
									(SELECT IFNULL(ROUND(SUM(total),2),'0')  FROM daily_payment_report WHERE daily_payment_report.status=1 and daily_payment_report.store_id=stores.id and DATE(daily_payment_report.date)>='$date_from' and DATE(daily_payment_report.date)<='$date_to') AS payments,
									
									(SELECT ROUND((SELECT IFNULL(ROUND(SUM(total),2),'0')  FROM daily_payment_report WHERE daily_payment_report.status=1 and daily_payment_report.store_id=stores.id and DATE(daily_payment_report.date)>='$date_from' and DATE(daily_payment_report.date)<='$date_to') - (SELECT IFNULL(ROUND(SUM(total_sales),2),'0')  FROM daily_sales_entry WHERE daily_sales_entry.status=1 and daily_sales_entry.store_id=stores.id and daily_sales_entry.date>='$date_from' and daily_sales_entry.date<='$date_to'),2)) as oversort,
									
									(SELECT IFNULL(ROUND(SUM(total_sales),2),'0')  FROM daily_sales_entry WHERE daily_sales_entry.status=1 and daily_sales_entry.store_id=stores.id and daily_sales_entry.date>='$date_from' and daily_sales_entry.date<='$date_to') AS sales,
									(SELECT IFNULL(ROUND(SUM(add_money_order),2),'0')  FROM daily_sales_entry WHERE daily_sales_entry.status=1 and daily_sales_entry.store_id=stores.id and daily_sales_entry.date>='$date_from' and daily_sales_entry.date<='$date_to') AS total_money_order,
									
									
									
									(SELECT IFNULL(ROUND(SUM(beer),2),'0')  FROM daily_sales_entry WHERE daily_sales_entry.status=1 and daily_sales_entry.store_id=stores.id and daily_sales_entry.date>='$date_from' and daily_sales_entry.date<='$date_to') AS beer,
									(SELECT IFNULL(ROUND(SUM(grocery),2),'0')  FROM daily_sales_entry WHERE daily_sales_entry.status=1 and daily_sales_entry.store_id=stores.id and daily_sales_entry.date>='$date_from' and daily_sales_entry.date<='$date_to') AS grocery,
									(SELECT IFNULL(ROUND(SUM(pizza),2),'0')  FROM daily_sales_entry WHERE daily_sales_entry.status=1 and daily_sales_entry.store_id=stores.id and daily_sales_entry.date>='$date_from' and daily_sales_entry.date<='$date_to') AS pizza,
									(SELECT IFNULL(ROUND(SUM(deli),2),'0')  FROM daily_sales_entry WHERE daily_sales_entry.status=1 and daily_sales_entry.store_id=stores.id and daily_sales_entry.date>='$date_from' and daily_sales_entry.date<='$date_to') AS deli,
									(SELECT IFNULL(ROUND(SUM(cigarette),2),'0')  FROM daily_sales_entry WHERE daily_sales_entry.status=1 and daily_sales_entry.store_id=stores.id and daily_sales_entry.date>='$date_from' and daily_sales_entry.date<='$date_to') AS cigarette,
									(SELECT IFNULL(ROUND(SUM(ebt),2),'0')  FROM daily_sales_entry WHERE daily_sales_entry.status=1 and daily_sales_entry.store_id=stores.id and daily_sales_entry.date>='$date_from' and daily_sales_entry.date<='$date_to') AS ebt1,
									(SELECT IFNULL(ROUND(SUM(nontax),2),'0')  FROM daily_sales_entry WHERE daily_sales_entry.status=1 and daily_sales_entry.store_id=stores.id and daily_sales_entry.date>='$date_from' and daily_sales_entry.date<='$date_to') AS nontax,
									(SELECT IFNULL(ROUND(SUM(novelty),2),'0')  FROM daily_sales_entry WHERE daily_sales_entry.status=1 and daily_sales_entry.store_id=stores.id and daily_sales_entry.date>='$date_from' and daily_sales_entry.date<='$date_to') AS novelty,
									(SELECT IFNULL(ROUND(SUM(merchandise),2),'0')  FROM daily_sales_entry WHERE daily_sales_entry.status=1 and daily_sales_entry.store_id=stores.id and daily_sales_entry.date>='$date_from' and daily_sales_entry.date<='$date_to') AS merchandise,
									
									
									
									(SELECT IFNULL(ROUND(SUM(add_money),2),'0')  FROM ATM WHERE ATM.status=1 and ATM.store_id=stores.id and DATE(ATM.date)>='$date_from' and DATE(ATM.date)<='$date_to') AS atm,
									
									(SELECT IFNULL(ROUND(SUM(cash),2),'0')  FROM ATM WHERE ATM.status=1 and ATM.store_id=stores.id and DATE(ATM.date)>='$date_from' and DATE(ATM.date)<='$date_to') AS total_cash,
									
									(SELECT IFNULL(ROUND(SUM(fp),2),'0')  FROM ATM WHERE ATM.status=1 and ATM.store_id=stores.id and DATE(ATM.date)>='$date_from' and DATE(ATM.date)<='$date_to') AS total_fp,
									
									(SELECT IFNULL(ROUND(SUM(price),2),'0')  FROM inventory WHERE inventory.status=1 and  inventory.store_id=stores.id and DATE(inventory.date)>='$date_from' and DATE(inventory.date)<='$date_to') AS inventory,
									
									(SELECT IFNULL(ROUND(SUM(sale_cigarette),2),'0')  FROM cigarettes WHERE cigarettes.status=1 and  cigarettes.store_id=stores.id and DATE(cigarettes.date)>='$date_from' and DATE(cigarettes.date)<='$date_to') AS cigarettes,
									
									(SELECT IFNULL(ROUND(SUM(price),2),'0')  FROM expense WHERE expense.status=1 and expense.store_id=stores.id and DATE(expense.date)>='$date_from' and DATE(expense.date)<='$date_to') AS expense,
									
									IFNULL( (SELECT     IFNULL(ROUND((total), 2), '0')   FROM    lottery   WHERE lottery.status = 1     AND lottery.store_id = stores.id      AND DATE(lottery.date) >= '$date_from'    AND DATE(lottery.date) <= '$date_to' ORDER BY lottery.`date` DESC LIMIT 0,1) ,0)AS lottery,
									
									(SELECT IFNULL(ROUND(SUM(weekly_commission),2),'0')  FROM lottery WHERE lottery.status=1 and lottery.store_id=stores.id and DATE(lottery.date)>='$date_from' and DATE(lottery.date)<='$date_to') AS weekly_commission,
									
									(SELECT IFNULL(ROUND(SUM(weekly_eft_ammount),2),'0')  FROM lottery WHERE lottery.status=1 and lottery.store_id=stores.id and DATE(lottery.date)>='$date_from' and DATE(lottery.date)<='$date_to') AS weekly_eft_ammount,
									
									(SELECT IFNULL(ROUND(SUM(total_cash),2),'0')  FROM daily_payment_report WHERE daily_payment_report.status=1 and daily_payment_report.store_id=stores.id and DATE(daily_payment_report.date)>='$date_from' and DATE(daily_payment_report.date)<='$date_to') AS grand_total_cash,
									
									(SELECT IFNULL(ROUND(SUM(lottery_cash),2),'0')  FROM daily_payment_report WHERE daily_payment_report.status=1 and daily_payment_report.store_id=stores.id and DATE(daily_payment_report.date)>='$date_from' and DATE(daily_payment_report.date)<='$date_to') AS grand_lottery_cash
									
									"))
						->where('stores.id','=',$id)
						->where('stores.status','=','1')
						->get();
				if($stores->count()<=0){
					return response()->json(['status' =>'0', 'error_msg'=>'No records found for given date range!']);
				}else{
					$cnt=0;
					$total=0;
					$grand_total_cash=0;
					$total_payments=0;
					$total_sales=0;
					$total_inside=0;
					$total_tax=0;
					$total_meat=0;
					$total_coupon=0;
					$total_mobile_coupon=0;
					$total_gas=0;
					$total_lottery_sale=0;
					$total_phone_card=0;
					$total_ebt=0;
					$total_inventory=0;
					$total_atm=0;
					$total_cigarettes=0;
					$total_expense=0;
					$total_lottery=0;
					$total_weekly_eft_ammount=0;
					$weekly_tottaly_cashout=0;
					$total_weekly_commission=0;
					$total_cash=0;
					$total_fp=0;
					$ttt = 0;
					$opstore=array();					
					$oversort=0;
					$total_merchandise=0;
					$total_novelty=0;
					$total_nontax=0;
					$total_ebt1=0;
					$total_cigarette=0;
					$total_deli=0;
					$total_pizza=0;
					$total_grocery=0;
					$total_beer=0;
						foreach($stores as $s){
						$total += $s->payments+$s->sales+$s->inventory+$s->atm+$s->cigarettes+$s->expense+$s->lottery;
						$ttt = $s->payments - $s->sales; 
						$s->oversort = $ttt;
						$total_payments += $s->payments;
						$total_sales +=$s->sales;
						$total_inside +=$s->total_inside;
						$total_tax +=$s->total_tax;
						$total_meat +=$s->total_meat;
						$total_coupon +=$s->total_coupon;
						$total_mobile_coupon +=$s->total_mobile_coupon;
						$total_gas +=$s->total_gas;
						$total_lottery_sale +=$s->total_lottery_sale;
						$total_phone_card +=$s->phone_card;
						$total_ebt +=$s->ebt;
						$total_inventory += $s->inventory;
						$total_atm += $s->atm;
						$total_cigarettes += $s->cigarettes;
						$total_expense += $s->expense;
						$total_cash += $s->total_cash;
						$total_fp += $s->total_fp;
						$s->total_cash = strval($s->total_cash);
						$s->total_fp = strval($s->total_fp);
						$total_lottery += $s->lottery;
						$total_weekly_commission += $s->weekly_commission;
						$total_weekly_eft_ammount += $s->weekly_eft_ammount;
						$total_merchandise += $s->merchandise;
						$total_novelty += $s->novelty;
						$total_nontax += $s->nontax;
						$total_cigarette += $s->cigarette;
						$total_deli += $s->deli;
						$total_pizza += $s->pizza;
						$total_grocery += $s->grocery;
						$total_beer += $s->beer;
						$total_ebt1 +=$s->ebt1;
						$oversort += $ttt;
						$s1=(array)$s;

						$s1['weekly_cash_out']=$s->sales_total-$s->payments_total;
						$weekly_tottaly_cashout +=$s1['weekly_cash_out'];
						$s1['weekly_cash_out']=strval($s1['weekly_cash_out']);
						
						$opstore[]=$s1;						
						$cnt++;
						}
						$total_payments = round($total_payments,2);
						$total_sales = round($total_sales,2);
						$total_inside = round($total_inside,2);
						$total_tax = round($total_tax,2);
						$total_meat = round($total_meat,2);
						$total_coupon = round($total_coupon,2);
						$total_mobile_coupon = round($total_mobile_coupon,2);
						$total_gas = round($total_gas,2);
						$total_lottery_sale = round($total_lottery_sale,2);
						$total_phone_card = round($total_phone_card,2);
						$total_ebt = round($total_ebt,2);
						$total_inventory = round($total_inventory,2);
						$total_atm = round($total_atm,2);
						$total_cigarettes = round($total_cigarettes,2);
						$total_expense = round($total_expense,2);
						$total_cash =strval(round($total_cash,2));
						$total_fp =strval(round($total_fp,2));
						$total_lottery = round($total_lottery,2);
						$total_weekly_commission = round($total_weekly_commission,2);
						$total_weekly_eft_ammount = round($total_weekly_eft_ammount,2);
						
						$total_merchandise = round($total_merchandise,2);
						$total_novelty = round($total_novelty,2);
						$total_nontax = round($total_nontax,2);
						$total_cigarette = round($total_cigarette,2);
						$total_deli = round($total_deli,2);
						$total_pizza = round($total_pizza,2);
						$total_grocery = round($total_grocery,2);
						$total_beer = round($total_beer,2);
						$total_ebt1 = round($total_ebt1,2);
						
						$oversort = round($oversort,2);
						$op = array("total_payments"=>strval($total_payments),"total_sales"=>strval($total_sales),"total_inventory"=>strval($total_inventory),"oversort"=>strval($oversort),"total_atm"=>strval($total_atm),"total_cigarettes"=>strval($total_cigarettes),"total_expense"=>strval($total_expense),"total_lottery"=>strval($total_lottery),"total_weekly_commission"=>strval($total_weekly_commission),"total_weekly_eft_ammount"=>strval($total_weekly_eft_ammount),
						
						"total_merchandise"=>strval($total_merchandise),
						"total_novelty"=>strval($total_novelty),
						"total_nontax"=>strval($total_nontax),
						"total_cigarette"=>strval($total_cigarette),
						"total_deli"=>strval($total_deli),
						"total_pizza"=>strval($total_pizza),
						"total_grocery"=>strval($total_grocery),
						"total_beer"=>strval($total_beer),
						"total_ebt1"=>strval($total_ebt1),
						
						"total_weekly_cash_out"=>strval($weekly_tottaly_cashout), "total_cash"=>$total_cash, "total_inside"=>strval($total_inside), "total_tax"=>strval($total_tax),"total_meat"=>strval($total_meat),"total_coupon"=>strval($total_coupon),"total_mobile_coupon"=>strval($total_mobile_coupon), "total_lottery_sale"=>strval($total_lottery_sale), "total_fp"=>strval($total_fp), "phone_card"=>strval($total_phone_card), "total_gas"=>strval($total_gas), "total_ebt"=>strval($total_ebt));
					return response()->json(['status' =>'1', 'stores'=>$opstore, 'total'=>$op]);
				}
			}else if($id == 0){
				
				if(!empty($store_access)){
					$stores = DB::table('stores')
							->select(DB::raw(
									"stores.*,
									(SELECT IFNULL(ROUND(SUM(lottery_online_cashout+lottery_instant_cashout),2),'0')  FROM daily_payment_report WHERE daily_payment_report.status=1 and daily_payment_report.store_id=stores.id and DATE(daily_payment_report.date)>='$date_from' and DATE(daily_payment_report.date)<='$date_to') AS payments_total,
									
									(SELECT IFNULL(ROUND(SUM(total_debit),2),'0')  FROM daily_payment_report WHERE daily_payment_report.status=1 and daily_payment_report.store_id=stores.id and DATE(daily_payment_report.date)>='$date_from' and DATE(daily_payment_report.date)<='$date_to') AS ebt,
									
									(SELECT IFNULL(ROUND(SUM(instant+lottery),2),'0')  FROM daily_sales_entry WHERE daily_sales_entry.status=1 and daily_sales_entry.store_id=stores.id and daily_sales_entry.date>='$date_from' and daily_sales_entry.date<='$date_to') AS total_lottery_sale,
									
									(SELECT IFNULL(ROUND(SUM(gas),2),'0')  FROM daily_sales_entry WHERE daily_sales_entry.status=1 and daily_sales_entry.store_id=stores.id and daily_sales_entry.date>='$date_from' and daily_sales_entry.date<='$date_to') AS total_gas,
									
									(SELECT IFNULL(ROUND(SUM(phone_card),2),'0')  FROM daily_sales_entry WHERE daily_sales_entry.status=1 and daily_sales_entry.store_id=stores.id and daily_sales_entry.date>='$date_from' and daily_sales_entry.date<='$date_to') AS phone_card,
									
									(SELECT IFNULL(ROUND(SUM(instant+lottery),2),'0')  FROM daily_sales_entry WHERE daily_sales_entry.status=1 and daily_sales_entry.store_id=stores.id and daily_sales_entry.date>='$date_from' and daily_sales_entry.date<='$date_to') AS sales_total,
									
									(SELECT IFNULL(ROUND(SUM(inside),2),'0')  FROM daily_sales_entry WHERE daily_sales_entry.status=1 and daily_sales_entry.store_id=stores.id and daily_sales_entry.date>='$date_from' and daily_sales_entry.date<='$date_to') AS total_inside,
									
									(SELECT IFNULL(ROUND(SUM(tax),2),'0')  FROM daily_sales_entry WHERE daily_sales_entry.status=1 and daily_sales_entry.store_id=stores.id and daily_sales_entry.date>='$date_from' and daily_sales_entry.date<='$date_to') AS total_tax,
									
									(SELECT IFNULL(ROUND(SUM(meat),2),'0')  FROM daily_sales_entry WHERE daily_sales_entry.status=1 and daily_sales_entry.store_id=stores.id and daily_sales_entry.date>='$date_from' and daily_sales_entry.date<='$date_to') AS total_meat,
									
									(SELECT IFNULL(ROUND(SUM(coupon),2),'0')  FROM daily_payment_report WHERE daily_payment_report.status=1 and daily_payment_report.store_id=stores.id and DATE(daily_payment_report.date)>='$date_from' and DATE(daily_payment_report.date)<='$date_to') AS total_coupon,
									
									(SELECT IFNULL(ROUND(SUM(mobile_coupon),2),'0')  FROM daily_payment_report WHERE daily_payment_report.status=1 and daily_payment_report.store_id=stores.id and DATE(daily_payment_report.date)>='$date_from' and DATE(daily_payment_report.date)<='$date_to') AS total_mobile_coupon,
									
									(SELECT IFNULL(ROUND(SUM(total),2),'0')  FROM daily_payment_report WHERE daily_payment_report.status=1 and daily_payment_report.store_id=stores.id and DATE(daily_payment_report.date)>='$date_from' and DATE(daily_payment_report.date)<='$date_to') AS payments,
									
									(SELECT ROUND((SELECT IFNULL(ROUND(SUM(total),2),'0')  FROM daily_payment_report WHERE daily_payment_report.status=1 and daily_payment_report.store_id=stores.id and DATE(daily_payment_report.date)>='$date_from' and DATE(daily_payment_report.date)<='$date_to') - (SELECT IFNULL(ROUND(SUM(total_sales),2),'0')  FROM daily_sales_entry WHERE daily_sales_entry.status=1 and daily_sales_entry.store_id=stores.id and daily_sales_entry.date>='$date_from' and daily_sales_entry.date<='$date_to'),2)) as oversort,
									
									(SELECT IFNULL(ROUND(SUM(total_sales),2),'0')  FROM daily_sales_entry WHERE daily_sales_entry.status=1 and daily_sales_entry.store_id=stores.id and daily_sales_entry.date>='$date_from' and daily_sales_entry.date<='$date_to') AS sales,
									(SELECT IFNULL(ROUND(SUM(add_money_order),2),'0')  FROM daily_sales_entry WHERE daily_sales_entry.status=1 and daily_sales_entry.store_id=stores.id and daily_sales_entry.date>='$date_from' and daily_sales_entry.date<='$date_to') AS total_money_order,
									
									
									(SELECT IFNULL(ROUND(SUM(beer),2),'0')  FROM daily_sales_entry WHERE daily_sales_entry.status=1 and daily_sales_entry.store_id=stores.id and daily_sales_entry.date>='$date_from' and daily_sales_entry.date<='$date_to') AS beer,
									(SELECT IFNULL(ROUND(SUM(grocery),2),'0')  FROM daily_sales_entry WHERE daily_sales_entry.status=1 and daily_sales_entry.store_id=stores.id and daily_sales_entry.date>='$date_from' and daily_sales_entry.date<='$date_to') AS grocery,
									(SELECT IFNULL(ROUND(SUM(pizza),2),'0')  FROM daily_sales_entry WHERE daily_sales_entry.status=1 and daily_sales_entry.store_id=stores.id and daily_sales_entry.date>='$date_from' and daily_sales_entry.date<='$date_to') AS pizza,
									(SELECT IFNULL(ROUND(SUM(deli),2),'0')  FROM daily_sales_entry WHERE daily_sales_entry.status=1 and daily_sales_entry.store_id=stores.id and daily_sales_entry.date>='$date_from' and daily_sales_entry.date<='$date_to') AS deli,
									(SELECT IFNULL(ROUND(SUM(cigarette),2),'0')  FROM daily_sales_entry WHERE daily_sales_entry.status=1 and daily_sales_entry.store_id=stores.id and daily_sales_entry.date>='$date_from' and daily_sales_entry.date<='$date_to') AS cigarette,
									(SELECT IFNULL(ROUND(SUM(ebt),2),'0')  FROM daily_sales_entry WHERE daily_sales_entry.status=1 and daily_sales_entry.store_id=stores.id and daily_sales_entry.date>='$date_from' and daily_sales_entry.date<='$date_to') AS ebt1,
									(SELECT IFNULL(ROUND(SUM(nontax),2),'0')  FROM daily_sales_entry WHERE daily_sales_entry.status=1 and daily_sales_entry.store_id=stores.id and daily_sales_entry.date>='$date_from' and daily_sales_entry.date<='$date_to') AS nontax,
									(SELECT IFNULL(ROUND(SUM(novelty),2),'0')  FROM daily_sales_entry WHERE daily_sales_entry.status=1 and daily_sales_entry.store_id=stores.id and daily_sales_entry.date>='$date_from' and daily_sales_entry.date<='$date_to') AS novelty,
									(SELECT IFNULL(ROUND(SUM(merchandise),2),'0')  FROM daily_sales_entry WHERE daily_sales_entry.status=1 and daily_sales_entry.store_id=stores.id and daily_sales_entry.date>='$date_from' and daily_sales_entry.date<='$date_to') AS merchandise,
									
									
									(SELECT IFNULL(ROUND(SUM(add_money),2),'0')  FROM ATM WHERE ATM.status=1 and ATM.store_id=stores.id and DATE(ATM.date)>='$date_from' and DATE(ATM.date)<='$date_to') AS atm,
									
									(SELECT IFNULL(ROUND(SUM(cash),2),'0')  FROM ATM WHERE ATM.status=1 and ATM.store_id=stores.id and DATE(ATM.date)>='$date_from' and DATE(ATM.date)<='$date_to') AS total_cash,
									
									(SELECT IFNULL(ROUND(SUM(fp),2),'0')  FROM ATM WHERE ATM.status=1 and ATM.store_id=stores.id and DATE(ATM.date)>='$date_from' and DATE(ATM.date)<='$date_to') AS total_fp,
									
									(SELECT IFNULL(ROUND(SUM(price),2),'0')  FROM inventory WHERE inventory.status=1 and  inventory.store_id=stores.id and DATE(inventory.date)>='$date_from' and DATE(inventory.date)<='$date_to') AS inventory,
									
									(SELECT IFNULL(ROUND(SUM(sale_cigarette),2),'0')  FROM cigarettes WHERE cigarettes.status=1 and  cigarettes.store_id=stores.id and DATE(cigarettes.date)>='$date_from' and DATE(cigarettes.date)<='$date_to') AS cigarettes,
									
									(SELECT IFNULL(ROUND(SUM(price),2),'0')  FROM expense WHERE expense.status=1 and expense.store_id=stores.id and DATE(expense.date)>='$date_from' and DATE(expense.date)<='$date_to') AS expense,
									
									IFNULL( (SELECT     IFNULL(ROUND((total), 2), '0')   FROM    lottery   WHERE lottery.status = 1     AND lottery.store_id = stores.id      AND DATE(lottery.date) >= '$date_from'    AND DATE(lottery.date) <= '$date_to' ORDER BY lottery.`date` DESC LIMIT 0,1) ,0)AS lottery,
									
									(SELECT IFNULL(ROUND(SUM(weekly_commission),2),'0')  FROM lottery WHERE lottery.status=1 and lottery.store_id=stores.id and DATE(lottery.date)>='$date_from' and DATE(lottery.date)<='$date_to') AS weekly_commission,
									
									(SELECT IFNULL(ROUND(SUM(weekly_eft_ammount),2),'0')  FROM lottery WHERE lottery.status=1 and lottery.store_id=stores.id and DATE(lottery.date)>='$date_from' and DATE(lottery.date)<='$date_to') AS weekly_eft_ammount,
									(SELECT IFNULL(ROUND(SUM(total_cash),2),'0')  FROM daily_payment_report WHERE daily_payment_report.status=1 and daily_payment_report.store_id=stores.id and DATE(daily_payment_report.date)>='$date_from' and DATE(daily_payment_report.date)<='$date_to') AS grand_total_cash,
									
									(SELECT IFNULL(ROUND(SUM(lottery_cash),2),'0')  FROM daily_payment_report WHERE daily_payment_report.status=1 and daily_payment_report.store_id=stores.id and DATE(daily_payment_report.date)>='$date_from' and DATE(daily_payment_report.date)<='$date_to') AS grand_lottery_cash
									"))
							->where('stores.status','=','1')
							->whereRaw('stores.id IN('.$store_access.')')
							->get();
				}else{
					$stores = DB::table('stores')
							->select(DB::raw(
									"stores.*,
									(SELECT IFNULL(ROUND(SUM(lottery_online_cashout+lottery_instant_cashout),2),'0')  FROM daily_payment_report WHERE daily_payment_report.status=1 and daily_payment_report.store_id=stores.id and DATE(daily_payment_report.date)>='$date_from' and DATE(daily_payment_report.date)<='$date_to') AS payments_total,
									
									(SELECT IFNULL(ROUND(SUM(total_debit),2),'0')  FROM daily_payment_report WHERE daily_payment_report.status=1 and daily_payment_report.store_id=stores.id and DATE(daily_payment_report.date)>='$date_from' and DATE(daily_payment_report.date)<='$date_to') AS ebt,
									
									(SELECT IFNULL(ROUND(SUM(instant+lottery),2),'0')  FROM daily_sales_entry WHERE daily_sales_entry.status=1 and daily_sales_entry.store_id=stores.id and daily_sales_entry.date>='$date_from' and daily_sales_entry.date<='$date_to') AS total_lottery_sale,
									
									(SELECT IFNULL(ROUND(SUM(gas),2),'0')  FROM daily_sales_entry WHERE daily_sales_entry.status=1 and daily_sales_entry.store_id=stores.id and daily_sales_entry.date>='$date_from' and daily_sales_entry.date<='$date_to') AS total_gas,
									
									(SELECT IFNULL(ROUND(SUM(phone_card),2),'0')  FROM daily_sales_entry WHERE daily_sales_entry.status=1 and daily_sales_entry.store_id=stores.id and daily_sales_entry.date>='$date_from' and daily_sales_entry.date<='$date_to') AS phone_card,
									
									(SELECT IFNULL(ROUND(SUM(instant+lottery),2),'0')  FROM daily_sales_entry WHERE daily_sales_entry.status=1 and daily_sales_entry.store_id=stores.id and daily_sales_entry.date>='$date_from' and daily_sales_entry.date<='$date_to') AS sales_total,
									
									(SELECT IFNULL(ROUND(SUM(inside),2),'0')  FROM daily_sales_entry WHERE daily_sales_entry.status=1 and daily_sales_entry.store_id=stores.id and daily_sales_entry.date>='$date_from' and daily_sales_entry.date<='$date_to') AS total_inside,
									
									(SELECT IFNULL(ROUND(SUM(tax),2),'0')  FROM daily_sales_entry WHERE daily_sales_entry.status=1 and daily_sales_entry.store_id=stores.id and daily_sales_entry.date>='$date_from' and daily_sales_entry.date<='$date_to') AS total_tax,
									
									(SELECT IFNULL(ROUND(SUM(meat),2),'0')  FROM daily_sales_entry WHERE daily_sales_entry.status=1 and daily_sales_entry.store_id=stores.id and daily_sales_entry.date>='$date_from' and daily_sales_entry.date<='$date_to') AS total_meat,
									
									(SELECT IFNULL(ROUND(SUM(coupon),2),'0')  FROM daily_payment_report WHERE daily_payment_report.status=1 and daily_payment_report.store_id=stores.id and DATE(daily_payment_report.date)>='$date_from' and DATE(daily_payment_report.date)<='$date_to') AS total_coupon,
									
									(SELECT IFNULL(ROUND(SUM(mobile_coupon),2),'0')  FROM daily_payment_report WHERE daily_payment_report.status=1 and daily_payment_report.store_id=stores.id and DATE(daily_payment_report.date)>='$date_from' and DATE(daily_payment_report.date)<='$date_to') AS total_mobile_coupon,
									
									(SELECT IFNULL(ROUND(SUM(total),2),'0')  FROM daily_payment_report WHERE daily_payment_report.status=1 and daily_payment_report.store_id=stores.id and DATE(daily_payment_report.date)>='$date_from' and DATE(daily_payment_report.date)<='$date_to') AS payments,
									
									(SELECT ROUND((SELECT IFNULL(ROUND(SUM(total),2),'0')  FROM daily_payment_report WHERE daily_payment_report.status=1 and daily_payment_report.store_id=stores.id and DATE(daily_payment_report.date)>='$date_from' and DATE(daily_payment_report.date)<='$date_to') - (SELECT IFNULL(ROUND(SUM(total_sales),2),'0')  FROM daily_sales_entry WHERE daily_sales_entry.status=1 and daily_sales_entry.store_id=stores.id and daily_sales_entry.date>='$date_from' and daily_sales_entry.date<='$date_to'),2)) as oversort,
									
									(SELECT IFNULL(ROUND(SUM(total_sales),2),'0')  FROM daily_sales_entry WHERE daily_sales_entry.status=1 and daily_sales_entry.store_id=stores.id and daily_sales_entry.date>='$date_from' and daily_sales_entry.date<='$date_to') AS sales,
									(SELECT IFNULL(ROUND(SUM(add_money_order),2),'0')  FROM daily_sales_entry WHERE daily_sales_entry.status=1 and daily_sales_entry.store_id=stores.id and daily_sales_entry.date>='$date_from' and daily_sales_entry.date<='$date_to') AS total_money_order,
									
									
									(SELECT IFNULL(ROUND(SUM(beer),2),'0')  FROM daily_sales_entry WHERE daily_sales_entry.status=1 and daily_sales_entry.store_id=stores.id and daily_sales_entry.date>='$date_from' and daily_sales_entry.date<='$date_to') AS beer,
									(SELECT IFNULL(ROUND(SUM(grocery),2),'0')  FROM daily_sales_entry WHERE daily_sales_entry.status=1 and daily_sales_entry.store_id=stores.id and daily_sales_entry.date>='$date_from' and daily_sales_entry.date<='$date_to') AS grocery,
									(SELECT IFNULL(ROUND(SUM(pizza),2),'0')  FROM daily_sales_entry WHERE daily_sales_entry.status=1 and daily_sales_entry.store_id=stores.id and daily_sales_entry.date>='$date_from' and daily_sales_entry.date<='$date_to') AS pizza,
									(SELECT IFNULL(ROUND(SUM(deli),2),'0')  FROM daily_sales_entry WHERE daily_sales_entry.status=1 and daily_sales_entry.store_id=stores.id and daily_sales_entry.date>='$date_from' and daily_sales_entry.date<='$date_to') AS deli,
									(SELECT IFNULL(ROUND(SUM(cigarette),2),'0')  FROM daily_sales_entry WHERE daily_sales_entry.status=1 and daily_sales_entry.store_id=stores.id and daily_sales_entry.date>='$date_from' and daily_sales_entry.date<='$date_to') AS cigarette,
									(SELECT IFNULL(ROUND(SUM(ebt),2),'0')  FROM daily_sales_entry WHERE daily_sales_entry.status=1 and daily_sales_entry.store_id=stores.id and daily_sales_entry.date>='$date_from' and daily_sales_entry.date<='$date_to') AS ebt1,
									(SELECT IFNULL(ROUND(SUM(nontax),2),'0')  FROM daily_sales_entry WHERE daily_sales_entry.status=1 and daily_sales_entry.store_id=stores.id and daily_sales_entry.date>='$date_from' and daily_sales_entry.date<='$date_to') AS nontax,
									(SELECT IFNULL(ROUND(SUM(novelty),2),'0')  FROM daily_sales_entry WHERE daily_sales_entry.status=1 and daily_sales_entry.store_id=stores.id and daily_sales_entry.date>='$date_from' and daily_sales_entry.date<='$date_to') AS novelty,
									(SELECT IFNULL(ROUND(SUM(merchandise),2),'0')  FROM daily_sales_entry WHERE daily_sales_entry.status=1 and daily_sales_entry.store_id=stores.id and daily_sales_entry.date>='$date_from' and daily_sales_entry.date<='$date_to') AS merchandise,
									
									
									(SELECT IFNULL(ROUND(SUM(add_money),2),'0')  FROM ATM WHERE ATM.status=1 and ATM.store_id=stores.id and DATE(ATM.date)>='$date_from' and DATE(ATM.date)<='$date_to') AS atm,
									
									(SELECT IFNULL(ROUND(SUM(cash),2),'0')  FROM ATM WHERE ATM.status=1 and ATM.store_id=stores.id and DATE(ATM.date)>='$date_from' and DATE(ATM.date)<='$date_to') AS total_cash,
									
									(SELECT IFNULL(ROUND(SUM(fp),2),'0')  FROM ATM WHERE ATM.status=1 and ATM.store_id=stores.id and DATE(ATM.date)>='$date_from' and DATE(ATM.date)<='$date_to') AS total_fp,
									
									(SELECT IFNULL(ROUND(SUM(price),2),'0')  FROM inventory WHERE inventory.status=1 and  inventory.store_id=stores.id and DATE(inventory.date)>='$date_from' and DATE(inventory.date)<='$date_to') AS inventory,
									
									(SELECT IFNULL(ROUND(SUM(sale_cigarette),2),'0')  FROM cigarettes WHERE cigarettes.status=1 and  cigarettes.store_id=stores.id and DATE(cigarettes.date)>='$date_from' and DATE(cigarettes.date)<='$date_to') AS cigarettes,
									
									(SELECT IFNULL(ROUND(SUM(price),2),'0')  FROM expense WHERE expense.status=1 and expense.store_id=stores.id and DATE(expense.date)>='$date_from' and DATE(expense.date)<='$date_to') AS expense,
									
									IFNULL( (SELECT     IFNULL(ROUND((total), 2), '0')   FROM    lottery   WHERE lottery.status = 1     AND lottery.store_id = stores.id      AND DATE(lottery.date) >= '$date_from'    AND DATE(lottery.date) <= '$date_to' ORDER BY lottery.`date` DESC LIMIT 0,1) ,0)AS lottery,
									
									(SELECT IFNULL(ROUND(SUM(weekly_commission),2),'0')  FROM lottery WHERE lottery.status=1 and lottery.store_id=stores.id and DATE(lottery.date)>='$date_from' and DATE(lottery.date)<='$date_to') AS weekly_commission,
									
									(SELECT IFNULL(ROUND(SUM(weekly_eft_ammount),2),'0')  FROM lottery WHERE lottery.status=1 and lottery.store_id=stores.id and DATE(lottery.date)>='$date_from' and DATE(lottery.date)<='$date_to') AS weekly_eft_ammount,
									(SELECT IFNULL(ROUND(SUM(total_cash),2),'0')  FROM daily_payment_report WHERE daily_payment_report.status=1 and daily_payment_report.store_id=stores.id and DATE(daily_payment_report.date)>='$date_from' and DATE(daily_payment_report.date)<='$date_to') AS grand_total_cash,
									
									(SELECT IFNULL(ROUND(SUM(lottery_cash),2),'0')  FROM daily_payment_report WHERE daily_payment_report.status=1 and daily_payment_report.store_id=stores.id and DATE(daily_payment_report.date)>='$date_from' and DATE(daily_payment_report.date)<='$date_to') AS grand_lottery_cash
									"))
							->where('stores.status','=','1')
							->get();
				}
						
				if($stores->count()<=0){
					
					
					return response()->json(['status' =>'0', 'error_msg'=>'No records found for given date range!']);
				}else{
					
					$cnt=0;
					$total=0;
					$total_payments=0;
					$total_sales=0;
					$total_inside=0;
					$total_tax=0;
					$total_meat=0;
					$total_coupon=0;
					$total_mobile_coupon=0;
					$total_gas=0;
					$total_lottery_sale=0;
					$total_phone_card=0;
					$total_ebt=0;
					$total_inventory=0;
					$total_atm=0;
					$total_cigarettes=0;
					$total_expense=0;
					$total_lottery=0;
					$total_weekly_eft_ammount=0;
					$total_weekly_commission=0;
					$ttt =0;
					$weekly_tottaly_cashout=0;
					$total_cash=0;
					$total_fp=0;
					$oversort=0;
					$opstore=array();
					$total_merchandise=0;
					$total_novelty=0;
					$total_nontax=0;
					$total_ebt1=0;
					$total_cigarette=0;
					$total_deli=0;
					$total_pizza=0;
					$total_grocery=0;
					$total_beer=0;
						foreach($stores as $s){
							
						$total += $s->payments+$s->sales+$s->inventory+$s->atm+$s->cigarettes+$s->expense+$s->lottery;
						//$ttt = $s->payments - $s->sales;
						$ttt = $s->payments - $s->sales ; 
						$s->oversort = $ttt;
						$total_payments += $s->payments;
						$total_sales +=$s->sales;
						$total_inside +=$s->total_inside;
						$total_tax +=$s->total_tax;
						$total_meat +=$s->total_meat;
						$total_coupon +=$s->total_coupon;
						$total_mobile_coupon +=$s->total_mobile_coupon;
						$total_gas +=$s->total_gas;
						$total_lottery_sale +=$s->total_lottery_sale;
						$total_phone_card +=$s->phone_card;
						$total_ebt +=$s->ebt;
						$total_inventory += $s->inventory;
						$total_atm += $s->atm;
						$total_cigarettes += $s->cigarettes;
						$total_expense += $s->expense;
						$total_cash += $s->total_cash;
						$total_fp += $s->total_fp;
						$s->total_cash = strval($s->total_cash);
						$s->total_fp = strval($s->total_fp);
						$total_lottery += $s->lottery;
						$total_weekly_commission += $s->weekly_commission;
						$total_weekly_eft_ammount += $s->weekly_eft_ammount;
						$total_merchandise += $s->merchandise;
						$total_novelty += $s->novelty;
						$total_nontax += $s->nontax;
						$total_cigarette += $s->cigarette;
						$total_deli += $s->deli;
						$total_pizza += $s->pizza;
						$total_grocery += $s->grocery;
						$total_beer += $s->beer;
						$total_ebt1 +=$s->ebt1;
						$oversort += $ttt;
						$s1=(array)$s;
						$s1['weekly_cash_out']=$s->sales_total-$s->payments_total;
						$weekly_tottaly_cashout +=$s1['weekly_cash_out'];
						$s1['weekly_cash_out']=strval($s1['weekly_cash_out']);
						
						$opstore[]=$s1;
						$cnt++;
						}
						$total_payments = round($total_payments,2);
						$total_sales = round($total_sales,2);
						$total_inventory = round($total_inventory,2);
						$total_atm = round($total_atm,2);
						$total_inside = round($total_inside,2);
						$total_tax = round($total_tax,2);
						$total_meat = round($total_meat,2);
						$total_coupon = round($total_coupon,2);
						$total_mobile_coupon = round($total_mobile_coupon,2);
						$total_gas = round($total_gas,2);
						$total_lottery_sale = round($total_lottery_sale,2);
						$total_phone_card = round($total_phone_card,2);
						$total_ebt = round($total_ebt,2);
						$total_cigarettes = round($total_cigarettes,2);
						$total_expense = round($total_expense,2);
						$total_lottery = round($total_lottery,2);
						$total_weekly_commission = round($total_weekly_commission,2);
						$total_weekly_eft_ammount = round($total_weekly_eft_ammount,2);
						
						$total_merchandise = round($total_merchandise,2);
						$total_novelty = round($total_novelty,2);
						$total_nontax = round($total_nontax,2);
						$total_cigarette = round($total_cigarette,2);
						$total_deli = round($total_deli,2);
						$total_pizza = round($total_pizza,2);
						$total_grocery = round($total_grocery,2);
						$total_beer = round($total_beer,2);
						$total_ebt1 = round($total_ebt1,2);
						
						$oversort = round($oversort,2);
						$total_cash =strval(round($total_cash,2));
						$total_fp =strval(round($total_fp,2));
						$op = array("total_payments"=>strval($total_payments),"total_sales"=>strval($total_sales),"total_inventory"=>strval($total_inventory),"oversort"=>strval($oversort),"total_atm"=>strval($total_atm),"total_cigarettes"=>strval($total_cigarettes),"total_expense"=>strval($total_expense),"total_lottery"=>strval($total_lottery),"total_weekly_commission"=>strval($total_weekly_commission),"total_weekly_eft_ammount"=>strval($total_weekly_eft_ammount),
						
						"total_merchandise"=>strval($total_merchandise),
						"total_novelty"=>strval($total_novelty),
						"total_nontax"=>strval($total_nontax),
						"total_cigarette"=>strval($total_cigarette),
						"total_deli"=>strval($total_deli),
						"total_pizza"=>strval($total_pizza),
						"total_grocery"=>strval($total_grocery),
						"total_beer"=>strval($total_beer),
						"total_ebt1"=>strval($total_ebt1),
						
						"total_weekly_cash_out"=>strval($weekly_tottaly_cashout), "total_cash"=>$total_cash, "total_inside"=>strval($total_inside), "total_tax"=>strval($total_tax),"total_meat"=>strval($total_meat),"total_coupon"=>strval($total_coupon),"total_mobile_coupon"=>strval($total_mobile_coupon),"total_lottery_sale"=>strval($total_lottery_sale), "total_fp"=>strval($total_fp), "phone_card"=>strval($total_phone_card), "total_gas"=>strval($total_gas), "total_ebt"=>strval($total_ebt));
					return response()->json(['status' =>'1', 'stores'=>$opstore, 'total'=>$op]);
				}
			}else{
				return response()->json(['status'=>'0', 'error_msg' =>'Provide store id and date or provide store id as 0 to view all store data!']);
			}
		}
		else
		{
			return response()->json(['status'=>'0', 'error_msg' =>'Token is invalid or expired!']);
		}
	}
	public function user_report(Request $request, JWTAuth $JWTAuth)
	{
		
		$user = $JWTAuth->parseToken()->authenticate();
		if(($user && $user->role == "admin")||true)
		{
			$user_id = $request->get('user_id');
			$id = $request->get('id');
			$date_from = $request->get('from');
			$date_to = $request->get('to');
			$shift = $request->get('shift');
			
			$user = User2::where(array("id"=>$user_id))->first();
			$store_access = $user['store_access'];
			
			 $payments = "SELECT  users.id as user_id, stores.id as store_id, IFNULL(ROUND(SUM(lottery_online_cashout+lottery_instant_cashout),2),'0') as payments_total,IFNULL(ROUND(SUM(coupon),2),'0') as total_coupon,IFNULL(ROUND(SUM(mobile_coupon),2),'0') as total_mobile_coupon,IFNULL(ROUND(SUM(total_debit),2),'0') as ebt, IFNULL(ROUND(SUM(total),2),'0') as payments FROM daily_payment_report left join users on users.id=daily_payment_report.user_id left join stores on stores.id=daily_payment_report.store_id WHERE daily_payment_report.status=1 and daily_payment_report.store_id=stores.id and DATE(daily_payment_report.date)>='$date_from' and DATE(daily_payment_report.date)<='$date_to' ".( ($shift != "ALL")?"and users.shift='$shift' ":" ").(($id != 0 )? " and users.id ='$id' ":" ").""."group by users.id "; 
			 
			$sales = "SELECT IFNULL(ROUND(SUM(instant+lottery),2),'0') as total_lottery_sale,
			IFNULL(ROUND(SUM(phone_card),2),'0') as phone_card, 
			IFNULL(ROUND(SUM(instant+lottery),2),'0') as sales_total,
			IFNULL(ROUND(SUM(inside),2),'0') as total_inside,
			IFNULL(ROUND(SUM(tax),2),'0') as total_tax,
			IFNULL(ROUND(SUM(total_sales),2),'0') as sales,
			IFNULL(ROUND(SUM(gas),2),'0') as total_gas, 
			IFNULL(ROUND(SUM(meat),2),'0') as total_meat,
			IFNULL(ROUND(SUM(beer),2),'0') as beer,
			IFNULL(ROUND(SUM(grocery),2),'0') as grocery, 
			IFNULL(ROUND(SUM(pizza),2),'0') as pizza,
			IFNULL(ROUND(SUM(deli),2),'0') as deli,
			IFNULL(ROUND(SUM(cigarette),2),'0') as cigarette,
			IFNULL(ROUND(SUM(ebt),2),'0') as ebt1,
			IFNULL(ROUND(SUM(nontax),2),'0') as nontax,
			IFNULL(ROUND(SUM(novelty),2),'0') as novelty,
			IFNULL(ROUND(SUM(merchandise),2),'0') as merchandise,
			
			stores.name as store_name, 
			stores.id as store_id, 
			users.id as user_id, users.name as user_name FROM daily_sales_entry left join users on users.id=daily_sales_entry.user_id left join stores on stores.id=daily_sales_entry.store_id WHERE daily_sales_entry.status=1 and daily_sales_entry.store_id=stores.id and DATE(daily_sales_entry.date)>='$date_from' and DATE(daily_sales_entry.date)<='$date_to' ".( ($shift != "ALL")?"and users.shift='$shift' ":" ").(($id != 0 )? " and users.id ='$id' ":" ").""."group by users.id ";
			
			$atm = "(SELECT IFNULL(ROUND(SUM(add_money),2),'0') as atm, IFNULL(ROUND(SUM(cash),2),'0') as total_cash, IFNULL(ROUND(SUM(fp),2),'0') as total_fp, users.name as user_name, users.id as user_id, stores.name as store_name, stores.id as store_id FROM ATM left join users on users.id=ATM.user_id left join stores on stores.id=ATM.store_id WHERE ATM.status=1 and ATM.store_id=stores.id and DATE(ATM.date)>='$date_from' and DATE(ATM.date)<='$date_to' ".( ($shift != "ALL")?"and users.shift='$shift' ":" ").(($id != 0 )? " and users.id ='$id' ":" ")." "."group by users.id )";
			
			$lottery = "SELECT IFNULL(ROUND((total), 2), '0') AS lottery,IFNULL(ROUND(SUM(weekly_commission),2),'0') as weekly_commission,IFNULL(ROUND(SUM(weekly_eft_ammount),2),'0') as weekly_eft_ammount,users.name as user_name, users.id as user_id, stores.name as store_name, stores.id as store_id FROM lottery left join users on users.id=lottery.user_id left join stores on stores.id=lottery.store_id  WHERE lottery.status = 1 AND lottery.store_id = stores.id AND DATE(lottery.date) >= '$date_from'    AND DATE(lottery.date) <= '$date_to' ".( ($shift != "ALL")?"and users.shift='$shift' ":" ").(($id != 0 )? " and users.id ='$id' ":" ")."  "." group by users.id  ORDER BY lottery.`date` DESC LIMIT 0,1";
			
			$inventory = "(SELECT IFNULL(ROUND(SUM(price),2),'0') as inventory,users.name as user_name,users.id as user_id,stores.name as store_name, stores.id as store_id FROM inventory left join users on users.id=inventory.user_id left join stores on stores.id=inventory.store_id WHERE inventory.status=1 and  inventory.store_id=stores.id and DATE(inventory.date)>='$date_from' and DATE(inventory.date)<='$date_to' ".( ($shift != "ALL")?"and users.shift='$shift' ":" ").(($id != 0 )? " and users.id ='$id' ":" ")."  "."group by users.id )";
			
			$cigarettes = "(SELECT IFNULL(ROUND(SUM(sale_cigarette),2),'0') as cigarettes,users.name as user_name,users.id as user_id, stores.name as store_name,stores.id as store_id FROM cigarettes left join users on users.id=cigarettes.user_id left join stores on stores.id=cigarettes.store_id WHERE cigarettes.status=1 and  cigarettes.store_id=stores.id and DATE(cigarettes.date)>='$date_from' and DATE(cigarettes.date)<='$date_to' ".( ($shift != "ALL")?"and users.shift='$shift' ":" ").(($id != 0 )? " and users.id ='$id' ":" ")." "."group by users.id )";
			
		  	$expense = "(SELECT IFNULL(ROUND(SUM(price),2),'0') as expense,users.name as user_name,users.id as user_id, stores.name as store_name,stores.id as store_id FROM expense left join users on users.id=expense.user_id left join stores on stores.id=expense.store_id WHERE expense.status=1 and expense.store_id=stores.id and DATE(expense.date)>='$date_from' and DATE(expense.date)<='$date_to' ".( ($shift != "ALL")?"and users.shift='$shift' ":" ").(($id != 0 )? " and users.id ='$id' ":" ")." "."group by users.id )";

			$gran_total_cash = "SELECT  users.id as user_id, stores.id as store_id, IFNULL(ROUND(SUM(total_cash+lottery_cash),2),'0') as grand_total FROM daily_payment_report left join users on users.id=daily_payment_report.user_id left join stores on stores.id=daily_payment_report.store_id WHERE daily_payment_report.status=1 and daily_payment_report.store_id=stores.id and DATE(daily_payment_report.date)>='$date_from' and DATE(daily_payment_report.date)<='$date_to' ".( ($shift != "ALL")?"and users.shift='$shift' ":" ").(($id != 0 )? " and users.id ='$id' ":" ").""."group by users.id "; 
			
			
			$output=array();
			$test = DB::select($payments);
			foreach($test as  $p){
				$output[$p->user_id]['payment']=$p;
				
			}
			$test = DB::select($sales);
			foreach($test as  $p){
				$output[$p->user_id]['sales']=$p;
				
			}
				$test = DB::select($atm);
			foreach($test as  $p){
				$output[$p->user_id]['atm']=$p;
				
			}	$test = DB::select($lottery);
			foreach($test as  $p){
				$output[$p->user_id]['lottery']=$p;
				
			}	$test = DB::select($inventory);
			foreach($test as  $p){
				$output[$p->user_id]['inventory']=$p;
				
			} $test = DB::select($cigarettes);
			foreach($test as  $p){
				$output[$p->user_id]['cigarettes']=$p;
				
			}
		$test = DB::select($expense);
			foreach($test as  $p){
				$output[$p->user_id]['expense']=$p;
				
			}
			
			$test = DB::select($gran_total_cash);
			foreach($test as  $p){
				$output[$p->user_id]['gran_total_cash']=$p;
				
			}
			
			$userid=array();
			foreach($output as $key => $value){
	if($key!=""){
  $userid[]= $key;
	}
}
		if(!empty($userid)){
			$users = User2::whereRaw("users.id in (". implode(',',$userid).")")->get();
		}
	
	

		$tempOutput=$output;
		$output=array();
		foreach($tempOutput as $key =>$s){
			if($key!=""){
			$s['name']="";
				$s['user_id']="";
			if(!isset($s['lottery'])){
				$s['lottery']=(object)array("lottery"=>0,"weekly_commission"=>0,"weekly_eft_ammount"=>0);
				}	
				if(!isset($s['atm'])){
				$s['atm']=(object)array("atm"=>0,"total_cash"=>0,"total_fp"=>0);
				}if(!isset($s['inventory'])){
				$s['inventory']=(object)array("inventory"=>0,"total_cash"=>0,"total_fp"=>0);
				}
				if(!isset($s['cigarettes'])){
				$s['cigarettes']=(object)array("cigarettes"=>0,"total_cash"=>0,"total_fp"=>0);
				}
				if(!isset($s['expense'])){
				$s['expense']=(object)array("expense"=>0,"total_cash"=>0,"total_fp"=>0);
				}
				if(!isset($s['gran_total_cash'])){
				$s['gran_total_cash']=(object)array("grand_total"=>0,"user_id"=>0,"store_id"=>0);
				}
				if(!isset($s['sales'])){
				$s['sales']=(object)array("total_lottery_sale"=>0,"phone_card"=>0,"sales_total"=>0,"total_inside"=>0,"total_tax"=>0,"sales"=>0, "total_gas"=>0,"total_meat"=>0,"beer"=>0,"grocery"=>0,"pizza"=>0,"deli"=>0,"cigarette"=>0,"ebt1"=>0, "nontax"=>0,"novelty"=>0,"merchandise"=>0);
				}
				if(!isset($s['payment'])){
				$s['payment']=(object)array("payments_total"=>"0","payments"=>"0","ebt"=>"0","total_coupon"=>"0","total_mobile_coupon"=>"0");
				}
			
			foreach($users as $u){
				if($u->id==$key){
				$s['name']=$u->name;
				$s['user_id']=strval($u->id);
			}
			}
		$output[]=	$s;
		}
		}
			
					$cnt=0;
					$total=0;
					$total_payments=0;
					$total_sales=0;
					$total_inside=0;
					$total_tax=0;
					$total_gas=0;
					$total_meat=0;
					$total_beer = 0;
					$total_grocery = 0;
					$total_pizza = 0;
					$total_deli = 0;
					$total_cigarette = 0;
					$total_ebt1 = 0;
					$total_nontax = 0;
					$total_novelty = 0;
					$total_merchandise = 0;
					$total_coupon = 0;
					$total_mobile_coupon = 0;
					$total_lottery_sale=0;
					$total_phone_card=0;
					$total_ebt=0;
					$total_inventory=0;
					$total_atm=0;
					$total_cigarettes=0;
					$total_expense=0;
					$total_lottery=0;
					$total_weekly_eft_ammount=0;
					$weekly_tottaly_cashout=0;
					$total_weekly_commission=0;
					$total_cash=0;
					$total_fp=0;
					$ttt = 0;
					$gran_total = 0;
						
$opstore=array();					$oversort=0;
						foreach($output as $s){
						
						
		$oversort= 0;
						if(isset($s['payment']->payment) && isset($s['sales']->sales)){
						$oversort=$s['payment']->payment- $s['sales']->sales;
						}else{
							$oversort = "0";
						}
						
						
		$s1=	array(
      "name"=>strval($s['name']),
    
      "user_id"=>strval( $s['user_id']),
      "status"=> "1",
      "payments_total"=>strval($s['payment']->payments_total),
      "total_lottery_sale"=>strval($s['sales']->total_lottery_sale),
      "phone_card"=>strval($s['sales']->phone_card),
      "sales_total"=> strval($s['sales']->sales_total),
      "total_inside"=> strval($s['sales']->total_inside),
      "total_tax"=> strval($s['sales']->total_tax),
	  "total_gas"=> strval($s['sales']->total_gas),
	  "total_meat"=> strval($s['sales']->total_meat),
	  "beer"=> strval($s['sales']->beer),
	  "grocery"=> strval($s['sales']->grocery),
	  "pizza"=> strval($s['sales']->pizza),
	  "deli"=> strval($s['sales']->deli),
	  "cigarette"=> strval($s['sales']->cigarette),
	  "ebt1"=> strval($s['sales']->ebt1),
	  "nontax"=> strval($s['sales']->nontax),
	  "novelty"=> strval($s['sales']->novelty),
	  "merchandise"=> strval($s['sales']->merchandise),
	  
	  
	  "total_coupon"=> strval($s['payment']->total_coupon),
	  "total_mobile_coupon"=> strval($s['payment']->total_mobile_coupon),
      "payments"=> strval($s['payment']->payments),
	  "ebt"=> strval($s['payment']->ebt),
      "oversort"=>strval($oversort),
      "sales"=> strval($s['sales']->sales),
      "atm"=>strval($s['atm']->atm),
      "total_cash"=>strval($s['atm']->total_cash),
      "total_fp"=> strval($s['atm']->total_fp),
      "inventory"=> strval($s['inventory']->inventory),
      "cigarettes"=> strval($s['cigarettes']->cigarettes),
      "expense"=>strval($s['expense']->expense),
      "lottery"=> strval($s['lottery']->lottery),
	  "grand_total_cash"=> strval($s['gran_total_cash']->grand_total),
      "weekly_commission"=>strval($s['lottery']->weekly_commission),
      "weekly_eft_ammount"=> strval($s['lottery']->weekly_eft_ammount),
      "weekly_cash_out"=>  strval($s['sales']->sales_total- $s['payment']->payments_total));
						$opstore[]=$s1;		
					
$s=(object)$s1;
	
						
							
						$total += $s->payments+$s->sales+$s->inventory+$s->atm+$s->cigarettes+$s->expense+$s->lottery;
						$ttt =$oversort;
						$total_payments += $s->payments;
						$total_sales +=$s->sales;
						$total_inside +=$s->total_inside;
						$total_tax +=$s->total_tax;
						$total_gas +=$s->total_gas;
						$total_meat +=$s->total_meat;
						$total_beer +=$s->beer;
						$total_grocery +=$s->grocery;
						$total_pizza +=$s->pizza;
						$total_deli +=$s->deli;
						$total_cigarette +=$s->cigarette;
						$total_ebt1 +=$s->ebt1;
						$total_nontax +=$s->nontax;
						$total_novelty +=$s->novelty;
						$total_merchandise +=$s->merchandise;
						$total_coupon +=$s->total_coupon;
						$total_mobile_coupon +=$s->total_mobile_coupon;
						$total_lottery_sale +=$s->total_lottery_sale;
						$total_phone_card +=$s->phone_card;
						$total_ebt +=$s->ebt;
						$total_inventory += $s->inventory;
						$total_atm += $s->atm;
						$total_cigarettes += $s->cigarettes;
						$total_expense += $s->expense;
						$total_cash += $s->total_cash;
						$total_fp += $s->total_fp;
						$s->total_cash = strval($s->total_cash);
						$s->total_fp = strval($s->total_fp);
						$total_lottery += $s->lottery;
						$total_weekly_commission += $s->weekly_commission;
						$total_weekly_eft_ammount += $s->weekly_eft_ammount;
						$oversort += $ttt;
						$gran_total +=$s->grand_total_cash;
						
						$cnt++;
						}
						$total_payments = round($total_payments,2);
						$total_sales = round($total_sales,2);
						$total_inside = round($total_inside,2);
						$total_tax = round($total_tax,2);
						$total_gas = round($total_gas,2);
						$total_meat = round($total_meat,2);
						$total_beer = round($total_beer,2);
						$total_grocery = round($total_grocery,2);
						$total_pizza = round($total_pizza,2);
						$total_deli = round($total_deli,2);
						$total_cigarette = round($total_cigarette,2);
						$total_ebt1 = round($total_ebt1,2);
						$total_nontax = round($total_nontax,2);
						$total_novelty = round($total_novelty,2);
						$total_merchandise = round($total_merchandise,2);
						$total_coupon = round($total_coupon,2);
						$total_mobile_coupon = round($total_mobile_coupon,2);
						$total_lottery_sale = round($total_lottery_sale,2);
						$total_phone_card = round($total_phone_card,2);
						$total_ebt = round($total_ebt,2);
						$total_inventory = round($total_inventory,2);
						$total_atm = round($total_atm,2);
						$total_cigarettes = round($total_cigarettes,2);
						$total_expense = round($total_expense,2);
						$total_cash =strval(round($total_cash,2));
						$total_fp =strval(round($total_fp,2));
						$total_lottery = round($total_lottery,2);
						$total_weekly_commission = round($total_weekly_commission,2);
						$total_weekly_eft_ammount = round($total_weekly_eft_ammount,2);
						$oversort = round($oversort,2);
						$gran_total = round($gran_total,2);
						$op = array("total_payments"=>strval($total_payments),
						"total_sales"=>strval($total_sales),
						"total_inventory"=>strval($total_inventory),
						"oversort"=>strval($oversort),
						"total_atm"=>strval($total_atm),
						"total_cigarettes"=>strval($total_cigarettes),
						"total_expense"=>strval($total_expense),
						"total_lottery"=>strval($total_lottery),
						"total_weekly_commission"=>strval($total_weekly_commission),
						"total_weekly_eft_ammount"=>strval($total_weekly_eft_ammount),
						"total_weekly_cash_out"=>strval($weekly_tottaly_cashout), 
						"total_cash"=>$total_cash, 
						"total_inside"=>strval($total_inside), 
						"total_tax"=>strval($total_tax), 
						"total_lottery_sale"=>strval($total_lottery_sale), 
						"total_fp"=>strval($total_fp), 
						"phone_card"=>strval($total_phone_card), 
						"total_gas"=>strval($total_gas), 
						"total_meat"=>strval($total_meat), 
						"total_beer" => strval($total_beer),
						"total_grocery" => strval($total_grocery),
						"total_pizza" => strval($total_pizza),
						"total_deli" => strval($total_deli),
						"total_cigarette" => strval($total_cigarette),
						"total_ebt1" => strval($total_ebt1),
						"total_nontax" => strval($total_nontax),
						"total_novelty" => strval($total_novelty),
						"total_merchandise" => strval($total_merchandise),
						"total_coupon"=>strval($total_coupon),
						"total_mobile_coupon"=>strval($total_mobile_coupon),
						"total_ebt"=>strval($total_ebt),
						"grand_total"=>strval($gran_total));
					return response()->json(['status' =>'1', 'stores'=>$opstore,'total'=>$op]);
				
		}
		else
		{
			return response()->json(['status'=>'0', 'error_msg' =>'Token is invalid or expired!']);
		}
	}
	
	public function user_store_in_profit(Request $request, JWTAuth $JWTAuth)
	{
		$user = $JWTAuth->parseToken()->authenticate();
		if(($user && $user->role == "admin")||true)
		{
			$user_id = $request->get('user_id');
			$id = $request->get('id');
			$date_from = $request->get('from');
			$date_to = $request->get('to');
			$shift = $request->get('shift');
			
			$user_data = User2::where(array("id"=>$id))->first();
			
			$user = User2::where(array("id"=>$user_id))->first();
			$store_access = $user['store_access'];
			
			 $payments = "SELECT  users.id as user_id, stores.id as store_id, IFNULL(ROUND(SUM(lottery_online_cashout+lottery_instant_cashout),2),'0') as payments_total,IFNULL(ROUND(SUM(coupon),2),'0') as total_coupon,IFNULL(ROUND(SUM(mobile_coupon),2),'0') as total_mobile_coupon,IFNULL(ROUND(SUM(total_debit),2),'0') as ebt ,IFNULL(ROUND(SUM(total),2),'0') as payments FROM daily_payment_report left join users on users.id=daily_payment_report.user_id left join stores on stores.id=daily_payment_report.store_id WHERE daily_payment_report.status=1 and daily_payment_report.store_id=stores.id and DATE(daily_payment_report.date)>='$date_from' and DATE(daily_payment_report.date)<='$date_to' ".( ($shift != "ALL")?"and users.shift='$shift' ":" ").(($id != 0 )? " and users.id ='$id' ":" ").""."group by  stores.id "; 
			
			$sales = "SELECT IFNULL(ROUND(SUM(instant+lottery),2),'0') as total_lottery_sale,
			IFNULL(ROUND(SUM(phone_card),2),'0') as phone_card, 
			IFNULL(ROUND(SUM(instant+lottery),2),'0') as sales_total,
			IFNULL(ROUND(SUM(inside),2),'0') as total_inside,
			IFNULL(ROUND(SUM(tax),2),'0') as total_tax,
			IFNULL(ROUND(SUM(total_sales),2),'0') as sales,
			IFNULL(ROUND(SUM(gas),2),'0') as total_gas,
			IFNULL(ROUND(SUM(meat),2),'0') as total_meat,
			IFNULL(ROUND(SUM(beer),2),'0') as beer,
			IFNULL(ROUND(SUM(grocery),2),'0') as grocery, 
			IFNULL(ROUND(SUM(pizza),2),'0') as pizza,
			IFNULL(ROUND(SUM(deli),2),'0') as deli,
			IFNULL(ROUND(SUM(cigarette),2),'0') as cigarette,
			IFNULL(ROUND(SUM(ebt),2),'0') as ebt1,
			IFNULL(ROUND(SUM(nontax),2),'0') as nontax,
			IFNULL(ROUND(SUM(novelty),2),'0') as novelty,
			IFNULL(ROUND(SUM(merchandise),2),'0') as merchandise,
			
			stores.name as store_name, 
			stores.id as store_id, 
			users.id as user_id,
			users.name as user_name FROM daily_sales_entry left join users on users.id=daily_sales_entry.user_id left join stores on stores.id=daily_sales_entry.store_id WHERE daily_sales_entry.status=1 and daily_sales_entry.store_id=stores.id and DATE(daily_sales_entry.date)>='$date_from' and DATE(daily_sales_entry.date)<='$date_to' ".( ($shift != "ALL")?"and users.shift='$shift' ":" ").(($id != 0 )? " and users.id ='$id' ":" ").""."group by stores.id";
			
			$atm = "(SELECT IFNULL(ROUND(SUM(add_money),2),'0') as atm, IFNULL(ROUND(SUM(cash),2),'0') as total_cash, IFNULL(ROUND(SUM(fp),2),'0') as total_fp, users.name as user_name, users.id as user_id, stores.name as store_name, stores.id as store_id FROM ATM left join users on users.id=ATM.user_id left join stores on stores.id=ATM.store_id WHERE ATM.status=1 and ATM.store_id=stores.id and DATE(ATM.date)>='$date_from' and DATE(ATM.date)<='$date_to' ".( ($shift != "ALL")?"and users.shift='$shift' ":" ").(($id != 0 )? " and users.id ='$id' ":" ")." "."group by  stores.id )";
			
			$lottery = "SELECT IFNULL(ROUND((total), 2), '0') AS lottery,IFNULL(ROUND(SUM(weekly_commission),2),'0') as weekly_commission,IFNULL(ROUND(SUM(weekly_eft_ammount),2),'0') as weekly_eft_ammount,users.name as user_name, users.id as user_id, stores.name as store_name, stores.id as store_id FROM lottery left join users on users.id=lottery.user_id left join stores on stores.id=lottery.store_id  WHERE lottery.status = 1 AND lottery.store_id = stores.id AND DATE(lottery.date) >= '$date_from'    AND DATE(lottery.date) <= '$date_to' ".( ($shift != "ALL")?"and users.shift='$shift' ":" ").(($id != 0 )? " and users.id ='$id' ":" ")."  "." group by  stores.id  ORDER BY lottery.`date` DESC LIMIT 0,1";
			
			$inventory = "(SELECT IFNULL(ROUND(SUM(price),2),'0') as inventory,users.name as user_name,users.id as user_id,stores.name as store_name, stores.id as store_id FROM inventory left join users on users.id=inventory.user_id left join stores on stores.id=inventory.store_id WHERE inventory.status=1 and  inventory.store_id=stores.id and DATE(inventory.date)>='$date_from' and DATE(inventory.date)<='$date_to' ".( ($shift != "ALL")?"and users.shift='$shift' ":" ").(($id != 0 )? " and users.id ='$id' ":" ")."  "."group by  stores.id )";
			
			$cigarettes = "(SELECT IFNULL(ROUND(SUM(sale_cigarette),2),'0') as cigarettes,users.name as user_name,users.id as user_id, stores.name as store_name,stores.id as store_id FROM cigarettes left join users on users.id=cigarettes.user_id left join stores on stores.id=cigarettes.store_id WHERE cigarettes.status=1 and  cigarettes.store_id=stores.id and DATE(cigarettes.date)>='$date_from' and DATE(cigarettes.date)<='$date_to' ".( ($shift != "ALL")?"and users.shift='$shift' ":" ").(($id != 0 )? " and users.id ='$id' ":" ")." "."group by  stores.id )";
			
		  	$expense = "(SELECT IFNULL(ROUND(SUM(price),2),'0') as expense,users.name as user_name,users.id as user_id, stores.name as store_name,stores.id as store_id FROM expense left join users on users.id=expense.user_id left join stores on stores.id=expense.store_id WHERE expense.status=1 and expense.store_id=stores.id and DATE(expense.date)>='$date_from' and DATE(expense.date)<='$date_to' ".( ($shift != "ALL")?"and users.shift='$shift' ":" ").(($id != 0 )? " and users.id ='$id' ":" ")." "."group by  stores.id )";
			
			$gran_total_cash = "(SELECT  users.id as user_id, stores.id as store_id, IFNULL(ROUND(SUM(total_cash+lottery_cash),2),'0') as grand_total FROM daily_payment_report left join users on users.id=daily_payment_report.user_id left join stores on stores.id=daily_payment_report.store_id WHERE daily_payment_report.status=1 and daily_payment_report.store_id=stores.id and DATE(daily_payment_report.date)>='$date_from' and DATE(daily_payment_report.date)<='$date_to' ".( ($shift != "ALL")?"and users.shift='$shift' ":" ").(($id != 0 )? " and users.id ='$id' ":" ").""."group by  stores.id )"; 
			
			$output=array();
			//echo $payments; die();
			$test = DB::select($payments);
			foreach($test as  $p){
				$output[$p->store_id]['payment']=$p;
				
			}
			$test = DB::select($sales);
			foreach($test as  $p){
				$output[$p->store_id]['sales']=$p;
				
			}
				$test = DB::select($atm);
			foreach($test as  $p){
				$output[$p->store_id]['atm']=$p;
				
			}	$test = DB::select($lottery);
			foreach($test as  $p){
				$output[$p->store_id]['lottery']=$p;
				
			}	$test = DB::select($inventory);
			foreach($test as  $p){
				$output[$p->store_id]['inventory']=$p;
				
			} $test = DB::select($cigarettes);
			foreach($test as  $p){
				$output[$p->store_id]['cigarettes']=$p;
				
			}
			$test = DB::select($gran_total_cash);
			foreach($test as  $p){
				$output[$p->store_id]['gran_total_cash']=$p;
				
			}
		$test = DB::select($expense);
			foreach($test as  $p){
				$output[$p->store_id]['expense']=$p;
				
			}
			
			$storeid=array();
			foreach($output as $key => $value){
	if($key!=""){
  $storeid[]= $key;
	}
}
	if(!empty($storeid)){
		$stores = Stores2::whereRaw("stores.id in (". implode(',',$storeid).")")->get();
	}

		$tempOutput=$output;
		$output=array();
		foreach($tempOutput as $key =>$s){
			if($key!=""){
			$s['name']="";
				$s['user_id']="";
			if(!isset($s['lottery'])){
				$s['lottery']=(object)array("lottery"=>0,"weekly_commission"=>0,"weekly_eft_ammount"=>0);
				}	
				if(!isset($s['atm'])){
				$s['atm']=(object)array("atm"=>0,"total_cash"=>0,"total_fp"=>0);
				}if(!isset($s['inventory'])){
				$s['inventory']=(object)array("inventory"=>0,"total_cash"=>0,"total_fp"=>0);
				}
				if(!isset($s['cigarettes'])){
				$s['cigarettes']=(object)array("cigarettes"=>0,"total_cash"=>0,"total_fp"=>0);
				}
				if(!isset($s['expense'])){
				$s['expense']=(object)array("expense"=>0,"total_cash"=>0,"total_fp"=>0);
				}
				if(!isset($s['gran_total_cash'])){
				$s['gran_total_cash']=(object)array("grand_total"=>0,"user_id"=>0,"store_id"=>0);
				}
				if(!isset($s['sales'])){
				$s['sales']=(object)array("total_lottery_sale"=>0,"phone_card"=>0,"sales_total"=>0,"total_inside"=>0,"total_tax"=>0,"sales"=>0, "total_gas"=>0,"total_meat"=>0,"beer"=>0,"grocery"=>0,"pizza"=>0,"deli"=>0,"cigarette"=>0,"ebt1"=>0, "nontax"=>0,"novelty"=>0,"merchandise"=>0);
				}
				if(!isset($s['payment'])){
				$s['payment']=(object)array("payments_total"=>"0","payments"=>"0","ebt"=>"0","total_coupon"=>"0","total_mobile_coupon"=>"0");
				}
			
			foreach($stores as $u){
				if($u->id==$key){
				$s['name']=$u->name;
				$s['store_id']=strval($u->id);
				$s['user_id']=strval($id);
				$s['user_name']=$user_data['name'];
			}
			}
			
		$output[]=	$s;
		}
		}
			
					$cnt=0;
					$total=0;
					$total_payments=0;
					$total_sales=0;
					$total_inside=0;
					$total_tax=0;
					$total_gas=0;
					$total_meat=0;
					$total_beer = 0;
					$total_grocery = 0;
					$total_pizza = 0;
					$total_deli = 0;
					$total_cigarette = 0;
					$total_ebt1 = 0;
					$total_nontax = 0;
					$total_novelty = 0;
					$total_merchandise = 0;
					$total_coupon = 0;
					$total_mobile_coupon = 0;
					$total_lottery_sale=0;
					$total_phone_card=0;
					$total_ebt=0;
					$total_inventory=0;
					$total_atm=0;
					$total_cigarettes=0;
					$total_expense=0;
					$total_lottery=0;
					$total_weekly_eft_ammount=0;
					$weekly_tottaly_cashout=0;
					$total_weekly_commission=0;
					$total_cash=0;
					$total_fp=0;
					$gran_total = 0;
					$ttt = 0;
					$opstore=array();
					$oversort=0;
					
					$total_beer = 0;
					$total_grocery = 0;
					$total_pizza = 0;
					$total_deli = 0;
					$total_cigarette = 0;
					$total_ebt1 = 0;
					$total_nontax = 0;
					$total_novelty = 0;
					$total_merchandise = 0;
					
						foreach($output as $s){
						
						
		$oversort= 0;
						if(isset($s['payment']->payment) && isset($s['sales']->sales)){
						$oversort=$s['payment']->payment- $s['sales']->sales;
						}else{
							$oversort = "0";
						}
						
						if(isset($s['store_id'])){
		$s1=	array(
      "name"=>strval($s['name']),
    
      "store_id"=> strval($s['store_id']),
	  "user_id"=> strval($s['user_id']),
	  "user_name"=> strval($s['user_name']),
      "status"=> "1",
      "payments_total"=>strval($s['payment']->payments_total),
      "total_lottery_sale"=>strval($s['sales']->total_lottery_sale),
      "phone_card"=>strval($s['sales']->phone_card),
      "sales_total"=> strval($s['sales']->sales_total),
      "total_inside"=> strval($s['sales']->total_inside),
      "total_tax"=> strval($s['sales']->total_tax),
	  "total_gas"=> strval($s['sales']->total_gas),
	  "total_meat"=> strval($s['sales']->total_meat),
	  "beer"=> strval($s['sales']->beer),
	  "grocery"=> strval($s['sales']->grocery),
	  "pizza"=> strval($s['sales']->pizza),
	  "deli"=> strval($s['sales']->deli),
	  "cigarette"=> strval($s['sales']->cigarette),
	  "ebt1"=> strval($s['sales']->ebt1),
	  "nontax"=> strval($s['sales']->nontax),
	  "novelty"=> strval($s['sales']->novelty),
	  "merchandise"=> strval($s['sales']->merchandise),
	  
	  "total_coupon"=> strval($s['payment']->total_coupon),
	  "total_mobile_coupon"=> strval($s['payment']->total_mobile_coupon),
      "payments"=> strval($s['payment']->payments),
	  "ebt"=> strval($s['payment']->ebt),
      "oversort"=>strval($oversort),
      "sales"=> strval($s['sales']->sales),
      "atm"=>strval($s['atm']->atm),
      "total_cash"=>strval($s['atm']->total_cash),
      "total_fp"=> strval($s['atm']->total_fp),
      "inventory"=> strval($s['inventory']->inventory),
      "cigarettes"=> strval($s['cigarettes']->cigarettes),
      "expense"=>strval($s['expense']->expense),
	  "grand_total_cash"=> strval($s['gran_total_cash']->grand_total),
      "lottery"=> strval($s['lottery']->lottery),
      "weekly_commission"=>strval($s['lottery']->weekly_commission),
      "weekly_eft_ammount"=> strval($s['lottery']->weekly_eft_ammount),
      "weekly_cash_out"=>  strval($s['sales']->sales_total- $s['payment']->payments_total));
						$opstore[]=$s1;		
					
$s=(object)$s1;
	
						
							
						$total += $s->payments+$s->sales+$s->inventory+$s->atm+$s->cigarettes+$s->expense+$s->lottery;
						$ttt =$oversort;
						$total_payments += $s->payments;
						$total_sales +=$s->sales;
						$total_inside +=$s->total_inside;
						$total_tax +=$s->total_tax;
						$total_gas +=$s->total_gas;
						$total_meat +=$s->total_meat;
						$total_beer +=$s->beer;
						$total_grocery +=$s->grocery;
						$total_pizza +=$s->pizza;
						$total_deli +=$s->deli;
						$total_cigarette +=$s->cigarette;
						$total_ebt1 +=$s->ebt1;
						$total_nontax +=$s->nontax;
						$total_novelty +=$s->novelty;
						$total_merchandise +=$s->merchandise;
						
						
						$total_coupon +=$s->total_coupon;
						$total_mobile_coupon +=$s->total_mobile_coupon;
						$total_lottery_sale +=$s->total_lottery_sale;
						$total_phone_card +=$s->phone_card;
						$total_ebt +=$s->ebt;
						$total_inventory += $s->inventory;
						$total_atm += $s->atm;
						$total_cigarettes += $s->cigarettes;
						$total_expense += $s->expense;
						$total_cash += $s->total_cash;
						$total_fp += $s->total_fp;
						$s->total_cash = strval($s->total_cash);
						$s->total_fp = strval($s->total_fp);
						$total_lottery += $s->lottery;
						$total_weekly_commission += $s->weekly_commission;
						$total_weekly_eft_ammount += $s->weekly_eft_ammount;
						$oversort += $ttt;
						$gran_total +=$s->grand_total_cash;
						
						$cnt++;
						}
						}
						
						$total_payments = round($total_payments,2);
						$total_sales = round($total_sales,2);
						$total_inside = round($total_inside,2);
						$total_tax = round($total_tax,2);
						$total_gas = round($total_gas,2);
						$total_meat = round($total_meat,2);
						$total_beer = round($total_beer,2);
						$total_grocery = round($total_grocery,2);
						$total_pizza = round($total_pizza,2);
						$total_deli = round($total_deli,2);
						$total_cigarette = round($total_cigarette,2);
						$total_ebt1 = round($total_ebt1,2);
						$total_nontax = round($total_nontax,2);
						$total_novelty = round($total_novelty,2);
						$total_merchandise = round($total_merchandise,2);
						$total_coupon = round($total_coupon,2);
						$total_mobile_coupon = round($total_mobile_coupon,2);
						$total_lottery_sale = round($total_lottery_sale,2);
						$total_phone_card = round($total_phone_card,2);
						$total_ebt = round($total_ebt,2);
						$total_inventory = round($total_inventory,2);
						$total_atm = round($total_atm,2);
						$total_cigarettes = round($total_cigarettes,2);
						$total_expense = round($total_expense,2);
						$total_cash =strval(round($total_cash,2));
						$total_fp =strval(round($total_fp,2));
						$total_lottery = round($total_lottery,2);
						$total_weekly_commission = round($total_weekly_commission,2);
						$total_weekly_eft_ammount = round($total_weekly_eft_ammount,2);
						$oversort = round($oversort,2);
						$gran_total = round($gran_total,2);
						$op = array("total_payments"=>strval($total_payments),
						"total_sales"=>strval($total_sales),
						"total_inventory"=>strval($total_inventory),
						"oversort"=>strval($oversort),
						"total_atm"=>strval($total_atm),
						"total_cigarettes"=>strval($total_cigarettes),
						"total_expense"=>strval($total_expense),
						"total_lottery"=>strval($total_lottery),
						"total_weekly_commission"=>strval($total_weekly_commission),
						"total_weekly_eft_ammount"=>strval($total_weekly_eft_ammount),
						"total_weekly_cash_out"=>strval($weekly_tottaly_cashout), 
						"total_cash"=>$total_cash, 
						"total_inside"=>strval($total_inside), 
						"total_tax"=>strval($total_tax), 
						"total_lottery_sale"=>strval($total_lottery_sale), 
						"total_fp"=>strval($total_fp), 
						"phone_card"=>strval($total_phone_card), 
						"total_gas"=>strval($total_gas),
						"total_meat"=>strval($total_meat),
						"total_beer" => strval($total_beer),
						"total_grocery" => strval($total_grocery),
						"total_pizza" => strval($total_pizza),
						"total_deli" => strval($total_deli),
						"total_cigarette" => strval($total_cigarette),
						"total_ebt1" => strval($total_ebt1),
						"total_nontax" => strval($total_nontax),
						"total_novelty" => strval($total_novelty),
						"total_merchandise" => strval($total_merchandise),
						"total_coupon"=>strval($total_coupon),
						"total_mobile_coupon"=>strval($total_mobile_coupon),
						"total_ebt"=>strval($total_ebt),
						"grand_total"=>strval($gran_total));
					return response()->json(['status' =>'1', 'stores'=>$opstore,'total'=>$op]);
				
		}
		else
		{
			return response()->json(['status'=>'0', 'error_msg' =>'Token is invalid or expired!']);
		}
	}
	
	
	public function user_entry_details(Request $request, JWTAuth $JWTAuth)
	{
		$user = $JWTAuth->parseToken()->authenticate();
		if(($user && $user->role == "admin")||true)
		{
			$id = $request->get('id');
			$date = $request->get('date');
			$store_id = $request->get('store_id');
			//echo $date; die();
			if(!empty($date) && !empty($id) && $id !=0){
				
				$sales = DB::table('daily_sales_entry')
						->select(DB::raw(
									"DATE_FORMAT(daily_sales_entry.date ,'%m/%d/%Y')as sdate,
									IFNULL(DATE_FORMAT(daily_sales_entry.insert_timestamp ,'%m/%d/%Y %h:%i:%p'),'')as sinsert_timestamp,
									daily_sales_entry.id as sales_id,
									ROUND(daily_sales_entry.inside,2) as inside,
									
									IFNULL(ROUND(daily_sales_entry.beer,2),'') as beer,
									IFNULL(ROUND(daily_sales_entry.grocery,2),'') as grocery,
									IFNULL(ROUND(daily_sales_entry.pizza,2),'') as pizza,
									IFNULL(ROUND(daily_sales_entry.deli,2),'') as deli,
									IFNULL(ROUND(daily_sales_entry.cigarette,2),'') as cigarette,
									IFNULL(ROUND(daily_sales_entry.ebt,2),'') as ebt,
									IFNULL(ROUND(daily_sales_entry.nontax,2),'') as nontax,
									IFNULL(ROUND(daily_sales_entry.novelty,2),'') as novelty,
									IFNULL(ROUND(daily_sales_entry.merchandise,2),'') as merchandise,
									IFNULL(ROUND(daily_sales_entry.wu_amount,2),'') as wu_amount,
									IFNULL(ROUND(daily_sales_entry.meat,2),'') as total_meat,
									ROUND(daily_sales_entry.gas,2) as gas,
									ROUND(daily_sales_entry.tax,2) as tax,
									ROUND(daily_sales_entry.phone_card,2) as phone_card,
									ROUND(daily_sales_entry.instant,2) as instant,
									ROUND(daily_sales_entry.lottery,2) as lottery,
									ROUND(daily_sales_entry.add_money_order,2) as add_money_order,
									ROUND(daily_sales_entry.total_sales,2) as total_sales 
									"))
						->leftJoin('users','daily_sales_entry.user_id','=','users.id')
						->where('users.id', '=',$id)
						->where('daily_sales_entry.status', '=',1)
						->where('daily_sales_entry.store_id', '=',$store_id)
						->whereDate('daily_sales_entry.date', '=',$date)
						//->groupBy('daily_sales_entry.date')
						//->groupBy('daily_sales_entry.user_id')
						//->groupBy('stores.id')
						->get();
						$sales[0]->total_sales = $sales[0]->total_sales;// + $sales[0]->add_money_order;
					$payment = DB::table('daily_payment_report')
						->select(DB::raw(
									"DATE_FORMAT(daily_payment_report.date ,'%m/%d/%Y')as pdate,
									IFNULL(DATE_FORMAT(daily_payment_report.insert_timestamp ,'%m/%d/%Y %h:%i:%p'),'')as pinsert_timestamp,
									daily_payment_report.id as payment_id,
									ROUND(daily_payment_report.total_cash,2) as total_cash,
									ROUND(daily_payment_report.total_credit,2) as total_credit,
									ROUND(daily_payment_report.total_debit,2) as total_debit,
									IFNULL(ROUND(daily_payment_report.wu_pay_out,2),'0') as wu_pay_out,
									IFNULL(ROUND(daily_payment_report.coupon,2),'0') as total_coupon,
									IFNULL(ROUND(daily_payment_report.mobile_coupon,2),'0') as total_mobile_coupon,
									ROUND(daily_payment_report.lottery_cash,2) as lottery_cash,
									ROUND(daily_payment_report.lottery_online_cashout,2) as lottery_online_cashout,
									ROUND(daily_payment_report.lottery_out,2) as lottery_out,
									ROUND(daily_payment_report.lottery_instant_cashout,2) as lottery_instant_cashout,
									ROUND(daily_payment_report.total,2) as total
									"))
						
						->leftJoin('users','users.id','=','daily_payment_report.user_id')
						->where('users.id', '=',$id)
						->where('daily_payment_report.status', '=',1)
						->where('daily_payment_report.store_id', '=',$store_id)
						->whereDate('daily_payment_report.date', '=',$date)
						//->groupBy('daily_payment_report.date')
						//->groupBy('daily_payment_report.user_id')
						//->groupBy('stores.id')
						->get();
						
					$inventory = DB::table('inventory')
						->select(DB::raw(
						"DATE_FORMAT(inventory.date ,'%m/%d/%Y')as sdate,
						IFNULL(DATE_FORMAT(inventory.insert_timestamp ,'%m/%d/%Y %h:%i:%p'),'') as iinsert_timestamp,
									inventory.id as inventory_id,
									inventory.invoice_no,
									inventory.item,
									inventory.vendor,
									inventory.quantity,
									IFNULL(inventory.pay_by,'') as pay_by,
									IFNULL(inventory.cheque_no, '') as cheque_no,
									ROUND(inventory.price,2) as price,
									ROUND(inventory.total_price,2) as total_price,
									items.name as item_name
									"))
						
						->leftJoin('users','users.id','=','inventory.user_id')
						->leftJoin('items','items.id','=','inventory.item')
						->where('users.id', '=',$id)
						->where('inventory.status', '=',1)
						->where('inventory.store_id', '=',$store_id)
						->whereDate('inventory.date', '=',$date)
						//->groupBy('inventory.date')
						//->groupBy('inventory.user_id')
						//->groupBy('stores.id')
						->get();
						
						
				$atm = DB::table('ATM')
						->select(DB::raw(
						"DATE_FORMAT(ATM.date ,'%m/%d/%Y')as atmdate,
						IFNULL(DATE_FORMAT(ATM.insert_timestamp ,'%m/%d/%Y %h:%i:%p'),'') as ainsert_timestamp,
									ATM.id as atmid,
									IFNULL(ROUND(ATM.money,2),'') as money,
									IFNULL(ROUND(ATM.add_money,2),'') as add_money,
									IFNULL(ROUND(ATM.total_money,2),'') as total_money,
									IFNULL(ROUND(ATM.cash,2),'') as cash,
									IFNULL(ROUND(ATM.fp,2),'') as fp,
									IFNULL(ATM.store_id,'') as store_id,
									IFNULL(ATM.user_id,'') as user_id
									"))
						->leftJoin('users','users.id','=','ATM.user_id')
						->where('users.id', '=',$id)
						->where('ATM.status', '=',1)
						->where('ATM.store_id', '=',$store_id)
						->whereDate('ATM.date', '=',$date)
						->get();
				
				$cigarette = DB::table('cigarettes')
						->select(DB::raw(
						"DATE_FORMAT(cigarettes.date ,'%m/%d/%Y')as cigdate,
						IFNULL(DATE_FORMAT(cigarettes.insert_timestamp ,'%m/%d/%Y %h:%i:%p'),'') as cinsert_timestamp,
									cigarettes.id as cigid,
									cigarettes.inventory,
									ROUND(cigarettes.add_cigarette,2) as add_cigarette,
									ROUND(cigarettes.sale_cigarette,2) as sale_cigarette,
									ROUND(cigarettes.available_stock,2) as available_stock,
									cigarettes.store_id,
									cigarettes.user_id
									"))
						->leftJoin('users','users.id','=','cigarettes.user_id')
						->where('users.id', '=',$id)
						->where('cigarettes.status', '=',1)
						->where('cigarettes.store_id', '=',$store_id)
						->whereDate('cigarettes.date', '=',$date)
						->get();
				$lottery = DB::table('lottery')
						->select(DB::raw(
						"DATE_FORMAT(lottery.date ,'%m/%d/%Y')as lotdate,
						IFNULL(DATE_FORMAT(lottery.insert_timestamp ,'%m/%d/%Y %h:%i:%p'),'') as linsert_timestamp,
									lottery.id as lotid,
									ROUND(lottery.inventory,2) as inventory,
									ROUND(lottery.add_book,2) as add_book,
									IFNULL(ROUND(lottery.weekly_eft_ammount,2),'0') as weekly_eft_ammount,
									ROUND(lottery.weekly_commission,2) as weekly_commission,
									ROUND(lottery.active_book,2) as active_book,
									ROUND(lottery.total,2) as total,
									lottery.store_id,
									lottery.user_id
									"))
						->leftJoin('users','users.id','=','lottery.user_id')
						->where('users.id', '=',$id)
						->where('lottery.status', '=',1)
						->where('lottery.store_id', '=',$store_id)
						->whereDate('lottery.date', '=',$date)
						->get();
				$expense = DB::table('expense')
						->select(DB::raw(
						"DATE_FORMAT(expense.date ,'%m/%d/%Y')as expdate,
						IFNULL(DATE_FORMAT(expense.insert_timestamp ,'%m/%d/%Y %h:%i:%p'),'') as einsert_timestamp,
									expense.id as expid,
									expense.title,
									ROUND(expense.price,2) as price,
									expense.user_id,
									expense.store_id,
									expense.item_id,
									expense_items.expense_item as item_name
									"))
						->leftJoin('users','users.id','=','expense.user_id')
						->leftJoin('expense_items','expense_items.id','=','expense.item_id')
						->where('users.id', '=',$id)
						->where('expense.status', '=',1)
						->where('expense.store_id', '=',$store_id)
						->whereDate('expense.date', '=',$date)
						->get();
						$output = array("sales"=>$sales,"payment"=>$payment,"inventory"=>$inventory,"cigarettes"=>$cigarette, "atm"=>$atm, "lottery"=>$lottery, "expense"=>$expense);
						
				
					return response()->json(['status' =>'1', 'data'=>$output]);
			}
		}
		else
		{
			return response()->json(['status'=>'0', 'error_msg' =>'Token is invalid or expired!']);
		}
	}
	public function user_report_date(Request $request, JWTAuth $JWTAuth)
	{
		$user = $JWTAuth->parseToken()->authenticate();
		if(($user && $user->role == "admin")||true)
		{
			$id = $request->get('id');
			$date = $request->get('date');
			$store_id = $request->get('store_id');
			//echo "Service response"; die();
			//echo $date. "   ".$store_id."   ".$id; die('test failed');
			if(!empty($date) && !empty($id) && $id !=0){
				
				$sales = DB::table('daily_sales_entry')
						->select(DB::raw(
									"DATE_FORMAT(daily_sales_entry.date ,'%m/%d/%Y')as sdate,
									IFNULL(DATE_FORMAT(daily_sales_entry.insert_timestamp ,'%m/%d/%Y %h:%i:%p'),'') as sinsert_timestamp,
									daily_sales_entry.id as sales_id,
									ROUND(daily_sales_entry.inside,2) as inside,
									ROUND(daily_sales_entry.gas,2) as gas,
									ROUND(daily_sales_entry.tax,2) as tax,
									ROUND(daily_sales_entry.phone_card,2) as phone_card,
									ROUND(daily_sales_entry.instant,2) as instant,
									ROUND(daily_sales_entry.lottery,2) as lottery,
									ROUND(daily_sales_entry.add_money_order,2) as add_money_order,
									ROUND(daily_sales_entry.total_sales,2) as total_sales,
									ROUND(daily_sales_entry.meat,2) as total_meat,
									ROUND(daily_sales_entry.beer,2) as beer,
									ROUND(daily_sales_entry.grocery,2) as grocery,
									ROUND(daily_sales_entry.pizza,2) as pizza,
									ROUND(daily_sales_entry.deli,2) as deli,
									ROUND(daily_sales_entry.cigarette,2) as cigarette,
									ROUND(daily_sales_entry.ebt,2) as ebt,
									ROUND(daily_sales_entry.nontax,2) as nontax,
									ROUND(daily_sales_entry.novelty,2) as novelty,
									ROUND(daily_sales_entry.merchandise,2) as merchandise,
									ROUND(daily_sales_entry.wu_amount,2) as wu_amount
									"))
						->leftJoin('users','daily_sales_entry.user_id','=','users.id')
						->where('users.id', '=',$id)
						->where('daily_sales_entry.status', '=',1)
						->where('daily_sales_entry.store_id', '=',$store_id)
						->whereDate('daily_sales_entry.date', '=',$date)
						//->groupBy('daily_sales_entry.date')
						//->groupBy('daily_sales_entry.user_id')
						//->groupBy('stores.id')
						->get();
						
					$payment = DB::table('daily_payment_report')
						->select(DB::raw(
									"DATE_FORMAT(daily_payment_report.date ,'%m/%d/%Y')as pdate,
									IFNULL(DATE_FORMAT(daily_payment_report.insert_timestamp ,'%m/%d/%Y %h:%i:%p'),'') as pinsert_timestamp,
									daily_payment_report.id as payment_id,
									ROUND(daily_payment_report.total_cash,2) as total_cash,
									ROUND(daily_payment_report.total_credit,2) as total_credit,
									ROUND(daily_payment_report.total_debit,2) as total_debit,
									ROUND(daily_payment_report.lottery_cash,2) as lottery_cash,
									ROUND(daily_payment_report.coupon,2) as total_coupon,
									ROUND(daily_payment_report.mobile_coupon,2) as total_mobile_coupon,
									ROUND(daily_payment_report.lottery_online_cashout,2) as lottery_online_cashout,
									ROUND(daily_payment_report.lottery_out,2) as lottery_out,
									ROUND(daily_payment_report.lottery_instant_cashout,2) as lottery_instant_cashout,
									ROUND(daily_payment_report.total,2) as total,
									IFNULL(ROUND(daily_payment_report.wu_pay_out,2),'') as wu_pay_out
									"))
						
						->leftJoin('users','users.id','=','daily_payment_report.user_id')
						->where('users.id', '=',$id)
						->where('daily_payment_report.status', '=',1)
						->where('daily_payment_report.store_id', '=',$store_id)
						->whereDate('daily_payment_report.date', '=',$date)
						//->groupBy('daily_payment_report.date')
						//->groupBy('daily_payment_report.user_id')
						//->groupBy('stores.id')
						->get();
						
					$inventory = DB::table('inventory')
						->select(DB::raw(
						"DATE_FORMAT(inventory.date ,'%m/%d/%Y')as sdate,
						IFNULL(DATE_FORMAT(inventory.insert_timestamp ,'%m/%d/%Y %h:%i:%p'),'') as iinsert_timestamp,
									inventory.id as inventory_id,
									inventory.invoice_no,
									inventory.item,
									inventory.vendor,
									inventory.quantity,
									IFNULL(inventory.pay_by,'') as pay_by,
									IFNULL(inventory.cheque_no, '') as cheque_no,
									ROUND(inventory.price,2) as price,
									ROUND(inventory.total_price,2) as total_price,
									items.name as item_name
									"))
						
						->leftJoin('users','users.id','=','inventory.user_id')
						->leftJoin('items','items.id','=','inventory.item')
						->where('users.id', '=',$id)
						->where('inventory.status', '=',1)
						->where('inventory.store_id', '=',$store_id)
						->whereDate('inventory.date', '=',$date)
						//->groupBy('inventory.date')
						//->groupBy('inventory.user_id')
						//->groupBy('stores.id')
						->get();
						
						
				$atm = DB::table('ATM')
						->select(DB::raw(
						"DATE_FORMAT(ATM.date ,'%m/%d/%Y')as atmdate,
						IFNULL(DATE_FORMAT(ATM.insert_timestamp ,'%m/%d/%Y %h:%i:%p'),'') as ainsert_timestamp,
									ATM.id as atmid,
									ROUND(ATM.money,2) as money,
									ROUND(ATM.add_money,2) as add_money,
									ROUND(ATM.total_money,2) as total_money,
									ROUND(ATM.cash,2) as cash,
									ROUND(ATM.fp,2) as fp,
									ATM.store_id,
									ATM.user_id
									"))
						->leftJoin('users','users.id','=','ATM.user_id')
						->where('users.id', '=',$id)
						->where('ATM.status', '=',1)
						->where('ATM.store_id', '=',$store_id)
						->whereDate('ATM.date', '=',$date)
						->get();
				
				$cigarette = DB::table('cigarettes')
						->select(DB::raw(
						"DATE_FORMAT(cigarettes.date ,'%m/%d/%Y')as cigdate,
						IFNULL(DATE_FORMAT(cigarettes.insert_timestamp ,'%m/%d/%Y %h:%i:%p'),'') as cinsert_timestamp,
									cigarettes.id as cigid,
									cigarettes.inventory,
									ROUND(cigarettes.add_cigarette,2) as add_cigarette,
									ROUND(cigarettes.sale_cigarette,2) as sale_cigarette,
									ROUND(cigarettes.available_stock,2) as available_stock,
									cigarettes.store_id,
									cigarettes.user_id
									"))
						->leftJoin('users','users.id','=','cigarettes.user_id')
						->where('users.id', '=',$id)
						->where('cigarettes.status', '=',1)
						->where('cigarettes.store_id', '=',$store_id)
						->whereDate('cigarettes.date', '=',$date)
						->get();
				$lottery = DB::table('lottery')
						->select(DB::raw(
						"DATE_FORMAT(lottery.date ,'%m/%d/%Y')as lotdate,
						IFNULL(DATE_FORMAT(lottery.insert_timestamp ,'%m/%d/%Y %h:%i:%p'),'') as linsert_timestamp,
									lottery.id as lotid,
									ROUND(lottery.inventory,2) as inventory,
									ROUND(lottery.add_book,2) as add_book,
									IFNULL(ROUND(lottery.weekly_eft_ammount,2),'0') as weekly_eft_ammount,
									ROUND(lottery.weekly_commission,2) as weekly_commission,
									ROUND(lottery.active_book,2) as active_book,
									ROUND(lottery.total,2) as total,
									lottery.store_id,
									lottery.user_id
									"))
						->leftJoin('users','users.id','=','lottery.user_id')
						->where('users.id', '=',$id)
						->where('lottery.status', '=',1)
						->where('lottery.store_id', '=',$store_id)
						->whereDate('lottery.date', '=',$date)
						->get();
				$expense = DB::table('expense')
						->select(DB::raw(
						"DATE_FORMAT(expense.date ,'%m/%d/%Y')as expdate,
						IFNULL(DATE_FORMAT(expense.insert_timestamp ,'%m/%d/%Y %h:%i:%p'),'')as einsert_timestamp,
									expense.id as expid,
									expense.title,
									ROUND(expense.price,2) as price,
									expense.user_id,
									expense.store_id,
									expense.item_id,
									expense_items.expense_item as item_name
									"))
						->leftJoin('users','users.id','=','expense.user_id')
						->leftJoin('expense_items','expense_items.id','=','expense.item_id')
						->where('users.id', '=',$id)
						->where('expense.status', '=',1)
						->where('expense.store_id', '=',$store_id)
						->whereDate('expense.date', '=',$date)
						->get();
						$output = array("sales"=>$sales,"payment"=>$payment,"inventory"=>$inventory,"cigarettes"=>$cigarette, "atm"=>$atm, "lottery"=>$lottery, "expense"=>$expense);
						
				
					return response()->json(['status' =>'1', 'data'=>$output]);
			}
		}
		else
		{
			return response()->json(['status'=>'0', 'error_msg' =>'Token is invalid or expired!']);
		}
	}
	public function latest(Request $request, JWTAuth $JWTAuth)
	{
		$data = array();
		$data[]=array("date"=>"28-12-2016","user_name"=>"hiten chauhan","use_fk"=>"3","sales"=>"3000","payement"=>"500","inventory"=>"2000");
		$data[]=array("date"=>"28-12-2016","user_name"=>"Pinkesh Patel","use_fk"=>"4","sales"=>"3000","payement"=>"500","inventory"=>"2000");
		return response()->json(['status'=>'1', 'data' =>$data]);
		$user = $JWTAuth->parseToken()->authenticate();
		if(($user && $user->role == "admin")||true)
		{
			$id = $request->get('id');
			$date_from = $request->get('from');
			$date_to = $request->get('to');
			//echo $date_to; die();
			if(!empty($date_from) && !empty($date_to) && $id !=0){
				$stores = DB::table('stores')
						->select(DB::raw(
									'stores.*,
									(SELECT IFNULL(SUM(total),"0")  FROM daily_payment_report WHERE daily_payment_report.store_id=stores.id AND users.id=daily_payment_report.user_id) AS payments,
									(SELECT IFNULL(SUM(total_sales),"0")  FROM daily_sales_entry WHERE daily_sales_entry.store_id=stores.id) AS sales,
									(SELECT IFNULL(SUM(total_price),"0")  FROM inventory WHERE inventory.store_id=stores.id) AS inventory
									'))
						->leftJoin('daily_payment_report', 'daily_payment_report.store_id', '=', 'stores.id')
						->leftJoin('daily_sales_entry', 'daily_sales_entry.store_id', '=', 'stores.id')
						->leftJoin('inventory', 'inventory.store_id', '=', 'stores.id')
						
						->where('stores.id','=',$id)
						->where('daily_sales_entry.date', '>=',$date_from)
						->where('daily_sales_entry.date', '<=',$date_to)
						->where('daily_payment_report.date', '>=',$date_from)
						->where('daily_payment_report.date', '<=',$date_to)
						->where('inventory.date', '>=',$date_from)
						->where('inventory.date', '<=',$date_to)
						//->groupBy('stores.id')
						->get();
				if($stores->count()<=0){
					return response()->json(['status' =>'0', 'error_msg'=>'No records found for given date range!']);
				}else{
					return response()->json(['status' =>'1', 'stores'=>$stores]);
				}
			}
		}
		else
		{
			return response()->json(['status'=>'0', 'error_msg' =>'Token is invalid or expired!']);
		}
	}
	public function store_info(Request $request, JWTAuth $JWTAuth)
	{
		$user = $JWTAuth->parseToken()->authenticate();
		if(($user && $user->role == "admin")||true)
		{
			$id = $request->get('id');
			$date_from = $request->get('from');
			$date_to = $request->get('to');
			
			$user_id = $request->get('user_id');
			$user = User2::where(array("id"=>$user_id))->first();
			$store_access = $user['store_access'];
			
			if(!empty($date_from) && !empty($date_to) && $id !=0){
				$sales = DB::table('daily_sales_entry')
						->select(DB::raw(
									"DATE_FORMAT(daily_sales_entry.date ,'%d-%m-%Y')as sdate,
									daily_sales_entry.user_id,users.name,
									IFNULL(ROUND(sum(daily_sales_entry.total_sales),2),'0') as total_sales,
									stores.name as store_name,
									daily_sales_entry.id as sales_id
									
									"))
						->leftJoin('users','users.id','=','daily_sales_entry.user_id')
						->leftJoin('stores','stores.id','=','daily_sales_entry.store_id')
						->where('stores.id', '=',$id)
						->where('daily_sales_entry.status', '=',1)
						->whereDate('daily_sales_entry.date', '>=',$date_from)
						->whereDate('daily_sales_entry.date', '<=',$date_to)
						->groupBy('daily_sales_entry.date')
						->groupBy('daily_sales_entry.user_id')
						->orderBy('daily_sales_entry.date','DESC')
						//->groupBy('stores.id')
						->get();
						$op=array();
						foreach($sales as $s){
							$op[$s->sdate][$s->user_id]['store_name']=$s->store_name;
							$op[$s->sdate][$s->user_id]['sales']=$s->total_sales;
							$op[$s->sdate][$s->user_id]['name']=$s->name;
							$op[$s->sdate][$s->user_id]['user_id']=$s->user_id;
							$op[$s->sdate][$s->user_id]['sales_id']=$s->sales_id;
							//$op[$s->sdate][$s->user_id]['store_name']=$s->store_name;
						}
					$payment = DB::table('daily_payment_report')
						->select(DB::raw(
									"DATE_FORMAT(daily_payment_report.date ,'%d-%m-%Y')as pdate,
									daily_payment_report.user_id,users.name,
									IFNULL(ROUND(sum(daily_payment_report.total),2),'0') as total_payment,
									stores.name as store_name,
									daily_payment_report.id as payment_id
									"))
						->leftJoin('users','users.id','=','daily_payment_report.user_id')
						->leftJoin('stores','stores.id','=','daily_payment_report.store_id')
						->where('stores.id', '=',$id)
						->where('daily_payment_report.status', '=',1)
						->whereDate('daily_payment_report.date', '>=',$date_from)
						->whereDate('daily_payment_report.date', '<=',$date_to)
						->groupBy('daily_payment_report.date')
						->groupBy('daily_payment_report.user_id')
						->orderBy('daily_payment_report.date','DESC')
						//->groupBy('stores.id')
						->get();
						foreach($payment as $s){
							$op[$s->pdate][$s->user_id]['store_name']=$s->store_name;
							$op[$s->pdate][$s->user_id]['payment']=$s->total_payment;
							$op[$s->pdate][$s->user_id]['name']=$s->name;
							$op[$s->pdate][$s->user_id]['user_id']=$s->user_id;
							$op[$s->pdate][$s->user_id]['payment_id']=$s->payment_id;
					}
					$stores = Inventory2::select(DB::raw(
						"DATE_FORMAT(inventory.date ,'%d-%m-%Y')as sdate,
									
									users.name,
									inventory.user_id,
									IFNULL(ROUND(sum(inventory.price),2),'0') as price,
									stores.name as store_name,
									inventory.id as inventory_id
									"))
						
						->leftJoin('users','users.id','=','inventory.user_id')
						->leftJoin('stores','stores.id','=','inventory.store_id')
						->where('stores.id', '=',$id)
						->where('inventory.status', '=',1)
						->whereDate('inventory.date', '>=',$date_from)
						->whereDate('inventory.date', '<=',$date_to)
						->groupBy('inventory.date')
						->groupBy('inventory.user_id')
						->orderBy('inventory.date','DESC')
						//->groupBy('stores.id')
						->get();
						foreach($stores as $s){
							$op[$s->sdate][$s->user_id]['store_name']=$s->store_name;
							$op[$s->sdate][$s->user_id]['inventory']=$s->price;
							$op[$s->sdate][$s->user_id]['name']=$s->name;
							$op[$s->sdate][$s->user_id]['user_id']=$s->user_id;
							$op[$s->sdate][$s->user_id]['inventory_id']=$s->inventory_id;
						}
						
			$atm = DB::table('ATM')
						->select(DB::raw(
									"DATE_FORMAT(ATM.date ,'%d-%m-%Y')as atmdate,
									ATM.user_id,users.name,
									IFNULL(ROUND(sum(ATM.add_money),2),'0') as total_atm,
									stores.name as store_name,
									ATM.id as atm_id
									"))
						->leftJoin('users','users.id','=','ATM.user_id')
						->leftJoin('stores','stores.id','=','ATM.store_id')
						->where('stores.id', '=',$id)
						->where('ATM.status', '=',1)
						->whereDate('ATM.date', '>=',$date_from)
						->whereDate('ATM.date', '<=',$date_to)
						->groupBy('ATM.date')
						->groupBy('ATM.user_id')
						->orderBy('ATM.date','DESC')
						//->groupBy('stores.id')
						->get();
						foreach($atm as $s){
							$op[$s->atmdate][$s->user_id]['store_name']=$s->store_name;
							$op[$s->atmdate][$s->user_id]['atm']=round($s->total_atm,2);
							$op[$s->atmdate][$s->user_id]['name']=$s->name;
							$op[$s->atmdate][$s->user_id]['user_id']=$s->user_id;
							$op[$s->atmdate][$s->user_id]['atm_id']=$s->atm_id;
					}
			$cigarettes = DB::table('cigarettes')
						->select(DB::raw(
									"DATE_FORMAT(cigarettes.date ,'%d-%m-%Y')as cigdate,
									cigarettes.user_id,users.name,
									IFNULL(ROUND(sum(cigarettes.available_stock),2),'0') as total_cigarettes,
									stores.name as store_name,
									cigarettes.id as cigarette_id
									"))
						->leftJoin('users','users.id','=','cigarettes.user_id')
						->leftJoin('stores','stores.id','=','cigarettes.store_id')
						->where('stores.id', '=',$id)
						->where('cigarettes.status', '=',1)
						->whereDate('cigarettes.date', '>=',$date_from)
						->whereDate('cigarettes.date', '<=',$date_to)
						->groupBy('cigarettes.date')
						->groupBy('cigarettes.user_id')
						->orderBy('cigarettes.date','DESC')
						//->groupBy('stores.id')
						->get();
						foreach($cigarettes as $s){
							$op[$s->cigdate][$s->user_id]['store_name']=$s->store_name;
							$op[$s->cigdate][$s->user_id]['cigarettes']=round($s->total_cigarettes,2);
							$op[$s->cigdate][$s->user_id]['name']=$s->name;
							$op[$s->cigdate][$s->user_id]['user_id']=$s->user_id;
							$op[$s->cigdate][$s->user_id]['cigarette_id']=$s->cigarette_id;
					}
			$lottery = DB::table('lottery')
						->select(DB::raw(
									"DATE_FORMAT(lottery.date ,'%d-%m-%Y')as lotdate,
									lottery.user_id,users.name,
									IFNULL(ROUND(sum(lottery.total),2),'0') as total_lottery,
									IFNULL(ROUND(sum(lottery.weekly_commission),2),'0') as weekly_commission,
									IFNULL(ROUND(sum(lottery.weekly_eft_ammount),2),'0') as weekly_eft_ammount,
									stores.name as store_name,
									lottery.id as lottery_id
									"))
						->leftJoin('users','users.id','=','lottery.user_id')
						->leftJoin('stores','stores.id','=','lottery.store_id')
						->where('stores.id', '=',$id)
						->where('lottery.status', '=',1)
						->whereDate('lottery.date', '>=',$date_from)
						->whereDate('lottery.date', '<=',$date_to)
						->groupBy('lottery.date')
						->groupBy('lottery.user_id')
						->orderBy('lottery.date','DESC')
						//->groupBy('stores.id')
						->get();
						foreach($lottery as $s){
							$op[$s->lotdate][$s->user_id]['store_name']=$s->store_name;
							$op[$s->lotdate][$s->user_id]['lottery']=round($s->total_lottery,2);
							$op[$s->lotdate][$s->user_id]['weekly_commission']=round($s->weekly_commission,2);
							$op[$s->lotdate][$s->user_id]['weekly_eft_ammount']=round($s->weekly_eft_ammount,2);
							$op[$s->lotdate][$s->user_id]['name']=$s->name;
							$op[$s->lotdate][$s->user_id]['user_id']=$s->user_id;
							$op[$s->lotdate][$s->user_id]['lottery_id']=$s->lottery_id;
					}
			$expense = DB::table('expense')
						->select(DB::raw(
									"DATE_FORMAT(expense.date ,'%d-%m-%Y')as expdate,
									expense.user_id,users.name,
									IFNULL(ROUND(sum(expense.price),2),'0') as total_expense,
									stores.name as store_name,
									expense.id as expense_id
									"))
						->leftJoin('users','users.id','=','expense.user_id')
						->leftJoin('stores','stores.id','=','expense.store_id')
						->where('stores.id', '=',$id)
						->where('expense.status', '=',1)
						->whereDate('expense.date', '>=',$date_from)
						->whereDate('expense.date', '<=',$date_to)
						->groupBy('expense.date')
						->groupBy('expense.user_id')
						->orderBy('expense.date','DESC')
						//->groupBy('stores.id')
						->get();
						foreach($expense as $s){
							$op[$s->expdate][$s->user_id]['store_name']=$s->store_name;
							$op[$s->expdate][$s->user_id]['expense']=round($s->total_expense,2);
							$op[$s->expdate][$s->user_id]['name']=$s->name;
							$op[$s->expdate][$s->user_id]['user_id']=$s->user_id;
							$op[$s->expdate][$s->user_id]['expense_id']=$s->expense_id;
					}
						$output=array();
						foreach($op as  $key => $v){
				
					foreach($v as  $k => $value){
						
						$output[]=array("date"=>$key,"user_name"=>isset($value["name"])?$value["name"]:"","store_name"=>$value["store_name"],"user_fk"=>isset($value["user_id"])?$value["user_id"]:"","sales"=>isset($value["sales"])?strval(round($value["sales"],2)):"0","payement"=>isset($value["payment"])?strval(round($value["payment"],2)):"0","inventory"=>isset($value["inventory"])?strval(round($value["inventory"],2)):"0", "atm"=>isset($value["atm"])?strval(round($value["atm"],2)):"0", "cigarettes"=>isset($value["cigarettes"])?strval(round($value["cigarettes"],2)):"0", "lottery"=>isset($value["lottery"])?strval(round($value["lottery"],2)):"0", "expense"=>isset($value["expense"])?strval(round($value["expense"],2)):"0", "weekly_commission"=>isset($value["weekly_commission"])?strval(round($value["weekly_commission"],2)):"0", "weekly_eft_ammount"=>isset($value["weekly_eft_ammount"])?strval(round($value["weekly_eft_ammount"],2)):"0",
						"sales_id"=>isset($value["sales_id"])?strval(round($value["sales_id"],2)):"0",
						"payment_id"=>isset($value["payment_id"])?strval(round($value["payment_id"],2)):"0",
						"inventory_id"=>isset($value["inventory_id"])?strval(round($value["inventory_id"],2)):"0",
						"atm_id"=>isset($value["atm_id"])?strval(round($value["atm_id"],2)):"0",
						"lottery_id"=>isset($value["lottery_id"])?strval(round($value["lottery_id"],2)):"0",
						"expense_id"=>isset($value["expense_id"])?strval(round($value["expense_id"],2)):"0",
						"cigarette_id"=>isset($value["cigarette_id"])?strval(round($value["cigarette_id"],2)):"0"
						);
					}
				}
				usort($output, function($a, $b) {
				return  $b['date'] - $a['date'];
				});
					return response()->json(['status' =>'1', 'data'=>$output]);
			}
		}
		else
		{
			return response()->json(['status'=>'0', 'error_msg' =>'Token is invalid or expired!']);
		}
	}


	public function store_info2(Request $request, JWTAuth $JWTAuth)
	{
		
		$user = $JWTAuth->parseToken()->authenticate();
		if(($user && $user->role == "admin")||true)
		{
			
			$id = $request->get('id');
			$date_from = $request->get('from');
			$date_to = $request->get('to');
			
			$user_id = $request->get('user_id');
			$user = User2::where(array("id"=>$user_id))->first();
			$store_access = $user['store_access'];
			//instant+lottery  lottery_cash+lottery_online_cashout+lottery_instant_cashout
			if(!empty($date_from) && !empty($date_to) && $id !=0){
				
				$sales = DB::table('daily_sales_entry')
						->select(DB::raw(
									"DATE_FORMAT(daily_sales_entry.date ,'%m/%d/%Y')as sdate,
									DATE_FORMAT(daily_sales_entry.insert_timestamp ,'%m/%d/%Y %H:%i:%s')as sinsert_timestamp,
									daily_sales_entry.user_id,users.name, instant+lottery as total_s,
									IFNULL(ROUND(sum(daily_sales_entry.total_sales),2),'0') as total_sales,
									IFNULL(ROUND(sum(daily_sales_entry.add_money_order),2),'0') as total_money_order,
									IFNULL(ROUND(sum(daily_sales_entry.inside),2),'0') as total_inside,
									IFNULL(ROUND(sum(daily_sales_entry.tax),2),'0') as total_tax,
									IFNULL(ROUND(sum(daily_sales_entry.phone_card),2),'0') as phone_card,
									IFNULL(ROUND(sum(daily_sales_entry.gas),2),'0') as total_gas,
									IFNULL(ROUND(sum(daily_sales_entry.meat),2),'0') as total_meat,
									IFNULL(ROUND(sum(daily_sales_entry.instant+daily_sales_entry.lottery),2),'0') as total_lottery_sale,
									
									
									IFNULL(ROUND(sum(daily_sales_entry.beer),2),'0') as beer,
									IFNULL(ROUND(sum(daily_sales_entry.grocery),2),'0') as grocery,
									IFNULL(ROUND(sum(daily_sales_entry.pizza),2),'0') as pizza,
									IFNULL(ROUND(sum(daily_sales_entry.deli),2),'0') as deli,
									IFNULL(ROUND(sum(daily_sales_entry.cigarette),2),'0') as cigarette,
									IFNULL(ROUND(sum(daily_sales_entry.ebt),2),'0') as ebt1,
									IFNULL(ROUND(sum(daily_sales_entry.nontax),2),'0') as nontax,
									IFNULL(ROUND(sum(daily_sales_entry.novelty),2),'0') as novelty,
									IFNULL(ROUND(sum(daily_sales_entry.merchandise),2),'0') as merchandise,
									
									stores.name as store_name,
									daily_sales_entry.id as sales_id
									"))
						->leftJoin('users','users.id','=','daily_sales_entry.user_id')
						->leftJoin('stores','stores.id','=','daily_sales_entry.store_id')
						->where('stores.id', '=',$id)
						->where('daily_sales_entry.status', '=',1)
						->whereDate('daily_sales_entry.date', '>=',$date_from)
						->whereDate('daily_sales_entry.date', '<=',$date_to)
						->groupBy('daily_sales_entry.date')
						->groupBy('daily_sales_entry.user_id')
						->orderBy('daily_sales_entry.date','DESC')
						//->groupBy('stores.id')
						->get();
						$op=array();
						foreach($sales as $s){
							$op[$s->sdate][$s->user_id]['store_name']=$s->store_name;
							$op[$s->sdate][$s->user_id]['sales']=$s->total_sales;
							$op[$s->sdate][$s->user_id]['sales1']=$s->total_sales;
							$op[$s->sdate][$s->user_id]['name']=$s->name;
							$op[$s->sdate][$s->user_id]['total_inside']=$s->total_inside;
							$op[$s->sdate][$s->user_id]['total_lottery_sale']=$s->total_lottery_sale;
							$op[$s->sdate][$s->user_id]['total_tax']=$s->total_tax;
							$op[$s->sdate][$s->user_id]['total_gas']=$s->total_gas;
							$op[$s->sdate][$s->user_id]['total_meat']=$s->total_meat;
							$op[$s->sdate][$s->user_id]['phone_card']=$s->phone_card;
							$op[$s->sdate][$s->user_id]['user_id']=$s->user_id;
							$op[$s->sdate][$s->user_id]['weekly_sales_total']=$s->total_s;
							$op[$s->sdate][$s->user_id]['sales_id']=$s->sales_id;
							$op[$s->sdate][$s->user_id]['sinsert_timestamp']=$s->sinsert_timestamp;
							
							$op[$s->sdate][$s->user_id]['beer']=$s->beer;
							$op[$s->sdate][$s->user_id]['grocery']=$s->grocery;
							$op[$s->sdate][$s->user_id]['pizza']=$s->pizza;
							$op[$s->sdate][$s->user_id]['deli']=$s->deli;
							$op[$s->sdate][$s->user_id]['cigarette']=$s->cigarette;
							$op[$s->sdate][$s->user_id]['ebt1']=$s->ebt1;
							$op[$s->sdate][$s->user_id]['nontax']=$s->nontax;
							$op[$s->sdate][$s->user_id]['novelty']=$s->novelty;
							$op[$s->sdate][$s->user_id]['merchandise']=$s->merchandise;
							//$op[$s->sdate][$s->user_id]['store_name']=$s->store_name;
						}
					$payment = DB::table('daily_payment_report')
						->select(DB::raw(
									"DATE_FORMAT(daily_payment_report.date ,'%m/%d/%Y')as pdate,
									DATE_FORMAT(daily_payment_report.insert_timestamp ,'%m/%d/%Y %H:%i:%s')as pinsert_timestamp,
									lottery_online_cashout+lottery_instant_cashout as total_p,
									daily_payment_report.user_id,users.name,
									IFNULL(ROUND(sum(daily_payment_report.total),2),'0') as total_payment,
									IFNULL(ROUND(sum(daily_payment_report.coupon),2),'0') as total_coupon,
									IFNULL(ROUND(sum(daily_payment_report.mobile_coupon),2),'0') as total_mobile_coupon,
									IFNULL(ROUND(sum(daily_payment_report.total_debit),2),'0') as ebt,
									IFNULL(ROUND(sum(daily_payment_report.total_cash),2),'0') as grand_total_cash,
									IFNULL(ROUND(sum(daily_payment_report.lottery_cash),2),'0') as grand_lottery_cash,
									stores.name as store_name,
									daily_payment_report.id as payment_id
									"))
						->leftJoin('users','users.id','=','daily_payment_report.user_id')
						->leftJoin('stores','stores.id','=','daily_payment_report.store_id')
						->where('stores.id', '=',$id)
						->where('daily_payment_report.status', '=',1)
						->whereDate('daily_payment_report.date', '>=',$date_from)
						->whereDate('daily_payment_report.date', '<=',$date_to)
						->groupBy('daily_payment_report.date')
						->groupBy('daily_payment_report.user_id')
						->orderBy('daily_payment_report.date','DESC')
						//->groupBy('stores.id')
						->get();
						foreach($payment as $s){
							$op[$s->pdate][$s->user_id]['store_name']=$s->store_name;
							$op[$s->pdate][$s->user_id]['payment']=$s->total_payment;
							$op[$s->pdate][$s->user_id]['total_coupon']=$s->total_coupon;
							$op[$s->pdate][$s->user_id]['total_mobile_coupon']=$s->total_mobile_coupon;
							$op[$s->pdate][$s->user_id]['ebt']=$s->ebt;
							$op[$s->pdate][$s->user_id]['grand_total_cash']= $s->grand_total_cash + $s->grand_lottery_cash;
							
							$op[$s->pdate][$s->user_id]['name']=$s->name;
							$op[$s->pdate][$s->user_id]['user_id']=$s->user_id;
							$op[$s->pdate][$s->user_id]['weekly_payment_total']=$s->total_p;
							$op[$s->pdate][$s->user_id]['payment_id']=$s->payment_id;
							$op[$s->pdate][$s->user_id]['pinsert_timestamp']=$s->pinsert_timestamp;
					}
					$stores = Inventory2::select(DB::raw(
						"DATE_FORMAT(inventory.date ,'%m/%d/%Y')as sdate,
									DATE_FORMAT(inventory.insert_timestamp ,'%m/%d/%Y %H:%i:%s')as iinsert_timestamp,
									users.name,
									inventory.user_id,
									IFNULL(ROUND(sum(inventory.price),2),'0') as price,
									stores.name as store_name,
									inventory.id as inventory_id
									"))
						
						->leftJoin('users','users.id','=','inventory.user_id')
						->leftJoin('stores','stores.id','=','inventory.store_id')
						->where('stores.id', '=',$id)
						->where('inventory.status', '=',1)
						->whereDate('inventory.date', '>=',$date_from)
						->whereDate('inventory.date', '<=',$date_to)
						->groupBy('inventory.date')
						->groupBy('inventory.user_id')
						->orderBy('inventory.date','DESC')
						//->groupBy('stores.id')
						->get();
						foreach($stores as $s){
							$op[$s->sdate][$s->user_id]['store_name']=$s->store_name;
							$op[$s->sdate][$s->user_id]['inventory']=$s->price;
							$op[$s->sdate][$s->user_id]['name']=$s->name;
							$op[$s->sdate][$s->user_id]['user_id']=$s->user_id;
							$op[$s->sdate][$s->user_id]['inventory_id']=$s->inventory_id;
							$op[$s->sdate][$s->user_id]['iinsert_timestamp']=$s->iinsert_timestamp;
						}
						
			$atm = DB::table('ATM')
						->select(DB::raw(
									"DATE_FORMAT(ATM.date ,'%m/%d/%Y')as atmdate,
									DATE_FORMAT(ATM.insert_timestamp ,'%m/%d/%Y %H:%i%s')as ainsert_timestamp,
									ATM.user_id,users.name,
									IFNULL(ROUND(sum(ATM.add_money),2),'0') as total_atm,
									IFNULL(ROUND(sum(ATM.cash),2),'0') as total_cash,
									IFNULL(ROUND(sum(ATM.fp),2),'0') as total_fp,
									stores.name as store_name,
									ATM.id as atm_id
									"))
						->leftJoin('users','users.id','=','ATM.user_id')
						->leftJoin('stores','stores.id','=','ATM.store_id')
						->where('stores.id', '=',$id)
						->where('ATM.status', '=',1)
						->whereDate('ATM.date', '>=',$date_from)
						->whereDate('ATM.date', '<=',$date_to)
						->groupBy('ATM.date')
						->groupBy('ATM.user_id')
						->orderBy('ATM.date','DESC')
						//->groupBy('stores.id')
						->get();
						foreach($atm as $s){
							$op[$s->atmdate][$s->user_id]['store_name']=$s->store_name;
							$op[$s->atmdate][$s->user_id]['atm']=round($s->total_atm,2);
							$op[$s->atmdate][$s->user_id]['total_cash']=round($s->total_cash,2);
							$op[$s->atmdate][$s->user_id]['total_fp']=round($s->total_fp,2);
							$op[$s->atmdate][$s->user_id]['name']=$s->name;
							$op[$s->atmdate][$s->user_id]['user_id']=$s->user_id;
							$op[$s->atmdate][$s->user_id]['atm_id']=$s->atm_id;
							$op[$s->atmdate][$s->user_id]['ainsert_timestamp']=$s->ainsert_timestamp;
					}
			$cigarettes = DB::table('cigarettes')
						->select(DB::raw(
									"DATE_FORMAT(cigarettes.date ,'%m/%d/%Y')as cigdate,
									DATE_FORMAT(cigarettes.insert_timestamp ,'%m/%d/%Y %H:%i%s')as cinsert_timestamp,
									cigarettes.user_id,users.name,
									IFNULL(ROUND(sum(cigarettes.sale_cigarette),2),'0') as total_cigarettes,
									stores.name as store_name,
									cigarettes.id as cigarette_id
									"))
						->leftJoin('users','users.id','=','cigarettes.user_id')
						->leftJoin('stores','stores.id','=','cigarettes.store_id')
						->where('stores.id', '=',$id)
						->where('cigarettes.status', '=',1)
						->whereDate('cigarettes.date', '>=',$date_from)
						->whereDate('cigarettes.date', '<=',$date_to)
						->groupBy('cigarettes.date')
						->groupBy('cigarettes.user_id')
						->orderBy('cigarettes.date','DESC')
						//->groupBy('stores.id')
						->get();
						foreach($cigarettes as $s){
							$op[$s->cigdate][$s->user_id]['store_name']=$s->store_name;
							$op[$s->cigdate][$s->user_id]['cigarettes']=round($s->total_cigarettes,2);
							$op[$s->cigdate][$s->user_id]['name']=$s->name;
							$op[$s->cigdate][$s->user_id]['user_id']=$s->user_id;
							$op[$s->cigdate][$s->user_id]['cigarette_id']=$s->cigarette_id;
							$op[$s->cigdate][$s->user_id]['cinsert_timestamp']=$s->cinsert_timestamp;
					}
			$lottery = DB::table('lottery')
						->select(DB::raw(
									"DATE_FORMAT(lottery.date ,'%m/%d/%Y')as lotdate,
									DATE_FORMAT(lottery.insert_timestamp ,'%m/%d/%Y %H:%i%s')as linsert_timestamp,
									lottery.user_id,users.name,
									IFNULL(ROUND(sum(lottery.total),2),'0') as total_lottery,
									IFNULL(ROUND(sum(lottery.weekly_commission),2),'0') as weekly_commission,
									IFNULL(ROUND(sum(lottery.weekly_eft_ammount),2),'0') as weekly_eft_ammount,
									stores.name as store_name,
									lottery.id as lottery_id
									"))
						->leftJoin('users','users.id','=','lottery.user_id')
						->leftJoin('stores','stores.id','=','lottery.store_id')
						->where('stores.id', '=',$id)
						->where('lottery.status', '=',1)
						->whereDate('lottery.date', '>=',$date_from)
						->whereDate('lottery.date', '<=',$date_to)
						->groupBy('lottery.date')
						->groupBy('lottery.user_id')
						->orderBy('lottery.date','DESC')
						//->groupBy('stores.id')
						->get();
						foreach($lottery as $s){
							$op[$s->lotdate][$s->user_id]['store_name']=$s->store_name;
							$op[$s->lotdate][$s->user_id]['lottery']=round($s->total_lottery,2);
							$op[$s->lotdate][$s->user_id]['weekly_commission']=round($s->weekly_commission,2);
							$op[$s->lotdate][$s->user_id]['weekly_eft_ammount']=round($s->weekly_eft_ammount,2);
							$op[$s->lotdate][$s->user_id]['name']=$s->name;
							$op[$s->lotdate][$s->user_id]['user_id']=$s->user_id;
							$op[$s->lotdate][$s->user_id]['lottery_id']=$s->lottery_id;
							$op[$s->lotdate][$s->user_id]['linsert_timestamp']=$s->linsert_timestamp;
					}
			$expense = DB::table('expense')
						->select(DB::raw(
									"DATE_FORMAT(expense.date ,'%m/%d/%Y')as expdate,
									DATE_FORMAT(expense.insert_timestamp ,'%m/%d/%Y %H:%i%s')as einsert_timestamp,
									expense.user_id,users.name,
									IFNULL(ROUND(sum(expense.price),2),'0') as total_expense,
									stores.name as store_name,
									expense.id as expense_id
									"))
						->leftJoin('users','users.id','=','expense.user_id')
						->leftJoin('stores','stores.id','=','expense.store_id')
						->where('stores.id', '=',$id)
						->where('expense.status', '=',1)
						->whereDate('expense.date', '>=',$date_from)
						->whereDate('expense.date', '<=',$date_to)
						->groupBy('expense.date')
						->groupBy('expense.user_id')
						->orderBy('expense.date','DESC')
						//->groupBy('stores.id')
						->get();
						foreach($expense as $s){
							$op[$s->expdate][$s->user_id]['store_name']=$s->store_name;
							$op[$s->expdate][$s->user_id]['expense']=round($s->total_expense,2);
							$op[$s->expdate][$s->user_id]['name']=$s->name;
							$op[$s->expdate][$s->user_id]['user_id']=$s->user_id;
							$op[$s->expdate][$s->user_id]['expense_id']=$s->expense_id;
							$op[$s->expdate][$s->user_id]['einsert_timestamp']=$s->einsert_timestamp;
					}
						$output=array();
						foreach($op as  $key => $v){
				
					foreach($v as  $k => $value){
						
						$pay= 0;
						
						$oversort= 0;
						if(isset($value["payment"]) && isset($value["sales1"])){
						$oversort=$value["payment"] - $value["sales1"];
						}else{
							$oversort = "0";
						}
						if(isset($value["weekly_payment_total"])){
						$pay=$value["weekly_payment_total"];
						}
						$sal= 0;
						if(isset($value["weekly_sales_total"])){
						$sal=$value["weekly_sales_total"];
						}

						$output[]=array("date"=>$key,
						"user_name"=>isset($value["name"])?$value["name"]:"",
						"store_name"=>$value["store_name"],
						"user_fk"=>isset($value["user_id"])?$value["user_id"]:"",
						"sales"=>isset($value["sales"])?strval(round($value["sales"],2)):"0",
						"payement"=>isset($value["payment"])?strval(round($value["payment"],2)):"0",
						"inventory"=>isset($value["inventory"])?strval(round($value["inventory"],2)):"0", 
						"atm"=>isset($value["atm"])?strval(round($value["atm"],2)):"0",
						"total_inside"=>isset($value["total_inside"])?strval(round($value["total_inside"],2)):"0",
						"total_tax"=>isset($value["total_tax"])?strval(round($value["total_tax"],2)):"0",
						"total_lottery_sale"=>isset($value["total_lottery_sale"])?strval(round($value["total_lottery_sale"],2)):"0", 
						"total_cash"=>isset($value["total_cash"])?strval(round($value["total_cash"],2)):"0", 
						"total_fp"=>isset($value["total_fp"])?strval(round($value["total_fp"],2)):"0", 
						"cigarettes"=>isset($value["cigarettes"])?strval(round($value["cigarettes"],2)):"0", 
						"lottery"=>isset($value["lottery"])?strval(round($value["lottery"],2)):"0", 
						"expense"=>isset($value["expense"])?strval(round($value["expense"],2)):"0", 
						"weekly_commission"=>isset($value["weekly_commission"])?strval(round($value["weekly_commission"],2)):"0", 
						"weekly_eft_ammount"=>isset($value["weekly_eft_ammount"])?strval(round($value["weekly_eft_ammount"],2)):"0", 
						"weekly_lottery_cash"=>strval(round($sal-$pay,2)), "oversort"=>strval(round($oversort,2)),
						"phone_card"=>isset($value["phone_card"])?strval(round($value["phone_card"],2)):"0",
						"total_gas"=>isset($value["total_gas"])?strval(round($value["total_gas"],2)):"0",
						"total_meat"=>isset($value["total_meat"])?strval(round($value["total_meat"],2)):"0",
						"ebt"=>isset($value["ebt"])?strval(round($value["ebt"],2)):"0",
						"total_coupon"=>isset($value["total_coupon"])?strval(round($value["total_coupon"],2)):"0",
						"total_mobile_coupon"=>isset($value["total_mobile_coupon"])?strval(round($value["total_mobile_coupon"],2)):"0",
						"sales_id"=>isset($value["sales_id"])?strval(round($value["sales_id"],2)):"0",
						"payment_id"=>isset($value["payment_id"])?strval(round($value["payment_id"],2)):"0",
						"inventory_id"=>isset($value["inventory_id"])?strval(round($value["inventory_id"],2)):"0",
						"lottery_id"=>isset($value["lottery_id"])?strval(round($value["lottery_id"],2)):"0",
						"expense_id"=>isset($value["expense_id"])?strval(round($value["expense_id"],2)):"0",
						"cigarette_id"=>isset($value["cigarette_id"])?strval(round($value["cigarette_id"],2)):"0",
						"atm_id"=>isset($value["atm_id"])?strval(round($value["atm_id"],2)):"0",
						
						"beer"=>isset($value["beer"])?strval(round($value["beer"],2)):"0",
						"grocery"=>isset($value["grocery"])?strval(round($value["grocery"],2)):"0",
						"pizza"=>isset($value["pizza"])?strval(round($value["pizza"],2)):"0",
						"deli"=>isset($value["deli"])?strval(round($value["deli"],2)):"0",
						"cigarette"=>isset($value["cigarette"])?strval(round($value["cigarette"],2)):"0",
						"ebt1"=>isset($value["ebt1"])?strval(round($value["ebt1"],2)):"0",
						"nontax"=>isset($value["nontax"])?strval(round($value["nontax"],2)):"0",
						"novelty"=>isset($value["novelty"])?strval(round($value["novelty"],2)):"0",
						"merchandise"=>isset($value["merchandise"])?strval(round($value["merchandise"],2)):"0",
						
						"grand_total_cash"=>isset($value["grand_total_cash"])?strval(round($value["grand_total_cash"],2)):"0",
						"sinsert_timestamp"=>isset($value["sinsert_timestamp"])?strval($value["sinsert_timestamp"]):"",
						"pinsert_timestamp"=>isset($value["pinsert_timestamp"])?strval($value["pinsert_timestamp"]):"",
						"iinsert_timestamp"=>isset($value["iinsert_timestamp"])?strval($value["iinsert_timestamp"]):"",
						"linsert_timestamp"=>isset($value["linsert_timestamp"])?strval($value["linsert_timestamp"]):"",
						"einsert_timestamp"=>isset($value["einsert_timestamp"])?strval($value["einsert_timestamp"]):"",
						"cinsert_timestamp"=>isset($value["cinsert_timestamp"])?strval($value["cinsert_timestamp"]):"",
						"ainsert_timestamp"=>isset($value["ainsert_timestamp"])?strval($value["ainsert_timestamp"]):""
						);
					}
				}
				usort($output, function($a, $b) {
				return  strtotime($a['date']) - strtotime($b['date']);
				});
					return response()->json(['status' =>'1', 'data'=>$output]);
			}
		}
		else
		{
			return response()->json(['status'=>'0', 'error_msg' =>'Token is invalid or expired!']);
		}
	}
	public function user_report_store(Request $request, JWTAuth $JWTAuth)
	{
		
		$user = $JWTAuth->parseToken()->authenticate();
		if(($user && $user->role == "admin")||true)
		{
		
			$id = $request->get('id');
			$date_from = $request->get('from');
			$date_to = $request->get('to');
			$store_id = $request->get('store_id');
			$user_id = $request->get('user_id');
			
			$user = User2::where(array("id"=>$user_id))->first();
			
			$store_access = $user['store_access'];
			
			//instant+lottery  lottery_cash+lottery_online_cashout+lottery_instant_cashout
			//echo $date_from." && ".$date_to." && ".$id."id";
			if(!empty($date_from) && !empty($date_to) && $id !=0){
				
				$sales = DB::table('daily_sales_entry')
						->select(DB::raw(
									"DATE_FORMAT(daily_sales_entry.date ,'%m/%d/%Y')as sdate,
									IFNULL(DATE_FORMAT(daily_sales_entry.insert_timestamp ,'%m/%d/%Y %H:%i:%s'),'') as sinsert_timestamp,
									daily_sales_entry.user_id,users.name, instant+lottery as total_s,
									IFNULL(ROUND(sum(daily_sales_entry.total_sales),2),'0') as total_sales,
									IFNULL(ROUND(sum(daily_sales_entry.inside),2),'0') as total_inside,
									IFNULL(ROUND(sum(daily_sales_entry.tax),2),'0') as total_tax,
									IFNULL(ROUND(sum(daily_sales_entry.phone_card),2),'0') as phone_card,
									IFNULL(ROUND(sum(daily_sales_entry.gas),2),'0') as total_gas,
									IFNULL(ROUND(sum(daily_sales_entry.instant+daily_sales_entry.lottery),2),'0') as total_lottery_sale,
									IFNULL(ROUND(sum(daily_sales_entry.meat),2),'0') as total_meat,
									IFNULL(ROUND(sum(daily_sales_entry.beer),2),'0') as beer,
									IFNULL(ROUND(sum(daily_sales_entry.grocery),2),'0') as grocery,
									IFNULL(ROUND(sum(daily_sales_entry.pizza),2),'0') as pizza,
									IFNULL(ROUND(sum(daily_sales_entry.deli),2),'0') as deli,
									IFNULL(ROUND(sum(daily_sales_entry.cigarette),2),'0') as cigarette,
									IFNULL(ROUND(sum(daily_sales_entry.ebt),2),'0') as ebt1,
									IFNULL(ROUND(sum(daily_sales_entry.nontax),2),'0') as nontax,
									IFNULL(ROUND(sum(daily_sales_entry.novelty),2),'0') as novelty,
									IFNULL(ROUND(sum(daily_sales_entry.merchandise),2),'0') as merchandise,
																		
									stores.name as store_name,
									daily_sales_entry.id as sales_id
									"))
						->leftJoin('users','users.id','=','daily_sales_entry.user_id')
						->leftJoin('stores','stores.id','=','daily_sales_entry.store_id')
						->where('daily_sales_entry.user_id', '=',$id)
						->where('daily_sales_entry.store_id', '=',$store_id)
						->where('daily_sales_entry.status', '=',1)
						->whereDate('daily_sales_entry.date', '>=',$date_from)
						->whereDate('daily_sales_entry.date', '<=',$date_to)
						->groupBy('daily_sales_entry.date')
						->groupBy('daily_sales_entry.user_id')
						->orderBy('daily_sales_entry.date','DESC')
						//->groupBy('stores.id')
						->get();
						$op=array();
						foreach($sales as $s){
							$op[$s->sdate][$s->user_id]['store_name']=$s->store_name;
							$op[$s->sdate][$s->user_id]['sales']=$s->total_sales;
							$op[$s->sdate][$s->user_id]['name']=$s->name;
							$op[$s->sdate][$s->user_id]['total_inside']=$s->total_inside;
							$op[$s->sdate][$s->user_id]['total_lottery_sale']=$s->total_lottery_sale;
							
							$op[$s->sdate][$s->user_id]['beer']=$s->beer;
							$op[$s->sdate][$s->user_id]['grocery']=$s->grocery;
							$op[$s->sdate][$s->user_id]['pizza']=$s->pizza;
							$op[$s->sdate][$s->user_id]['deli']=$s->deli;
							$op[$s->sdate][$s->user_id]['cigarette']=$s->cigarette;
							$op[$s->sdate][$s->user_id]['ebt1']=$s->ebt1;
							$op[$s->sdate][$s->user_id]['nontax']=$s->nontax;
							$op[$s->sdate][$s->user_id]['novelty']=$s->novelty;
							$op[$s->sdate][$s->user_id]['merchandise']=$s->merchandise;
							$op[$s->sdate][$s->user_id]['total_meat']=$s->total_meat;
							$op[$s->sdate][$s->user_id]['total_tax']=$s->total_tax;
							$op[$s->sdate][$s->user_id]['total_gas']=$s->total_gas;
							$op[$s->sdate][$s->user_id]['phone_card']=$s->phone_card;
							$op[$s->sdate][$s->user_id]['user_id']=$s->user_id;
							$op[$s->sdate][$s->user_id]['weekly_sales_total']=$s->total_s;
							$op[$s->sdate][$s->user_id]['sinsert_timestamp']=$s->sinsert_timestamp;
							//$op[$s->sdate][$s->user_id]['store_name']=$s->store_name;
						}
					$payment = DB::table('daily_payment_report')
						->select(DB::raw(
									"DATE_FORMAT(daily_payment_report.date ,'%m/%d/%Y')as pdate,
									DATE_FORMAT(daily_payment_report.insert_timestamp ,'%m/%d/%Y %H:%i:%s')as pinsert_timestamp,
									lottery_online_cashout+lottery_instant_cashout as total_p,
									daily_payment_report.user_id,users.name,
									IFNULL(ROUND(sum(daily_payment_report.total),2),'0') as total_payment,
									IFNULL(ROUND(sum(daily_payment_report.coupon),2),'0') as total_coupon,
									IFNULL(ROUND(sum(daily_payment_report.mobile_coupon),2),'0') as total_mobile_coupon,
									IFNULL(ROUND(sum(daily_payment_report.total_debit),2),'0') as ebt,
									IFNULL(ROUND(sum(daily_payment_report.total_cash+daily_payment_report.lottery_cash),2),'0') as grand_total,
									stores.name as store_name,
									daily_payment_report.id as payment_id
									"))
						->leftJoin('users','users.id','=','daily_payment_report.user_id')
						->leftJoin('stores','stores.id','=','daily_payment_report.store_id')
						->where('daily_payment_report.user_id', '=',$id)
						->where('daily_payment_report.store_id', '=',$store_id)
						->where('daily_payment_report.status', '=',1)
						->whereDate('daily_payment_report.date', '>=',$date_from)
						->whereDate('daily_payment_report.date', '<=',$date_to)
						->groupBy('daily_payment_report.date')
						->groupBy('daily_payment_report.user_id')
						->orderBy('daily_payment_report.date','DESC')
						//->groupBy('stores.id')
						->get();
						foreach($payment as $s){
							$op[$s->pdate][$s->user_id]['store_name']=$s->store_name;
							$op[$s->pdate][$s->user_id]['payment']=$s->total_payment;
							$op[$s->pdate][$s->user_id]['total_coupon']=$s->total_coupon;
							$op[$s->pdate][$s->user_id]['total_mobile_coupon']=$s->total_mobile_coupon;
							$op[$s->pdate][$s->user_id]['ebt']=$s->ebt;
							$op[$s->pdate][$s->user_id]['grand_total']=$s->grand_total;
							$op[$s->pdate][$s->user_id]['name']=$s->name;
							$op[$s->pdate][$s->user_id]['user_id']=$s->user_id;
							$op[$s->pdate][$s->user_id]['weekly_payment_total']=$s->total_p;
							$op[$s->pdate][$s->user_id]['pinsert_timestamp']=$s->pinsert_timestamp;
					}
					$stores = Inventory2::select(DB::raw(
						"DATE_FORMAT(inventory.date ,'%m/%d/%Y')as sdate,
									DATE_FORMAT(inventory.insert_timestamp ,'%m/%d/%Y %H:%i:%s')as iinsert_timestamp,
									users.name,
									inventory.user_id,
									IFNULL(ROUND(sum(inventory.price),2),'0') as price,
									stores.name as store_name,
									inventory.id as inventory_id
									"))
						
						->leftJoin('users','users.id','=','inventory.user_id')
						->leftJoin('stores','stores.id','=','inventory.store_id')
						->where('inventory.user_id', '=',$id)
						->where('inventory.store_id', '=',$store_id)
						->where('inventory.status', '=',1)
						->whereDate('inventory.date', '>=',$date_from)
						->whereDate('inventory.date', '<=',$date_to)
						->groupBy('inventory.date')
						->groupBy('inventory.user_id')
						->orderBy('inventory.date','DESC')
						//->groupBy('stores.id')
						->get();
						foreach($stores as $s){
							$op[$s->sdate][$s->user_id]['store_name']=$s->store_name;
							$op[$s->sdate][$s->user_id]['inventory']=$s->price;
							$op[$s->sdate][$s->user_id]['name']=$s->name;
							$op[$s->sdate][$s->user_id]['user_id']=$s->user_id;
							$op[$s->sdate][$s->user_id]['iinsert_timestamp']=$s->iinsert_timestamp;
						}
						
			$atm = DB::table('ATM')
						->select(DB::raw(
									"DATE_FORMAT(ATM.date ,'%m/%d/%Y')as atmdate,
									DATE_FORMAT(ATM.insert_timestamp ,'%m/%d/%Y %H:%i%s')as ainsert_timestamp,
									ATM.user_id,users.name,
									IFNULL(ROUND(sum(ATM.add_money),2),'0') as total_atm,
									IFNULL(ROUND(sum(ATM.cash),2),'0') as total_cash,
									IFNULL(ROUND(sum(ATM.fp),2),'0') as total_fp,
									stores.name as store_name,
									ATM.id as atm_id
									"))
						->leftJoin('users','users.id','=','ATM.user_id')
						->leftJoin('stores','stores.id','=','ATM.store_id')
						->where('ATM.user_id', '=',$id)
						->where('ATM.store_id', '=',$store_id)
						->where('ATM.status', '=',1)
						->whereDate('ATM.date', '>=',$date_from)
						->whereDate('ATM.date', '<=',$date_to)
						->groupBy('ATM.date')
						->groupBy('ATM.user_id')
						->orderBy('ATM.date','DESC')
						//->groupBy('stores.id')
						->get();
						foreach($atm as $s){
							$op[$s->atmdate][$s->user_id]['store_name']=$s->store_name;
							$op[$s->atmdate][$s->user_id]['atm']=round($s->total_atm,2);
							$op[$s->atmdate][$s->user_id]['total_cash']=round($s->total_cash,2);
							$op[$s->atmdate][$s->user_id]['total_fp']=round($s->total_fp,2);
							$op[$s->atmdate][$s->user_id]['name']=$s->name;
							$op[$s->atmdate][$s->user_id]['user_id']=$s->user_id;
							$op[$s->atmdate][$s->user_id]['ainsert_timestamp']=$s->ainsert_timestamp;
					}
			$cigarettes = DB::table('cigarettes')
						->select(DB::raw(
									"DATE_FORMAT(cigarettes.date ,'%m/%d/%Y')as cigdate,
									DATE_FORMAT(cigarettes.insert_timestamp ,'%m/%d/%Y %H:%i%s')as cinsert_timestamp,
									cigarettes.user_id,users.name,
									IFNULL(ROUND(sum(cigarettes.sale_cigarette),2),'0') as total_cigarettes,
									stores.name as store_name,
									cigarettes.id as cigarette_id
									"))
						->leftJoin('users','users.id','=','cigarettes.user_id')
						->leftJoin('stores','stores.id','=','cigarettes.store_id')
						->where('cigarettes.user_id', '=',$id)
						->where('cigarettes.store_id', '=',$store_id)
						->where('cigarettes.status', '=',1)
						->whereDate('cigarettes.date', '>=',$date_from)
						->whereDate('cigarettes.date', '<=',$date_to)
						->groupBy('cigarettes.date')
						->groupBy('cigarettes.user_id')
						->orderBy('cigarettes.date','DESC')
						//->groupBy('stores.id')
						->get();
						foreach($cigarettes as $s){
							$op[$s->cigdate][$s->user_id]['store_name']=$s->store_name;
							$op[$s->cigdate][$s->user_id]['cigarettes']=round($s->total_cigarettes,2);
							$op[$s->cigdate][$s->user_id]['name']=$s->name;
							$op[$s->cigdate][$s->user_id]['user_id']=$s->user_id;
							$op[$s->cigdate][$s->user_id]['cinsert_timestamp']=$s->cinsert_timestamp;
					}
			$lottery = DB::table('lottery')
						->select(DB::raw(
									"DATE_FORMAT(lottery.date ,'%m/%d/%Y')as lotdate,
									DATE_FORMAT(lottery.insert_timestamp ,'%m/%d/%Y %H:%i%s')as linsert_timestamp,
									lottery.user_id,users.name,
									IFNULL(ROUND(sum(lottery.total),2),'0') as total_lottery,
									IFNULL(ROUND(sum(lottery.weekly_commission),2),'0') as weekly_commission,
									IFNULL(ROUND(sum(lottery.weekly_eft_ammount),2),'0') as weekly_eft_ammount,
									stores.name as store_name,
									lottery.id as lottery_id
									"))
						->leftJoin('users','users.id','=','lottery.user_id')
						->leftJoin('stores','stores.id','=','lottery.store_id')
						->where('lottery.user_id', '=',$id)
						->where('lottery.store_id', '=',$store_id)
						->where('lottery.status', '=',1)
						->whereDate('lottery.date', '>=',$date_from)
						->whereDate('lottery.date', '<=',$date_to)
						->groupBy('lottery.date')
						->groupBy('lottery.user_id')
						->orderBy('lottery.date','DESC')
						//->groupBy('stores.id')
						->get();
						foreach($lottery as $s){
							$op[$s->lotdate][$s->user_id]['store_name']=$s->store_name;
							$op[$s->lotdate][$s->user_id]['lottery']=round($s->total_lottery,2);
							$op[$s->lotdate][$s->user_id]['weekly_commission']=round($s->weekly_commission,2);
							$op[$s->lotdate][$s->user_id]['weekly_eft_ammount']=round($s->weekly_eft_ammount,2);
							$op[$s->lotdate][$s->user_id]['name']=$s->name;
							$op[$s->lotdate][$s->user_id]['user_id']=$s->user_id;
							$op[$s->lotdate][$s->user_id]['linsert_timestamp']=$s->linsert_timestamp;
					}
					
			$expense = DB::table('expense')
						->select(DB::raw(
									"DATE_FORMAT(expense.date ,'%m/%d/%Y')as expdate,
									DATE_FORMAT(expense.insert_timestamp ,'%m/%d/%Y %H:%i%s')as einsert_timestamp,
									expense.user_id,users.name,
									IFNULL(ROUND(sum(expense.price),2),'0') as total_expense,
									stores.name as store_name,
									expense.id as expense_id
									"))
						->leftJoin('users','users.id','=','expense.user_id')
						->leftJoin('stores','stores.id','=','expense.store_id')
						->where('expense.user_id', '=',$id)
						->where('expense.store_id', '=',$store_id)
						->where('expense.status', '=',1)
						->whereDate('expense.date', '>=',$date_from)
						->whereDate('expense.date', '<=',$date_to)
						->groupBy('expense.date')
						->groupBy('expense.user_id')
						->orderBy('expense.date','DESC')
						//->groupBy('stores.id')
						->get();
						foreach($expense as $s){
							$op[$s->expdate][$s->user_id]['store_name']=$s->store_name;
							$op[$s->expdate][$s->user_id]['expense']=round($s->total_expense,2);
							$op[$s->expdate][$s->user_id]['name']=$s->name;
							$op[$s->expdate][$s->user_id]['user_id']=$s->user_id;
							$op[$s->expdate][$s->user_id]['einsert_timestamp']=$s->einsert_timestamp;
					}
						$output=array();
						
						foreach($op as  $key => $v){
				
					foreach($v as  $k => $value){
						
						$pay= 0;
						
						$oversort= 0;
						if(isset($value["payment"]) && isset($value["sales"])){
						$oversort=$value["payment"] - $value["sales"];
						}else{
							$oversort = "0";
						}
						if(isset($value["weekly_payment_total"])){
						$pay=$value["weekly_payment_total"];
						}
						$sal= 0;
						if(isset($value["weekly_sales_total"])){
						$sal=$value["weekly_sales_total"];
						}
						$grand_total = 0;
						if(isset($value["grand_total"])){
						$grand_total=$value["grand_total"];
						}
						$output[]=array("date"=>$key,
						"user_name"=>isset($value["name"])?$value["name"]:"",
						"store_name"=>$value["store_name"],
						"user_fk"=>isset($value["user_id"])?$value["user_id"]:"",
						"sales"=>isset($value["sales"])?strval(round($value["sales"],2)):"0",
						"payement"=>isset($value["payment"])?strval(round($value["payment"],2)):"0",
						"inventory"=>isset($value["inventory"])?strval(round($value["inventory"],2)):"0",
						"atm"=>isset($value["atm"])?strval(round($value["atm"],2)):"0",
						"total_inside"=>isset($value["total_inside"])?strval(round($value["total_inside"],2)):"0",
						"total_tax"=>isset($value["total_tax"])?strval(round($value["total_tax"],2)):"0",
						"total_meat"=>isset($value["total_meat"])?strval(round($value["total_meat"],2)):"0",
						"beer"=>isset($value["beer"])?strval(round($value["beer"],2)):"0",
						"grocery"=>isset($value["grocery"])?strval(round($value["grocery"],2)):"0",
						"pizza"=>isset($value["pizza"])?strval(round($value["pizza"],2)):"0",
						"deli"=>isset($value["deli"])?strval(round($value["deli"],2)):"0",
						"cigarette"=>isset($value["cigarette"])?strval(round($value["cigarette"],2)):"0",
						"ebt1"=>isset($value["ebt1"])?strval(round($value["ebt1"],2)):"0",
						"nontax"=>isset($value["nontax"])?strval(round($value["nontax"],2)):"0",
						"novelty"=>isset($value["novelty"])?strval(round($value["novelty"],2)):"0",
						"merchandise"=>isset($value["merchandise"])?strval(round($value["merchandise"],2)):"0",
						"total_coupon"=>isset($value["total_coupon"])?strval(round($value["total_coupon"],2)):"0",
						"total_mobile_coupon"=>isset($value["total_mobile_coupon"])?strval(round($value["total_mobile_coupon"],2)):"0",
						"total_lottery_sale"=>isset($value["total_lottery_sale"])?strval(round($value["total_lottery_sale"],2)):"0",
						"total_cash"=>isset($value["total_cash"])?strval(round($value["total_cash"],2)):"0",
						"total_fp"=>isset($value["total_fp"])?strval(round($value["total_fp"],2)):"0",
						"cigarettes"=>isset($value["cigarettes"])?strval(round($value["cigarettes"],2)):"0",
						"lottery"=>isset($value["lottery"])?strval(round($value["lottery"],2)):"0",
						"expense"=>isset($value["expense"])?strval(round($value["expense"],2)):"0",
						"weekly_commission"=>isset($value["weekly_commission"])?strval(round($value["weekly_commission"],2)):"0",
						"weekly_eft_ammount"=>isset($value["weekly_eft_ammount"])?strval(round($value["weekly_eft_ammount"],2)):"0",
						"weekly_lottery_cash"=>strval(round($sal-$pay,2)),
						"oversort"=>strval(round($oversort,2)),
						"phone_card"=>isset($value["phone_card"])?strval(round($value["phone_card"],2)):"0",
						"total_gas"=>isset($value["total_gas"])?strval(round($value["total_gas"],2)):"0",
						"ebt"=>isset($value["ebt"])?strval(round($value["ebt"],2)):"0",
						"grand_total"=>$grand_total,
						
						"sinsert_timestamp"=>isset($value["sinsert_timestamp"])?strval($value["sinsert_timestamp"]):"",
						"pinsert_timestamp"=>isset($value["pinsert_timestamp"])?strval($value["pinsert_timestamp"]):"",
						"iinsert_timestamp"=>isset($value["iinsert_timestamp"])?strval($value["iinsert_timestamp"]):"",
						"linsert_timestamp"=>isset($value["linsert_timestamp"])?strval($value["linsert_timestamp"]):"",
						"einsert_timestamp"=>isset($value["einsert_timestamp"])?strval($value["einsert_timestamp"]):"",
						"cinsert_timestamp"=>isset($value["cinsert_timestamp"])?strval($value["cinsert_timestamp"]):"",
						"ainsert_timestamp"=>isset($value["ainsert_timestamp"])?strval($value["ainsert_timestamp"]):""
						
						);
					}
				}

				usort($output, function($a, $b) {
				return  strtotime($a['date']) - strtotime($b['date']);
				});
					return response()->json(['status' =>'1', 'data'=>$output]);
			}
		}
		else
		{
			return response()->json(['status'=>'0', 'error_msg' =>'Token is invalid or expired!']);
		}
	}

	public function add_inventory(Request $request, JWTAuth $JWTAuth)
	{
		$user = $JWTAuth->parseToken()->authenticate();
		if($user || true)
		{
			$validator = Validator::make($request->all(), [
            'date' => 'required',
			'invoice_no' => 'required',
			'item' => 'required',
			'vendor' => 'required',
			'quantity' => 'required',
			'price' => 'required',
			'total_price' => 'required',
			'store_id' => 'required',
			'user_id' => 'required',
			'insert_timestamp' => 'required',
        ]);
		
		if ($validator->fails()) {
				return response()->json(['status'=>'0', 'error_msg' =>'Please provide valid values for all fields!']);
			}else{
				$user_data = User2::where(array("id"=>$request->get('user_id')))->first();
				$data1 = $request->all();
				$store = User2::where(array("id"=>$data1['user_id']))->first();
				$count1 = Stores2::where(array("id"=>$store['store_id']))->first();
				if($count1['status']==0){
					return response()->json(['status'=>'0', 'error_msg' =>'Sorry! Your store is no longer active!']);
				}
				$data1['store_id'] = $user_data['store_id'];
				$count = inventory2::whereDate("inventory.date", "=", $data1['date'])->where(array("user_id"=>$data1['user_id'],"status"=>"1","store_id"=>$user_data['store_id']))->count();
				if(false){
					return response()->json(['status'=>'0', 'error_msg' =>'Inventory report already added for this date by this user!']);
				}else{
					$data1['total_price']=$data1['price'];
			
					$new_item = new Inventory2($data1);
					$query=json_encode($data1);
			//		mail("hiten@virtualheight.com","My subject",$query);
				$new_item->save();
     	 		if($new_item) {
				return response()->json(['status'=>'1', 'data' =>'Inventory successfully added!']);
        	   }else {
        	   return response()->json(['status'=>'0', 'error_msg' =>'Some error occured!']);
        	   	}
				}
			}
		}
		else
		{
			return response()->json(['status'=>'0', 'error_msg' =>'Token is invalid or expired!']);
		}
	}
	public function add_payment_report(Request $request, JWTAuth $JWTAuth)
	{
		$user = $JWTAuth->parseToken()->authenticate();
		if(($user && $user->role == "staff")||true)
		{
			$validator = Validator::make($request->all(), [
			'date' => 'required',
            'total_cash' => 'required',
			'total_credit' => 'required',
			'total_debit' => 'required',
			'total' => 'required',
			'lottery_out' => 'required',
			'store_id' => 'required',
			'user_id' => 'required',
			'lottery_online_cashout' => 'required',
			'lottery_instant_cashout' => 'required',
			'lottery_cash' => 'required',
	
        ]);
		if ($validator->fails()) {
			 //return $validator->errors()->all();
				return response()->json(['status'=>'0', 'error_msg' =>'Please provide valid values for all fields!']);
			}else{
				$data1 = $request->all();
				$store = User2::where(array("id"=>$data1['user_id']))->first();
				$count1 = Stores2::where(array("id"=>$store['store_id']))->first();
				if($count1['status']==0){
					return response()->json(['status'=>'0', 'error_msg' =>'Sorry! Your store is no longer active!']);
				}
				$data1['store_id'] = $store['store_id'];
				$count = Payments2::whereDate("daily_payment_report.date", "=", $data1['date'])->where(array("user_id"=>$data1['user_id'],"status"=>"1"))->count();
				if($count>0){
					return response()->json(['status'=>'0', 'error_msg' =>'Daily payment report already added for this date by this user!']);
				}else{
					$new_item = new Payments2($data1);
				$new_item->save();
     	 		if($new_item) {
				return response()->json(['status'=>'1', 'data' =>'Daily payment report successfully added!']);
        	   }else {
        	   return response()->json(['status'=>'0', 'error_msg' =>'Some error occured!']);
        	   	}
				}
			}
		}
		else
		{
			return response()->json(['status'=>'0', 'error_msg' =>'Token is invalid or expired!']);
		}
	}
	public function get_vendor_items(Request $request, JWTAuth $JWTAuth)
	{
		$user = $JWTAuth->parseToken()->authenticate();
		if($user || true)
		{
			$items = Items2::where(array("status"=>1))->get();
			$vendors = Vendors2::where(array("status"=>1))->get();
			return response()->json(['status'=>'1', 'items' =>$items, 'vendors'=>$vendors]);
		}
		else
		{
			return response()->json(['status'=>'0', 'error_msg' =>'Token is invalid or expired!']);
		}
	}
	public function all_daily_report(Request $request, JWTAuth $JWTAuth)
	{
		$user = $JWTAuth->parseToken()->authenticate();
		if($user || true)
		{
			$day = $request->get('day');
			if(!empty($day)){
				$sales = Sales2::whereDate("daily_sales_entry.date", "=", date('Y-m-d',strtotime($day)))->get();
				$payments = Payments2::whereDate("daily_payment_report.date", "=", date('Y-m-d',strtotime($day)))->get();
				$inventory = inventory2::whereDate("inventory.date", "=", date('Y-m-d',strtotime($day)))->get();
				return response()->json(['status'=>'1', 'sales' =>$sales, 'payments'=>$payments, 'inventory'=>$inventory]);
			}else{
				return response()->json(['status'=>'0', 'error_msg' =>'Provide date to get reports!']);
			}
			
		}
		else
		{
			return response()->json(['status'=>'0', 'error_msg' =>'Token is invalid or expired!']);
		}
	}
	public function add_lottery(Request $request, JWTAuth $JWTAuth)
	{
		$user = $JWTAuth->parseToken()->authenticate();
		if(($user && $user->role == "staff")||true)
		{
			$validator = Validator::make($request->all(), [
			'date' => 'required',
			'inventory' => 'required',
            'add_book' => 'required',
			'active_book' => 'required',
			'total' => 'required',
			'store_id' => 'required',
			'user_id' => 'required',
			'weekly_eft_ammount' => 'required',
			'weekly_commission' => 'required',
			'insert_timestamp' => 'required',
        ]);
		if ($validator->fails()) {
				return response()->json(['status'=>'0', 'error_msg' =>'Please provide valid values for all fields!']);
			}else{
				$data1 = $request->all();
				$user_data = User2::where(array("id"=>$request->get('user_id')))->first();
				$store = User2::where(array("id"=>$data1['user_id']))->first();
				$count1 = Stores2::where(array("id"=>$store['store_id']))->first();
				if($count1['status']==0){
					return response()->json(['status'=>'0', 'error_msg' =>'Sorry! Your store is no longer active!']);
				}
				$data1['store_id'] = $store['store_id'];
				$count = Lottery2::whereDate("lottery.date", "=", $data1['date'])->where(array("user_id"=>$data1['user_id'],"status"=>"1","store_id"=>$user_data['store_id']))->count();
				if($count>0){
					return response()->json(['status'=>'0', 'error_msg' =>'Lottery entry already added for this date by this user!']);
				}else{
					$data1['store_id'] = $user_data['store_id'];
					$new_item = new Lottery2($data1);
				$new_item->save();
     	 		if($new_item) {
					
					$os = $request->get('total')-$request->get('inventory');
					if($os >= 10){
						$store_id = $data1['store_id'];
						$user_list = DB::table('users')
									->select(DB::raw('device_type,firebase_token'))
									 ->whereRaw("find_in_set(".$store_id.",store_access)")
									->get();
						foreach($user_list as $exist){
							if($exist->device_type != ""){
								
								$device_id = $exist->firebase_token;
								$notificationtype = $exist->device_type;
								
								$url = 'http://website-demo.in/aaraypush_new/push.php?device_id='.$device_id.'&msg=Overshot is '.$os.' &type=reportl&notificationtype='.$notificationtype.'&date='.$request->get('date').'&store_id='.$request->get('store_id');
								$url = str_replace(" ","%20",$url);
								$data = $this->get_content($url);
								$data2 = json_decode($data);
							}
						}
					}
				return response()->json(['status'=>'1', 'data' =>'Lottery details successfully added!']);
        	   }else {
        	   return response()->json(['status'=>'0', 'error_msg' =>'Some error occured!']);
        	   	}
				}
			}
		}
		else
		{
			return response()->json(['status'=>'0', 'error_msg' =>'Token is invalid or expired!']);
		}
	}
	public function add_expense(Request $request, JWTAuth $JWTAuth)
	{
		$user = $JWTAuth->parseToken()->authenticate();
		if(($user && $user->role == "staff")||true)
		{
			$validator = Validator::make($request->all(), [
			'item_id' => 'required',
			'title' => 'required',
            'price' => 'required',
			'store_id' => 'required',
			'user_id' => 'required',
			'date' => 'required',
			'insert_timestamp' => 'required',
        ]);
		if ($validator->fails()) {
				return response()->json(['status'=>'0', 'error_msg' =>'Please provide valid values for all fields!']);
			}else{
					$data1 = $request->all();
					$store = User2::where(array("id"=>$data1['user_id']))->first();
					$count1 = Stores2::where(array("id"=>$store['store_id']))->first();
					if($count1['status']==0){
						return response()->json(['status'=>'0', 'error_msg' =>'Sorry! Your store is no longer active!']);
					}
					$data1['store_id'] = $store['store_id'];
					$new_item = new Expense2($data1);
				$new_item->save();
     	 		if($new_item) {
				return response()->json(['status'=>'1', 'data' =>'Expense details successfully added!']);
        	   }else {
        	   return response()->json(['status'=>'0', 'error_msg' =>'Some error occured!']);
        	   	}
				
			}
		}
		else
		{
			return response()->json(['status'=>'0', 'error_msg' =>'Token is invalid or expired!']);
		}

	}
	public function send_message(Request $request, JWTAuth $JWTAuth)
	{
		//$data1 = $request->all();
		//print_r($data1); die();
		$user = $JWTAuth->parseToken()->authenticate();
		if(($user && $user->role == "staff")||true)
		{
			$validator = Validator::make($request->all(), [
			'subject' => 'required',
            'description' => 'required',
			'user_id' => 'required',
			'date' => 'required',
			'username' => 'required',
			'insert_timestamp' => 'required',
        ]);
		if ($validator->fails()) {
				return response()->json(['status'=>'0', 'error_msg' =>'Please provide valid values for all fields!']);
			}else{
				$data1 = $request->all();
				$data2['email'] = "nikhil@aaryagroup.us";
				
				
				if ($request->hasFile('image')){
					
					
					$validator = Validator::make($request->all(), [
						'image' => 'required|max:10000|mimes:jpg,jpeg,png,gif',
					]);
					if ($validator->fails()) {
						return response()->json(['status'=>'0', 'error_msg' =>'Invalid image!']);
					}else{
						$image = $request->file('image')->getClientOriginalName();
						$image = time().str_replace(" ","_",$image);
						$data1['image']=$image;
					
						$destination = public_path().'/admin_assets/uploads/';
						$request->file('image')->move($destination, $image);
					}
				}
				
				if ($request->hasFile('image')){
					$data2['subject'] = $data1['subject'];
					$data2['description'] = $data1['description'];
					$data2['username'] = $data1['username'];
					$data2['email'] = "nikhil@aaryagroup.us";
					//$data2['email'] = "rajan@virtualheight.com";
					$data2['pathToFile'] = asset('admin_assets/uploads/')."/".$image;
					Mail::send('admin.message_email',$data2, function($message) use ($data2){
								$message->from('support@aaryagroup.com', 'Aarya Group');
								$message->to($data2['email']);
								$message->subject('New message');
								$message->attach($data2['pathToFile']);
					});
				}else{
					$data2['subject'] = $data1['subject'];
					$data2['description'] = $data1['description'];
					$data2['username'] = $data1['username'];
					$data2['email'] = "nikhil@aaryagroup.us";
					//$data2['email'] = "rajan@virtualheight.com";
					Mail::send('admin.message_email',$data2, function($message) use ($data2){
								$message->from('support@aaryagroup.com', 'Aarya Group');
								$message->to($data2['email']);
								$message->subject('New message');
					});
				}
				
				if( count(Mail::failures()) > 0 ) {
					//echo "There was one or more failures. They were: <br />";
					//print_R(Mail::failures()); die();
				}
				
     	 		$new_item = new Messages2($data1);
				$new_item->save();
				$lastId = $new_item->id;
				$data2['email'] = "admin@virtualheight.com"; 
				$exist = User2::where("email",'=',$data2['email'])->first();
				if($exist['device_type'] != ""){
					$device_id = $exist['firebase_token'];
					$notificationtype = $exist['device_type'];
					$url = 'http://website-demo.in/aaraypush_new/push.php?device_id='.$device_id.'&msg='.$data1['subject'].'&type=msg&notificationtype='.$notificationtype.'&msg_id='.$lastId;
					$url = str_replace(" ","%20",$url);
					$data = $this->get_content($url);
					$data2 = json_decode($data);
				}
				$data2['email'] = "nikhil@aaryagroup.us";
				
				$exist = User2::where("email",'=',$data2['email'])->first();
				if($exist['device_type'] != ""){
					$device_id = $exist['firebase_token'];
					$notificationtype = $exist['device_type'];
					$url = 'http://website-demo.in/aaraypush_new/push.php?device_id='.$device_id.'&msg='.$data1['subject'].'&type=msg&notificationtype='.$notificationtype.'&msg_id='.$lastId;
					$url = str_replace(" ","%20",$url);
					$data = $this->get_content($url);
					$data2 = json_decode($data);
				}
     	 		if($new_item) {
				return response()->json(['status'=>'1', 'data' =>'Message successfully sent to admin!']);
        	   }else {
        	   return response()->json(['status'=>'0', 'error_msg' =>'Some error occured!']);
        	   	}
			}
		}
		else
		{
			return response()->json(['status'=>'0', 'error_msg' =>'Token is invalid or expired!']);
		}
	}
	public function get_expense_items(Request $request, JWTAuth $JWTAuth)
	{
		$user = $JWTAuth->parseToken()->authenticate();
		if(($user && $user->role == "staff")||true)
		{
			$expenseitems = ExpenseItems2::where(array("status"=>1))->get();
			return response()->json(['status' =>'1', 'expenseitems'=>$expenseitems]);
		}
		else
		{
			return response()->json(['status'=>'0', 'error_msg' =>'Token is invalid or expired!']);
		}
	}
	public function get_config(Request $request, JWTAuth $JWTAuth)
	{
		
		$user = $JWTAuth->parseToken()->authenticate();
		if($request->get('firebase_token') != ""){
			$user_data = array("device_type"=>$request->get('device_type'),"firebase_token"=>$request->get('firebase_token'));
			$update = User2::where(array("id"=>$user->id))->update($user_data);
		}
		return response()->json(['compulsary'=>'1', 'androidversion' =>'35', 'message'=>'A new version of this app is available. Update your app now to continue using this app.']);
	}
	public function admin_sales_edit(Request $request, JWTAuth $JWTAuth)
	{
		$user = $JWTAuth->parseToken()->authenticate();
		if(($user && $user->role == "admin")||true)
		{
			$id = $request->get('id');
			$data = $request->all();
			//$data['total_sales'] = $data['inside']+$data['tax']+$data['gas']+$data['instant']+$data['lottery'];
			$data['inside']=$data['beer']+$data['grocery']+$data['pizza']+$data['deli']+$data['cigarette']+$data['ebt']+$data['nontax']+$data['novelty']+$data['merchandise']+$data['meat'];
			$data['total_sales'] = $data['inside']+$data['tax']+$data['gas']+$data['instant']+$data['lottery']+$data['add_money_order']+$data['phone_card']+$data['wu_amount'];
			$update = Sales4::where("id","=",$id)->update($data);
			if($update){
				return response()->json(['status' =>'1', 'data'=>'Sales report successfully updated!']);
			}else{
				return response()->json(['status'=>'0', 'error_msg' =>'Unknown error occured while updating sales report. please try again!']);
			}
		}
		else
		{
			return response()->json(['status'=>'0', 'error_msg' =>'Token is invalid or expired!']);
		}
	}
	public function admin_payment_edit(Request $request, JWTAuth $JWTAuth)
	{
		$user = $JWTAuth->parseToken()->authenticate();
		if(($user && $user->role == "admin")||true)
		{
			$id = $request->get('id');
			$data = $request->all();
			$data['total'] = $data['total_cash']+$data['total_credit']+$data['total_debit']+$data['lottery_online_cashout']+$data['lottery_instant_cashout']+$data['lottery_cash']+$data['lottery_out']+$data['wu_pay_out']+$data['coupon']+$data['mobile_coupon'];
			
				//hiten
			$update = Payments4::where("id","=",$id)->update($data);
			if($update){
				return response()->json(['status' =>'1', 'data'=>'Payment report successfully updated!']);
			}else{
				return response()->json(['status'=>'0', 'error_msg' =>'Unknown error occured while updating payment report. please try again!']);
			}
		}
		else
		{
			return response()->json(['status'=>'0', 'error_msg' =>'Token is invalid or expired!']);
		}
	}
	public function admin_inventory_edit(Request $request, JWTAuth $JWTAuth)
	{
		$user = $JWTAuth->parseToken()->authenticate();
		if(($user && $user->role == "admin")||true)
		{
			$id = $request->get('id');
			$data = $request->all();
			$data2=array();
			$data2['date']=$data['date'];
			$data2['invoice_no']=$data['invoice_no'];
			$data2['item']=$data['item'];
			$data2['vendor']=$data['vendor'];
			$data2['quantity']=$data['quantity'];
			$data2['price']=$data['price'];
			$data2['total_price']=$data['price'];
			$data2['cheque_no']=$data['cheque_no'];
			$data2['pay_by']=$data['pay_by'];
			$update = inventory2::where("id","=",$id)->update($data2);
			if($update){
				return response()->json(['status' =>'1', 'data'=>'Inventory report successfully updated!']);
			}else{
				return response()->json(['status'=>'0', 'error_msg' =>'Unknown error occured while updating inventory report. please try again!']);
			}
		}
		else
		{
			return response()->json(['status'=>'0', 'error_msg' =>'Token is invalid or expired!']);
		}
	}
	public function admin_atm_edit(Request $request, JWTAuth $JWTAuth)
	{
		$user = $JWTAuth->parseToken()->authenticate();
		if(($user && $user->role == "admin")||true)
		{
			$id = $request->get('id');
			$data = $request->all();
			$update = ATM2::where("id","=",$id)->update($data);
			if($update){
				return response()->json(['status' =>'1', 'data'=>'ATM report successfully updated!']);
			}else{
				return response()->json(['status'=>'0', 'error_msg' =>'Unknown error occured while updating ATM report. please try again!']);
			}
		}
		else
		{
			return response()->json(['status'=>'0', 'error_msg' =>'Token is invalid or expired!']);
		}
	}
	public function admin_cigarette_edit(Request $request, JWTAuth $JWTAuth)
	{
		$user = $JWTAuth->parseToken()->authenticate();
		if(($user && $user->role == "admin")||true)
		{
			$id = $request->get('id');
			$data = $request->all();
			$update = Cigarettes2::where("id","=",$id)->update($data);
			if($update){
				return response()->json(['status' =>'1', 'data'=>'Cigarettes report successfully updated!']);
			}else{
				return response()->json(['status'=>'0', 'error_msg' =>'Unknown error occured while updating Cigarettes report. please try again!']);
			}
		}
		else
		{
			return response()->json(['status'=>'0', 'error_msg' =>'Token is invalid or expired!']);
		}
	}
	public function admin_lottery_edit(Request $request, JWTAuth $JWTAuth)
	{
		$user = $JWTAuth->parseToken()->authenticate();
		if(($user && $user->role == "admin")||true)
		{
			$id = $request->get('id');
			$data = $request->all();
			$update = Lottery2::where("id","=",$id)->update($data);
			if($update){
				return response()->json(['status' =>'1', 'data'=>'Lottery report successfully updated!']);
			}else{
				return response()->json(['status'=>'0', 'error_msg' =>'Unknown error occured while updating Lottery report. please try again!']);
			}
		}
		else
		{
			return response()->json(['status'=>'0', 'error_msg' =>'Token is invalid or expired!']);
		}
	}
	public function admin_expense_edit(Request $request, JWTAuth $JWTAuth)
	{
		$user = $JWTAuth->parseToken()->authenticate();
		if(($user && $user->role == "admin")||true)
		{
			$id = $request->get('id');
			$data = $request->all();
			$update = Expense2::where("id","=",$id)->update($data);
			if($update){
				return response()->json(['status' =>'1', 'data'=>'Expense report successfully updated!']);
			}else{
				return response()->json(['status'=>'0', 'error_msg' =>'Unknown error occured while updating Expense report. please try again!']);
			}
		}
		else
		{
			return response()->json(['status'=>'0', 'error_msg' =>'Token is invalid or expired!']);
		}
	}
	public function admin_sales_delete(Request $request, JWTAuth $JWTAuth)
	{
		$user = $JWTAuth->parseToken()->authenticate();
		if(($user && $user->role == "admin")||true)
		{
			$id = $request->get('id');
			$update = Sales2::where("id","=",$id)->update(array("status"=>0));
			if($update){
				return response()->json(['status' =>'1', 'data'=>'Sales report successfully deleted!']);
			}else{
				return response()->json(['status'=>'0', 'error_msg' =>'Unknown error occured while deleting sales report. please try again!']);
			}
		}
		else
		{
			return response()->json(['status'=>'0', 'error_msg' =>'Token is invalid or expired!']);
		}
	}
	public function admin_payment_delete(Request $request, JWTAuth $JWTAuth)
	{
		$user = $JWTAuth->parseToken()->authenticate();
		if(($user && $user->role == "admin")||true)
		{
			$id = $request->get('id');
			$update = Payments2::where("id","=",$id)->update(array("status"=>0));
			if($update){
				return response()->json(['status' =>'1', 'data'=>'Payment report successfully deleted!']);
			}else{
				return response()->json(['status'=>'0', 'error_msg' =>'Unknown error occured while deleting payment report. please try again!']);
			}
		}
		else
		{
			return response()->json(['status'=>'0', 'error_msg' =>'Token is invalid or expired!']);
		}
	}
	public function admin_inventory_delete(Request $request, JWTAuth $JWTAuth)
	{
		$user = $JWTAuth->parseToken()->authenticate();
		if(($user && $user->role == "admin")||true)
		{
			$id = $request->get('id');
			$update = inventory2::where("id","=",$id)->update(array("status"=>0));
			if($update){
				return response()->json(['status' =>'1', 'data'=>'Inventory report successfully deleted!']);
			}else{
				return response()->json(['status'=>'0', 'error_msg' =>'Unknown error occured while deleting inventory report. please try again!']);
			}
		}
		else
		{
			return response()->json(['status'=>'0', 'error_msg' =>'Token is invalid or expired!']);
		}
	}
	public function admin_atm_delete(Request $request, JWTAuth $JWTAuth)
	{
		$user = $JWTAuth->parseToken()->authenticate();
		if(($user && $user->role == "admin")||true)
		{
			$id = $request->get('id');
			$update = ATM2::where("id","=",$id)->update(array("status"=>0));
			if($update){
				return response()->json(['status' =>'1', 'data'=>'ATM report successfully deleted!']);
			}else{
				return response()->json(['status'=>'0', 'error_msg' =>'Unknown error occured while deleting ATM report. please try again!']);
			}
		}
		else
		{
			return response()->json(['status'=>'0', 'error_msg' =>'Token is invalid or expired!']);
		}
	}
	public function admin_cigarette_delete(Request $request, JWTAuth $JWTAuth)
	{
		$user = $JWTAuth->parseToken()->authenticate();
		if(($user && $user->role == "admin")||true)
		{
			$id = $request->get('id');
			$update = Cigarettes2::where("id","=",$id)->update(array("status"=>0));
			if($update){
				return response()->json(['status' =>'1', 'data'=>'Cigarettes report successfully deleted!']);
			}else{
				return response()->json(['status'=>'0', 'error_msg' =>'Unknown error occured while deleting Cigarettes report. please try again!']);
			}
		}
		else
		{
			return response()->json(['status'=>'0', 'error_msg' =>'Token is invalid or expired!']);
		}
	}
	public function admin_lottery_delete(Request $request, JWTAuth $JWTAuth)
	{
		$user = $JWTAuth->parseToken()->authenticate();
		if(($user && $user->role == "admin")||true)
		{
			$id = $request->get('id');
			$update = Lottery2::where("id","=",$id)->update(array("status"=>0));
			if($update){
				return response()->json(['status' =>'1', 'data'=>'Lottery report successfully deleted!']);
			}else{
				return response()->json(['status'=>'0', 'error_msg' =>'Unknown error occured while deleting Lottery report. please try again!']);
			}
		}
		else
		{
			return response()->json(['status'=>'0', 'error_msg' =>'Token is invalid or expired!']);
		}
	}
	public function admin_expense_delete(Request $request, JWTAuth $JWTAuth)
	{
		$user = $JWTAuth->parseToken()->authenticate();
		if(($user && $user->role == "admin")||true)
		{
			$id = $request->get('id');
			$update = Expense2::where("id","=",$id)->update(array("status"=>0));
			if($update){
				return response()->json(['status' =>'1', 'data'=>'Expense report successfully deleted!']);
			}else{
				return response()->json(['status'=>'0', 'error_msg' =>'Unknown error occured while deleting Expense report. please try again!']);
			}
		}
		else
		{
			return response()->json(['status'=>'0', 'error_msg' =>'Token is invalid or expired!']);
		}
	}
	public function store_list_new(Request $request, JWTAuth $JWTAuth)
    {
        $user = $JWTAuth->parseToken()->authenticate();
        if(($user && $user->role == "admin")||true)
        {
            $store_data = DB::table('stores')
                ->select(DB::raw(
                    'stores.*,
									(SELECT IFNULL(SUM(total),"0")  FROM daily_payment_report WHERE daily_payment_report.store_id=stores.id) AS payments,
									(SELECT IFNULL(SUM(total_sales),"0")  FROM daily_sales_entry WHERE daily_sales_entry.store_id=stores.id) AS sales,
									(SELECT IFNULL(SUM(total_price),"0")  FROM inventory WHERE inventory.store_id=stores.id) AS inventory
									'))
                ->leftJoin('daily_payment_report', 'daily_payment_report.store_id', '=', 'stores.id')
                ->leftJoin('daily_sales_entry', 'daily_sales_entry.store_id', '=', 'stores.id')
                ->leftJoin('inventory', 'inventory.store_id', '=', 'stores.id')
                ->where('stores.status','=','1')
                ->groupBy('stores.id')
                ->get();
            return response()->json(['status' =>'1', 'Store_list'=>$store_data]);
        }
        else
        {
            return response()->json(['status'=>'0', 'error_msg' =>'Token is invalid or expired!']);
        }
    }
	public function del_user(Request $request, JWTAuth $JWTAuth)
	{
		$user = $JWTAuth->parseToken()->authenticate();
		if(($user && $user->role == "admin")||true)
		{
			$id = $request->get('id');
			if(!empty($id)){
				$user = User2::where(array("id"=>$id))->first();
				if(!empty($user)){
						$block = User2::where("id","=",$id)->first();
						//$credentials = array("email"=>$block['email'], "password"=>$block['password']);
						//$token = $JWTAuth->attempt($credentials);
						//$JWTAuth->invalidate($token);
						$up = array("status"=>2, "deleted_by"=>$request->get('user_id'));
						$update = User2::where(array("id"=>$id))->update($up);
						return response()->json(['status'=>'1', 'data' =>'User successfully deleted!']);
					
				}else{
					return response()->json(['status'=>'0', 'error_msg' =>'No user found with this id!']);
				}
			}else{
				return response()->json(['status'=>'0', 'error_msg' =>'Provide id of the user!']);
			}
			
		}
		else
		{
			return response()->json(['status'=>'0', 'error_msg' =>'Token is invalid or expired!']);
		}
	}
	public function add_atm(Request $request, JWTAuth $JWTAuth)
	{
		$user = $JWTAuth->parseToken()->authenticate();
		if(($user && $user->role == "staff")||true)
		{
			$validator = Validator::make($request->all(), [
			'date' => 'required',
            'money' => 'required',
			'add_money' => 'required',
			'total_money' => 'required',
			'cash' => 'required',
			'fp' => 'required',
			'store_id' => 'required',
			'user_id' => 'required',
			'insert_timestamp' => 'required',
        ]);
		if ($validator->fails()) {
			return response()->json(['status'=>'0', 'error_msg' =>'Provide valid values for all fields!']);
				return response()->json(['status'=>'0', 'error_msg' =>'Please provide valid values for all fields!']);
			}else{
				$data1 = $request->all();
				$user_data = User2::where(array("id"=>$request->get('user_id')))->first();
				$store = User2::where(array("id"=>$data1['user_id']))->first();
				$count1 = Stores2::where(array("id"=>$store['store_id']))->first();
				if($count1['status']==0){
					return response()->json(['status'=>'0', 'error_msg' =>'Sorry! Your store is no longer active!']);
				}
				$data1['store_id'] = $store['store_id'];
				$count = ATM2::whereDate("ATM.date", "=", $data1['date'])->where(array("user_id"=>$data1['user_id'],"status"=>"1","store_id"=>$user_data['store_id']))->count();
				if($count>0){
					return  response()->json(['status'=>'0', 'error_msg' =>'ATM entry already added for this date by this user!']);
				}else{
				//$store = User2::where(array("id"=>$data1['user_id']))->first();
				$data1['store_id'] = $user_data['store_id'];
				$new_item = new ATM2($data1);
				$new_item->save();
     	 		if($new_item) {
				return response()->json(['status'=>'1', 'data' =>'ATM entry successfully added!']);
        	   }else {
        	   return response()->json(['status'=>'0', 'error_msg' =>'Some error occured!']);
        	   	}
				}
			}
		}
		else
		{
			return response()->json(['status'=>'0', 'error_msg' =>'Token is invalid or expired!']);
		}
		
	}
	public function add_cigarette(Request $request, JWTAuth $JWTAuth)
	{
		$user = $JWTAuth->parseToken()->authenticate();
		if(($user && $user->role == "staff")||true)
		{
			$validator = Validator::make($request->all(), [
			'date' => 'required',
            'inventory' => 'required',
			'add_cigarette' => 'required',
			'sale_cigarette' => 'required',
			'available_stock' => 'required',
			'store_id' => 'required',
			'user_id' => 'required',
			'insert_timestamp' => 'required',
        ]);
		if ($validator->fails()) {
			return response()->json(['status'=>'0', 'error_msg' =>'Provide valid values for all fields!']);
				return response()->json(['status'=>'0', 'error_msg' =>'Please provide valid values for all fields!']);
			}else{
				
				$data1 = $request->all();
				$store = User2::where(array("id"=>$data1['user_id']))->first();
				$count1 = Stores2::where(array("id"=>$store['store_id']))->first();
				$user_data = User2::where(array("id"=>$request->get('user_id')))->first();
				if($count1['status']==0){
					return response()->json(['status'=>'0', 'error_msg' =>'Sorry! Your store is no longer active!']);
				}
				$data1['store_id'] = $store['store_id'];
				$count = Cigarettes2::whereDate("cigarettes.date", "=", $data1['date'])->where(array("user_id"=>$data1['user_id'],"status"=>"1","store_id"=>$user_data['store_id']))->count();
				if($count>0){
					return  response()->json(['status'=>'0', 'error_msg' =>'Daily cigarette entry already added for this date by this user!']);
				}else{
					$data1['store_id'] = $user_data['store_id'];
					$new_item = new Cigarettes2($data1);
				$new_item->save();
     	 		if($new_item) {
					$os = $request->get('available_stock')-$request->get('inventory');
					if($os >= 10){
						$store_id = $data1['store_id'];
						$user_list = DB::table('users')
									->select(DB::raw('device_type,firebase_token'))
									 ->whereRaw("find_in_set(".$store_id.",store_access)")
									->get();
						foreach($user_list as $exist){
							if($exist->device_type != ""){
								
								$device_id = $exist->firebase_token;
								$notificationtype = $exist->device_type;
								
								$url = 'http://website-demo.in/aaraypush_new/push.php?device_id='.$device_id.'&msg=Overshot is '.$os.' &type=reportc&notificationtype='.$notificationtype.'&date='.$request->get('date').'&store_id='.$request->get('store_id');
								$url = str_replace(" ","%20",$url);
								$data = $this->get_content($url);
								$data2 = json_decode($data);
							}
						}
					}
					
				return response()->json(['status'=>'1', 'data' =>'Cigarette entry successfully added!']);
        	   }else {
        	   return response()->json(['status'=>'0', 'error_msg' =>'Some error occured!']);
        	   	}
				}
			}
		}
		else
		{
			return response()->json(['status'=>'0', 'error_msg' =>'Token is invalid or expired!']);
		}
		
	}
	public function get_all_messages(Request $request, JWTAuth $JWTAuth)
	{
		$user = $JWTAuth->parseToken()->authenticate();
		if($user || true)
		{
			$item_data = Messages2::where(array("status"=>1))->get();
			return response()->json(['status' =>'1', 'messages'=>$item_data]);
		}
		else
		{
			return response()->json(['status'=>'0', 'error_msg' =>'Token is invalid or expired!']);
		}
	}
	public function get_stores(Request $request, JWTAuth $JWTAuth)
	{
		$stores = Stores2::where(array("status"=>1))->get();
		return response()->json(['status' =>'1', 'stores'=>$stores]);
	}
	public function signup(Request $request, JWTAuth $JWTAuth)
	{
			$exist = User2::where("email",'=',$request->get('email'))->count();
			if($exist>0){
				return response()->json(['status'=>'0', 'error_msg' =>'Email already exists in database!']);
			}else{
			$original_pass = $request->get('password');
			$password = Hash::make($request->get('password'));
			$data1=array(
				"email"=>$request->get('email'),
     	 		"name"=>$request->get('name'),
				"password"=>$password,
				"role"=>$request->get('role'),
				"mobile"=>$request->get('mobile'),
				"store_id"=>$request->get('store_id'),
     	 		);
     	 		$new_user = new User2($data1);
				$new_user->save();
     	 		if($new_user) {
					
					$data1['email'] = $request->get('email');
					$data1['name'] = $request->get('name');
					$data1['password'] = $original_pass;
					Mail::send('admin.account_password_email',$data1, function($message) use ($data1){
								$message->from('support@aaryagroup.com', 'Aarya Group');
								$message->to($data1['email']);
								$message->subject('Account Password');
					});
				return response()->json(['status'=>'1', 'data' =>'You have succesfully registered!']);
        	   }else {
        	   return response()->json(['status'=>'0', 'error_msg' =>'Some error occured!']);
        	   	}
		}
	}
	public function add_sales_payment(Request $request, JWTAuth $JWTAuth)
	{
		$user = $JWTAuth->parseToken()->authenticate();
		if(($user && $user->role == "staff")||true)
		{
			$validator = Validator::make($request->all(), [
			'date' => 'required',
            'inside' => 'required',
			'tax' => 'required',
			'gas' => 'required',
			'phone_card' => 'required',
			'instant' => 'required',
			'lottery' => 'required',
			'store_id' => 'required',
			'user_id' => 'required',
			'total_sales' => 'required',
            'total_cash' => 'required',
			'total_credit' => 'required',
			'total_debit' => 'required',
			'total' => 'required',
			'lottery_out' => 'required',
			'lottery_online_cashout' => 'required',
			'lottery_instant_cashout' => 'required',
			'lottery_cash' => 'required',
			'add_money_order' => 'required',
			'insert_timestamp' => 'required',
			'meat' => 'required',
			'coupon' => 'required',
			'mobile_coupon' => 'required',
        ]);
		if ($validator->fails()) {
			 //return $validator->errors()->all();
				return response()->json(['status'=>'0', 'error_msg' =>json_encode($validator->errors()->all()),'data'=>'']);
			}else{
				$data1 = $request->all();
				
				$user_data = User2::where(array("id"=>$request->get('user_id')))->first();
				$store = User2::where(array("id"=>$data1['user_id']))->first();
				$count1 = Stores2::where(array("id"=>$store['store_id']))->first();
				if($count1['status']==0){
					return response()->json(['status'=>'0', 'error_msg' =>'Sorry! Your store is no longer active!']);
				}
				$data1['store_id'] = $store['store_id'];
				
				$count1 = Payments3::whereDate("daily_payment_report.date", "=", $data1['date'])->where(array("user_id"=>$data1['user_id'],"status"=>"1", "store_id"=>$user_data['store_id']))->count();
				$count2 = Sales3::whereDate("daily_sales_entry.date", "=", $data1['date'])->where(array("user_id"=>$data1['user_id'],"status"=>"1", "store_id"=>$user_data['store_id']))->count();
				if($count1>0 && $count2>0){
					return response()->json(['status'=>'0', 'error_msg' =>'Daily payment report and daily sales report are already added for this date by this user!','data'=>'']);
				}else if($count1>0){
					return response()->json(['status'=>'0', 'error_msg' =>'Daily payment report already added for this date by this user!','data'=>'']);
				}else if($count2>0){
					return response()->json(['status'=>'0', 'error_msg' =>'Daily sales report already added for this date by this user!','data'=>'']);
				}
				else{
				
/*@Field("beer") String beer,
@Field("grocery") String grocery,
@Field("pizza") String pizza,
@Field("deli") String deli,
@Field("cigarette") String cigarette,
@Field("ebt") String ebt,
@Field("nontax") String nontax,
@Field("novelty") String novelty,
@Field("merchandise") String merchandise
*/
				$data1['inside']=$data1['beer']+$data1['grocery']+$data1['pizza']+$data1['deli']+$data1['cigarette']+$data1['ebt']+$data1['nontax']+$data1['novelty']+$data1['merchandise']+$data1['meat'];
				
				
$sales_data = array( 
				"date"=>$data1['date'],
				"inside"=>$data1['inside'],
				"beer"=>$data1['beer'],
				"grocery"=>$data1['grocery'],
				"pizza"=>$data1['pizza'],
				"deli"=>$data1['deli'],
				"cigarette"=>$data1['cigarette'],
				"ebt"=>$data1['ebt'],
				"nontax"=>$data1['nontax'],
				"novelty"=>$data1['novelty'],
				"merchandise"=>$data1['merchandise'],
				"gas"=>$data1['gas'],
				"tax"=>$data1['tax'],
				"phone_card"=>$data1['phone_card'],
				"instant"=>$data1['instant'],
				"lottery"=>$data1['lottery'],
				"add_money_order"=>$data1['add_money_order'],
				"store_id"=>$user_data['store_id'],
				"user_id"=>$data1['user_id'],
				"insert_timestamp"=>$data1['insert_timestamp'],
				"insert_timestamp"=>$data1['insert_timestamp'],
				"wu_amount"=>$data1['wu_amount'],
				"meat"=>$data1['meat'],
				"total_sales"=>$data1['inside']+$data1['tax']+$data1['gas']+$data1['instant']+$data1['lottery']+$data1['add_money_order']+$data1['phone_card']+$data1['wu_amount'],
				'lottery_mrg'=> $data1['lottery_mrg'],
				'lottery_eve'=> $data1['lottery_eve'],
				'lottery_nght'=> $data1['lottery_nght']
				);
				
				$payment_data = array(
				"date"=>$data1['date'],
				"total_cash"=>$data1['total_cash'],
				"total_credit"=>$data1['total_credit'],
				"total_debit"=>$data1['total_debit'],
				"total"=>$data1['total_cash']+$data1['total_credit']+$data1['total_debit']+$data1['lottery_online_cashout']+$data1['lottery_instant_cashout']+$data1['lottery_cash']+$data1['lottery_out']+$data1['wu_pay_out']+$data1['coupon']+$data1['mobile_coupon'],
				"lottery_out"=>$data1['lottery_out'],
				"store_id"=>$user_data['store_id'],
				"user_id"=>$data1['user_id'],
				"insert_timestamp"=>$data1['insert_timestamp'],
				"lottery_online_cashout"=>$data1['lottery_online_cashout'],
				"lottery_instant_cashout"=>$data1['lottery_instant_cashout'],
				"lottery_cash"=>$data1['lottery_cash'],
				"wu_pay_out"=>$data1['wu_pay_out'],
				"coupon"=>$data1['coupon'],
				"mobile_coupon"=>$data1['mobile_coupon'],
				"lottery_online_cashout_mrg"=>$data1['lottery_online_cashout_mrg'],
				"lottery_online_cashout_eve"=>$data1['lottery_online_cashout_eve'],
				"lottery_online_cashout_nght"=>$data1['lottery_online_cashout_nght'],
				"lottery_instant_cashout_mrg"=>$data1['lottery_instant_cashout_mrg'],
				"lottery_instant_cashout_eve"=>$data1['lottery_instant_cashout_eve'],
				"lottery_instant_cashout_nght"=>$data1['lottery_instant_cashout_nght']
				);
				$sales_save = new Sales5($sales_data);
				$payment_save = new Payments5($payment_data);
				$sales_save->save();
				$payment_save->save();
				$data1['overshot'] = $payment_save['total'] - $sales_save['total_sales'];
				if($data1['overshot'] >= 10){
					
				$data1['email'] = "nikhil@aaryagroup.us";
				$store_id = $data1['store_id'];
				$user_list = DB::table('users')
							->select(DB::raw('device_type,firebase_token'))
							 ->whereRaw("find_in_set(".$store_id.",store_access)")
							->get();
				foreach($user_list as $exist){
					if($exist->device_type != ""){
						
						$device_id = $exist->firebase_token;
						$notificationtype = $exist->device_type;
						
						$url = 'http://website-demo.in/aaraypush_new/push.php?device_id='.$device_id.'&msg=Overshot is '.$data1["overshot"].' &type=report&notificationtype='.$notificationtype.'&date='.$request->get('date').'&store_id='.$request->get('store_id');
						$url = str_replace(" ","%20",$url);
						$data = $this->get_content($url);
						$data2 = json_decode($data);
					}
				}
					
					/* $store_data = Stores2::where(array("id"=>$user_data['store_id']))->first();
					$data1['sales'] = $sales_save['total_sales'];
					$data1['payments'] = $payment_save['total'];
					$data1['overshot'] = $payment_save['total'] - $sales_save['total_sales'];
					$data1['user'] = $user_data['name'];
					$data1['store'] = $store_data['name'];
					$data1['date'] = date('m/d/Y',strtotime($request->get('date')));
					//$data1['email'] = "nikhil@aaryagroup.us";
					//$data1['email'] = "vishal@virtualheight.com";
					Mail::send('admin.overshot_crossed_sales_email',$data1, function($message) use ($data1){
										$message->from('support@aaryagroup.com', 'Aarya Group');
										$message->to($data1['email']);
										$message->subject('Overshot limit cross notification');
					}); */
					
				}
     	 		if($sales_save && $payment_save) {
				return response()->json(['status'=>'1', 'data' =>'Daily payment report and sales report successfully added!', 'error_msg'=>'']);
        	   }else {
        	   return response()->json(['status'=>'0', 'error_msg' =>'Some error occured!','data'=>'']);
        	   	}
				}
			}
		}
		else
		{
			return response()->json(['status'=>'0', 'error_msg' =>'Token is invalid or expired!','data'=>'']);
		}
	}
	public function inventory_filter(Request $request, JWTAuth $JWTAuth)
	{
		$item_id = $request->get('id');
		$store_id = $request->get('store_id');
		$date_from = $request->get('from');
		$date_to = $request->get('to');
		$user_id = $request->get('user_id');
		
		$user = User2::where(array("id"=>$user_id))->first();
		$store_access = $user['store_access'];
		//$store_access = explode(',',$store_access1);
		
		$user = $JWTAuth->parseToken()->authenticate();
		if(($user && $user->role == "admin")||true)
		{	
			DB::connection()->setFetchMode(\PDO::FETCH_ASSOC);
			$query = "SELECT it.id, it.name,
					(SELECT IFNULL(ROUND(SUM(i.price),2),'0.0') FROM `inventory` i WHERE it.`id`=i.item  AND i.status = 1    AND i.pay_by='Cash' and DATE(i.date)>='$date_from' and DATE(i.date)<='$date_to'".( (!empty($store_access))?"and i.store_id IN($store_access) ":" ").( ($store_id != 0)?"and i.store_id='$store_id' ":" ").") AS cash,
					(SELECT IFNULL(ROUND(SUM(i.price),2),'0.0') FROM `inventory` i WHERE it.`id`=i.item AND i.status = 1    AND i.pay_by='Cheque' and DATE(i.date)>='$date_from' and DATE(i.date)<='$date_to'".( (!empty($store_access))?"and i.store_id IN($store_access) ":" ").( ($store_id != 0)?"and i.store_id='$store_id' ":" ").") AS cheque,
					(SELECT IFNULL(ROUND(SUM(i.price),2),'0.0') FROM `inventory` i WHERE it.`id`=i.item AND i.status = 1    AND i.pay_by='Card' and DATE(i.date)>='$date_from' and DATE(i.date)<='$date_to'".( (!empty($store_access))?"and i.store_id IN($store_access) ":" ").( ($store_id != 0)?"and i.store_id='$store_id' ":" ").") AS card,
					
					(SELECT IFNULL(ROUND((SELECT IFNULL(ROUND(SUM(i.price),2),'0.0') FROM `inventory` i WHERE it.`id`=i.item  AND i.status = 1    AND i.pay_by='Cash' and DATE(i.date)>='$date_from' and DATE(i.date)<='$date_to'".( (!empty($store_access))?"and i.store_id IN($store_access) ":" ").( ($store_id != 0)?"and i.store_id='$store_id' ":" ").") +
					(SELECT IFNULL(ROUND(SUM(i.price),2),'0.0') FROM `inventory` i WHERE it.`id`=i.item AND i.status = 1    AND i.pay_by='Cheque' and DATE(i.date)>='$date_from' and DATE(i.date)<='$date_to'".( (!empty($store_access))?"and i.store_id IN($store_access) ":" ").( ($store_id != 0)?"and i.store_id='$store_id' ":" ").") +
					(SELECT IFNULL(ROUND(SUM(i.price),2),'0.0') FROM `inventory` i WHERE it.`id`=i.item AND i.status = 1    AND i.pay_by='Card' and DATE(i.date)>='$date_from' and DATE(i.date)<='$date_to'".( (!empty($store_access))?"and i.store_id IN($store_access) ":" ").( ($store_id != 0)?"and i.store_id='$store_id' ":" ")."),2),'')) AS total
					
					FROM items it where it.status=1.".( ($item_id != 0)?"and it.id='$item_id' ":" ")." GROUP BY it.id";
			$result = DB::select($query);
			DB::setFetchMode(\PDO::FETCH_CLASS);
			
			return response()->json(['status'=>'1', 'error_msg' =>'','data'=>$result]);
			
		}
		else
		{
			return response()->json(['status'=>'0', 'error_msg' =>'Token is invalid or expired!','data'=>'']);
		}
	}
	public function inventory_filter_page2(Request $request, JWTAuth $JWTAuth)
	{
		$item_id = $request->get('id');
		$store_id = $request->get('store_id');
		$date_from = $request->get('from');
		$date_to = $request->get('to');
		$user_id = $request->get('user_id');
		$pay_by = $request->get('pay_by');
		
		$user = User2::where(array("id"=>$user_id))->first();
		$store_access = $user['store_access'];
		
		$user = $JWTAuth->parseToken()->authenticate();
		if(($user && $user->role == "admin")||true)
		{	
			DB::connection()->setFetchMode(\PDO::FETCH_ASSOC);
			//echo $_SESSION['query']; die();
			$query = "select DATE_FORMAT(inventory.date ,'%m/%d/%Y')as idate,
							IFNULL(DATE_FORMAT(inventory.insert_timestamp ,'%m/%d/%Y %H:%i:%s'),'') as iinsert_timestamp,
									inventory.id as inventory_id,
									inventory.invoice_no,
									inventory.vendor,
									inventory.quantity,
									IFNULL(inventory.pay_by,'') as pay_by,
									IFNULL(inventory.cheque_no, '') as cheque_no,
									ROUND(inventory.price,2) as price,
									ROUND(inventory.total_price,2) as total_price,
									inventory.user_id,
									inventory.store_id,
									stores.name as store_name,
									stores.id as store_id,
									items.name as item_name,
									items.id as item_id
									from inventory left join items on items.id=inventory.item 
									left join stores on stores.id=inventory.store_id
									where inventory.status=1 and inventory.date>='$date_from' 
									and inventory.date<='$date_to'".(($item_id != 0)? " and inventory.item ='$item_id' ":" ").((!empty($store_access) )? " and inventory.store_id IN($store_access) ":" ").(($store_id != 0)? " and inventory.store_id ='$store_id' ":" ").((!empty($pay_by))? "and inventory.pay_by ='$pay_by' ":" ");
			//echo $query; die();
			//$request->session()->get('key');
			
			$msg = wordwrap("test",70);

// send email
//mail("hiten@virtualheight.com","My subject",$query);
			$result = DB::select($query);
			DB::setFetchMode(\PDO::FETCH_CLASS);
			return response()->json(['status'=>'1', 'error_msg' =>'','data'=>$result]);
			
		}
		else
		{
			return response()->json(['status'=>'0', 'error_msg' =>'Token is invalid or expired!','data'=>'']);
		}
	}
	public function del_multiple(Request $request, JWTAuth $JWTAuth)
	{
		$user = $JWTAuth->parseToken()->authenticate();
		if(($user && $user->role == "admin")||true)
		{
			$sales_id = $request->get('sales_id');
			$payment_id = $request->get('payment_id');
			$atm_id = $request->get('atm_id');
			$cigarette_id = $request->get('cigarette_id');
			$lottery_id = $request->get('lottery_id');
			
			$expense_id = $request->get('expense_id');
			$inventory_id = $request->get('inventory_id');
			
			$del_sales = Sales2::where(array("id"=>$sales_id))->update(array("status"=>0));
			$del_payment = Payments2::where(array("id"=>$payment_id))->update(array("status"=>0));
			$del_atm = ATM2::where(array("id"=>$atm_id))->update(array("status"=>0));
			$del_cigarette = Cigarettes2::where(array("id"=>$cigarette_id))->update(array("status"=>0));
			$del_lottery = Lottery2::where(array("id"=>$lottery_id))->update(array("status"=>0));
			
			if(!empty($expense_id)){
				$del_expense = Expense2::whereRaw('expense.id IN('.$expense_id.')')->update(array("status"=>0));
			}
			if(!empty($inventory_id)){
				$del_inventory = inventory2::whereRaw('inventory.id IN('.$inventory_id.')')->update(array("status"=>0));
			}
			
			return response()->json(['status'=>'1', 'error_msg' =>'', 'data'=>'Marked entries succesfully deleted!']);
		}
		else
		{
			return response()->json(['status'=>'0', 'error_msg' =>'Token is invalid or expired!', 'data'=>'']);
		}
	}
	public function add_sales_report(Request $request, JWTAuth $JWTAuth)
	{
		$user = $JWTAuth->parseToken()->authenticate();
		if(($user && $user->role == "staff")||true)
		{
			$validator = Validator::make($request->all(), [
			'date' => 'required',
            'inside' => 'required',
			'tax' => 'required',
			'gas' => 'required',
			'phone_card' => 'required',
			'instant' => 'required',
			'lottery' => 'required',
			'store_id' => 'required',
			'user_id' => 'required',
			'total_sales' => 'required',
        ]);
		if ($validator->fails()) {
			return response()->json(['status'=>'0', 'error_msg' =>'Provide valid values for all fields!']);
			}else{
				$data1 = $request->all();
				$store = User2::where(array("id"=>$data1['user_id']))->first();
				$count1 = Stores2::where(array("id"=>$store['store_id']))->first();
				if($count1['status']==0){
					return response()->json(['status'=>'0', 'error_msg' =>'Sorry! Your store is no longer active!']);
				}
				$data1['store_id'] = $store['store_id'];
				$count = Sales2::whereDate("daily_sales_entry.date", "=", $data1['date'])->where(array("user_id"=>$data1['user_id'],"status"=>"1"))->count();
				if($count>0){
					return  response()->json(['status'=>'0', 'error_msg' =>'Daily sales entry already added for this date by this user!']);
				}else{
					$new_item = new Sales2($data1);
				$new_item->save();
     	 		if($new_item) {
				return response()->json(['status'=>'1', 'data' =>'Daily sales entry successfully added!']);
        	   }else {
        	   return response()->json(['status'=>'0', 'error_msg' =>'Some error occured!']);
        	   	}
				}
			}
		}
		else
		{
			return response()->json(['status'=>'0', 'error_msg' =>'Token is invalid or expired']);
		}
	}
	public function add_western_union(Request $request, JWTAuth $JWTAuth)
	{
		$user = $JWTAuth->parseToken()->authenticate();
		if(($user && $user->role == "staff")||true)
		{
			$validator = Validator::make($request->all(), [
			'date' => 'required',
			'in' => 'required',
            'out' => 'required',
			'total' => 'required',
			'user_id' => 'required',
			'store_id' => 'required',
			'insert_timestamp' => 'required',
			'uhaul_in' => 'required',
			'uhaul_cash' => 'required',
			'uhaul_credit' => 'required',
			'uhaul_total' => 'required',
        ]);
		if ($validator->fails()) {
			return response()->json(['status'=>'0', 'error_msg' =>'Provide valid values for all fields!']);
			}else{
				$data1 = $request->all();
				$store = User2::where(array("id"=>$data1['user_id']))->first();
				$count1 = Stores2::where(array("id"=>$store['store_id']))->first();
				if($count1['status']==0){
					return response()->json(['status'=>'0', 'error_msg' =>'Sorry! Your store is no longer active!']);
				}
				$data1['store_id'] = $store['store_id'];
				$count = WesternUnion::whereDate("western_union.date", "=", $data1['date'])->where(array("user_id"=>$data1['user_id'],"status"=>"1"))->count();
				if($count>0){
					return  response()->json(['status'=>'0', 'error_msg' =>'Western Union entry already added for this date by this user!']);
				}else{
				$new_item = new WesternUnion($data1);
				$new_item->save();
     	 		if($new_item) {
				return response()->json(['status'=>'1', 'data' =>'Western Union entry successfully added!']);
        	   }else {
        	   return response()->json(['status'=>'0', 'error_msg' =>'Some error occured!']);
        	   	}
				}
			}
		}
		else
		{
			return response()->json(['status'=>'0', 'error_msg' =>'Token is invalid or expired']);
		}
	}
	public function admin_western_union_edit(Request $request, JWTAuth $JWTAuth)
	{
		$user = $JWTAuth->parseToken()->authenticate();
		if(($user && $user->role == "staff")||true)
		{
			$validator = Validator::make($request->all(), [
			'date' => 'required',
			'in' => 'required',
            'out' => 'required',
			'total' => 'required',
			'user_id' => 'required',
			'store_id' => 'required',
			'id' => 'required',
			'uhaul_in' => 'required',
			'uhaul_cash' => 'required',
			'uhaul_credit' => 'required',
			'uhaul_total' => 'required',
        ]);
		if ($validator->fails()) {
			return response()->json(['status'=>'0', 'error_msg' =>'Provide valid values for all fields!']);
			}else{
				$data1 = $request->all();
				$update = WesternUnion::where(array("id"=>$request->get('id')))->update($data1);
				return response()->json(['status'=>'1', 'data' =>'Western Union entry successfully updated!']);
			}
		}
		else
		{
			return response()->json(['status'=>'0', 'error_msg' =>'Token is invalid or expired']);
		}
	}
	public function admin_western_union_delete(Request $request, JWTAuth $JWTAuth)
	{
		$user = $JWTAuth->parseToken()->authenticate();
		if(($user && $user->role == "admin")||true)
		{
			$validator = Validator::make($request->all(), [
			'id' => 'required',
        ]);
		if ($validator->fails()) {
			return response()->json(['status'=>'0', 'error_msg' =>'Provide valid values for all fields!']);
			}else{
				$update = WesternUnion::where(array("id"=>$request->get('id')))->update(array("status"=>0));
				return response()->json(['status'=>'1', 'data' =>'Western Union entry successfully deleted!']);
			}
		}
		else
		{
			return response()->json(['status'=>'0', 'error_msg' =>'Token is invalid or expired!']);
		}
	}
	public function western_union_report(Request $request, JWTAuth $JWTAuth)
	{
		$user = $JWTAuth->parseToken()->authenticate();
		if(($user && $user->role == "admin")||true)
		{
			$store_id = $request->get('store_id');
			$date_from = $request->get('from');
			$date_to = $request->get('to');
			$user_id = $request->get('user_id');
		
			$user = User2::where(array("id"=>$user_id))->first();
			$store_access = $user['store_access'];
			DB::connection()->setFetchMode(\PDO::FETCH_ASSOC);
			$query = "SELECT IFNULL(ROUND(SUM(western_union.in),2),'') as total_in,
							 IFNULL(ROUND(SUM(western_union.out),2),'') as total_out,
							 IFNULL(ROUND(SUM(western_union.total),2),'') as total,
							 IFNULL(ROUND(SUM(western_union.uhaul_in),2),'') as total_uhaul_in,
							 IFNULL(ROUND(SUM(western_union.uhaul_cash),2),'') as total_uhaul_cash,
							 IFNULL(ROUND(SUM(western_union.uhaul_credit),2),'') as total_uhaul_credit,
							 IFNULL(ROUND(SUM(western_union.uhaul_total),2),'') as total_uhaul_total,
							 IFNULL(DATE_FORMAT(western_union.date ,'%m/%d/%Y'),'')as date,
							 IFNULL(DATE_FORMAT(western_union.insert_timestamp ,'%m/%d/%Y %H:%i:%s'),'')as winsert_timestamp,
							 IFNULL(western_union.user_id, '') as user_id,
							 IFNULL(western_union.store_id,'') as store_id,
							 IFNULL(stores.name,'') as store_name,
							 IFNULL(stores.id,'') as id
					FROM western_union
					LEFT JOIN stores ON stores.id = western_union.store_id
					 where western_union.status=1 and DATE(western_union.date)>='$date_from' and DATE(western_union.date)<='$date_to'".( (!empty($store_access))?" and western_union.store_id IN($store_access) ":" ").( ($store_id != 0)?" and western_union.store_id='$store_id' ":" ")." group by stores.id";
			$result = DB::select($query);
			$total_in = 0;
			$total_out = 0;
			$total = 0;
			
			$total_uhaul_in = 0;
			$total_uhaul_cash = 0;
			$total_uhaul_credit = 0;
			$total_uhaul_total = 0;
			$cnt = 0;
			$op = array();
			foreach($result as $r){
				$total_in += $r['total_in'];
				$total_out += $r['total_out'];
				$total += $r['total'];
				
				$total_uhaul_in += $r['total_uhaul_in'];
				$total_uhaul_cash += $r['total_uhaul_cash'];
				$total_uhaul_credit += $r['total_uhaul_credit'];
				$total_uhaul_total += $r['total_uhaul_total'];
			}
			$op['total_in'] = strval(round($total_in,2));
			$op['total_out'] = strval(round($total_out,2));
			$op['total'] = strval(round($total,2));
			$op['total_uhaul_in'] = strval(round($total_uhaul_in,2));
			$op['total_uhaul_cash'] = strval(round($total_uhaul_cash,2));
			$op['total_uhaul_credit'] = strval(round($total_uhaul_credit,2));
			$op['total_uhaul_total'] = strval(round($total_uhaul_total,2));
			DB::setFetchMode(\PDO::FETCH_CLASS);
			if(!empty($result)){
				return response()->json(['status'=>'1', 'error_msg' =>'','data'=>$result, 'total'=>$op]);
			}else{
				return response()->json(['status'=>'0', 'error_msg' =>'No data available!', 'data'=>array()]);
			}
		}
		else
		{
			return response()->json(['status'=>'0', 'error_msg' =>'Token is invalid or expired!']);
		}
	}
	public function western_union_report2(Request $request, JWTAuth $JWTAuth)
	{
		$user = $JWTAuth->parseToken()->authenticate();
		if(($user && $user->role == "admin")||true)
		{
			$store_id = $request->get('store_id');
			$date_from = $request->get('from');
			$date_to = $request->get('to');
			$user_id = $request->get('user_id');
		
			$data = DB::table('western_union')
						->select(DB::raw(
									"IFNULL(ROUND(SUM(western_union.in),2),'') as total_in,
									 IFNULL(ROUND(SUM(western_union.out),2),'') as total_out,
									 IFNULL(ROUND(SUM(western_union.total),2),'') as total,
									 IFNULL(ROUND(SUM(western_union.uhaul_in),2),'') as total_uhaul_in,
									 IFNULL(ROUND(SUM(western_union.uhaul_cash),2),'') as total_uhaul_cash,
									 IFNULL(ROUND(SUM(western_union.uhaul_credit),2),'') as total_uhaul_credit,
									 IFNULL(ROUND(SUM(western_union.uhaul_total),2),'') as total_uhaul_total,
									 IFNULL(DATE_FORMAT(western_union.date ,'%m/%d/%Y'),'')as date,
									 IFNULL(DATE_FORMAT(western_union.insert_timestamp ,'%m/%d/%Y %H:%i:%s'),'')as winsert_timestamp,
									 IFNULL(western_union.user_id, '') as user_id,
									 IFNULL(western_union.store_id,'') as store_id,
									 IFNULL(stores.name,'') as store_name,
									 IFNULL(users.name,'') as user_name
									"))
						->leftJoin('users','users.id','=','western_union.user_id')
						->leftJoin('stores','stores.id','=','western_union.store_id')
						->where('western_union.store_id', '=',$store_id)
						->where('western_union.status', '=',1)
						->whereDate('western_union.date', '>=',$date_from)
						->whereDate('western_union.date', '<=',$date_to)
						->groupBy('western_union.date')
						->groupBy('western_union.user_id')
						->orderBy('western_union.date','DESC')
						//->groupBy('stores.id')
						->get();
			if(!empty($data[0])){
				return response()->json(['status'=>'1', 'error_msg' =>'','data'=>$data]);
			}else{
				return response()->json(['status'=>'0', 'error_msg' =>'No data available!','data'=>array()]);
			}
		}
		else
		{
			return response()->json(['status'=>'0', 'error_msg' =>'Token is invalid or expired!']);
		}
	}
	public function western_union_report3(Request $request, JWTAuth $JWTAuth)
	{
		$user = $JWTAuth->parseToken()->authenticate();
		if(($user && $user->role == "admin")||true)
		{
			$store_id = $request->get('store_id');
			$date = $request->get('date');
			$user_id = $request->get('user_id');
		
			$data = DB::table('western_union')
						->select(DB::raw(
									"IFNULL(ROUND(western_union.in,2),'') as total_in,
									 IFNULL(ROUND(western_union.out,2),'') as total_out,
									 IFNULL(ROUND(western_union.total,2),'') as total,
									 IFNULL(ROUND(SUM(western_union.uhaul_in),2),'') as total_uhaul_in,
									 IFNULL(ROUND(SUM(western_union.uhaul_cash),2),'') as total_uhaul_cash,
									 IFNULL(ROUND(SUM(western_union.uhaul_credit),2),'') as total_uhaul_credit,
									 IFNULL(ROUND(SUM(western_union.uhaul_total),2),'') as total_uhaul_total,
									 IFNULL(DATE_FORMAT(western_union.date ,'%m/%d/%Y'),'')as date,
									 IFNULL(DATE_FORMAT(western_union.insert_timestamp ,'%m/%d/%Y %h:%i:%p'),'')as winsert_timestamp,
									 IFNULL(western_union.user_id, '') as user_id,
									 IFNULL(western_union.store_id,'') as store_id,
									 IFNULL(users.name,'') as user_name,
									 IFNULL(western_union.id,'') as id
									"))
						->leftJoin('users','western_union.user_id','=','users.id')
						->where('western_union.user_id', '=',$user_id)
						->where('western_union.status', '=',1)
						->where('western_union.store_id', '=',$store_id)
						->whereDate('western_union.date', '=',$date)
						->get();
			//echo "<pre>"; print_R($data[0]); die();
			$data = UsersController2::convertArray($data);
			if(!empty($data[0]['total_in'])){
				return response()->json(['status'=>'1', 'error_msg' =>'','data'=>$data]);
			}else{
				return response()->json(['status'=>'0', 'error_msg' =>'No data available!','data'=>array()]);
			}
		}
		else
		{
			return response()->json(['status'=>'0', 'error_msg' =>'Token is invalid or expired!']);
		}
	}
	public function messages(Request $request, JWTAuth $JWTAuth)
	{
		$user = $JWTAuth->parseToken()->authenticate();
		if(($user && $user->role == "admin")||true)
		{
			$messages = Messages2::select(DB::raw('
											messages.*,
											users.name as username
									'))
									->leftJoin('users','users.id','=','messages.user_id')
									->where('messages.status','=',1)
									->groupBy('messages.user_id')
									->orderBy('messages.id','DESC')
									->get();
			if(!empty($messages[0])){
				return response()->json(['status' =>'1', 'data'=>$messages, 'error_msg' =>'']);
			}else{
				return response()->json(['status'=>'0', 'error_msg' =>'No messages available!','data'=>array()]);
			}
		}
		else
		{
			return response()->json(['status'=>'0', 'error_msg' =>'Token is invalid or expired!']);
		}
	}
	public function get_messages(Request $request, JWTAuth $JWTAuth)
	{
		$user = $JWTAuth->parseToken()->authenticate();
		if(($user && $user->role == "admin")||true)
		{
			$validator = Validator::make($request->all(), [
			'user_id' => 'required',
		]);
		if ($validator->fails()) {
			return response()->json(['status'=>'0', 'error_msg' =>'Provide valid values for all fields!']);
		}else{
			$messages = Messages2::select(DB::raw('
											messages.*,
											users.name as username
									'))
									->leftJoin('users','users.id','=','messages.user_id')
									->where('messages.status','=',1)
									->where('messages.user_id','=',$request->get('user_id'))
									->orderBy('messages.id','DESC')
									->get();
			$op = array();
			$cnt = 0;
			foreach($messages as $m){
				$op[$cnt]['id'] = $m['id'];
				$op[$cnt]['subject'] = $m['subject'];
				$op[$cnt]['description'] = $m['description'];
				$op[$cnt]['user_id'] = $m['user_id'];
				$op[$cnt]['username'] = $m['username'];
				$op[$cnt]['date'] = date('m/d/Y',strtotime($m['created_at']));
				$op[$cnt]['time'] = date('h:i:s a',strtotime($m['created_at']));
				if(!empty($m['image'])){
					$op[$cnt]['image'] = public_path()."/admin_assets/uploads/".$m['image'];
				}else{
					$op[$cnt]['image'] = "";
				}
				$cnt++;
			}
			if(!empty($op[0])){
				return response()->json(['status' =>'1', 'data'=>$op, 'error_msg' =>'']);
			}else{
				return response()->json(['status'=>'0', 'error_msg' =>'No messages available!','data'=>array()]);
			}
		}
		}
		else
		{
			return response()->json(['status'=>'0', 'error_msg' =>'Token is invalid or expired!']);
		}
	}
	public function get_messages_id(Request $request, JWTAuth $JWTAuth)
	{
		$user = $JWTAuth->parseToken()->authenticate();
		if(($user && $user->role == "admin")||true)
		{
			$validator = Validator::make($request->all(), [
			'msg_id' => 'required',
		]);
		if ($validator->fails()) {
			return response()->json(['status'=>'0', 'error_msg' =>'Provide valid values for all fields!', "data"=> ""]);
		}else{
			$messages = Messages2::select(DB::raw('
											messages.id,messages.date,messages.subject,messages.description,messages.image,messages.created_at,messages.user_id,
											users.name as username
									'))
									->leftJoin('users','users.id','=','messages.user_id')
									->where('messages.status','=',1)
									->where('messages.id','=',$request->get('msg_id'))
									->orderBy('messages.id','DESC')
									->get();
			$op = array();
			$cnt = 0;
			foreach($messages as $m){
				$op['id'] = "".$m['id'];
				$op['subject'] = $m['subject'];
				$op['description'] = $m['description'];
				$op['user_id'] = $m['user_id'];
				$op['username'] = $m['username'];
				$op['date'] = date('m/d/Y',strtotime($m['created_at']));
				$op['time'] = date('h:i:s a',strtotime($m['created_at']));
				if(!empty($m['image'])){
					$op['image'] = $m['image'];
				}else{
					$op['image'] = "";
				}
				$cnt++;
			}
			if(!empty($op)){
				return response()->json(['status' =>'1', 'data'=>array($op), 'error_msg' =>'']);
			}else{
				return response()->json(['status'=>'0', 'error_msg' =>'No messages available!','data'=>array()]);
			}
		}
		}
		else
		{
			return response()->json(['status'=>'0', 'error_msg' =>'Token is invalid or expired!', "data"=> ""]);
		}
	}
	public function ios_upload_image(Request $request, JWTAuth $JWTAuth)
	{
		$user = $JWTAuth->parseToken()->authenticate();
		if(($user && $user->role == "admin")||true)
		{
			$validator = Validator::make($request->all(), [
			'image' => 'required|max:10000|mimes:jpg,jpeg,png,gif',
			]);
			if ($validator->fails()) {
				return response()->json(['status'=>'0', 'error_msg' =>'Invalid image!']);
			}else{
				$image = $request->file('image')->getClientOriginalName();
				$image = time().str_replace(" ","_",$image);
				$destination = public_path().'/admin_assets/uploads/';
				$request->file('image')->move($destination, $image);
				return response()->json(['status' =>'1', 'data'=>array("image"=>$image), 'error_msg' =>'']);
			}
		}
		else
		{
			return response()->json(['status'=>'0', 'error_msg' =>'Token is invalid or expired!']);
		}
	}
	public function ios_send_message(Request $request, JWTAuth $JWTAuth)
	{
		
		$user = $JWTAuth->parseToken()->authenticate();
		if(($user && $user->role == "staff")||true)
		{
			$validator = Validator::make($request->all(), [
			'subject' => 'required',
            'description' => 'required',
			'user_id' => 'required',
			'date' => 'required',
			'username' => 'required',
			'insert_timestamp' => 'required',
        ]);
		if ($validator->fails()) {
				return response()->json(['status'=>'0', 'error_msg' =>'Please provide valid values for all fields!']);
			}else{
				$data1 = $request->all();
				$data2['email'] = "nikhil@aaryagroup.us";
				
				if ($request->hasFile('image')){
					$data2['email'] = "nikhil@aaryagroup.us";
					//$data2['email'] = "vishal@virtualheight.com";
					$data2['subject'] = $data1['subject'];
					$data2['description'] = $data1['description'];
					$data2['username'] = $data1['username'];
					
					$data2['pathToFile'] = asset('admin_assets/uploads/')."/".$request->get('image');
					Mail::send('admin.message_email',$data2, function($message) use ($data2){
								$message->from('support@aaryagroup.com', 'Aarya Group');
								$message->to($data2['email']);
								$message->subject('New message');
								$message->attach($data2['pathToFile']);
					});
					
				}else{
					$data2['email'] = "nikhil@aaryagroup.us";
					//$data2['email'] = "vishal@virtualheight.com";
					$data2['subject'] = $data1['subject'];
					$data2['description'] = $data1['description'];
					$data2['username'] = $data1['username'];
					
					Mail::send('admin.message_email',$data2, function($message) use ($data2){
								$message->from('support@aaryagroup.com', 'Aarya Group');
								$message->to($data2['email']);
								$message->subject('New message');
					});
				}
				
				if( count(Mail::failures()) > 0 ) {
					//echo "There was one or more failures. They were: <br />";
					//print_R(Mail::failures()); die();
				}
				
     	 		$new_item = new Messages2($data1);
				$new_item->save();
				$lastId = $new_item->id;
				$data2['email'] = "admin@virtualheight.com";
				$exist = User2::where("email",'=',$data2['email'])->first();
				
				if($exist['device_type'] != ""){
					
					$notificationtype = $exist['device_type'];
					$device_id = $exist['firebase_token'];
					$url = 'http://website-demo.in/aaraypush_new/push.php?device_id='.$device_id.'&msg='.$data1['subject'].'&type=msg&notificationtype='.$notificationtype.'&msg_id='.$lastId;
					$url = str_replace(" ","%20",$url);
					$data = $this->get_content($url);
					$data2 = json_decode($data);
				}
				$data2['email'] = "nikhil@aaryagroup.us";
				$exist = User2::where("email",'=',$data2['email'])->first();
				
				if($exist['device_type'] != ""){
					
					$notificationtype = $exist['device_type'];
					$device_id = $exist['firebase_token'];
					$url = 'http://website-demo.in/aaraypush_new/push.php?device_id='.$device_id.'&msg='.$data1['subject'].'&type=msg&notificationtype='.$notificationtype.'&msg_id='.$lastId;
					$url = str_replace(" ","%20",$url);
					$data = $this->get_content($url);
					$data2 = json_decode($data);
				}
     	 		if($new_item) {
				return response()->json(['status'=>'1', 'data' =>'Message successfully sent to admin!']);
        	   }else {
        	   return response()->json(['status'=>'0', 'error_msg' =>'Some error occured!']);
        	   	}
			}
		}
		else
		{
			return response()->json(['status'=>'0', 'error_msg' =>'Token is invalid or expired!']);
		}
	}
	static function convertArray($array)
	{
		
		$array = json_decode(json_encode($array), true);
		$new_array = array();
		$cnt = 0;
		//print_R($array);
		//die();
		if(!empty($array[1])){
			foreach($array as $val){
				foreach($val as $k=>$v){
					$new_array[$cnt][$k] = strval($v);
				
				}
				$cnt++;
			}
			return $new_array;
		}else if(!empty($array[0])){
			foreach($array as $val){
				foreach($val as $k=>$v){
					$new_array[$cnt][$k] = strval($v);
				
				}
				$cnt++;
			}
			return $new_array;
		}else{
			
			$new_array[0] = array_map('strval',$array);
			//print_R($new_array);
			
			//die();
			return $new_array;
		}
	}
	public function overshort(Request $request, JWTAuth $JWTAuth)
	{
		
		$user = $JWTAuth->parseToken()->authenticate();
		if(($user && $user->role == "admin")||true)
		{
			$user_id = $request->get('user_id');
			$user = User2::where(array("id"=>$user_id))->first();
			$store_access = $user['store_access'];
			//print_r($_REQUEST);
			$id = $request->get('id');
			$date_from = $request->get('from');
			$date_to = $request->get('to');
			
			//echo $date_from."  ".$date_to."  ".$id; die();
			//instant+lottery  lottery_cash+lottery_online_cashout+lottery_instant_cashout
			if(!empty($date_from) && !empty($date_to) && $id !=0){
				$stores = DB::table('stores')
						->select(DB::raw(
									"stores.*,
									(SELECT IFNULL(ROUND(SUM(total),2),'0')  FROM daily_payment_report WHERE daily_payment_report.status=1 and daily_payment_report.store_id=stores.id and DATE(daily_payment_report.date)>='$date_from' and DATE(daily_payment_report.date)<='$date_to') AS payments,
									(SELECT ROUND((SELECT IFNULL(ROUND(SUM(total),2),'0')  FROM daily_payment_report WHERE daily_payment_report.status=1 and daily_payment_report.store_id=stores.id and DATE(daily_payment_report.date)>='$date_from' and DATE(daily_payment_report.date)<='$date_to') - (SELECT IFNULL(ROUND(SUM(total_sales),2),'0')  FROM daily_sales_entry WHERE daily_sales_entry.status=1 and daily_sales_entry.store_id=stores.id and daily_sales_entry.date>='$date_from' and daily_sales_entry.date<='$date_to'),2)) as oversort,
									(SELECT IFNULL(ROUND(SUM(total_sales),2),'0')  FROM daily_sales_entry WHERE daily_sales_entry.status=1 and daily_sales_entry.store_id=stores.id and daily_sales_entry.date>='$date_from' and daily_sales_entry.date<='$date_to') AS sales,
									(SELECT IFNULL(ROUND(SUM(add_money_order),2),'0')  FROM daily_sales_entry WHERE daily_sales_entry.status=1 and daily_sales_entry.store_id=stores.id and daily_sales_entry.date>='$date_from' and daily_sales_entry.date<='$date_to') AS total_money_order
									"))
						->where('stores.id','=',$id)
						->where('stores.status','=','1')
						->get();
				if($stores->count()<=0){
					return response()->json(['status' =>'0', 'error_msg'=>'No records found for given date range!', "data"=> ""]);
				}else{
					$cnt=0;
					$ttt = 0;
$opstore=array();					$oversort=0;
						foreach($stores as $s){
						$ttt = $s->payments - $s->sales ;
						$s->oversort = $ttt;
						$oversort += $ttt;
						$s1=(array)$s;
						$opstore[]=$s1;						
						$cnt++;
						}
						$oversort = round($oversort,2);
						$op = array("oversort"=>strval($oversort));
						
					return response()->json(['status' =>'1', 'data'=>$opstore, 'total'=>$op]);
				}
			}else if($id == 0){
				if(!empty($store_access)){
					$stores = DB::table('stores')
							->select(DB::raw(
									"stores.*,
									(SELECT IFNULL(ROUND(SUM(total),2),'0')  FROM daily_payment_report WHERE daily_payment_report.status=1 and daily_payment_report.store_id=stores.id and DATE(daily_payment_report.date)>='$date_from' and DATE(daily_payment_report.date)<='$date_to') AS payments,
									(SELECT ROUND((SELECT IFNULL(ROUND(SUM(total),2),'0')  FROM daily_payment_report WHERE daily_payment_report.status=1 and daily_payment_report.store_id=stores.id and DATE(daily_payment_report.date)>='$date_from' and DATE(daily_payment_report.date)<='$date_to') - (SELECT IFNULL(ROUND(SUM(total_sales),2),'0')  FROM daily_sales_entry WHERE daily_sales_entry.status=1 and daily_sales_entry.store_id=stores.id and daily_sales_entry.date>='$date_from' and daily_sales_entry.date<='$date_to'),2)) as oversort,
									(SELECT IFNULL(ROUND(SUM(total_sales),2),'0')  FROM daily_sales_entry WHERE daily_sales_entry.status=1 and daily_sales_entry.store_id=stores.id and daily_sales_entry.date>='$date_from' and daily_sales_entry.date<='$date_to') AS sales,
									(SELECT IFNULL(ROUND(SUM(add_money_order),2),'0')  FROM daily_sales_entry WHERE daily_sales_entry.status=1 and daily_sales_entry.store_id=stores.id and daily_sales_entry.date>='$date_from' and daily_sales_entry.date<='$date_to') AS total_money_order
									"))
							->where('stores.status','=','1')
							->whereRaw('stores.id IN('.$store_access.')')
							->get();
				}else{
					$stores = DB::table('stores')
							->select(DB::raw(
									"stores.*,
									(SELECT IFNULL(ROUND(SUM(total),2),'0')  FROM daily_payment_report WHERE daily_payment_report.status=1 and daily_payment_report.store_id=stores.id and DATE(daily_payment_report.date)>='$date_from' and DATE(daily_payment_report.date)<='$date_to') AS payments,
									(SELECT ROUND((SELECT IFNULL(ROUND(SUM(total),2),'0')  FROM daily_payment_report WHERE daily_payment_report.status=1 and daily_payment_report.store_id=stores.id and DATE(daily_payment_report.date)>='$date_from' and DATE(daily_payment_report.date)<='$date_to') - (SELECT IFNULL(ROUND(SUM(total_sales),2),'0')  FROM daily_sales_entry WHERE daily_sales_entry.status=1 and daily_sales_entry.store_id=stores.id and daily_sales_entry.date>='$date_from' and daily_sales_entry.date<='$date_to'),2)) as oversort,
									(SELECT IFNULL(ROUND(SUM(total_sales),2),'0')  FROM daily_sales_entry WHERE daily_sales_entry.status=1 and daily_sales_entry.store_id=stores.id and daily_sales_entry.date>='$date_from' and daily_sales_entry.date<='$date_to') AS sales,
									(SELECT IFNULL(ROUND(SUM(add_money_order),2),'0')  FROM daily_sales_entry WHERE daily_sales_entry.status=1 and daily_sales_entry.store_id=stores.id and daily_sales_entry.date>='$date_from' and daily_sales_entry.date<='$date_to') AS total_money_order
									"))
							->where('stores.status','=','1')
							->get();
				}
						
				if($stores->count()<=0){
					
					
					return response()->json(['status' =>'0', 'error_msg'=>'No records found for given date range!', "data"=> ""]);
				}else{
					$cnt=0;
					$ttt =0;
					$oversort=0;
					$opstore=array();
						foreach($stores as $s){
						$ttt = $s->payments - $s->sales;
						$s->oversort = $ttt;
						$oversort += $ttt;
						$s1=(array)$s;
						$opstore[]=$s1;
						$cnt++;
						}
						
						$oversort = round($oversort,2);
						
						$op = array("oversort"=>strval($oversort));
							
					return response()->json(['status' =>'1', 'data'=>$opstore, 'total'=>$op]);
				}
			}else{
				return response()->json(['status'=>'0', 'error_msg' =>'Provide store id and date or provide store id as 0 to view all store data!', "data"=> ""]);
			}
		}
		else
		{
			return response()->json(['status'=>'0', 'error_msg' =>'Token is invalid or expired!', "data"=> ""]);
		}
	}
	public function store_info_overshort2(Request $request, JWTAuth $JWTAuth)
	{
		$user = $JWTAuth->parseToken()->authenticate();
		if(($user && $user->role == "admin")||true)
		{

			$id = $request->get('id');
			$date_from = $request->get('from');
			$date_to = $request->get('to');
			
			$user_id = $request->get('user_id');
			$user = User2::where(array("id"=>$user_id))->first();
			$store_access = $user['store_access'];
			
			//instant+lottery  lottery_cash+lottery_online_cashout+lottery_instant_cashout
			if(!empty($date_from) && !empty($date_to) && $id !=0){
			
				$sales = DB::table('daily_sales_entry')
						->select(DB::raw(
									"DATE_FORMAT(daily_sales_entry.date ,'%m/%d/%Y')as sdate,
									DATE_FORMAT(daily_sales_entry.insert_timestamp ,'%m/%d/%Y %H:%i:%s')as sinsert_timestamp,
									daily_sales_entry.user_id,users.name, instant+lottery as total_s,
									IFNULL(ROUND(sum(daily_sales_entry.total_sales),2),'0') as total_sales,
									stores.name as store_name,
									daily_sales_entry.id as sales_id
									"))
						->leftJoin('users','users.id','=','daily_sales_entry.user_id')
						->leftJoin('stores','stores.id','=','daily_sales_entry.store_id')
						->where('stores.id', '=',$id)
						->where('daily_sales_entry.status', '=',1)
						->whereDate('daily_sales_entry.date', '>=',$date_from)
						->whereDate('daily_sales_entry.date', '<=',$date_to)
						->groupBy('daily_sales_entry.date')
						->groupBy('daily_sales_entry.user_id')
						->orderBy('daily_sales_entry.date','DESC')
						//->groupBy('stores.id')
						->get();
						$op=array();
						foreach($sales as $s){
							$op[$s->sdate][$s->user_id]['store_name']=$s->store_name;
							$op[$s->sdate][$s->user_id]['sales1']=$s->total_sales;
							$op[$s->sdate][$s->user_id]['name']=$s->name;
							$op[$s->sdate][$s->user_id]['user_id']=$s->user_id;
							//$op[$s->sdate][$s->user_id]['store_name']=$s->store_name;
						}
					$payment = DB::table('daily_payment_report')
						->select(DB::raw(
									"DATE_FORMAT(daily_payment_report.date ,'%m/%d/%Y')as pdate,
									IFNULL(ROUND(sum(daily_payment_report.total),2),'0') as total_payment,
									daily_payment_report.user_id,users.name,
									stores.name as store_name
									"))
						->leftJoin('users','users.id','=','daily_payment_report.user_id')
						->leftJoin('stores','stores.id','=','daily_payment_report.store_id')
						->where('stores.id', '=',$id)
						->where('daily_payment_report.status', '=',1)
						->whereDate('daily_payment_report.date', '>=',$date_from)
						->whereDate('daily_payment_report.date', '<=',$date_to)
						->groupBy('daily_payment_report.date')
						->groupBy('daily_payment_report.user_id')
						->orderBy('daily_payment_report.date','DESC')
						//->groupBy('stores.id')
						->get();
						foreach($payment as $s){
							$op[$s->pdate][$s->user_id]['store_name']=$s->store_name;
							$op[$s->pdate][$s->user_id]['payment']=$s->total_payment;
							$op[$s->pdate][$s->user_id]['name']=$s->name;
							$op[$s->pdate][$s->user_id]['user_id']=$s->user_id;
					}
					
						$output=array();
						foreach($op as  $key => $v){
				
					foreach($v as  $k => $value){
						
						$pay= 0;
						
						$oversort= 0;
						if(isset($value["payment"]) && isset($value["sales1"])){
						$oversort=$value["payment"] - $value["sales1"];
						}else{
							$oversort = "0";
						}
						if(isset($value["weekly_payment_total"])){
						$pay=$value["weekly_payment_total"];
						}
						$sal= 0;
						if(isset($value["weekly_sales_total"])){
						$sal=$value["weekly_sales_total"];
						}

						$output[]=array("date"=>$key,
						"user_name"=>isset($value["name"])?$value["name"]:"",
						"store_name"=>$value["store_name"],
						"user_fk"=>isset($value["user_id"])?$value["user_id"]:"",
						"oversort"=>strval(round($oversort,2))
						);
					}
				}
				usort($output, function($a, $b) {
				return  strtotime($a['date']) - strtotime($b['date']);
				});
					return response()->json(['status' =>'1', 'data'=>$output]);
			}
		}
		else
		{
			return response()->json(['status'=>'0', 'error_msg' =>'Token is invalid or expired!']);
		}
		/* $user = $JWTAuth->parseToken()->authenticate();
		if(($user && $user->role == "admin")||true)
		{
			$id = $request->get('id');
			$date_from = $request->get('from');
			$date_to = $request->get('to');
			
			$user_id = $request->get('user_id');
			$user = User2::where(array("id"=>$user_id))->first();
			$store_access = $user['store_access'];
			//instant+lottery  lottery_cash+lottery_online_cashout+lottery_instant_cashout
			if(!empty($date_from) && !empty($date_to) && $id !=0){
				$sales = DB::table('daily_sales_entry')
						->select(DB::raw(
									"DATE_FORMAT(daily_sales_entry.date ,'%m/%d/%Y')as sdate,
									daily_sales_entry.user_id,users.name,
									IFNULL(ROUND(sum(daily_sales_entry.total_sales),2),'0') as total_sales,
									IFNULL(ROUND(sum(daily_sales_entry.add_money_order),2),'0') as total_money_order,
									stores.name as store_name"))
						->leftJoin('users','users.id','=','daily_sales_entry.user_id')
						->leftJoin('stores','stores.id','=','daily_sales_entry.store_id')
						->where('stores.id', '=',$id)
						->where('daily_sales_entry.status', '=',1)
						->whereDate('daily_sales_entry.date', '>=',$date_from)
						->whereDate('daily_sales_entry.date', '<=',$date_to)
						->groupBy('daily_sales_entry.date')
						->groupBy('daily_sales_entry.user_id')
						->orderBy('daily_sales_entry.date','DESC')
						//->groupBy('stores.id')
						->get();
						$op=array();
						foreach($sales as $s){
							$op[$s->sdate][$s->user_id]['store_name']=$s->store_name;
							$op[$s->sdate][$s->user_id]['sales']=$s->total_sales + $s->total_money_order;
							$op[$s->sdate][$s->user_id]['name']=$s->name;
							$op[$s->sdate][$s->user_id]['user_id']=$s->user_id;
							
							//$op[$s->sdate][$s->user_id]['store_name']=$s->store_name;
						}
					$payment = DB::table('daily_payment_report')
						->select(DB::raw(
									"DATE_FORMAT(daily_payment_report.date ,'%m/%d/%Y')as pdate,
									daily_payment_report.user_id,users.name,
									IFNULL(ROUND(sum(daily_payment_report.total),2),'0') as total_payment,
									stores.name as store_name
									"))
						->leftJoin('users','users.id','=','daily_payment_report.user_id')
						->leftJoin('stores','stores.id','=','daily_payment_report.store_id')
						->where('stores.id', '=',$id)
						->where('daily_payment_report.status', '=',1)
						->whereDate('daily_payment_report.date', '>=',$date_from)
						->whereDate('daily_payment_report.date', '<=',$date_to)
						->groupBy('daily_payment_report.date')
						->groupBy('daily_payment_report.user_id')
						->orderBy('daily_payment_report.date','DESC')
						//->groupBy('stores.id')
						->get();
						foreach($payment as $s){
							$op[$s->pdate][$s->user_id]['store_name']=$s->store_name;
							$op[$s->pdate][$s->user_id]['payment']=$s->total_payment;
							$op[$s->pdate][$s->user_id]['name']=$s->name;
							$op[$s->pdate][$s->user_id]['user_id']=$s->user_id;
					}
			$expense = DB::table('expense')
						->select(DB::raw("DATE_FORMAT(expense.date ,'%m/%d/%Y')as expdate,
									DATE_FORMAT(expense.insert_timestamp ,'%m/%d/%Y %H:%i%s' )as einsert_timestamp,
									expense.user_id,users.name,
									IFNULL(ROUND(sum(expense.price),2),'0') as total_expense,
									stores.name as store_name,
									expense.id as expense_id
									"))
						->leftJoin('users','users.id','=','expense.user_id')
						->leftJoin('stores','stores.id','=','expense.store_id')
						->where('stores.id', '=',$id)
						->where('expense.status', '=',1)
						->whereDate('expense.date', '>=',$date_from)
						->whereDate('expense.date', '<=',$date_to)
						->groupBy('expense.date')
						->groupBy('expense.user_id')
						->orderBy('expense.date','DESC')
						//->groupBy('stores.id')
						->get();
						
						foreach($expense as $s){
							$op[$s->expdate][$s->user_id]['store_name']=$s->store_name;
					}
						$output=array();
						foreach($op as  $key => $v){
				
					foreach($v as  $k => $value){
						$pay= 0;
						$oversort= 0;
						if(isset($value["payment"]) && isset($value["sales"])){
						$oversort=$value["payment"] - $value["sales"];
						}else{
							$oversort = "0";
						}
						$output[]=array("date"=>$key,"user_name"=>isset($value["name"])?$value["name"]:"","store_name"=>$value["store_name"],"user_fk"=>isset($value["user_id"])?$value["user_id"]:"","oversort"=>strval(round($oversort,2)));
					}
				}
				usort($output, function($a, $b) {
				return  strtotime($a['date']) - strtotime($b['date']);
				});
					return response()->json(['status' =>'1', 'data'=>$output]);
			}
		}
		else
		{
			return response()->json(['status'=>'0', 'error_msg' =>'Token is invalid or expired!', "data"=> ""]);
		} */
	}
	public function cigarettes(Request $request, JWTAuth $JWTAuth)
	{
		
		$user = $JWTAuth->parseToken()->authenticate();
		if(($user && $user->role == "admin")||true)
		{
			$user_id = $request->get('user_id');
			$user = User2::where(array("id"=>$user_id))->first();
			$store_access = $user['store_access'];
			//print_r($_REQUEST);
			$id = $request->get('id');
			$date_from = $request->get('from');
			$date_to = $request->get('to');
			$sfinal = array();
			//echo $date_from."  ".$date_to."  ".$id; die();
			//instant+lottery  lottery_cash+lottery_online_cashout+lottery_instant_cashout
			$date_from = date('Y-m-d', strtotime($date_from . ' -1 day'));
			if(!empty($date_from) && !empty($date_to) && $id !=0){
				
				/* $stores = DB::table('stores')
						->select(DB::raw(
									"stores.id,stores.name,
									(SELECT IFNULL(ROUND(SUM(available_stock),2),'0')  FROM cigarettes WHERE cigarettes.status=1 and  cigarettes.store_id=stores.id and DATE(cigarettes.date)>='$date_from' and DATE(cigarettes.date)<='$date_to') AS available_stock,
									(SELECT IFNULL(ROUND(SUM(inventory),2),'0')  FROM cigarettes WHERE cigarettes.status=1 and  cigarettes.store_id=stores.id and DATE(cigarettes.date)>='$date_from' and DATE(cigarettes.date)<='$date_to') AS inventory
									"))
						->where('stores.id','=',$id)
						->where('stores.status','=','1')
						->get(); */
						$stores = DB::table('stores')
						->select(DB::raw(
									"stores.id,stores.name,cigarettes.available_stock,cigarettes.inventory"))
						->join('cigarettes','cigarettes.store_id','stores.id')
						->join('users','users.id','cigarettes.user_id')
						->where('stores.id','=',$id)
						->where('stores.status','=','1')
						->where('cigarettes.status','=','1')
						->whereRaw(" DATE(cigarettes.date)>='$date_from' and DATE(cigarettes.date)<='$date_to' ")
						->orderBy('stores.id','ASC')
						->orderBy('cigarettes.date','ASC')
						->orderBy('users.shift','ASC')
						->orderBy('cigarettes.created_at','ASC')
						->get();
						//print_r($stores);
						
				if($stores->count()<=0){
					return response()->json(['status' =>'0', 'error_msg'=>'No records found for given date range!', "data"=> ""]);
				}else{
					$cnt=0;
					$total_cigarettes=0;
					$opstore=array();					
					$storeidslist = array();
						foreach($stores as $s){
							//echo $s->ci." <br>";
							if(!in_array($s->id,$storeidslist)){
								if($cnt != 0){
									$s1=(array)$sfinal;
									$opstore[]=$s1;
								}
								array_push($storeidslist,$s->id);
								$laststock = $s->available_stock;
								$temp = 0;
								$sfinal = $s;
							}else{
								$temp = $temp + $s->inventory - $laststock;
								$s->cigarettes_overshort = "".$temp; 
								$laststock = $s->available_stock;
								$sfinal = $s;
							}
							//echo $temp."<br>";
						/* $temp = $s->available_stock - $s->inventory;
						$s->cigarettes_overshort = "".$temp;
						$s1=(array)$s;
						$opstore[]=$s1;*/
						$total_cigarettes += $temp;
						$cnt++; 
						}
						$s1=(array)$sfinal;
						$opstore[]=$s1;
						$total_cigarettes = round($total_cigarettes,2);
						
						$op = array("total_cigarettes"=>strval($total_cigarettes));
					return response()->json(['status' =>'1', 'data'=>$opstore, 'total'=>$op]);
				}
			}else if($id == 0){
				if(!empty($store_access)){
					/* $stores = DB::table('stores')
							->select(DB::raw(
									"stores.id,stores.name,
									(SELECT IFNULL(ROUND(SUM(available_stock),2),'0')  FROM cigarettes WHERE cigarettes.status=1 and  cigarettes.store_id=stores.id and DATE(cigarettes.date)>='$date_from' and DATE(cigarettes.date)<='$date_to') AS available_stock,
									(SELECT IFNULL(ROUND(SUM(inventory),2),'0')  FROM cigarettes WHERE cigarettes.status=1 and  cigarettes.store_id=stores.id and DATE(cigarettes.date)>='$date_from' and DATE(cigarettes.date)<='$date_to') AS inventory
									"))
							->where('stores.status','=','1')
							->whereRaw('stores.id IN('.$store_access.')')
							->get(); */
							$stores = DB::table('stores')
							->select(DB::raw(
									"stores.id,stores.name,cigarettes.available_stock,cigarettes.inventory"))
							->join('cigarettes','cigarettes.store_id','stores.id')
							->join('users','users.id','cigarettes.user_id')
							->where('stores.status','=','1')
							->where('cigarettes.status','=','1')
							->whereRaw("stores.id IN(".$store_access.") and DATE(cigarettes.date)>='$date_from' and DATE(cigarettes.date)<='$date_to'")
							->orderBy('stores.id','ASC')
							->orderBy('cigarettes.date','ASC')
							->orderBy('users.shift','ASC')
							->orderBy('cigarettes.created_at','ASC')
							->get();
							//print_r($store);
				}else{
					/* $stores = DB::table('stores')
							->select(DB::raw(
									"stores.id,stores.name,
									(SELECT IFNULL(ROUND(SUM(available_stock),2),'0')  FROM cigarettes WHERE cigarettes.status=1 and  cigarettes.store_id=stores.id and DATE(cigarettes.date)>='$date_from' and DATE(cigarettes.date)<='$date_to') AS available_stock,
									(SELECT IFNULL(ROUND(SUM(inventory),2),'0')  FROM cigarettes WHERE cigarettes.status=1 and  cigarettes.store_id=stores.id and DATE(cigarettes.date)>='$date_from' and DATE(cigarettes.date)<='$date_to') AS inventory
									"))
							->where('stores.status','=','1')
							->get(); */
							$stores = DB::table('stores')
							->select(DB::raw(
									"stores.id,stores.name,cigarettes.available_stock,cigarettes.inventory"))
							->join('cigarettes','cigarettes.store_id','stores.id')
							->join('users','users.id','cigarettes.user_id')
							->where('stores.status','=','1')
							->where('cigarettes.status','=','1')
							->whereRaw(" DATE(cigarettes.date)>='$date_from' and DATE(cigarettes.date)<='$date_to' ")
							->orderBy('stores.id','ASC')
							->orderBy('cigarettes.date','ASC')
							->orderBy('users.shift','ASC')
							->orderBy('cigarettes.created_at','ASC')
							->get();
							//print_r($stores);
				}
						
				if($stores->count()<=0){
					
					
					return response()->json(['status' =>'0', 'error_msg'=>'No records found for given date range!', "data"=> ""]);
				}else{
					$cnt=0;
					
					$total_cigarettes=0;
					
					$opstore=array();
					$storeidslist = array();
						foreach($stores as $s){
							//if($s->id == '2'){
								//echo $s->ci."tes <br>";
							if(!in_array($s->id,$storeidslist)){
								if($cnt != 0){
									$s1=(array)$sfinal;
									$opstore[]=$s1;
									
								}
								array_push($storeidslist,$s->id);
								$laststock = $s->available_stock;
								$temp = 0;
								$s->cigarettes_overshort = "0";
								$sfinal = $s;
							}else{
								$temp = $temp + $s->inventory - $laststock;
								$s->cigarettes_overshort = "".$temp;
								$laststock = $s->available_stock;
								//echo "  ".$s->ci."<br>";
								$sfinal = $s;
							}
							//}
							//echo $temp."<br>";
						/* $temp = $s->available_stock - $s->inventory;
						$s->cigarettes_overshort = "".$temp;
						$s1=(array)$s;
						$opstore[]=$s1;*/
						$total_cigarettes += $temp;
						$cnt++; 
						}
						
						$total_cigarettes = round($total_cigarettes,2);
						
						$op = array("total_cigarettes"=>strval($total_cigarettes));
					return response()->json(['status' =>'1', 'data'=>$opstore, 'total'=>$op]);
				}
			}else{
				return response()->json(['status'=>'0', 'error_msg' =>'Provide store id and date or provide store id as 0 to view all store data!', "data"=> ""]);
			}
		}
		else
		{
			return response()->json(['status'=>'0', 'error_msg' =>'Token is invalid or expired!']);
		}
	}
	public function store_cigarettes_user_report(Request $request, JWTAuth $JWTAuth)
	{
		$user = $JWTAuth->parseToken()->authenticate();
		if(($user && $user->role == "admin")||true)
		{
			$id = $request->get('id');
			$date_from = $request->get('from');
			$date_to = $request->get('to');
			
			$user_id = $request->get('user_id');
			$user = User2::where(array("id"=>$user_id))->first();
			$store_access = $user['store_access'];
			$date_from = date('Y-m-d', strtotime($date_from . ' -1 day'));
			//instant+lottery  lottery_cash+lottery_online_cashout+lottery_instant_cashout
			if(!empty($date_from) && !empty($date_to) && $id !=0){
				
						$op=array();
						/* $cigarettes = DB::table('cigarettes')
						->select(DB::raw(
									"DATE_FORMAT(cigarettes.date ,'%m/%d/%Y')as cigdate,
									cigarettes.user_id,users.name,
									(SELECT IFNULL(ROUND(SUM(available_stock),2),'0')  FROM cigarettes WHERE cigarettes.status=1 and  cigarettes.store_id=stores.id and DATE(cigarettes.date)>='$date_from' and DATE(cigarettes.date)<='$date_to'  AND cigarettes.`user_id`=users.id) AS available_stock,
									(SELECT IFNULL(ROUND(SUM(inventory),2),'0')  FROM cigarettes WHERE cigarettes.status=1 and  cigarettes.store_id=stores.id and DATE(cigarettes.date)>='$date_from' and DATE(cigarettes.date)<='$date_to' AND cigarettes.`user_id`=users.id) AS inventory,
									stores.name as store_name,
									cigarettes.id as cigarette_id
									"))
						->leftJoin('users','users.id','=','cigarettes.user_id')
						->leftJoin('stores','stores.id','=','cigarettes.store_id')
						->where('stores.id', '=',$id)
						->where('cigarettes.status', '=',1)
						->whereDate('cigarettes.date', '>=',$date_from)
						->whereDate('cigarettes.date', '<=',$date_to)
						->groupBy('cigarettes.date')
						->groupBy('cigarettes.user_id')
						->orderBy('cigarettes.date','DESC')
						->get(); */
						
					
						 $cigarettes = DB::table('cigarettes')
						->select(DB::raw(
									"users.id AS user_id,stores.`name` AS store_name,users.`name`,cigarettes.available_stock,cigarettes.inventory"))
						->leftJoin('users','users.id','=','cigarettes.user_id')
						->leftJoin('stores','stores.id','=','cigarettes.store_id')
						->where('stores.id', '=',$id)
						->where('cigarettes.status', '=',1)
						->whereDate('cigarettes.date', '>=',$date_from)
						->whereDate('cigarettes.date', '<=',$date_to)
						->orderBy('cigarettes.date','ASC')
						->orderBy('users.shift','ASC')
						->orderBy('cigarettes.created_at','ASC')
						->get();
						//print_r($cigarettes); 
						$temp = array();
						/* foreach($cigarettes as $s){
							$test = round($s->available_stock,2) - round($s->inventory,2);
							$op['store_name']=$s->store_name;
							$op['cigarettes']= "".$test;
							$op['name']=$s->name;
							$op['user_id']=$s->user_id;
							$op['cigarette_id']=$s->cigarette_id;
							array_push($temp,$op);
					} */
					$cnt = 0;
					$usersIds = array();
					$userArray = array();
						foreach($cigarettes as $s){
							if($cnt == 0){
								$laststock = $s->available_stock;
								$cnt++; 
							}else{
								if(!in_array($s->user_id,$usersIds)){
									
									array_push($usersIds,$s->user_id);

									$s->cigarettes = $s->inventory - $laststock;
									array_push($userArray,$s);
								}else{
									$overshot = $s->inventory - $laststock;
									$usercount=0;
									foreach($userArray as $user){
										if($user->user_id == $s->user_id){
											$userArray[$usercount]->cigarettes = $user->cigarettes+$overshot;
										}
										$usercount++;
									}
								}
								$laststock = $s->available_stock;
							}
						}
						//print_r($userArray);
					return response()->json(['status' =>'1', 'data'=>$userArray]);
			}
		}
		else
		{
			return response()->json(['status'=>'0', 'error_msg' =>'Token is invalid or expired!', "data"=> ""]);
		}
	}
	public function lottery_report(Request $request, JWTAuth $JWTAuth)
	{
		
		$user = $JWTAuth->parseToken()->authenticate();
		if(($user && $user->role == "admin")||true)
		{
			$user_id = $request->get('user_id');
			$user = User2::where(array("id"=>$user_id))->first();
			$store_access = $user['store_access'];
			$id = $request->get('id');
			$date_from = $request->get('from');
			$date_to = $request->get('to');
			//echo $date_from."  ".$date_to."  ".$id; die();
			//instant+lottery  lottery_cash+lottery_online_cashout+lottery_instant_cashout
			$date_from = date('Y-m-d', strtotime($date_from . ' -1 day'));
			if(!empty($date_from) && !empty($date_to) && $id !=0){
				/* $stores = DB::table('stores')
						->select(DB::raw(
									"stores.id,stores.name,
									IFNULL((SELECT SUM(lottery.total) FROM lottery WHERE lottery.status = 1 AND lottery.store_id = stores.id AND lottery.date >= '$date_from' AND lottery.date <= '$date_to'),0) AS total,
									IFNULL((SELECT SUM(lottery.inventory) FROM lottery WHERE lottery.status = 1  AND lottery.store_id = stores.id AND lottery.date >= '$date_from' AND lottery.date <= '$date_to'),0) AS lottery
									"))
						->where('stores.id','=',$id)
						->where('stores.status','=','1')
						->get(); */
						$stores = DB::table('stores')
						->select(DB::raw("stores.id,stores.name,lottery.total,lottery.inventory"))
						->join('lottery','lottery.store_id','stores.id')
						->join('users','users.id','lottery.user_id')
						->where('stores.id','=',$id)
						->where('stores.status','=','1')
						->where('lottery.status','=','1')
						->whereRaw(" DATE(lottery.date)>='$date_from' and DATE(lottery.date)<='$date_to' ")
						->orderBy('stores.id','ASC')
						->orderBy('lottery.date','ASC')
						->orderBy('users.shift','ASC')
						->orderBy('lottery.created_at','ASC')
						->get();
				if($stores->count()<=0){
					return response()->json(['status' =>'0', 'error_msg'=>'No records found for given date range!', "data"=> ""]);
				}else{
					$cnt=0;
					$total_lottery_sale=0;
					$total_lottery=0;
					$opstore=array();
					$storeidslist = array();
						/* foreach($stores as $s){
						$temp = round($s->total - $s->lottery,2);
						$total_lottery_sale += $temp;
						//$total_lottery += $s->lottery;
						$s->lottery_overshot = "".$temp;
						$s1=(array)$s;
						$opstore[]=$s1;						
						$cnt++;
						} */
						foreach($stores as $s){
							if(!in_array($s->id,$storeidslist)){
								if($cnt != 0){
									$s1=(array)$sfinal;
									$opstore[]=$s1;
								}
								array_push($storeidslist,$s->id);
								$laststock = $s->total;
								$temp = 0;
								$sfinal = $s;
							}else{
								//echo $s->inventory - $laststock ."=".$s->inventory ."-". $laststock."<br>";
								$temp = $temp + $s->inventory - $laststock;
								$s->lottery_overshot = "".$temp; 
								$laststock = $s->total;
								$sfinal = $s;
							}
						$total_lottery_sale += $temp;
						$cnt++; 
						}
						$s1=(array)$sfinal;
						$opstore[]=$s1;
						$total_lottery_sale = round($total_lottery_sale,2);
						$total_lottery = round($total_lottery,2);
						$op = array("total_lottery"=>strval($total_lottery),"total_lottery_sale"=>strval($total_lottery_sale));
					return response()->json(['status' =>'1', 'data'=>$opstore, 'total'=>$op]);
				}
			}else if($id == 0){
				if(!empty($store_access)){
					/* $stores = DB::table('stores')
							->select(DB::raw(
									"stores.id,stores.name,
									IFNULL((SELECT SUM(lottery.total) FROM lottery WHERE lottery.status = 1 AND lottery.store_id = stores.id AND lottery.date >= '$date_from' AND lottery.date <= '$date_to'),0) AS total,
									IFNULL((SELECT SUM(lottery.inventory) FROM lottery WHERE lottery.status = 1  AND lottery.store_id = stores.id AND lottery.date >= '$date_from' AND lottery.date <= '$date_to'),0) AS lottery
									"))
							->where('stores.status','=','1')
							->whereRaw('stores.id IN('.$store_access.')')
							->get(); */
							$stores = DB::table('stores')
							->select(DB::raw("stores.id,stores.name,lottery.total,lottery.inventory"))
							->join('lottery','lottery.store_id','stores.id')
							->join('users','users.id','lottery.user_id')
							->where('stores.status','=','1')
							->whereRaw('stores.id IN('.$store_access.')')
							->where('lottery.status','=','1')
							->whereRaw(" DATE(lottery.date)>='$date_from' and DATE(lottery.date)<='$date_to' ")
							->orderBy('stores.id','ASC')
							->orderBy('lottery.date','ASC')
							->orderBy('users.shift','ASC')
							->orderBy('lottery.created_at','ASC')
							->get();
							
				}else{
					/* $stores = DB::table('stores')
							->select(DB::raw(
									"stores.id,stores.name,
									IFNULL((SELECT SUM(lottery.total) FROM lottery WHERE lottery.status = 1 AND lottery.store_id = stores.id AND lottery.date >= '$date_from' AND lottery.date <= '$date_to'),0) AS total,
									IFNULL((SELECT SUM(lottery.inventory) FROM lottery WHERE lottery.status = 1  AND lottery.store_id = stores.id AND lottery.date >= '$date_from' AND lottery.date <= '$date_to'),0) AS lottery
									"))
							->where('stores.status','=','1')
							->get(); */
							$stores = DB::table('stores')
							->select(DB::raw("stores.id,stores.name,lottery.total,lottery.inventory"))
							->join('lottery','lottery.store_id','stores.id')
							->join('users','users.id','lottery.user_id')
							->where('stores.status','=','1')
							->where('lottery.status','=','1')
							->whereRaw(" DATE(lottery.date)>='$date_from' and DATE(lottery.date)<='$date_to' ")
							->orderBy('stores.id','ASC')
							->orderBy('lottery.date','ASC')
							->orderBy('users.shift','ASC')
							->orderBy('lottery.created_at','ASC')
							->get();
							//->toSql();
						//print_r($stores);
				}
						
				if($stores->count()<=0){
					
					
					return response()->json(['status' =>'0', 'error_msg'=>'No records found for given date range!', "data"=> ""]);
				}else{
					$cnt=0;
					$total_lottery_sale=0;
					$total_lottery=0;
					$opstore=array();
					$storeidslist = array();
						/* foreach($stores as $s){
						$temp = round($s->total - $s->lottery,2);
						$total_lottery_sale += $temp;
						//$total_lottery += $s->lottery;
						$s->lottery_overshot = "".$temp;
						$s1=(array)$s;
						$opstore[]=$s1;
						$cnt++;
						} */
						foreach($stores as $s){
							if(!in_array($s->id,$storeidslist)){
								if($cnt != 0){
									if(isset($sfinal->lottery_overshot) == ""){
										$sfinal->lottery_overshot = '0';
									}
									$s1=(array)$sfinal;
									
									$opstore[]=$s1;
								}
								array_push($storeidslist,$s->id);
								$laststock = $s->total;
								$temp = 0;
								$sfinal = $s;
							}else{
								//echo $s->inventory - $laststock ."=".$s->inventory ."-". $laststock."<br>";
								$temp = $temp + $s->inventory - $laststock;
								$s->lottery_overshot = "".$temp; 
								$laststock = $s->total;
								$sfinal = $s;
							}
						$total_lottery_sale += $temp;
						$cnt++; 
						}
						if(isset($sfinal->lottery_overshot) == ""){
							
										$sfinal->lottery_overshot = '0';
									}
						$s1=(array)$sfinal;
						$opstore[]=$s1;
						$total_lottery_sale = round($total_lottery_sale,2);
						$total_lottery = round($total_lottery,2);
						$op = array("total_lottery_sale"=>strval($total_lottery_sale));
					return response()->json(['status' =>'1', 'data'=>$opstore, 'total'=>$op]);
				}
			}else{
				return response()->json(['status'=>'0', 'error_msg' =>'Provide store id and date or provide store id as 0 to view all store data!', "data"=> ""]);
			}
		}
		else
		{
			return response()->json(['status'=>'0', 'error_msg' =>'Token is invalid or expired!', "data"=> ""]);
		}
	}
	public function store_lottery_user_report(Request $request, JWTAuth $JWTAuth)
	{
		$user = $JWTAuth->parseToken()->authenticate();
		if(($user && $user->role == "admin")||true)
		{
			$id = $request->get('id');
			$date_from = $request->get('from');
			$date_to = $request->get('to');
			
			$user_id = $request->get('user_id');
			$user = User2::where(array("id"=>$user_id))->first();
			$store_access = $user['store_access'];
			//instant+lottery  lottery_cash+lottery_online_cashout+lottery_instant_cashout
			if(!empty($date_from) && !empty($date_to) && $id !=0){
				$date_from = date('Y-m-d', strtotime($date_from . ' -1 day'));
					
			/* $lottery = DB::table('lottery')
						->select(DB::raw(
									"DATE_FORMAT(lottery.date ,'%m/%d/%Y')as lotdate,
									DATE_FORMAT(lottery.insert_timestamp ,'%m/%d/%Y %H:%i%s')as linsert_timestamp,
									lottery.user_id,users.name,
									IFNULL((SELECT SUM(lottery.total) FROM lottery WHERE lottery.status = 1 AND lottery.store_id = stores.id AND lottery.date >= '$date_from' AND lottery.date <= '$date_to'  AND lottery.`user_id` = users.id),0) AS total,
									IFNULL((SELECT SUM(lottery.inventory) FROM lottery WHERE lottery.status = 1  AND lottery.store_id = stores.id AND lottery.date >= '$date_from' AND lottery.date <= '$date_to'  AND lottery.`user_id` = users.id),0) AS lottery,
									stores.name as store_name,
									lottery.id as lottery_id
									"))
						->leftJoin('users','users.id','=','lottery.user_id')
						->leftJoin('stores','stores.id','=','lottery.store_id')
						->where('stores.id', '=',$id)
						->where('lottery.status', '=',1)
						->whereDate('lottery.date', '>=',$date_from)
						->whereDate('lottery.date', '<=',$date_to)
						->groupBy('lottery.date')
						->groupBy('lottery.user_id')
						->orderBy('lottery.date','DESC')
						->get(); */
						$lottery = DB::table('lottery')
						->select(DB::raw("stores.id,stores.name AS store_name,lottery.total,lottery.inventory,users.id as user_id,users.name"))
						->leftJoin('users','users.id','=','lottery.user_id')
						->leftJoin('stores','stores.id','=','lottery.store_id')
						->where('stores.id', '=',$id)
						->where('stores.status','=','1')
						->where('lottery.status','=','1')
						->whereRaw(" DATE(lottery.date)>='$date_from' and DATE(lottery.date)<='$date_to' ")
						->orderBy('stores.id','ASC')
						->orderBy('lottery.date','ASC')
						->orderBy('users.shift','ASC')
						->orderBy('lottery.created_at','ASC')
						->get();
						//->toSql();
						//print_r($lottery); die();
						$op = array();
						$temp = array();
						$cnt = 0;
					$usersIds = array();
					$userArray = array();
						foreach($lottery as $s){
							/* $test = "0";
							$op['store_name']=$s->store_name;
							$test = "".round($s->total - $s->lottery,2);
							$op['lottery']=$test ;
							$op['name']=$s->name;
							$op['user_id']=$s->user_id;
							$op['lottery_id']=$s->lottery_id;
							$op['linsert_timestamp']=$s->linsert_timestamp;
							array_push($temp,$op); */
							if($cnt == 0){
								$laststock = $s->total;
								$cnt++; 
							}else{
								if(!in_array($s->user_id,$usersIds)){
									array_push($usersIds,$s->user_id);
									$s->lottery = $s->inventory - $laststock;
									array_push($userArray,$s);
								}else{
									$overshot = $s->inventory - $laststock;
									$usercount=0;
									foreach($userArray as $user){
										if($user->user_id == $s->user_id){
											$userArray[$usercount]->lottery = $user->lottery+$overshot;
										}
										$usercount++;
									}
								}
								$laststock = $s->total;
							}
						}
			
						
					return response()->json(['status' =>'1', 'data'=>$userArray]);
			}
		}
		else
		{
			return response()->json(['status'=>'0', 'error_msg' =>'Token is invalid or expired!', "data"=> ""]);
		}
	}
		public function profit_lost_report(Request $request, JWTAuth $JWTAuth)
	{
		
		$user = $JWTAuth->parseToken()->authenticate();
		if(($user && $user->role == "admin")||true)
		{
			$user_id = $request->get('user_id');
			$user = User2::where(array("id"=>$user_id))->first();
			$store_access = $user['store_access'];
			//print_r($_REQUEST);
			$id = $request->get('id');
			$date_from = $request->get('from');
			$date_to = $request->get('to');
			
			//echo $date_from."  ".$date_to."  ".$id; die();
			//instant+lottery  lottery_cash+lottery_online_cashout+lottery_instant_cashout
			if(!empty($date_from) && !empty($date_to) && $id !=0){
				$stores = DB::table('stores')
						->select(DB::raw(
									"stores.id,stores.name,
									IFNULL((SELECT SUM(inventory.total_price) FROM inventory WHERE inventory.status = 1 AND inventory.store_id = stores.id AND inventory.date >= '$date_from' AND inventory.date <= '$date_to'),0) AS total_inventory,
									IFNULL((SELECT SUM(expense.price) FROM expense WHERE expense.status = 1  AND expense.store_id = stores.id AND expense.date >= '$date_from' AND expense.date <= '$date_to'),0) AS total_expense,
									IFNULL((SELECT SUM(ATM.fp) FROM ATM WHERE ATM.status = 1  AND ATM.store_id = stores.id AND ATM.date >= '$date_from' AND ATM.date <= '$date_to'),0) AS total_fp,
									IFNULL((SELECT SUM(inside)  FROM daily_sales_entry WHERE daily_sales_entry.status=1 and daily_sales_entry.store_id=stores.id and daily_sales_entry.date>='$date_from' and daily_sales_entry.date<='$date_to'),0) AS total_inside,
									(SELECT IFNULL(ROUND(SUM(gas),2),'0')  FROM daily_sales_entry WHERE daily_sales_entry.status=1 and daily_sales_entry.store_id=stores.id and daily_sales_entry.date>='$date_from' and daily_sales_entry.date<='$date_to') AS total_gas,
									(SELECT IFNULL(ROUND(SUM(weekly_commission),2),'0')  FROM lottery WHERE lottery.status=1 and lottery.store_id=stores.id and DATE(lottery.date)>='$date_from' and DATE(lottery.date)<='$date_to') AS total_commission,
									(SELECT IFNULL(ROUND(SUM(ATM.cash),2),'0')  FROM ATM WHERE ATM.status=1 and ATM.store_id=stores.id and DATE(ATM.date)>='$date_from' and DATE(ATM.date)<='$date_to') AS total_fp_cas
									"))
						->where('stores.id','=',$id)
						->where('stores.status','=','1')
						->get();
				if($stores->count()<=0){
					return response()->json(['status' =>'0', 'error_msg'=>'No records found for given date range!', "data"=> ""]);
				}else{
					$cnt=0;
					$total_profit_lost=0;
					$total_lottery=0;
					$opstore=array();
						foreach($stores as $s){
						$temp = round( ($s->total_inside+$s->total_gas+$s->total_commission+$s->total_fp_cas) - ($s->total_inventory+$s->total_expense+$s->total_fp),2);
						$total_profit_lost += $temp;
						//$total_lottery += $s->lottery;
						$s->profit_lost = "".$temp;
						$s1=(array)$s;
						$opstore[]=$s1;
						$cnt++;
						}
						$total_lottery_sale = round($total_profit_lost,2);
						$total_lottery = round($total_lottery,2);
						$op = array("total_profit_lost"=>strval($total_lottery_sale));
					return response()->json(['status' =>'1', 'data'=>$opstore, 'total'=>$op]);
				}
			}else if($id == 0){
				if(!empty($store_access)){
					$stores = DB::table('stores')
							->select(DB::raw(
									"stores.id,stores.name,
									IFNULL((SELECT SUM(inventory.total_price) FROM inventory WHERE inventory.status = 1 AND inventory.store_id = stores.id AND inventory.date >= '$date_from' AND inventory.date <= '$date_to'),0) AS total_inventory,
									IFNULL((SELECT SUM(expense.price) FROM expense WHERE expense.status = 1  AND expense.store_id = stores.id AND expense.date >= '$date_from' AND expense.date <= '$date_to'),0) AS total_expense,
									IFNULL((SELECT SUM(ATM.fp) FROM ATM WHERE ATM.status = 1  AND ATM.store_id = stores.id AND ATM.date >= '$date_from' AND ATM.date <= '$date_to'),0) AS total_fp,
									IFNULL((SELECT SUM(inside)  FROM daily_sales_entry WHERE daily_sales_entry.status=1 and daily_sales_entry.store_id=stores.id and daily_sales_entry.date>='$date_from' and daily_sales_entry.date<='$date_to'),0) AS total_inside,
									(SELECT IFNULL(ROUND(SUM(gas),2),'0')  FROM daily_sales_entry WHERE daily_sales_entry.status=1 and daily_sales_entry.store_id=stores.id and daily_sales_entry.date>='$date_from' and daily_sales_entry.date<='$date_to') AS total_gas,
									(SELECT IFNULL(ROUND(SUM(weekly_commission),2),'0')  FROM lottery WHERE lottery.status=1 and lottery.store_id=stores.id and DATE(lottery.date)>='$date_from' and DATE(lottery.date)<='$date_to') AS total_commission,
									(SELECT IFNULL(ROUND(SUM(ATM.cash),2),'0')  FROM ATM WHERE ATM.status=1 and ATM.store_id=stores.id and DATE(ATM.date)>='$date_from' and DATE(ATM.date)<='$date_to') AS total_fp_cas
									"))
							->where('stores.status','=','1')
							->whereRaw('stores.id IN('.$store_access.')')
							->get();
							//->toSql();
				}else{
					$stores = DB::table('stores')
							->select(DB::raw(
									"stores.id,stores.name,
									IFNULL((SELECT SUM(inventory.total_price) FROM inventory WHERE inventory.status = 1 AND inventory.store_id = stores.id AND inventory.date >= '$date_from' AND inventory.date <= '$date_to'),0) AS total_inventory,
									IFNULL((SELECT SUM(expense.price) FROM expense WHERE expense.status = 1  AND expense.store_id = stores.id AND expense.date >= '$date_from' AND expense.date <= '$date_to'),0) AS total_expense,
									IFNULL((SELECT SUM(ATM.fp) FROM ATM WHERE ATM.status = 1  AND ATM.store_id = stores.id AND ATM.date >= '$date_from' AND ATM.date <= '$date_to'),0) AS total_fp,
									IFNULL((SELECT SUM(inside)  FROM daily_sales_entry WHERE daily_sales_entry.status=1 and daily_sales_entry.store_id=stores.id and daily_sales_entry.date>='$date_from' and daily_sales_entry.date<='$date_to'),0) AS total_inside,
									(SELECT IFNULL(ROUND(SUM(gas),2),'0')  FROM daily_sales_entry WHERE daily_sales_entry.status=1 and daily_sales_entry.store_id=stores.id and daily_sales_entry.date>='$date_from' and daily_sales_entry.date<='$date_to') AS total_gas,
									(SELECT IFNULL(ROUND(SUM(weekly_commission),2),'0')  FROM lottery WHERE lottery.status=1 and lottery.store_id=stores.id and DATE(lottery.date)>='$date_from' and DATE(lottery.date)<='$date_to') AS total_commission,
									(SELECT IFNULL(ROUND(SUM(ATM.cash),2),'0')  FROM ATM WHERE ATM.status=1 and ATM.store_id=stores.id and DATE(ATM.date)>='$date_from' and DATE(ATM.date)<='$date_to') AS total_fp_cas
									"))
							->where('stores.status','=','1')
							->get();
							//->toSql();
				}
						//print_r($stores); die();
				if($stores->count()<=0){
					
					
					return response()->json(['status' =>'0', 'error_msg'=>'No records found for given date range!', "data"=> ""]);
				}else{
					$cnt=0;
					$total_profit_lost=0;
					$total_lottery=0;
					$opstore=array();
						foreach($stores as $s){
						$temp = round(($s->total_inside+$s->total_gas+$s->total_commission+$s->total_fp_cas) - ($s->total_inventory+$s->total_expense+$s->total_fp),2);
						$total_profit_lost += $temp;
						//$total_lottery += $s->lottery;
						$s->profit_lost = "".$temp;
						$s1=(array)$s;
						$opstore[]=$s1;
						$cnt++;
						}
						$total_lottery_sale = round($total_profit_lost,2);
						$total_lottery = round($total_lottery,2);
						$op = array("total_profit_lost"=>strval($total_lottery_sale));
					return response()->json(['status' =>'1', 'data'=>$opstore, 'total'=>$op]);
				}
			}else{
				return response()->json(['status'=>'0', 'error_msg' =>'Provide store id and date or provide store id as 0 to view all store data!', "data"=> ""]);
			}
		}
		else
		{
			return response()->json(['status'=>'0', 'error_msg' =>'Token is invalid or expired!', "data"=> ""]);
		}
	}
	public function profit_lost_user_report(Request $request, JWTAuth $JWTAuth)
	{
		
		$user = $JWTAuth->parseToken()->authenticate();
		if(($user && $user->role == "admin")||true)
		{
			
			$id = $request->get('id');
			$date_from = $request->get('from');
			$date_to = $request->get('to');//instant+lottery  lottery_cash+lottery_online_cashout+lottery_instant_cashout
			if(!empty($date_from) && !empty($date_to) && $id !=0){
					
			$lottery = DB::table('stores')
							->select(DB::raw(
									"users.id,users.name,
									IFNULL((SELECT SUM(inventory.total_price) FROM inventory WHERE inventory.status = 1 AND inventory.store_id = stores.id AND inventory.created_at >= '$date_from' AND inventory.created_at <= '$date_to' AND inventory.user_id = users.id ),0) AS total_inventory,
									IFNULL((SELECT SUM(expense.price) FROM expense WHERE expense.status = 1  AND expense.store_id = stores.id AND expense.date >= '$date_from' AND expense.date <= '$date_to'  AND expense.user_id = users.id ),0) AS total_expense,
									IFNULL((SELECT SUM(ATM.fp) FROM ATM WHERE ATM.status = 1  AND ATM.store_id = stores.id AND ATM.date >= '$date_from' AND ATM.date <= '$date_to'  AND ATM.user_id = users.id ),0) AS total_fp,
									IFNULL((SELECT SUM(inside)  FROM daily_sales_entry WHERE daily_sales_entry.status=1 and daily_sales_entry.store_id=stores.id and daily_sales_entry.date>='$date_from' and daily_sales_entry.date<='$date_to'  AND daily_sales_entry.user_id = users.id ),0) AS total_inside,
									(SELECT IFNULL(ROUND(SUM(gas),2),'0')  FROM daily_sales_entry WHERE daily_sales_entry.status=1 and daily_sales_entry.store_id=stores.id and daily_sales_entry.date>='$date_from' and daily_sales_entry.date<='$date_to' AND daily_sales_entry.user_id = users.id ) AS total_gas,
									(SELECT IFNULL(ROUND(SUM(weekly_commission),2),'0')  FROM lottery WHERE lottery.status=1 and lottery.store_id=stores.id and DATE(lottery.date)>='$date_from' and DATE(lottery.date)<='$date_to' AND lottery.user_id = users.id ) AS total_commission,
									(SELECT IFNULL(ROUND(SUM(ATM.fp),2),'0')  FROM ATM WHERE ATM.status=1 and ATM.store_id=stores.id and DATE(ATM.date)>='$date_from' and DATE(ATM.date)<='$date_to' AND ATM.user_id = users.id ) AS total_fp_cas
									"))
							->leftJoin('users','users.store_id','=','stores.id')
							->where('stores.status','=','1')
							->where('stores.id','=',$id)
							->groupBy('users.id')
							->get();
							//->toSql();
							$cnt = "0";
			$total_profit_lost=0;
					$total_lottery=0;
					$opstore=array();
						foreach($lottery as $s){
						$temp = round(($s->total_inside+$s->total_gas+$s->total_commission+$s->total_fp_cas) - ($s->total_inventory+$s->total_expense+$s->total_fp),2);
						$total_profit_lost += $temp;
						//$total_lottery += $s->lottery;
						$s->profit_lost = "".$temp;
						$s1=(array)$s;
						$opstore[]=$s1;
						$cnt++;
						}
						
					return response()->json(['status' =>'1', 'data'=>$opstore]);
			}
		}
		else
		{
			return response()->json(['status'=>'0', 'error_msg' =>'Token is invalid or expired!', "data"=> ""]);
		}
	}
	function get_content($URL){
		$ch = curl_init();
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
		curl_setopt($ch, CURLOPT_URL, $URL);
		$data = curl_exec($ch);
		curl_close($ch);
		return $URL;
	}

	public function item_profit_lost(Request $request, JWTAuth $JWTAuth)
	{
		$user = $JWTAuth->parseToken()->authenticate();
		if(($user && $user->role == "admin")||true)
		{
			$date_from = $request->get('from');
			$date_to = $request->get('to');
			
			$id = $request->get('id');
			
			$where = "";
			if($id != ""){
					$where .= " And inventory.store_id = '$id'";
			}
			
			
			if($date_from != "" && $date_to != ""){
				$where .= " And inventory.date <= '$date_to' and  inventory.date >= '$date_from' ";
			}
			$item_total = DB::table('items')
						->select(DB::raw("IFNULL(ROUND(SUM(inventory.price),2),'0') AS total_price, items.name"))
						->leftJoin('inventory','inventory.item','items.id')
						->whereRaw("inventory.status='1' AND items.status='1' AND items.id IN(1,2,4,5,7,8,11,12)".$where)
						->groupBy("items.id")
						->get();
						
						$inventoryGrocery = 0;
						$inventoryBeer = 0;
						$inventoryCigarette = 0;
						$inventoryGas = 0;
						$inventoryNovelty = 0;
						$inventoryNontaxable = 0;
						$inventoryPIZZA = 0;
						$inventoryMeat = 0;
			foreach($item_total as $item){
				if($item->name == "Grocery"){ $inventoryGrocery = $item->total_price; }
				if($item->name == "Beer"){ $inventoryBeer = $item->total_price; }
				if($item->name == "Cigarette"){ $inventoryCigarette = $item->total_price; }
				if($item->name == "Gas"){ $inventoryGas = $item->total_price; }
				if($item->name == "All non taxable"){ $inventoryNontaxable = $item->total_price; }
				if($item->name == "Meat"){ $inventoryMeat = $item->total_price; }
				if($item->name == "PIZZA"){ $PIZZA = $item->total_price; }
			}
			$where = "";
			if($id != ""){
					$where .= " And store_id = '$id'";
			}
			
			if($date_from != "" && $date_to != ""){
				$where .= " And date <= '$date_to' and  date >= '$date_from' ";
			}
			$sales_total = DB::table('daily_sales_entry')
						->select(DB::raw("IFNULL(ROUND(SUM(beer),2),'0') AS total_beer,IFNULL(ROUND(SUM(grocery),2),'0') AS total_grocery,IFNULL(ROUND(SUM(pizza),2),'0') AS total_pizza,IFNULL(ROUND(SUM(cigarette),2),'0') AS total_cigarette,IFNULL(ROUND(SUM(nontax),2),'0') AS total_nontax,IFNULL(ROUND(SUM(novelty),2),'0') AS totral_novelty,IFNULL(ROUND(SUM(gas),2),'0') AS total_gas,IFNULL(ROUND(SUM(meat),2),'0') AS total_meat "))
						->whereRaw("status='1' ".$where)
						->first();	
			$finalArray = array();
			array_push($finalArray,array("name"=>"Grocery","purchese"=>$inventoryGrocery,"sales"=>$sales_total->total_grocery,"profit"=>"".$inventoryGrocery-$sales_total->total_grocery.""));
			array_push($finalArray,array("name"=>"Beer","purchese"=>$inventoryBeer,"sales"=>$sales_total->total_beer,"profit"=>"".$inventoryBeer-$sales_total->total_beer.""));
			array_push($finalArray,array("name"=>"Cigarette","purchese"=>$inventoryCigarette,"sales"=>$sales_total->total_cigarette,"profit"=>"".$inventoryCigarette-$sales_total->total_cigarette.""));
			array_push($finalArray,array("name"=>"Gas","purchese"=>$inventoryGas,"sales"=>$sales_total->total_gas,"profit"=>"".$inventoryGas-$sales_total->total_gas.""));
			array_push($finalArray,array("name"=>"Nontaxable","purchese"=>$inventoryNontaxable,"sales"=>$sales_total->total_nontax,"profit"=>"".$inventoryNontaxable-$sales_total->total_nontax.""));
			array_push($finalArray,array("name"=>"Meat","purchese"=>$inventoryMeat,"sales"=>$sales_total->total_meat,"profit"=>$inventoryMeat-$sales_total->total_meat.""));
			array_push($finalArray,array("name"=>"PIZZA","purchese"=>$inventoryPIZZA,"sales"=>$sales_total->total_pizza,"profit"=>$inventoryPIZZA-$sales_total->total_pizza.""));
			return response()->json(['status' =>'1', 'data'=>$finalArray, 'error_msg' =>'']);
		}
		else
		{
			return response()->json(['status'=>'0', 'error_msg' =>'Token is invalid or expired!']);
		}
	}
	public function user_sift(Request $request, JWTAuth $JWTAuth)
	{
		$user = $JWTAuth->parseToken()->authenticate();
		if($user || true)
		{
			$user_swift = User2::where(array("id"=>$user->id))->first();
			$sift = "";
			if($user_swift['shift'] != ""){
				$sift = $user_swift['shift'];
			}
			
			return response()->json(['status' =>'1', 'data'=>array(array("sift"=>$sift)), 'error_msg' =>'']);
		}
		else
		{
			return response()->json(['status'=>'0', 'error_msg' =>'Token is invalid or expired!']);
		}
	}
}